/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import io.confluent.kafka.storage.checksum.E2EChecksumProtectedObjectType;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kafka.server.KafkaConfig;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.AutoAbortingGenericInputStream;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.CombinedObjectStream;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.S3AutoAbortingInputStream;
import kafka.tier.store.S3TierObjectStoreConfig;
import kafka.tier.store.S3VersionInformation;
import kafka.tier.store.ThrottledFileInputStream;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreAction;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.ThrottledSegmentUpload;
import kafka.tier.store.objects.TierSegmentUpload;
import kafka.tier.store.objects.metadata.HealthMetadata;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.utils.Throttler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.exception.RetryableException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAttributesRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectAttributes;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class S3TierObjectStore
extends TierObjectStore {
    private static final Logger log = LoggerFactory.getLogger(S3TierObjectStore.class);
    private final Optional<String> clusterIdOpt;
    private final Optional<Integer> brokerIdOpt;
    private final AmazonS3 client;
    private final Optional<S3AsyncClient> asyncClientOpt;
    private final Optional<AWSCredentialsProvider> credentialsProvider;
    private final String bucket;
    private final String prefix;
    private final String sseAlgorithm;
    private final String sseCustomerEncryptionKey;
    private final int autoAbortThresholdBytes;
    private final boolean v2Enabled;
    private AtomicInteger credentialsRefreshRetries = new AtomicInteger();
    private Optional<ExecutorService> executorOpt = Optional.empty();
    private final Optional<E2EChecksumStore> checksumStoreOpt;
    private static final int DEFAULT_S3_MAX_CREDENTIAL_REFRESH_RETRIES = 5;
    private static final int DEFAULT_S3_DELETE_BATCH_SIZE = 1000;
    private static final int DEFAULT_S3_MAX_LIST_KEYS = 1000;
    private static final String CRC32C = "CRC32C";
    private static final String CRC32C_HEADER = "x-amz-checksum-crc32c";
    private static final String ERROR_CODE_BAD_DIGEST = "BadDigest";
    static final String ERROR_CODE_EXPIRED_TOKEN = "ExpiredToken";
    private static final String ERROR_CODE_NO_SUCH_KEY = "NoSuchKey";

    public S3TierObjectStore(S3TierObjectStoreConfig config, Optional<E2EChecksumStore> checksumStoreOpt) {
        this(S3TierObjectStore.client(config), config, checksumStoreOpt);
    }

    S3TierObjectStore(AmazonS3ClientAndCredentialsProvider clientAndCredentialsProvider, S3TierObjectStoreConfig config, Optional<E2EChecksumStore> checksumStoreOpt) {
        this(clientAndCredentialsProvider.client(), clientAndCredentialsProvider.asyncClientOpt(), clientAndCredentialsProvider.credentialsProvider(), config, checksumStoreOpt);
    }

    S3TierObjectStore(AmazonS3 client, AWSCredentialsProvider credentialsProvider, S3TierObjectStoreConfig config, Optional<E2EChecksumStore> checksumStoreOpt) {
        this(client, Optional.empty(), credentialsProvider, config, checksumStoreOpt);
    }

    S3TierObjectStore(AmazonS3 client, Optional<S3AsyncClient> asyncClientOpt, AWSCredentialsProvider credentialsProvider, S3TierObjectStoreConfig config, Optional<E2EChecksumStore> checksumStoreOpt) {
        this.clusterIdOpt = config.clusterIdOpt;
        this.brokerIdOpt = config.brokerIdOpt;
        this.client = client;
        this.asyncClientOpt = asyncClientOpt;
        this.credentialsProvider = Optional.ofNullable(credentialsProvider);
        this.bucket = config.s3Bucket;
        this.prefix = config.s3Prefix;
        this.sseAlgorithm = config.s3SseAlgorithm;
        this.sseCustomerEncryptionKey = config.s3SseCustomerEncryptionKey;
        this.autoAbortThresholdBytes = config.s3AutoAbortThresholdBytes;
        this.expectBucket(this.bucket, config.s3Region, config.s3EndpointOverride);
        this.checksumStoreOpt = checksumStoreOpt;
        this.v2Enabled = config.s3V2Enabled;
    }

    @Override
    public String keyPrefix() {
        return this.prefix;
    }

    @Override
    public TierObjectStore.Backend getBackend() {
        return TierObjectStore.Backend.S3;
    }

    private void handleV2Exception(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof TierObjectStoreRetriableException) {
            throw (TierObjectStoreRetriableException)((Object)cause);
        }
        if (cause instanceof TierObjectStoreFatalException) {
            throw (TierObjectStoreFatalException)cause;
        }
        if (cause instanceof E2EChecksumInvalidException) {
            throw (E2EChecksumInvalidException)cause;
        }
        throw new TierObjectStoreFatalException("Unknown exception while getting objects", cause != null ? cause : e);
    }

    private Set<String> listObjectsWithoutVersions(String keyPrefix) {
        HashSet<String> objects = new HashSet<String>();
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                ListObjectsV2Result result;
                com.amazonaws.services.s3.model.ListObjectsV2Request req = new com.amazonaws.services.s3.model.ListObjectsV2Request().withBucketName(this.bucket).withPrefix(keyPrefix).withMaxKeys(Integer.valueOf(1000));
                do {
                    result = this.client.listObjectsV2(req);
                    for (S3ObjectSummary objectSummary : result.getObjectSummaries()) {
                        objects.add(objectSummary.getKey());
                    }
                    String token = result.getNextContinuationToken();
                    req.setContinuationToken(token);
                } while (result.isTruncated());
                log.debug("TierObjectStore listObjects versions: false keyPrefix:  " + keyPrefix + " # of objects returned: " + objects.size());
                return null;
            });
        }
        catch (SdkClientException e) {
            throw new TierObjectStoreRetriableException("Failed to list the objects (without versions) with prefix: " + keyPrefix, e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception while listing objects (without versions) with prefix: " + keyPrefix, e);
        }
        return objects;
    }

    @Override
    public Map<String, List<VersionInformation>> listObject(String keyPrefix, boolean getVersionInfo) {
        if (this.v2Enabled) {
            try {
                return this.listObjectAsync(keyPrefix, getVersionInfo).get();
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while listing objects with prefix: " + keyPrefix, e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                this.handleV2Exception(e);
            }
        }
        HashMap<String, List<VersionInformation>> results = new HashMap<String, List<VersionInformation>>();
        if (!getVersionInfo) {
            for (String object : this.listObjectsWithoutVersions(keyPrefix)) {
                results.put(object, new ArrayList());
            }
            return results;
        }
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                ListVersionsRequest request = new ListVersionsRequest().withBucketName(this.bucket).withPrefix(keyPrefix).withMaxResults(Integer.valueOf(1000));
                VersionListing versionListings = this.client.listVersions(request);
                while (true) {
                    for (S3VersionSummary versionSummary : versionListings.getVersionSummaries()) {
                        results.putIfAbsent(versionSummary.getKey(), new ArrayList());
                        S3VersionInformation versionInfo = new S3VersionInformation(versionSummary.getVersionId(), versionSummary.isDeleteMarker(), versionSummary.isLatest());
                        ((List)results.get(versionSummary.getKey())).add(versionInfo);
                    }
                    if (!versionListings.isTruncated()) break;
                    versionListings = this.client.listNextBatchOfVersions(versionListings);
                }
                if (log.isDebugEnabled()) {
                    StringBuilder allBlobs = new StringBuilder();
                    results.forEach((key, versions) -> allBlobs.append("[").append((String)key).append("->").append(Arrays.toString(versions.toArray())).append("] "));
                    log.debug("TierObjectStore listObjects versions: true keyPrefix: " + keyPrefix + " " + allBlobs);
                }
                return null;
            });
        }
        catch (SdkClientException e) {
            throw new TierObjectStoreRetriableException("Failed to list the objects with prefix: " + keyPrefix, e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception while listing objects with prefix: " + keyPrefix, e);
        }
        return results;
    }

    private CompletableFuture<Map<String, List<VersionInformation>>> listObjectsWithoutVersionsAsync(String keyPrefix) {
        CompletableFuture<Map<String, List<VersionInformation>>> future = new CompletableFuture<Map<String, List<VersionInformation>>>();
        try {
            HashMap objects = new HashMap();
            ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket).prefix(keyPrefix).maxKeys(Integer.valueOf(1000)).build();
            this.asyncClientOpt.get().listObjectsV2Paginator(request).subscribe(response -> response.contents().forEach(object -> {
                List cfr_ignored_0 = objects.putIfAbsent(object.key(), new ArrayList());
            })).whenComplete((response, e) -> {
                if (e != null) {
                    future.completeExceptionally(this.convertOperationException(e.getCause(), TierObjectStoreAction.LIST_LIVE_OBJECTS.action(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(keyPrefix), Optional.empty()));
                } else {
                    future.complete(objects);
                }
            });
        }
        catch (Exception e2) {
            log.error("Failed to send async list request without version, keyPrefix: {}", (Object)keyPrefix, (Object)e2);
            future.completeExceptionally(e2);
        }
        return future;
    }

    @Override
    public CompletableFuture<Map<String, List<VersionInformation>>> listObjectAsync(String keyPrefix, boolean getVersionInfo) {
        this.checkAsyncClientPresent("listObject");
        if (!getVersionInfo) {
            return this.listObjectsWithoutVersionsAsync(keyPrefix);
        }
        CompletableFuture<Map<String, List<VersionInformation>>> future = new CompletableFuture<Map<String, List<VersionInformation>>>();
        try {
            HashMap results = new HashMap();
            ListObjectVersionsRequest request = (ListObjectVersionsRequest)ListObjectVersionsRequest.builder().bucket(this.bucket).prefix(keyPrefix).maxKeys(Integer.valueOf(1000)).build();
            this.asyncClientOpt.get().listObjectVersionsPaginator(request).subscribe(response -> {
                response.versions().forEach(version -> {
                    results.putIfAbsent(version.key(), new ArrayList());
                    ((List)results.get(version.key())).add(new S3VersionInformation(version.versionId(), false, version.isLatest()));
                });
                response.deleteMarkers().forEach(deleteMarker -> {
                    results.putIfAbsent(deleteMarker.key(), new ArrayList());
                    ((List)results.get(deleteMarker.key())).add(new S3VersionInformation(deleteMarker.versionId(), true, deleteMarker.isLatest()));
                });
            }).whenComplete((response, e) -> {
                if (e != null) {
                    future.completeExceptionally(this.convertOperationException(e.getCause(), TierObjectStoreAction.LIST_OBJECT.action(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(keyPrefix), Optional.empty()));
                } else {
                    if (log.isDebugEnabled()) {
                        StringBuilder allBlobs = new StringBuilder();
                        results.forEach((key, versions) -> allBlobs.append("[").append((String)key).append("->").append(Arrays.toString(versions.toArray())).append("] "));
                        log.debug("TierObjectStore listObjects versions: true keyPrefix: " + keyPrefix + " " + allBlobs);
                    }
                    future.complete(results);
                }
            });
        }
        catch (Exception e2) {
            log.error("Failed to send async list request, keyPrefix: {}, getVersionInfo: {}", new Object[]{keyPrefix, getVersionInfo, e2});
            future.completeExceptionally(e2);
        }
        return future;
    }

    @Override
    protected TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) {
        S3Object object;
        GetObjectRequest request;
        if (this.v2Enabled) {
            try {
                return this.getObjectAsync(objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive, versionInformation).get();
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while getting objects", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                this.handleV2Exception(e);
            }
        }
        String key = this.keyPath(objectMetadata, objectType);
        String fullPath = this.fullKeyPath(key);
        GetObjectRequest getObjectRequest = request = versionInformation != null ? new GetObjectRequest(this.bucket, key, versionInformation.getVersionId()) : new GetObjectRequest(this.bucket, key);
        if (byteOffsetStart != null && byteOffsetEndExclusive != null) {
            request.setRange(byteOffsetStart.longValue(), byteOffsetEndExclusive - 1L);
        } else if (byteOffsetStart != null && byteOffsetStart != 0L) {
            request.setRange(byteOffsetStart.longValue());
        } else if (byteOffsetEndExclusive != null) {
            throw new IllegalStateException(String.format("Cannot specify a byteOffsetEndExclusive=%d without specifying a byteOffsetStart", byteOffsetEndExclusive));
        }
        log.debug("Fetching object from {}, with range {} - {}", new Object[]{fullPath, byteOffsetStart, byteOffsetEndExclusive});
        try {
            object = this.checkExpiredCredentialsExceptionAndTryRefresh(() -> this.client.getObject(request));
        }
        catch (Exception e) {
            throw this.convertFetchException(e, fullPath, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive);
        }
        S3ObjectInputStream inputStream = object.getObjectContent();
        return new S3TierObjectStoreResponse((InputStream)inputStream, this.autoAbortThresholdBytes, object.getObjectMetadata().getContentLength());
    }

    @Override
    protected CompletableFuture<TierObjectStoreResponse> getObjectAsync(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) {
        CompletableFuture<TierObjectStoreResponse> future = new CompletableFuture<TierObjectStoreResponse>();
        try {
            if (this.asyncClientOpt.isPresent()) {
                String key = this.keyPath(objectMetadata, objectType);
                String fullPath = this.fullKeyPath(key);
                GetObjectRequest.Builder requestBuilder = software.amazon.awssdk.services.s3.model.GetObjectRequest.builder().bucket(this.bucket).key(key);
                if (versionInformation != null) {
                    requestBuilder.versionId(versionInformation.getVersionId());
                }
                if (byteOffsetStart != null && byteOffsetEndExclusive != null) {
                    requestBuilder.range(String.format("bytes=%d-%d", byteOffsetStart, byteOffsetEndExclusive - 1L));
                } else if (byteOffsetStart != null && byteOffsetStart != 0L) {
                    requestBuilder.range(String.format("bytes=%d-", byteOffsetStart));
                } else if (byteOffsetEndExclusive != null) {
                    throw new IllegalStateException("Cannot specify a byteOffsetEndExclusive without specifying a byteOffsetStart");
                }
                log.debug("Fetching object from {}, with range {} - {}", new Object[]{fullPath, byteOffsetStart, byteOffsetEndExclusive});
                this.asyncClientOpt.get().getObject((software.amazon.awssdk.services.s3.model.GetObjectRequest)requestBuilder.build(), AsyncResponseTransformer.toBlockingInputStream()).handle((responseInputStream, e) -> {
                    if (e != null) {
                        future.completeExceptionally(this.convertFetchException(e.getCause() != null ? e.getCause() : e, fullPath, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive));
                    } else {
                        Long contentLength = ((GetObjectResponse)responseInputStream.response()).contentLength();
                        future.complete(new S3TierObjectStoreResponse((InputStream)responseInputStream, this.autoAbortThresholdBytes, contentLength != null ? contentLength : Long.MAX_VALUE));
                    }
                    return null;
                });
            } else {
                log.warn("Fallback to getObject because async S3 client isn't created, metadata: {}, type: {}", (Object)objectMetadata, (Object)objectType);
                future.complete(this.getObject(objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive, versionInformation));
            }
        }
        catch (Exception e2) {
            log.error("Failed to send async fetch request, metadata: {}, type: {}", new Object[]{objectMetadata, objectType, e2});
            future.completeExceptionally(e2);
        }
        return future;
    }

    private RuntimeException convertFetchException(Throwable e, String fullPath, ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive) {
        if (e instanceof AmazonClientException || e instanceof RetryableException) {
            return new TierObjectStoreRetriableException(String.format("Failed to fetch object from %s, metadata: %s type: %s range %s-%s", new Object[]{fullPath, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive}), e);
        }
        return new TierObjectStoreFatalException(String.format("Unknown exception when fetching object from %s, metadata: %s type: %s range %s-%s", new Object[]{fullPath, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive}), e);
    }

    @Override
    public ByteBuffer getSnapshot(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
        ByteBuffer buffer;
        if (this.v2Enabled) {
            try {
                return this.getSnapshotAsync(metadata, fragmentType, estimatedBufferSize).get();
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while getting snapshots", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                this.handleV2Exception(e);
            }
        }
        if (FragmentType.checkGetSnapshotSupported(fragmentType)) {
            throw new IllegalArgumentException("getSnapshot does not support the given fragmentType: " + (Object)((Object)fragmentType));
        }
        try (TierObjectStoreResponse response = this.getObjectStoreFragment(metadata, fragmentType);){
            buffer = ByteBuffer.wrap(Utils.readFullyToArray((InputStream)response.getInputStream(), (int)estimatedBufferSize));
        }
        catch (Exception e) {
            for (Throwable cause = e.getCause(); cause != null && cause != cause.getCause(); cause = cause.getCause()) {
                if (!(cause instanceof AmazonS3Exception) || !ERROR_CODE_NO_SUCH_KEY.equals(((AmazonS3Exception)cause).getErrorCode())) continue;
                throw new TierObjectStoreFatalException("Snapshot object not found in object store.", cause);
            }
            throw new TierObjectStoreRetriableException("Encountered an exception when fetching snapshot from object store.", e);
        }
        return buffer;
    }

    @Override
    public CompletableFuture<ByteBuffer> getSnapshotAsync(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
        this.checkAsyncClientPresent("getSnapshot");
        if (FragmentType.checkGetSnapshotSupported(fragmentType)) {
            CompletableFuture<ByteBuffer> future = new CompletableFuture<ByteBuffer>();
            future.completeExceptionally(new IllegalArgumentException("getSnapshotAsync does not support the given fragmentType: " + (Object)((Object)fragmentType)));
            return future;
        }
        return ((CompletableFuture)this.getObjectStoreFragmentAsync(metadata, fragmentType).thenApply(response -> {
            try {
                return ByteBuffer.wrap(Utils.readFullyToArray((InputStream)response.getInputStream(), (int)estimatedBufferSize));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).exceptionally(e -> {
            for (Throwable cause = e.getCause(); cause != null && cause != cause.getCause(); cause = cause.getCause()) {
                if (!(cause instanceof S3Exception) || !ERROR_CODE_NO_SUCH_KEY.equals(((S3Exception)cause).awsErrorDetails().errorCode())) continue;
                throw new TierObjectStoreFatalException("Snapshot object not found in object store.", cause);
            }
            throw new TierObjectStoreRetriableException("Encountered an exception when fetching snapshot from object store.", (Throwable)e);
        });
    }

    @Override
    public OpaqueData prepPutSegment() throws TierObjectStoreRetriableException, IOException {
        return OpaqueData.ZEROED;
    }

    @Override
    public String putObject(ObjectStoreMetadata objectMetadata, File file, ObjectType objectType) {
        if (this.v2Enabled) {
            try {
                return this.putObjectAsync(objectMetadata, file, objectType).get();
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while putting objects", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                this.handleV2Exception(e);
            }
        }
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        String key = this.keyPath(objectMetadata, objectType);
        String fullPath = this.fullKeyPath(key);
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                this.putFile(key, metadata, file, objectType.toE2EChecksumProtectedObjectType());
                return null;
            });
        }
        catch (AmazonClientException e) {
            AmazonS3Exception ex;
            if (e instanceof AmazonS3Exception && ERROR_CODE_BAD_DIGEST.equals((ex = (AmazonS3Exception)e).getErrorCode())) {
                throw new E2EChecksumInvalidException("Checksum mismatch during object store upload", (Throwable)ex);
            }
            throw new TierObjectStoreRetriableException(String.format("Failed to upload object to %s with metadata %s, file %s, type %s", new Object[]{fullPath, objectMetadata, file, objectType}), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Failed to upload object to %s with metadata %s, file %s, type %s", new Object[]{fullPath, objectMetadata, file, objectType}), e);
        }
        return key;
    }

    @Override
    public CompletableFuture<String> putObjectAsync(ObjectStoreMetadata objectMetadata, File file, ObjectType objectType) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            this.checkAsyncClientPresent("putObject");
            Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
            String key = this.keyPath(objectMetadata, objectType);
            String fullPath = this.fullKeyPath(key);
            ((CompletableFuture)this.putFileAsync(key, metadata, file, objectType.toE2EChecksumProtectedObjectType()).thenApply(res -> future.complete(key))).exceptionally(e -> {
                future.completeExceptionally(this.convertOperationException((Throwable)e, TierObjectStoreAction.PUT_OBJECT.action(), Optional.of(objectMetadata), Optional.of(file), Optional.of(objectType), Optional.of(fullPath), Optional.empty()));
                return null;
            });
        }
        catch (Exception e2) {
            log.error("Failed to upload object to file {}, type {}, metadata {}", new Object[]{file, objectType, objectMetadata, e2});
            future.completeExceptionally(e2);
        }
        return future;
    }

    private RuntimeException convertOperationException(Throwable e, String action, Optional<ObjectStoreMetadata> metadata, Optional<File> file, Optional<ObjectType> objectType, Optional<String> fullPath, Optional<ByteBuffer> buffer) {
        Object exception = null;
        if (e instanceof S3Exception) {
            S3Exception ex = (S3Exception)e;
            if (ERROR_CODE_BAD_DIGEST.equals(ex.awsErrorDetails().errorCode())) {
                if (action.equals(TierObjectStoreAction.PUT_SEGMENT.action())) {
                    try {
                        this.handleS3ExceptionDuringSegmentUpload(ex, metadata.get(), objectType.get(), file.get());
                    }
                    catch (E2EChecksumInvalidException | TierObjectStoreRetriableException tierObjectStoreException) {
                        exception = tierObjectStoreException;
                    }
                } else {
                    exception = new E2EChecksumInvalidException(String.format("Checksum mismatch when %s", action), (Throwable)ex);
                }
            } else {
                exception = new TierObjectStoreFatalException(String.format("Fatal: Unknown service exception when %s with metadata: %s, file: %s, type: %s, filePath: %s, buffer: %s", action, metadata.orElse(null), file.orElse(null), objectType.orElse(null), fullPath.orElse(null), buffer.orElse(null)), (Throwable)ex);
            }
        } else {
            exception = e instanceof RetryableException ? new TierObjectStoreRetriableException(String.format("Retryable: Failed %s with metadata: %s, file: %s, type: %s, filePath: %s, buffer: %s", action, metadata.orElse(null), file.orElse(null), objectType.orElse(null), fullPath.orElse(null), buffer.orElse(null)), e) : new TierObjectStoreFatalException(String.format("Fatal: Failed %s with metadata: %s, file: %s, type: %s, filePath: %s, buffer: %s", action, metadata.orElse(null), file.orElse(null), objectType.orElse(null), fullPath.orElse(null), buffer.orElse(null)), e);
        }
        return exception;
    }

    @Override
    public String putBuffer(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType objectType) {
        if (this.v2Enabled) {
            try {
                return this.putBufferAsync(objectMetadata, buffer, objectType).get();
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while putting buffer", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                this.handleV2Exception(e);
            }
        }
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        String key = this.keyPath(objectMetadata, objectType);
        String fullPath = this.fullKeyPath(key);
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                this.putBuf(key, metadata, buffer);
                return null;
            });
        }
        catch (AmazonClientException e) {
            throw new TierObjectStoreRetriableException(String.format("Failed to upload object to %s with metadata %s, buffer %s, type %s", new Object[]{fullPath, objectMetadata, buffer, objectType}), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Failed to upload object to %s with metadata %s, buffer %s, type %s", new Object[]{fullPath, objectMetadata, buffer, objectType}), e);
        }
        return key;
    }

    @Override
    public CompletableFuture<String> putBufferAsync(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType objectType) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            this.checkAsyncClientPresent("putBuffer");
            String key = this.keyPath(objectMetadata, objectType);
            Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
            String fullPath = this.fullKeyPath(key);
            ((CompletableFuture)this.putBufAsync(key, metadata, buffer).thenApply(res -> future.complete(key))).exceptionally(e -> {
                future.completeExceptionally(this.convertOperationException((Throwable)e, TierObjectStoreAction.PUT_BUFFER.action(), Optional.of(objectMetadata), Optional.empty(), Optional.of(objectType), Optional.of(fullPath), Optional.of(buffer)));
                return null;
            });
        }
        catch (Exception e2) {
            log.error("Failed to upload object with metadata {}, buffer {}, type {}", new Object[]{objectMetadata, buffer, objectType});
            future.completeExceptionally(e2);
        }
        return future;
    }

    @Override
    public void restoreObjectByCopy(ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        if (this.v2Enabled) {
            try {
                this.restoreObjectByCopyAsync(objectMetadata, key, lastLiveVersion).get();
                return;
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while restoring object by copying buffer", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                this.handleV2Exception(e);
            }
        }
        String lastLiveVersionId = lastLiveVersion.getVersionId();
        String fullPath = this.fullKeyPath(key);
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                CopyObjectRequest request = new CopyObjectRequest(this.bucket, key, lastLiveVersionId, this.bucket, key).withNewObjectMetadata(this.objectMetadata(null));
                this.setKmsParams(request);
                log.debug("restore object for {}-{}", (Object)fullPath, (Object)lastLiveVersionId);
                this.client.copyObject(request);
                return null;
            });
        }
        catch (AmazonClientException e) {
            throw new TierObjectStoreRetriableException(String.format("Failed to restore object %s (version: %s)", fullPath, lastLiveVersionId), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Unknown exception when restoring object %s (version: %s)", fullPath, lastLiveVersionId), e);
        }
    }

    @Override
    public CompletableFuture<Void> restoreObjectByCopyAsync(ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        this.checkAsyncClientPresent("restoreObjectByCopy");
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            String lastLiveVersionId = lastLiveVersion.getVersionId();
            String fullPath = this.fullKeyPath(key);
            CopyObjectRequest.Builder requestBuilder = software.amazon.awssdk.services.s3.model.CopyObjectRequest.builder().sourceBucket(this.bucket).sourceKey(key).sourceVersionId(lastLiveVersionId).destinationBucket(this.bucket).destinationKey(key).metadata(objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt));
            if (this.usesKms()) {
                requestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS).ssekmsKeyId(this.sseCustomerEncryptionKey);
            }
            log.debug("restore object for {}-{}", (Object)fullPath, (Object)lastLiveVersionId);
            this.asyncClientOpt.get().copyObject((software.amazon.awssdk.services.s3.model.CopyObjectRequest)requestBuilder.build()).handle((response, e) -> {
                if (e != null) {
                    future.completeExceptionally(this.convertOperationException(e.getCause(), String.format("%s %s", TierObjectStoreAction.RESTORE_OBJECT.action(), lastLiveVersionId), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(fullPath), Optional.empty()));
                } else {
                    future.complete(null);
                }
                return null;
            });
        }
        catch (Exception e2) {
            log.error("Failed to send async restore request, metadata: {}, key: {}", new Object[]{objectMetadata, key, e2});
            future.completeExceptionally(e2);
        }
        return future;
    }

    private void setKmsParams(CopyObjectRequest request) {
        if (this.usesKms()) {
            request.setSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(this.sseCustomerEncryptionKey));
        }
    }

    private void putSegmentAsMultiObject(TierSegmentUpload<?> tierSegmentUpload, AtomicReference<ObjectType> currObjectType) throws IOException {
        Map<String, String> metadata = tierSegmentUpload.objectMetadata().objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        currObjectType.set(ObjectType.SEGMENT);
        if (tierSegmentUpload.throttlerOpt().isPresent() && tierSegmentUpload instanceof ThrottledSegmentUpload) {
            ThrottledSegmentUpload upload = (ThrottledSegmentUpload)tierSegmentUpload;
            Throttler throttler = upload.throttlerOpt().get();
            this.putFileWithThrottling(this.keyPath(upload.objectMetadata(), ObjectType.SEGMENT), metadata, upload.segment(), E2EChecksumProtectedObjectType.SEGMENT, throttler);
            currObjectType.set(ObjectType.OFFSET_INDEX);
            this.putFileWithThrottling(this.keyPath(upload.objectMetadata(), ObjectType.OFFSET_INDEX), metadata, upload.offsetIdx(), E2EChecksumProtectedObjectType.OFFSET_INDEX, throttler);
            currObjectType.set(ObjectType.TIMESTAMP_INDEX);
            this.putFileWithThrottling(this.keyPath(upload.objectMetadata(), ObjectType.TIMESTAMP_INDEX), metadata, upload.timestampIdx(), E2EChecksumProtectedObjectType.TIMESTAMP_INDEX, throttler);
            if (upload.producerStateSnapshotOpt().isPresent()) {
                currObjectType.set(ObjectType.PRODUCER_STATE);
                this.putFileWithThrottling(this.keyPath(upload.objectMetadata(), ObjectType.PRODUCER_STATE), metadata, (File)upload.producerStateSnapshotOpt().get(), E2EChecksumProtectedObjectType.PRODUCER_STATE, throttler);
            }
        } else {
            this.putFile(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT), metadata, tierSegmentUpload.segment(), E2EChecksumProtectedObjectType.SEGMENT);
            currObjectType.set(ObjectType.OFFSET_INDEX);
            this.putFile(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.OFFSET_INDEX), metadata, tierSegmentUpload.offsetIdx(), E2EChecksumProtectedObjectType.OFFSET_INDEX);
            currObjectType.set(ObjectType.TIMESTAMP_INDEX);
            this.putFile(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.TIMESTAMP_INDEX), metadata, tierSegmentUpload.timestampIdx(), E2EChecksumProtectedObjectType.TIMESTAMP_INDEX);
            if (tierSegmentUpload.producerStateSnapshotOpt().isPresent()) {
                currObjectType.set(ObjectType.PRODUCER_STATE);
                Object producerState = tierSegmentUpload.producerStateSnapshotOpt().get();
                if (producerState instanceof File) {
                    this.putFile(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.PRODUCER_STATE), metadata, (File)producerState, E2EChecksumProtectedObjectType.PRODUCER_STATE);
                } else if (producerState instanceof ByteBuffer) {
                    this.putBuf(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.PRODUCER_STATE), metadata, (ByteBuffer)producerState);
                }
            }
        }
        if (tierSegmentUpload.txnIdxOpt().isPresent()) {
            currObjectType.set(ObjectType.TRANSACTION_INDEX);
            this.putBuf(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.TRANSACTION_INDEX), metadata, tierSegmentUpload.txnIdxOpt().get());
        }
        if (tierSegmentUpload.epochStateOpt().isPresent()) {
            currObjectType.set(ObjectType.EPOCH_STATE);
            this.putBuf(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.EPOCH_STATE), metadata, tierSegmentUpload.epochStateOpt().get());
        }
    }

    private void putSegmentAsCombinedObject(TierSegmentUpload<?> tierSegmentUpload) throws IOException {
        Map<String, String> metadata = tierSegmentUpload.objectMetadata().objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        try (CombinedObjectStream combinedObjectStream = tierSegmentUpload.makeCombinedObjectStream(131073);){
            Optional<String> checksumOpt = this.getCrcForCombinedObject(tierSegmentUpload);
            String combinedObjectKeyPath = this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT_WITH_METADATA);
            this.putInputStream(combinedObjectKeyPath, metadata, combinedObjectStream, combinedObjectStream.length(), checksumOpt);
        }
    }

    private void putInputStream(String key, Map<String, String> metadata, InputStream stream, long contentLength, Optional<String> checksumOpt) {
        if (!stream.markSupported()) {
            log.warn("InputStream does not support mark/reset, wrapping in BufferedInputStream");
            stream = new BufferedInputStream(stream, 131073);
        }
        com.amazonaws.services.s3.model.ObjectMetadata s3Metadata = this.objectMetadata(metadata);
        s3Metadata.setContentLength(contentLength);
        checksumOpt.ifPresent(checksum -> s3Metadata.setHeader(CRC32C_HEADER, checksum));
        PutObjectRequest request = new PutObjectRequest(this.bucket, key, stream, s3Metadata);
        this.setKmsParams(request);
        this.client.putObject(request);
    }

    private List<CompletableFuture<PutObjectResponse>> putSegmentAsMultiObjectAsync(TierSegmentUpload<?> tierSegmentUpload, AtomicReference<ObjectType> currObjectType) {
        ArrayList<CompletableFuture<PutObjectResponse>> pendingFutures = new ArrayList<CompletableFuture<PutObjectResponse>>();
        Map<String, String> metadata = tierSegmentUpload.objectMetadata().objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        currObjectType.set(ObjectType.SEGMENT);
        pendingFutures.add(this.putAsync(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT), metadata, tierSegmentUpload.segment(), E2EChecksumProtectedObjectType.SEGMENT, tierSegmentUpload.throttlerOpt()));
        currObjectType.set(ObjectType.OFFSET_INDEX);
        pendingFutures.add(this.putAsync(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.OFFSET_INDEX), metadata, tierSegmentUpload.offsetIdx(), E2EChecksumProtectedObjectType.OFFSET_INDEX, tierSegmentUpload.throttlerOpt()));
        currObjectType.set(ObjectType.TIMESTAMP_INDEX);
        pendingFutures.add(this.putAsync(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.TIMESTAMP_INDEX), metadata, tierSegmentUpload.timestampIdx(), E2EChecksumProtectedObjectType.TIMESTAMP_INDEX, tierSegmentUpload.throttlerOpt()));
        if (tierSegmentUpload.producerStateSnapshotOpt().isPresent()) {
            currObjectType.set(ObjectType.PRODUCER_STATE);
            pendingFutures.add(this.putAsync(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.PRODUCER_STATE), metadata, tierSegmentUpload.producerStateSnapshotOpt().get(), E2EChecksumProtectedObjectType.PRODUCER_STATE, tierSegmentUpload.throttlerOpt()));
        }
        if (tierSegmentUpload.txnIdxOpt().isPresent()) {
            currObjectType.set(ObjectType.TRANSACTION_INDEX);
            pendingFutures.add(this.putBufAsync(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.TRANSACTION_INDEX), metadata, tierSegmentUpload.txnIdxOpt().get()));
        }
        if (tierSegmentUpload.epochStateOpt().isPresent()) {
            currObjectType.set(ObjectType.EPOCH_STATE);
            pendingFutures.add(this.putBufAsync(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.EPOCH_STATE), metadata, tierSegmentUpload.epochStateOpt().get()));
        }
        return pendingFutures;
    }

    private List<CompletableFuture<PutObjectResponse>> putSegmentAsCombinedObjectAsync(TierSegmentUpload<?> tierSegmentUpload) throws IOException {
        ArrayList<CompletableFuture<PutObjectResponse>> pendingFutures = new ArrayList<CompletableFuture<PutObjectResponse>>();
        Map<String, String> metadata = tierSegmentUpload.objectMetadata().objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        try (CombinedObjectStream combinedObjectStream = tierSegmentUpload.makeCombinedObjectStream(131073);){
            Optional<String> checksumOpt = this.getCrcForCombinedObject(tierSegmentUpload);
            String combinedObjectKeyPath = this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT_WITH_METADATA);
            pendingFutures.add(this.putInputStreamAsync(combinedObjectKeyPath, metadata, combinedObjectStream, combinedObjectStream.length(), checksumOpt));
        }
        return pendingFutures;
    }

    protected CompletableFuture<PutObjectResponse> putInputStreamAsync(String key, Map<String, String> userMetadata, InputStream stream, long contentLength, Optional<String> checksumOpt) {
        this.checkAsyncClientPresent("putInputStream");
        CompletableFuture<PutObjectResponse> future = new CompletableFuture<PutObjectResponse>();
        HashMap<String, String> metadata = new HashMap<String, String>(userMetadata);
        checksumOpt.ifPresent(checksum -> metadata.put(CRC32C_HEADER, (String)checksum));
        PutObjectRequest.Builder putRequestBuilder = software.amazon.awssdk.services.s3.model.PutObjectRequest.builder().bucket(this.bucket).key(key).metadata(metadata);
        if (!stream.markSupported()) {
            log.warn("InputStream does not support mark/reset, wrapping in BufferedInputStream");
            stream = new BufferedInputStream(stream, 131073);
        }
        this.setSseAlgorithmAndKmsParamsV2(putRequestBuilder);
        log.debug("Uploading InputStream to s3://{}/{}", (Object)this.bucket, (Object)key);
        this.asyncClientOpt.get().putObject((software.amazon.awssdk.services.s3.model.PutObjectRequest)putRequestBuilder.build(), AsyncRequestBody.fromInputStream((InputStream)stream, (Long)contentLength, (ExecutorService)this.getExecutor().get())).handle((response, e) -> {
            if (e != null) {
                future.completeExceptionally(e.getCause());
            } else {
                future.complete((PutObjectResponse)response);
            }
            return null;
        });
        return future;
    }

    @Override
    public void putSegment(TierSegmentUpload<?> tierSegmentUpload) {
        AtomicReference currentPutObjectType = new AtomicReference();
        if (this.v2Enabled) {
            try {
                this.putSegmentAsync(tierSegmentUpload).get();
                return;
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while putting segment", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                this.handleV2Exception(e);
            }
        }
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                switch (tierSegmentUpload.putMode()) {
                    case LegacyMultiObject: {
                        this.putSegmentAsMultiObject(tierSegmentUpload, currentPutObjectType);
                        break;
                    }
                    case CombinedObject: {
                        currentPutObjectType.set(ObjectType.SEGMENT_WITH_METADATA);
                        this.putSegmentAsCombinedObject(tierSegmentUpload);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported segment PUT mode: " + tierSegmentUpload.putMode());
                    }
                }
                return null;
            });
            this.checksumStoreOpt.ifPresent(tierSegmentUpload::postPutSegmentCleanup);
        }
        catch (AmazonClientException e) {
            Optional<File> file = TierObjectStoreUtils.getCurrentPutObjectFile(tierSegmentUpload, ((ObjectType)((Object)currentPutObjectType.get())).toE2EChecksumProtectedObjectType());
            if (!file.isPresent()) {
                throw new TierObjectStoreRetriableException("Failed to upload segment: " + tierSegmentUpload.objectMetadata(), e);
            }
            this.handleAmazonClientException(e, tierSegmentUpload.objectMetadata(), (ObjectType)((Object)currentPutObjectType.get()), file.get());
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception when uploading segment: " + tierSegmentUpload.objectMetadata(), e);
        }
    }

    @Override
    public CompletableFuture<Void> putSegmentAsync(TierSegmentUpload<?> tierSegmentUpload) {
        this.checkAsyncClientPresent("putSegment");
        AtomicReference<ObjectType> currentPutObjectType = new AtomicReference<ObjectType>();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            List<CompletableFuture<PutObjectResponse>> pendingFutures;
            switch (tierSegmentUpload.putMode()) {
                case LegacyMultiObject: {
                    pendingFutures = this.putSegmentAsMultiObjectAsync(tierSegmentUpload, currentPutObjectType);
                    break;
                }
                case CombinedObject: {
                    currentPutObjectType.set(ObjectType.SEGMENT_WITH_METADATA);
                    pendingFutures = this.putSegmentAsCombinedObjectAsync(tierSegmentUpload);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported segment PUT mode " + tierSegmentUpload.putMode());
                }
            }
            ((CompletableFuture)CompletableFuture.allOf(pendingFutures.toArray(new CompletableFuture[0])).thenApply(res -> {
                this.checksumStoreOpt.ifPresent(tierSegmentUpload::postPutSegmentCleanup);
                future.complete(null);
                return null;
            })).exceptionally(e -> {
                Optional<File> file = TierObjectStoreUtils.getCurrentPutObjectFile(tierSegmentUpload, ((ObjectType)((Object)((Object)currentPutObjectType.get()))).toE2EChecksumProtectedObjectType());
                if (!file.isPresent()) {
                    future.completeExceptionally((Throwable)((Object)new TierObjectStoreRetriableException("Failed to upload segment: " + tierSegmentUpload.objectMetadata(), (Throwable)e)));
                    return null;
                }
                future.completeExceptionally(this.convertOperationException(e.getCause(), TierObjectStoreAction.PUT_SEGMENT.action(), Optional.of(tierSegmentUpload.objectMetadata()), file, Optional.of(currentPutObjectType.get()), Optional.empty(), Optional.empty()));
                return null;
            });
        }
        catch (Exception e2) {
            future.completeExceptionally(new TierObjectStoreFatalException("Unknown exception when uploading segment: " + tierSegmentUpload.objectMetadata(), e2));
        }
        return future;
    }

    private <T> CompletableFuture<PutObjectResponse> putAsync(String key, Map<String, String> metadata, T data, E2EChecksumProtectedObjectType objectType, Optional<Throttler> throttler) {
        if (throttler.isPresent()) {
            return this.putFileWithThrottlingAsync(key, metadata, (File)data, objectType, throttler.get());
        }
        if (data instanceof File) {
            return this.putFileAsync(key, metadata, (File)data, objectType);
        }
        return this.putBufAsync(key, metadata, (ByteBuffer)data);
    }

    private <T> T checkExpiredCredentialsExceptionAndTryRefresh(Callable<T> func) throws Exception {
        try {
            T result = func.call();
            this.credentialsRefreshRetries.set(0);
            return result;
        }
        catch (AmazonS3Exception ex) {
            if (ERROR_CODE_EXPIRED_TOKEN.equals(ex.getErrorCode())) {
                this.tryRefreshCredentials(ex);
            } else {
                this.credentialsRefreshRetries.set(0);
            }
            throw ex;
        }
    }

    private void tryRefreshCredentials(AmazonS3Exception ex) {
        try {
            int numRetries = this.credentialsRefreshRetries.getAndIncrement();
            if (numRetries >= 5) {
                log.warn("Hit maximum number of consecutive credential refresh attempts without seeing a successful request, skipping refresh attempt.");
                return;
            }
            this.credentialsProvider.ifPresent(provider -> {
                log.info("S3 credentials expired; attempting a credentials provider refresh.", (Throwable)ex);
                provider.refresh();
            });
        }
        catch (Exception refreshException) {
            log.error("Received exception while attempting to refresh S3 credentials.", (Throwable)refreshException);
        }
    }

    @Override
    public void deleteSegment(ObjectMetadata objectMetadata) {
        if (this.v2Enabled) {
            try {
                this.deleteSegmentAsync(objectMetadata).get();
                return;
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while deleting segment", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                this.handleV2Exception(e);
            }
        }
        List<DeleteObjectsRequest.KeyVersion> keys = this.keysForSegment(objectMetadata);
        com.amazonaws.services.s3.model.DeleteObjectsRequest request = new com.amazonaws.services.s3.model.DeleteObjectsRequest(this.bucket).withKeys(keys);
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> this.client.deleteObjects(request));
        }
        catch (AmazonClientException e) {
            throw new TierObjectStoreRetriableException("Failed to delete segment: " + objectMetadata, e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception when deleting segment: " + objectMetadata, e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteSegmentAsync(ObjectMetadata objectMetadata) {
        this.checkAsyncClientPresent("deleteSegment");
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            List<ObjectIdentifier> keys = this.keysForSegmentV2(objectMetadata);
            DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.bucket).delete((Delete)Delete.builder().objects(keys).build()).build();
            this.asyncClientOpt.get().deleteObjects(request).handle((response, exception) -> {
                if (exception == null) {
                    future.complete(null);
                } else {
                    Throwable e = exception.getCause();
                    future.completeExceptionally(this.convertOperationException(e, TierObjectStoreAction.DELETE_SEGMENT.action(), Optional.of(objectMetadata), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
                }
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(new TierObjectStoreFatalException("Unknown exception when deleting segment: " + objectMetadata, e));
        }
        return future;
    }

    @Override
    public TierObjectAttribute objectExists(ObjectStoreMetadata objectMetadata, ObjectType objectType) throws TierObjectStoreRetriableException {
        if (this.v2Enabled) {
            try {
                return this.objectExistsAsync(objectMetadata, objectType).get();
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception when checking objects", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                this.handleV2Exception(e);
            }
        }
        TierObjectAttribute result = new TierObjectAttribute(false);
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                String key = this.keyPath(objectMetadata, objectType);
                com.amazonaws.services.s3.model.ObjectMetadata metadata = this.client.getObjectMetadata(this.bucket, key);
                log.trace("objectExists at s3://{}/{} with metadata {}", new Object[]{this.bucket, key, metadata});
                result.exist = true;
                result.size = metadata.getContentLength();
                return null;
            });
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404) {
                result.exist = false;
            }
            throw new TierObjectStoreRetriableException("Failed to check object existence: " + objectMetadata + " type: " + (Object)((Object)objectType), e);
        }
        catch (AmazonClientException e) {
            throw new TierObjectStoreRetriableException("Failed to check object existence: " + objectMetadata + " type: " + (Object)((Object)objectType), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception when checking object existence: " + objectMetadata + " type: " + (Object)((Object)objectType), e);
        }
        return result;
    }

    @Override
    public CompletableFuture<TierObjectAttribute> objectExistsAsync(ObjectStoreMetadata objectMetadata, ObjectType objectType) {
        CompletableFuture<TierObjectAttribute> future = new CompletableFuture<TierObjectAttribute>();
        try {
            if (this.asyncClientOpt.isPresent()) {
                String key = this.keyPath(objectMetadata, objectType);
                GetObjectAttributesRequest.Builder requestBuilder = GetObjectAttributesRequest.builder().bucket(this.bucket).key(key).objectAttributes(new ObjectAttributes[]{ObjectAttributes.OBJECT_SIZE});
                this.asyncClientOpt.get().getObjectAttributes((GetObjectAttributesRequest)requestBuilder.build()).handle((attributes, exception) -> {
                    if (exception != null) {
                        Throwable e;
                        Throwable throwable = e = exception.getCause() != null ? exception.getCause() : exception;
                        if (e instanceof NoSuchKeyException) {
                            future.complete(new TierObjectAttribute(false));
                        } else if (e instanceof AwsServiceException) {
                            if (((AwsServiceException)e).statusCode() == 404) {
                                future.complete(new TierObjectAttribute(false));
                            } else {
                                future.completeExceptionally((Throwable)((Object)new TierObjectStoreRetriableException("Failed to check object existence: " + objectMetadata + " type: " + (Object)((Object)objectType), e)));
                            }
                        } else if (e instanceof RetryableException) {
                            future.completeExceptionally((Throwable)((Object)new TierObjectStoreRetriableException("Failed to check object existence: " + objectMetadata + " type: " + (Object)((Object)objectType), e)));
                        } else {
                            future.completeExceptionally(new TierObjectStoreFatalException("Unknown exception when checking object existence: " + objectMetadata + " type: " + (Object)((Object)objectType), e));
                        }
                    } else {
                        log.trace("objectExists (async) at s3://{}/{} with metadata {}", new Object[]{this.bucket, key, attributes});
                        future.complete(new TierObjectAttribute(true, attributes.objectSize()));
                    }
                    return null;
                });
            } else {
                log.warn("Fallback to objectExists because async S3 client isn't created, metadata: {}, type: {}", (Object)objectMetadata, (Object)objectType);
                future.complete(this.objectExists(objectMetadata, objectType));
            }
        }
        catch (Exception e) {
            log.error("Failed to send objectExistsAsync request, metadata: {}, type: {}", new Object[]{objectMetadata, objectType, e});
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public void deleteVersions(List<TierObjectStore.KeyAndVersion> keys) {
        if (this.v2Enabled) {
            try {
                this.deleteVersionsAsync(keys).get();
                return;
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception when deleting versions", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                this.handleV2Exception(e);
            }
        }
        ArrayList<DeleteObjectsRequest.KeyVersion> s3Keys = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        for (TierObjectStore.KeyAndVersion key : keys) {
            DeleteObjectsRequest.KeyVersion keyVersion = key.versionId() == null ? new DeleteObjectsRequest.KeyVersion(key.key()) : new DeleteObjectsRequest.KeyVersion(key.key(), key.versionId());
            log.debug("Deleting object {} {}", (Object)keyVersion.getKey(), (Object)keyVersion.getVersion());
            s3Keys.add(keyVersion);
            if (s3Keys.size() < 1000) continue;
            this.makeDeleteObjectsCall(s3Keys);
            s3Keys.clear();
        }
        if (!s3Keys.isEmpty()) {
            this.makeDeleteObjectsCall(s3Keys);
        }
    }

    @Override
    public CompletableFuture<Void> deleteVersionsAsync(List<TierObjectStore.KeyAndVersion> keys) {
        this.checkAsyncClientPresent("deleteVersions");
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            ArrayList<ObjectIdentifier> s3Keys = new ArrayList<ObjectIdentifier>();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (TierObjectStore.KeyAndVersion key : keys) {
                ObjectIdentifier keyVersion = key.versionId() == null ? (ObjectIdentifier)ObjectIdentifier.builder().key(key.key()).build() : (ObjectIdentifier)ObjectIdentifier.builder().key(key.key()).versionId(key.versionId()).build();
                log.debug("Deleting object {} {}", (Object)keyVersion.key(), (Object)keyVersion.versionId());
                s3Keys.add(keyVersion);
                if (s3Keys.size() < 1000) continue;
                futures.add(this.makeDeleteObjectsCallAsync(s3Keys));
                s3Keys.clear();
            }
            if (!s3Keys.isEmpty()) {
                futures.add(this.makeDeleteObjectsCallAsync(s3Keys));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((response, e) -> {
                if (e != null) {
                    future.completeExceptionally((Throwable)e);
                } else {
                    future.complete(null);
                }
            });
        }
        catch (Exception e2) {
            log.error("Failed to send async delete request, keys: {}", keys, (Object)e2);
            future.completeExceptionally(e2);
        }
        return future;
    }

    private void makeDeleteObjectsCall(List<DeleteObjectsRequest.KeyVersion> s3Keys) {
        com.amazonaws.services.s3.model.DeleteObjectsRequest request = new com.amazonaws.services.s3.model.DeleteObjectsRequest(this.bucket).withKeys(s3Keys);
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                log.debug("Sending a batch delete request");
                return this.client.deleteObjects(request);
            });
        }
        catch (MultiObjectDeleteException e) {
            log.error("S3 reported errors while deleting the following versioned objects:");
            e.getErrors().forEach(err -> log.error("Blob Key: " + err.getKey() + " Blob VersionId: " + err.getVersionId() + " Error Code: " + err.getCode() + " Error Message: " + err.getMessage()));
            throw new TierObjectStoreRetriableException("Failed to delete " + e.getErrors().size() + " versioned objects", e);
        }
        catch (SdkClientException e) {
            log.error(Arrays.toString(e.getStackTrace()));
            throw new TierObjectStoreRetriableException("Failed to delete versioned objects", e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception when deleting versioned objects", e);
        }
    }

    private CompletableFuture<Void> makeDeleteObjectsCallAsync(List<ObjectIdentifier> s3Keys) {
        DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.bucket).delete((Delete)Delete.builder().objects(s3Keys).build()).build();
        log.debug("Sending a batch delete request");
        return this.asyncClientOpt.get().deleteObjects(request).handle((response, e) -> {
            if (e != null) {
                throw this.convertOperationException(e.getCause(), TierObjectStoreAction.DELETE_VERSIONED_OBJECTS.action(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
            }
            return null;
        });
    }

    @Override
    public void close() {
        super.close();
        this.client.shutdown();
        this.asyncClientOpt.ifPresent(c -> c.close());
        this.executorOpt.ifPresent(e -> e.shutdown());
    }

    private String keyPath(ObjectStoreMetadata objectMetadata, ObjectType objectType) {
        return TierObjectStoreUtils.keyPath(this.prefix, objectMetadata, objectType);
    }

    private String fullKeyPath(String key) {
        return "s3://" + this.bucket + "/" + key;
    }

    private com.amazonaws.services.s3.model.ObjectMetadata objectMetadata(Map<String, String> userMetadata) {
        com.amazonaws.services.s3.model.ObjectMetadata metadata = new com.amazonaws.services.s3.model.ObjectMetadata();
        if (this.sseAlgorithm != null) {
            metadata.setSSEAlgorithm(this.sseAlgorithm);
        }
        if (userMetadata != null) {
            metadata.setUserMetadata(userMetadata);
        }
        return metadata;
    }

    private void setSseAlgorithmAndKmsParamsV2(PutObjectRequest.Builder requestBuilder) {
        if (this.usesKms()) {
            requestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS).ssekmsKeyId(this.sseCustomerEncryptionKey);
        }
        if (this.sseAlgorithm != null) {
            requestBuilder.serverSideEncryption(this.sseAlgorithm);
        }
    }

    private void checkAsyncClientPresent(String requestType) {
        if (!this.asyncClientOpt.isPresent()) {
            throw new TierObjectStoreFatalException(String.format("Failed to send async %s request because async S3 client isn't created", requestType));
        }
    }

    private void setKmsParams(PutObjectRequest request) {
        if (this.usesKms()) {
            request.setSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(this.sseCustomerEncryptionKey));
        }
    }

    private void putFile(String key, Map<String, String> metadata, File file, E2EChecksumProtectedObjectType objectType) {
        com.amazonaws.services.s3.model.ObjectMetadata s3ObjMetadata = this.objectMetadata(metadata);
        Optional<String> crc = this.getCrcAndSetHeader(objectType, file, metadata, s3ObjMetadata);
        PutObjectRequest request = new PutObjectRequest(this.bucket, key, file).withMetadata(s3ObjMetadata);
        this.setKmsParams(request);
        if (crc.isPresent()) {
            log.debug("Uploading object to s3://{}/{} with crc {}", new Object[]{this.bucket, key, crc.get()});
        } else {
            log.debug("Uploading object to s3://{}/{}", (Object)this.bucket, (Object)key);
        }
        this.client.putObject(request);
    }

    private CompletableFuture<PutObjectResponse> putFileAsync(String key, Map<String, String> metadata, File file, E2EChecksumProtectedObjectType objectType) {
        CompletableFuture<PutObjectResponse> future = new CompletableFuture<PutObjectResponse>();
        try {
            this.checkAsyncClientPresent("putFile");
            Optional<String> crc = this.getCrcAndSetHeaderV2(objectType, file, metadata);
            PutObjectRequest.Builder putRequestBuilder = software.amazon.awssdk.services.s3.model.PutObjectRequest.builder().bucket(this.bucket).key(key).metadata(metadata);
            this.setSseAlgorithmAndKmsParamsV2(putRequestBuilder);
            log.debug("Uploading object to s3://{}/{} with crc {}", new Object[]{this.bucket, key, crc.orElse(null)});
            this.asyncClientOpt.get().putObject((software.amazon.awssdk.services.s3.model.PutObjectRequest)putRequestBuilder.build(), AsyncRequestBody.fromFile((File)file)).handle((response, e) -> {
                if (e != null) {
                    future.completeExceptionally(e.getCause());
                } else {
                    future.complete((PutObjectResponse)response);
                }
                return null;
            });
        }
        catch (Exception e2) {
            log.error("Failed to send putFileAsync request, key: {}, metadata: {}, type: {}, file: {}", new Object[]{key, metadata, objectType, file.getPath()});
            future.completeExceptionally(e2);
        }
        return future;
    }

    private void putFileWithThrottling(String key, Map<String, String> metadata, File file, E2EChecksumProtectedObjectType objectType, Throttler throttler) throws IOException {
        com.amazonaws.services.s3.model.ObjectMetadata s3Metadata = this.objectMetadata(metadata);
        Optional<String> crc = this.getCrcAndSetHeader(objectType, file, metadata, s3Metadata);
        try (ThrottledFileInputStream fileInputStream = new ThrottledFileInputStream(file, throttler);){
            s3Metadata.setContentLength(file.length());
            PutObjectRequest request = new PutObjectRequest(this.bucket, key, (InputStream)fileInputStream, s3Metadata);
            this.setKmsParams(request);
            if (crc.isPresent()) {
                log.debug("Uploading object to s3 with throttling://{}/{} with crc {}", new Object[]{this.bucket, key, crc.get()});
            } else {
                log.debug("Uploading object to s3 with throttling://{}/{}", (Object)this.bucket, (Object)key);
            }
            this.client.putObject(request);
        }
    }

    private Optional<ExecutorService> getExecutor() {
        if (!this.executorOpt.isPresent()) {
            this.executorOpt = Optional.of(Executors.newSingleThreadExecutor());
        }
        return this.executorOpt;
    }

    private CompletableFuture<PutObjectResponse> putFileWithThrottlingAsync(String key, Map<String, String> metadata, File file, E2EChecksumProtectedObjectType objectType, Throttler throttler) {
        this.checkAsyncClientPresent("putFileWithThrottling");
        CompletableFuture<PutObjectResponse> future = new CompletableFuture<PutObjectResponse>();
        Optional<String> crc = this.getCrcAndSetHeaderV2(objectType, file, metadata);
        PutObjectRequest.Builder putRequestBuilder = software.amazon.awssdk.services.s3.model.PutObjectRequest.builder().bucket(this.bucket).key(key).metadata(metadata);
        this.setSseAlgorithmAndKmsParamsV2(putRequestBuilder);
        try (ThrottledFileInputStream fileInputStream = new ThrottledFileInputStream(file, throttler);){
            log.debug("Uploading object to s3 with throttling://{}/{} with crc {}", new Object[]{this.bucket, key, crc.orElse(null)});
            this.asyncClientOpt.get().putObject((software.amazon.awssdk.services.s3.model.PutObjectRequest)putRequestBuilder.build(), AsyncRequestBody.fromInputStream((InputStream)fileInputStream, (Long)file.length(), (ExecutorService)this.getExecutor().get())).handle((response, e) -> {
                if (e != null) {
                    future.completeExceptionally(e.getCause());
                } else {
                    future.complete((PutObjectResponse)response);
                }
                return null;
            });
        }
        catch (Exception e2) {
            future.completeExceptionally(e2);
        }
        return future;
    }

    private Optional<String> getCrcForCombinedObject(TierSegmentUpload<?> tierSegmentUpload) {
        return this.checksumStoreOpt.flatMap(checksumStore -> {
            if (!checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.SEGMENT_WITH_METADATA)) {
                return Optional.empty();
            }
            return Optional.of(tierSegmentUpload.getChecksumForCombinedObject());
        });
    }

    private Optional<String> getCrc(E2EChecksumProtectedObjectType objectType, File file, Map<String, String> metadata) {
        if (!this.checksumStoreOpt.isPresent()) {
            return Optional.empty();
        }
        E2EChecksumStore checksumStore = this.checksumStoreOpt.get();
        Optional crc = Optional.empty();
        if (checksumStore.checksumProtectionEnabled(objectType)) {
            crc = objectType.shouldCalculateBeforeUpload() ? E2EChecksumUtils.compute32BitBase64Crc32c((File)file) : E2EChecksumUtils.getBase64CrcFromStore((E2EChecksumStore)checksumStore, (File)file, metadata);
        }
        return crc;
    }

    private Optional<String> getCrcAndSetHeader(E2EChecksumProtectedObjectType objectType, File file, Map<String, String> metadata, com.amazonaws.services.s3.model.ObjectMetadata s3ObjMetadata) {
        Optional<String> crc = this.getCrc(objectType, file, metadata);
        crc.ifPresent(s -> s3ObjMetadata.setHeader(CRC32C_HEADER, s));
        return crc;
    }

    private Optional<String> getCrcAndSetHeaderV2(E2EChecksumProtectedObjectType objectType, File file, Map<String, String> metadata) {
        Optional<String> crc = this.getCrc(objectType, file, metadata);
        if (crc.isPresent()) {
            metadata.put(CRC32C_HEADER, crc.get());
        } else {
            metadata.remove(CRC32C_HEADER);
        }
        return crc;
    }

    public void putBuf(String key, Map<String, String> userMetadata, ByteBuffer buf) {
        com.amazonaws.services.s3.model.ObjectMetadata s3Metadata = this.objectMetadata(userMetadata);
        s3Metadata.setContentLength((long)(buf.limit() - buf.position()));
        s3Metadata.setHeader(CRC32C_HEADER, (Object)E2EChecksumUtils.compute32BitBase64Crc32c((ByteBuffer)buf));
        PutObjectRequest request = new PutObjectRequest(this.bucket, key, (InputStream)new ByteBufferInputStream(buf.duplicate()), s3Metadata);
        this.setKmsParams(request);
        log.debug("Uploading buffer to s3://{}/{}", (Object)this.bucket, (Object)key);
        this.client.putObject(request);
    }

    public CompletableFuture<PutObjectResponse> putBufAsync(String key, Map<String, String> userMetadata, ByteBuffer buf) {
        this.checkAsyncClientPresent("putBuf");
        CompletableFuture<PutObjectResponse> future = new CompletableFuture<PutObjectResponse>();
        HashMap<String, String> metadata = new HashMap<String, String>(userMetadata);
        metadata.put(CRC32C_HEADER, E2EChecksumUtils.compute32BitBase64Crc32c((ByteBuffer)buf));
        PutObjectRequest.Builder putRequestBuilder = software.amazon.awssdk.services.s3.model.PutObjectRequest.builder().bucket(this.bucket).key(key).metadata(metadata);
        this.setSseAlgorithmAndKmsParamsV2(putRequestBuilder);
        log.debug("Uploading buffer to s3://{}/{}", (Object)this.bucket, (Object)key);
        this.asyncClientOpt.get().putObject((software.amazon.awssdk.services.s3.model.PutObjectRequest)putRequestBuilder.build(), AsyncRequestBody.fromByteBuffer((ByteBuffer)buf.duplicate())).handle((response, e) -> {
            if (e != null) {
                future.completeExceptionally(e.getCause());
            } else {
                future.complete((PutObjectResponse)response);
            }
            return null;
        });
        return future;
    }

    private boolean usesKms() {
        return this.sseCustomerEncryptionKey != null && this.sseAlgorithm.equals("aws:kms");
    }

    private List<DeleteObjectsRequest.KeyVersion> keysForSegment(ObjectMetadata objectMetadata) {
        if (objectMetadata.isCombinedObject(this.prefix)) {
            return Collections.singletonList(new DeleteObjectsRequest.KeyVersion(this.keyPath(objectMetadata, ObjectType.SEGMENT_WITH_METADATA)));
        }
        ArrayList<DeleteObjectsRequest.KeyVersion> keys = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        block5: for (ObjectType objectType : TierObjectStore.getObjectTypesPerSegment()) {
            switch (objectType) {
                case TRANSACTION_INDEX: {
                    if (!objectMetadata.hasAbortedTxns()) continue block5;
                    keys.add(new DeleteObjectsRequest.KeyVersion(this.keyPath(objectMetadata, objectType)));
                    continue block5;
                }
                case EPOCH_STATE: {
                    if (!objectMetadata.hasEpochState()) continue block5;
                    keys.add(new DeleteObjectsRequest.KeyVersion(this.keyPath(objectMetadata, objectType)));
                    continue block5;
                }
                case PRODUCER_STATE: {
                    if (!objectMetadata.hasProducerState()) continue block5;
                    keys.add(new DeleteObjectsRequest.KeyVersion(this.keyPath(objectMetadata, objectType)));
                    continue block5;
                }
            }
            keys.add(new DeleteObjectsRequest.KeyVersion(this.keyPath(objectMetadata, objectType)));
        }
        return keys;
    }

    private List<ObjectIdentifier> keysForSegmentV2(ObjectMetadata objectMetadata) {
        if (objectMetadata.isCombinedObject(this.prefix)) {
            return Collections.singletonList(ObjectIdentifier.builder().key(this.keyPath(objectMetadata, ObjectType.SEGMENT_WITH_METADATA)).build());
        }
        ArrayList<ObjectIdentifier> keys = new ArrayList<ObjectIdentifier>();
        block5: for (ObjectType objectType : TierObjectStore.getObjectTypesPerSegment()) {
            switch (objectType) {
                case TRANSACTION_INDEX: {
                    if (!objectMetadata.hasAbortedTxns()) continue block5;
                    keys.add((ObjectIdentifier)ObjectIdentifier.builder().key(this.keyPath(objectMetadata, objectType)).build());
                    continue block5;
                }
                case EPOCH_STATE: {
                    if (!objectMetadata.hasEpochState()) continue block5;
                    keys.add((ObjectIdentifier)ObjectIdentifier.builder().key(this.keyPath(objectMetadata, objectType)).build());
                    continue block5;
                }
                case PRODUCER_STATE: {
                    if (!objectMetadata.hasProducerState()) continue block5;
                    keys.add((ObjectIdentifier)ObjectIdentifier.builder().key(this.keyPath(objectMetadata, objectType)).build());
                    continue block5;
                }
            }
            keys.add((ObjectIdentifier)ObjectIdentifier.builder().key(this.keyPath(objectMetadata, objectType)).build());
        }
        return keys;
    }

    @Override
    public BucketHealthResult checkBucketHealth() {
        if (this.v2Enabled) {
            return this.checkBucketHealthV2();
        }
        try {
            return this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                ByteBuffer payload = TierObjectStoreUtils.timeHealthPayload();
                HealthMetadata metadata = new HealthMetadata(this.clusterIdOpt, this.brokerIdOpt);
                String key = metadata.toFragmentLocation(this.prefix, FragmentType.HEALTH_CHECK).get().objectPath();
                this.putBuf(key, metadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt), payload);
                try (InputStream inputStream = this.getObjectStoreFragment(metadata, FragmentType.HEALTH_CHECK).getInputStream();){
                    int read;
                    while ((read = inputStream.read()) > 0) {
                        log.trace("Bucket probe read {} bytes", (Object)read);
                    }
                }
                this.client.deleteObject(this.bucket, key);
                return BucketHealthResult.HEALTHY;
            });
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 400 && e.getErrorCode() != null && e.getErrorCode().startsWith("KMS.")) {
                log.error("Bucket health checker resulted in a BYOK related error with error code: {}, status code: {}", new Object[]{e.getErrorCode(), e.getStatusCode(), e});
                return BucketHealthResult.BYOK;
            }
            if (e.getStatusCode() == 403 && Objects.equals(e.getErrorCode(), "AccessDenied")) {
                log.error("Bucket health checker resulted in a permission error for customer key: {}", (Object)(this.usesKms() ? "not enabled" : this.sseCustomerEncryptionKey), (Object)e);
                if (this.usesKms()) {
                    return BucketHealthResult.BYOK;
                }
                return BucketHealthResult.PERMISSION;
            }
            log.error("Bucket health checker returned an unclassified error for status code: {} error code: {}", new Object[]{e.getStatusCode(), e.getErrorCode(), e});
            return BucketHealthResult.UNCLASSIFIED;
        }
        catch (Exception e) {
            log.error("Bucket health checker returned unclassified error", (Throwable)e);
            return BucketHealthResult.UNCLASSIFIED;
        }
    }

    public BucketHealthResult checkBucketHealthV2() {
        try {
            this.checkAsyncClientPresent("checkBucketHealth");
            ByteBuffer payload = TierObjectStoreUtils.timeHealthPayload();
            HealthMetadata metadata = new HealthMetadata(this.clusterIdOpt, this.brokerIdOpt);
            String key = metadata.toFragmentLocation(this.prefix, FragmentType.HEALTH_CHECK).get().objectPath();
            this.putBufAsync(key, metadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt), payload).get();
            try (InputStream inputStream = this.getObjectStoreFragmentAsync(metadata, FragmentType.HEALTH_CHECK).get().getInputStream();){
                int read;
                while ((read = inputStream.read()) > 0) {
                    log.trace("Bucket probe read {} bytes", (Object)read);
                }
            }
            ObjectIdentifier objectToDelete = (ObjectIdentifier)ObjectIdentifier.builder().key(key).build();
            DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.bucket).delete((Delete)Delete.builder().objects(new ObjectIdentifier[]{objectToDelete}).build()).build();
            this.asyncClientOpt.get().deleteObjects(request).get();
            return BucketHealthResult.HEALTHY;
        }
        catch (Exception exception) {
            Throwable e;
            Throwable throwable = e = exception instanceof CompletionException ? exception.getCause() : exception;
            if (e instanceof AwsServiceException) {
                AwsServiceException awsEx = (AwsServiceException)e;
                if (awsEx.statusCode() == 400 && awsEx.awsErrorDetails().errorCode() != null && awsEx.awsErrorDetails().errorCode().startsWith("KMS.")) {
                    log.error("Bucket health checker resulted in a BYOK related error with error code: {}, status code: {}", new Object[]{awsEx.awsErrorDetails().errorCode(), awsEx.statusCode(), awsEx});
                    return BucketHealthResult.BYOK;
                }
                if (awsEx.statusCode() == 403 && Objects.equals(awsEx.awsErrorDetails().errorCode(), "AccessDenied")) {
                    log.error("Bucket health checker resulted in a permission error for customer key: {}", (Object)(this.usesKms() ? "not enabled" : this.sseCustomerEncryptionKey), (Object)awsEx);
                    if (this.usesKms()) {
                        return BucketHealthResult.BYOK;
                    }
                    return BucketHealthResult.PERMISSION;
                }
                log.error("Bucket health checker returned an unclassified error for status code: {} error code: {}", new Object[]{awsEx.statusCode(), awsEx.awsErrorDetails().errorCode(), awsEx});
                return BucketHealthResult.UNCLASSIFIED;
            }
            log.error("Bucket health checker returned unclassified error", e);
            return BucketHealthResult.UNCLASSIFIED;
        }
    }

    public static String validateAndGetS3RegionName(String s3Region) {
        try {
            return Regions.fromName((String)s3Region).getName();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Configured " + KafkaConfig.TierS3RegionProp() + " '" + s3Region + "' is not known");
        }
    }

    public static AmazonS3ClientAndCredentialsProvider client(S3TierObjectStoreConfig config) throws TierObjectStoreFatalException {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setUserAgentPrefix(config.s3UserAgentPrefix);
        SSLConnectionSocketFactory sslConnectionSocketFactory = S3TierObjectStore.getSSLConnectionSocketFactory(config);
        if (sslConnectionSocketFactory != null) {
            clientConfiguration.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)sslConnectionSocketFactory);
        }
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        builder.setClientConfiguration(clientConfiguration);
        if (config.s3ForcePathStyleAccess.booleanValue()) {
            builder.setPathStyleAccessEnabled(Boolean.valueOf(true));
        }
        if (config.s3SignerOverride.isPresent() && !config.s3SignerOverride.get().isEmpty()) {
            clientConfiguration.setSignerOverride(config.s3SignerOverride.get());
        }
        if (config.s3EndpointOverride.isPresent() && !config.s3EndpointOverride.get().isEmpty()) {
            String s3RegionName = S3TierObjectStore.validateAndGetS3RegionName(config.s3Region);
            builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(config.s3EndpointOverride.get(), s3RegionName));
        } else if (config.s3Region != null && !config.s3Region.isEmpty()) {
            builder.setRegion(config.s3Region);
        }
        log.debug("AWS_METADATA_SERVICE_TIMEOUT is {} seconds", (Object)System.getenv("AWS_METADATA_SERVICE_TIMEOUT"));
        AWSCredentialsProvider provider = config.s3CredFilePath.map(PropertiesFileCredentialsProvider::new).orElse((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
        if (config.assumeRoleArn.isPresent()) {
            AWSSecurityTokenServiceClientBuilder stsClientBuilder = AWSSecurityTokenServiceClient.builder();
            stsClientBuilder.setCredentials(provider);
            if (config.s3EndpointOverride.isPresent() && !config.s3EndpointOverride.get().isEmpty()) {
                String s3RegionName = S3TierObjectStore.validateAndGetS3RegionName(config.s3Region);
                stsClientBuilder.setRegion(s3RegionName);
            } else if (config.s3Region != null && !config.s3Region.isEmpty()) {
                stsClientBuilder.setRegion(config.s3Region);
            }
            AWSSecurityTokenService stsClient = (AWSSecurityTokenService)stsClientBuilder.build();
            provider = new STSAssumeRoleSessionCredentialsProvider.Builder(config.assumeRoleArn.get(), "tiered-storage").withStsClient(stsClient).build();
        }
        builder.setCredentials(provider);
        return new AmazonS3ClientAndCredentialsProvider((AmazonS3)builder.build(), S3TierObjectStore.buildAsyncClient(config, sslConnectionSocketFactory), provider);
    }

    private static Optional<S3AsyncClient> buildAsyncClient(S3TierObjectStoreConfig config, SSLConnectionSocketFactory sslConnectionSocketFactory) {
        if (sslConnectionSocketFactory != null) {
            log.error("Skip building S3 async client: sslConnectionSocketFactory is specified");
            return Optional.empty();
        }
        if (config.s3SignerOverride.isPresent() && !config.s3SignerOverride.get().isEmpty()) {
            log.error("Skip building S3 async client: s3SignerOverride is specified");
            return Optional.empty();
        }
        if (config.s3CredFilePath.isPresent() && !config.s3CredFilePath.get().isEmpty()) {
            log.error("Skip building S3 async client: s3CredFilePath is specified");
            return Optional.empty();
        }
        ClientOverrideConfiguration.Builder clientOverrideConfiguration = ClientOverrideConfiguration.builder();
        clientOverrideConfiguration.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)config.s3UserAgentPrefix);
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        builder.overrideConfiguration((ClientOverrideConfiguration)clientOverrideConfiguration.build());
        builder.forcePathStyle(config.s3ForcePathStyleAccess);
        if (config.s3EndpointOverride.isPresent() && !config.s3EndpointOverride.get().isEmpty()) {
            String s3RegionName = S3TierObjectStore.validateAndGetS3RegionName(config.s3Region);
            builder.endpointOverride(URI.create(config.s3EndpointOverride.get()));
            builder.region(Region.of((String)s3RegionName));
        } else if (config.s3Region != null && !config.s3Region.isEmpty()) {
            builder.region(Region.of((String)config.s3Region));
        }
        log.debug("AWS_METADATA_SERVICE_TIMEOUT is {} seconds", (Object)System.getenv("AWS_METADATA_SERVICE_TIMEOUT"));
        DefaultCredentialsProvider provider = DefaultCredentialsProvider.builder().build();
        if (config.assumeRoleArn.isPresent() && !config.assumeRoleArn.get().isEmpty()) {
            StsClient stsClient = (StsClient)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)provider)).build();
            provider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(config.assumeRoleArn.get()).roleSessionName("tiered-storage").build()).build();
        }
        builder.credentialsProvider((AwsCredentialsProvider)provider);
        return Optional.of(builder.build());
    }

    private void expectBucket(String bucket, String expectedRegion, Optional<String> endpointOverride) throws TierObjectStoreFatalException {
        try {
            String actualRegion = this.client.getBucketLocation(bucket);
            if (actualRegion.equals("US") && expectedRegion.equals("us-east-1")) {
                return;
            }
            if (!expectedRegion.equals(actualRegion)) {
                log.warn("Bucket region {} does not match expected region {}", (Object)actualRegion, (Object)expectedRegion);
            }
        }
        catch (AmazonClientException ex) {
            if (endpointOverride.isPresent() && !endpointOverride.get().isEmpty()) {
                log.warn("On-prem store does not implement S3 API's GetBucketLocation. Skipping check which ensures that actual bucket region matches expected region.");
            }
            throw new TierObjectStoreFatalException("Failed to validate that bucket location for " + bucket + " matches location " + expectedRegion + "; unable to call GetBucketLocation", ex);
        }
    }

    private static SSLConnectionSocketFactory getSSLConnectionSocketFactory(S3TierObjectStoreConfig config) throws TierObjectStoreFatalException {
        boolean hasCustomKeyStore;
        if (config.s3SecurityProviders.isPresent() && !config.s3SecurityProviders.get().trim().isEmpty()) {
            HashMap<String, String> securityProviders = new HashMap<String, String>();
            securityProviders.put("security.providers", config.s3SecurityProviders.get());
            SecurityUtils.addConfiguredSecurityProviders(securityProviders);
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        boolean hasCustomTrustStore = config.s3SslTrustStoreLocation.isPresent() && !config.s3SslTrustStoreLocation.get().isEmpty();
        boolean bl = hasCustomKeyStore = config.s3SslKeyStoreLocation.isPresent() && !config.s3SslKeyStoreLocation.get().isEmpty();
        if (hasCustomTrustStore || hasCustomKeyStore) {
            try {
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                if (hasCustomTrustStore) {
                    KeyStore trustStore = KeyStore.getInstance(config.s3SslTrustStoreType.get());
                    FileInputStream trustKeyStoreFile = new FileInputStream(config.s3SslTrustStoreLocation.get());
                    trustStore.load(trustKeyStoreFile, config.s3SslTrustStorePassword.get().value().toCharArray());
                    sslContextBuilder.loadTrustMaterial(trustStore, null);
                }
                if (hasCustomKeyStore) {
                    KeyStore keyStore = KeyStore.getInstance(config.s3SslKeyStoreType.get());
                    FileInputStream identityKeyStoreFile = new FileInputStream(config.s3SslKeyStoreLocation.get());
                    keyStore.load(identityKeyStoreFile, config.s3SslKeyStorePassword.get().value().toCharArray());
                    sslContextBuilder.loadKeyMaterial(keyStore, config.s3SslKeyPassword.get().value().toCharArray(), (aliases, socket) -> "confluent.kafka");
                }
                sslContextBuilder.setProtocol(config.s3SslProtocol);
                if (config.s3SslProvider.isPresent() && !config.s3SslProvider.get().trim().isEmpty()) {
                    config.s3SslProvider.ifPresent(arg_0 -> ((SSLContextBuilder)sslContextBuilder).setProvider(arg_0));
                }
                SSLContext sslContext = sslContextBuilder.build();
                sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, config.s3SslEnabledProtocols.toArray(new String[0]), null, (HostnameVerifier)new DefaultHostnameVerifier());
            }
            catch (Exception e) {
                throw new TierObjectStoreFatalException("Failed to load keystore or trust store for tiered object store", e);
            }
        }
        return sslConnectionSocketFactory;
    }

    private void handleAmazonClientException(AmazonClientException e, ObjectStoreMetadata objectMetadata, ObjectType objectType, File file) {
        if (objectType != ObjectType.SEGMENT_WITH_METADATA && e instanceof AmazonS3Exception && ERROR_CODE_BAD_DIGEST.equals(((AmazonS3Exception)((Object)e)).getErrorCode())) {
            this.validateChecksumOnPutSegmentFailure(objectMetadata, objectType, file, e);
        }
        throw new TierObjectStoreRetriableException("Failed to upload segment: " + objectMetadata + " due to file: " + file, e);
    }

    private void handleS3ExceptionDuringSegmentUpload(S3Exception e, ObjectStoreMetadata objectMetadata, ObjectType objectType, File file) {
        if (objectType != ObjectType.SEGMENT_WITH_METADATA) {
            this.validateChecksumOnPutSegmentFailure(objectMetadata, objectType, file, (Throwable)e);
        }
        throw new TierObjectStoreRetriableException("Failed to upload segment: " + objectMetadata + " due to file: " + file, (Throwable)e);
    }

    private void validateChecksumOnPutSegmentFailure(ObjectStoreMetadata objectMetadata, ObjectType objectType, File file, Throwable e) {
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        String filePath = file.getAbsolutePath();
        Optional crc = Optional.empty();
        String remotePath = this.keyPath(objectMetadata, objectType);
        if (this.checksumStoreOpt.isPresent() && this.checksumStoreOpt.get().checksumProtectionEnabled(objectType.toE2EChecksumProtectedObjectType())) {
            crc = E2EChecksumUtils.getBase64CrcFromStore((E2EChecksumStore)this.checksumStoreOpt.get(), (File)file, metadata);
        }
        if (crc.isPresent()) {
            Optional recalculatedCrc = E2EChecksumUtils.compute32BitBase64Crc32c((File)file);
            if (crc.equals(recalculatedCrc)) {
                log.info("Network Error: On-network corruption of a file during upload: {} with expected CRC value: {} and recalculated CRC value: {}", new Object[]{filePath, crc.get(), recalculatedCrc.get()});
                throw new TierObjectStoreRetriableException(String.format("Failed to upload object, due to on-network corruption, to %s with metadata %s, file %s, type %s", new Object[]{remotePath, metadata, file, objectType}), e);
            }
            throw new E2EChecksumInvalidException("Failed to upload object due to an on-disk corruption of file: " + filePath, e);
        }
    }

    private static class S3TierObjectStoreResponse
    implements TierObjectStoreResponse {
        private final AutoAbortingGenericInputStream inputStream;

        S3TierObjectStoreResponse(InputStream inputStream, long autoAbortSize, long streamSize) {
            this.inputStream = new S3AutoAbortingInputStream(inputStream, autoAbortSize, streamSize);
        }

        @Override
        public void close() {
            this.inputStream.close();
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }
    }

    public static class AmazonS3ClientAndCredentialsProvider {
        private final AmazonS3 client;
        private final Optional<S3AsyncClient> asyncClientOpt;
        private final AWSCredentialsProvider credentialsProvider;

        public AmazonS3ClientAndCredentialsProvider(AmazonS3 client, Optional<S3AsyncClient> asyncClientOpt, AWSCredentialsProvider credentialsProvider) {
            this.client = client;
            this.asyncClientOpt = asyncClientOpt;
            this.credentialsProvider = credentialsProvider;
        }

        public AmazonS3 client() {
            return this.client;
        }

        public Optional<S3AsyncClient> asyncClientOpt() {
            return this.asyncClientOpt;
        }

        public AWSCredentialsProvider credentialsProvider() {
            return this.credentialsProvider;
        }
    }
}

