/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.tier.DeletedPartitionsChangeListener;
import kafka.tier.TierReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.StartPartitionDeletion;
import kafka.tier.tasks.StopChangeMetadata;
import kafka.tier.tasks.StopLeadership;
import kafka.tier.tasks.StopPartitionDeletion;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.UpdatableQueue;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001B\t\u0013\u0001eA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!AQ\f\u0001B\u0001B\u0003%a\fC\u0003k\u0001\u0011\u00051\u000eC\u0003v\u0001\u0011\u0005c\u000f\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0011!\ty\u0001\u0001Q\u0001\n\u0005\r\u0001bBA\t\u0001\u0011\u0005\u00131\u0003\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\t)\u0004\u0001C!\u0003oAq!a\u000f\u0001\t\u0003\ni\u0004C\u0004\u0002`\u0001!\t%!\u0019\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005\u001d\u0004bBA6\u0001\u0011\u0005\u0013q\r\u0005\b\u0003[\u0002A\u0011BA8\u00055\u0019\u0005.\u00198hK6\u000bg.Y4fe*\u00111\u0003F\u0001\u0006i\u0006\u001c8n\u001d\u0006\u0003+Y\tA\u0001^5fe*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\r\u0001Q\"EK\u00174!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0003mC:<'\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cq\u0011aa\u00142kK\u000e$\bCA\u0012(\u001d\t!S%D\u0001\u0015\u0013\t1C#\u0001\nUS\u0016\u0014(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018B\u0001\u0015*\u00059\u0019\u0005.\u00198hK2K7\u000f^3oKJT!A\n\u000b\u0011\u0005\u0011Z\u0013B\u0001\u0017\u0015\u0005}!U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"iC:<W\rT5ti\u0016tWM\u001d\t\u0003]Ej\u0011a\f\u0006\u0003aY\tQ!\u001e;jYNL!AM\u0018\u0003\u000f1{wmZ5oOB\u00111\u0004N\u0005\u0003kq\u0011Q\"Q;u_\u000ecwn]3bE2,\u0017aA2uqB\u0011\u0001hO\u0007\u0002s)\u0011!\bF\u0001\bM\u0016$8\r[3s\u0013\ta\u0014HA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/\u0001\u0006uCN\\\u0017+^3vKN\u00042aP%M\u001d\t\u0001eI\u0004\u0002B\t6\t!I\u0003\u0002D1\u00051AH]8pizJ\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\"\u000bq\u0001]1dW\u0006<WMC\u0001F\u0013\tQ5JA\u0002TKFT!a\u0012%1\u00055\u001b\u0006c\u0001(P#6\t!#\u0003\u0002Q%\tiA+[3s)\u0006\u001c8.U;fk\u0016\u0004\"AU*\r\u0001\u0011IAKAA\u0001\u0002\u0003\u0015\t!\u0016\u0002\u0004?\u0012\n\u0014C\u0001,[!\t9\u0006,D\u0001I\u0013\tI\u0006JA\u0004O_RD\u0017N\\4\u0011\u0005][\u0016B\u0001/I\u0005\r\te._\u0001\u0005i&lW\r\u0005\u0002`Q6\t\u0001M\u0003\u00021C*\u0011!mY\u0001\u0007G>lWn\u001c8\u000b\u0005]!'BA3g\u0003\u0019\t\u0007/Y2iK*\tq-A\u0002pe\u001eL!!\u001b1\u0003\tQKW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\t1lg\u000e\u001e\t\u0003\u001d\u0002AQA\u000e\u0003A\u0002]BQ!\u0010\u0003A\u0002=\u00042aP%qa\t\t8\u000fE\u0002O\u001fJ\u0004\"AU:\u0005\u0013Qs\u0017\u0011!A\u0001\u0006\u0003)\u0006\"B/\u0005\u0001\u0004q\u0016A\u00037pO\u001e,'OT1nKV\tq\u000f\u0005\u0002yy:\u0011\u0011P\u001f\t\u0003\u0003\"K!a\u001f%\u0002\rA\u0013X\rZ3g\u0013\tihP\u0001\u0004TiJLgn\u001a\u0006\u0003w\"\u000b1b\u00195b]\u001e,\u0017+^3vKV\u0011\u00111\u0001\t\u0006\u001d\u0006\u0015\u0011\u0011B\u0005\u0004\u0003\u000f\u0011\"AD+qI\u0006$\u0018M\u00197f#V,W/\u001a\t\u0004\u001d\u0006-\u0011bAA\u0007%\tq1\t[1oO\u0016lU\r^1eCR\f\u0017\u0001D2iC:<W-U;fk\u0016\u0004\u0013AD8o\u0005\u0016\u001cw.\\3MK\u0006$WM\u001d\u000b\u0007\u0003+\tY\"!\n\u0011\u0007]\u000b9\"C\u0002\u0002\u001a!\u0013A!\u00168ji\"9\u0011Q\u0004\u0005A\u0002\u0005}\u0011\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o!\r!\u0013\u0011E\u0005\u0004\u0003G!\"\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\t9\u0003\u0003a\u0001\u0003S\t1\u0002\\3bI\u0016\u0014X\t]8dQB\u0019q+a\u000b\n\u0007\u00055\u0002JA\u0002J]R\f\u0001c\u001c8CK\u000e|W.\u001a$pY2|w/\u001a:\u0015\t\u0005U\u00111\u0007\u0005\b\u0003;I\u0001\u0019AA\u0010\u0003!yg\u000eR3mKR,G\u0003BA\u000b\u0003sAq!!\b\u000b\u0001\u0004\ty\"A\rj]&$\u0018.\u0019;f!\u0006\u0014H/\u001b;j_:$U\r\\3uS>tGCBA\u000b\u0003\u007f\t\t\u0005C\u0004\u0002\u001e-\u0001\r!a\b\t\u000f\u0005\r3\u00021\u0001\u0002F\u0005iA/[3sK\u0012|%M[3diN\u0004RaPA$\u0003\u0017J1!!\u0013L\u0005\u0011a\u0015n\u001d;\u0011\t\u00055\u00131L\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0003\u0002V\u0005]\u0013aB8cU\u0016\u001cGo\u001d\u0006\u0004\u00033\"\u0012!B:u_J,\u0017\u0002BA/\u0003\u001f\u0012ab\u00142kK\u000e$X*\u001a;bI\u0006$\u0018-A\u000bti>\u0004\b+\u0019:uSRLwN\u001c#fY\u0016$\u0018n\u001c8\u0015\t\u0005U\u00111\r\u0005\b\u0003;a\u0001\u0019AA\u0010\u0003E\u0001(o\\2fgN\fE\u000fT3bgR|e.\u001a\u000b\u0003\u0003+\tq\u0001\u001d:pG\u0016\u001c8/A\u0003dY>\u001cX-A\u0007qe>\u001cWm]:DQ\u0006tw-\u001a\u000b\u0005\u0003+\t\t\bC\u0004\u0002tA\u0001\r!!\u0003\u0002\r\rD\u0017M\\4f\u0001")
public class ChangeManager
implements TierReplicaManager.ChangeListener,
DeletedPartitionsChangeListener,
Logging,
AutoCloseable {
    private final CancellationContext ctx;
    private final Seq<TierTaskQueue<?>> taskQueues;
    private final UpdatableQueue<ChangeMetadata> changeQueue;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return ChangeManager.class.getName();
    }

    private UpdatableQueue<ChangeMetadata> changeQueue() {
        return this.changeQueue;
    }

    @Override
    public void onBecomeLeader(TopicIdPartition topicIdPartition, int leaderEpoch) {
        this.changeQueue().push(new StartLeadership(topicIdPartition, leaderEpoch));
    }

    @Override
    public void onBecomeFollower(TopicIdPartition topicIdPartition) {
        this.changeQueue().push(new StopLeadership(topicIdPartition));
    }

    @Override
    public void onDelete(TopicIdPartition topicIdPartition) {
        this.changeQueue().push(new StopLeadership(topicIdPartition));
    }

    @Override
    public void initiatePartitionDeletion(TopicIdPartition topicIdPartition, List<ObjectMetadata> tieredObjects) {
        this.changeQueue().push(new StartPartitionDeletion(topicIdPartition, tieredObjects));
    }

    @Override
    public void stopPartitionDeletion(TopicIdPartition topicIdPartition) {
        this.changeQueue().push(new StopPartitionDeletion(topicIdPartition));
    }

    public void processAtLeastOne() {
        ChangeMetadata change = this.changeQueue().take();
        this.processChange(change);
        this.process();
    }

    public void process() {
        boolean done = false;
        while (!this.ctx.isCancelled() && !done) {
            Option<ChangeMetadata> option = this.changeQueue().poll();
            if (option instanceof Some) {
                ChangeMetadata change = (ChangeMetadata)((Some)option).value();
                this.processChange(change);
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                done = true;
                continue;
            }
            throw new MatchError(option);
        }
    }

    @Override
    public void close() {
        this.ctx.cancel();
        this.changeQueue().close();
    }

    private void processChange(ChangeMetadata change) {
        if (change instanceof StartChangeMetadata) {
            StartChangeMetadata startChangeMetadata = (StartChangeMetadata)change;
            this.taskQueues.foreach((Function1 & Serializable)x$1 -> {
                x$1.maybeAddTask(startChangeMetadata);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (change instanceof StopChangeMetadata) {
            StopChangeMetadata stopChangeMetadata = (StopChangeMetadata)change;
            this.taskQueues.foreach((Function1 & Serializable)x$2 -> {
                x$2.maybeRemoveTask(stopChangeMetadata);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)change);
    }

    public ChangeManager(CancellationContext ctx, Seq<TierTaskQueue<?>> taskQueues, Time time) {
        this.ctx = ctx;
        this.taskQueues = taskQueues;
        this.changeQueue = new UpdatableQueue();
    }
}

