/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import com.yammer.metrics.core.Counter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Random;
import java.util.concurrent.CancellationException;
import kafka.cluster.Partition;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.ValidateLogResult$;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierLogCompactionFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreLinearRetry;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.compaction.CompactionTask$;
import kafka.tier.tasks.compaction.OffsetMapSupplier;
import kafka.tier.tasks.compaction.TierCleaner;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.tier.tasks.config.CompactionTasksConfig;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.SegmentMetadataLayoutPutMode;
import org.apache.kafka.storage.internals.log.ExtendedOffsetMap;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r\u0005h\u0001B#G\u0005=C\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t%\u0018\u0005\tI\u0002\u0011\t\u0011)A\u0005=\"AQ\r\u0001BC\u0002\u0013\u0005c\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003h\u0011!a\u0007A!b\u0001\n\u0003i\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u00028\t\u0011I\u0004!\u00111A\u0005\u0002MD!ba\"\u0001\u0005\u0003\u0007I\u0011ABE\u0011%\u0019i\t\u0001B\u0001B\u0003&A\u000f\u0003\u0006\u0002l\u0002\u0011)\u0019!C\u0001\u0007\u001fC!b!%\u0001\u0005\u0003\u0005\u000b\u0011BAw\u0011)\t)\u0010\u0001B\u0001B\u0003%\u0011q\u001f\u0005\b\u0003+\u0001A\u0011ABJ\u0011\u001d\tI\u0002\u0001C!\u00037A\u0011b!)\u0001\u0005\u0004%\taa)\t\u0011\r\u0015\u0006\u0001)A\u0005\u0005SC\u0011ba*\u0001\u0001\u0004%\ta!+\t\u0013\r5\u0006\u00011A\u0005\u0002\r=\u0006\u0002CBZ\u0001\u0001\u0006Kaa+\t\u000f\ru\u0006\u0001\"\u0001\u0004@\"9\u00111\u000e\u0001\u0005B\r-\u0007b\u0002B\\\u0001\u0011\u00053qI\u0004\b\u0003\u00071\u0005\u0012AA\u0003\r\u0019)e\t#\u0001\u0002\b!9\u0011Q\u0003\r\u0005\u0002\u0005]\u0001bBA\r1\u0011E\u00131\u0004\u0005\n\u0003[A\"\u0019!C\u0001\u0003_A\u0001\"a\u000e\u0019A\u0003%\u0011\u0011\u0007\u0005\n\u0003sA\"\u0019!C\u0001\u0003_A\u0001\"a\u000f\u0019A\u0003%\u0011\u0011\u0007\u0005\n\u0003{A\"\u0019!C\u0001\u0003\u007fA\u0001\"!\u0014\u0019A\u0003%\u0011\u0011\t\u0004\u000b\u0003\u001fB\u0002\u0013aI\u0011\r\u0006E\u0003bBA*C\u0019\u0005\u0011q\u0006\u0005\b\u0003+\nc\u0011AA,\u0011\u001d\tY'\tD\u0001\u0003[2aAa\u0002\u0019\u0001\n%\u0001BCA*K\tU\r\u0011\"\u0001\u00020!Q!1E\u0013\u0003\u0012\u0003\u0006I!!\r\t\u0015\t\u0015RE!f\u0001\n\u0003\u00119\u0003\u0003\u0006\u0003*\u0015\u0012\t\u0012)A\u0005\u00033Bq!!\u0006&\t\u0003\u0011Y\u0003C\u0004\u0002V\u0015\"\t%a\u0016\t\u000f\u0005-T\u0005\"\u0011\u00034!9!QJ\u0013\u0005\u0002\t=\u0003b\u0002BAK\u0011%!1\u0011\u0005\b\u0005++C\u0011\u0001BL\u0011\u001d\u00119,\nC!\u0005sC\u0011Ba/&\u0003\u0003%\tA!0\t\u0013\t\rW%%A\u0005\u0002\t\u0015\u0007\"\u0003BnKE\u0005I\u0011\u0001Bo\u0011%\u0011\t/JA\u0001\n\u0003\u0012\u0019\u000fC\u0005\u0003t\u0016\n\t\u0011\"\u0001\u00020!I!Q_\u0013\u0002\u0002\u0013\u0005!q\u001f\u0005\n\u0007\u0007)\u0013\u0011!C!\u0007\u000bA\u0011ba\u0005&\u0003\u0003%\ta!\u0006\t\u0013\reQ%!A\u0005B\rm\u0001\"CB\u0010K\u0005\u0005I\u0011IB\u0011\u0011%\u0019\u0019#JA\u0001\n\u0003\u001a)cB\u0005\u0004*a\t\t\u0011#\u0001\u0004,\u0019I!q\u0001\r\u0002\u0002#\u00051Q\u0006\u0005\b\u0003+iD\u0011AB#\u0011%\u00119,PA\u0001\n\u000b\u001a9\u0005C\u0005\u0004Ju\n\t\u0011\"!\u0004L!I1\u0011K\u001f\u0002\u0002\u0013\u000551\u000b\u0005\n\u0007Cj\u0014\u0011!C\u0005\u0007GBqaa\u001b\u0019\t\u0003\u0019i\u0007C\u0004\u0004~a!Iaa \u0003\u001d\r{W\u000e]1di&|g\u000eV1tW*\u0011q\tS\u0001\u000bG>l\u0007/Y2uS>t'BA%K\u0003\u0015!\u0018m]6t\u0015\tYE*\u0001\u0003uS\u0016\u0014(\"A'\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0015,\u0011\u0007E\u0013F+D\u0001I\u0013\t\u0019\u0006J\u0001\u0005US\u0016\u0014H+Y:l!\t)\u0006!D\u0001G!\t9&,D\u0001Y\u0015\tIF*A\u0003vi&d7/\u0003\u0002\\1\n9Aj\\4hS:<\u0017aA2uqV\ta\f\u0005\u0002`E6\t\u0001M\u0003\u0002b\u0015\u00069a-\u001a;dQ\u0016\u0014\u0018BA2a\u0005M\u0019\u0015M\\2fY2\fG/[8o\u0007>tG/\u001a=u\u0003\u0011\u0019G\u000f\u001f\u0011\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>tW#A4\u0011\u0005!LW\"\u0001&\n\u0005)T%\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003E!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0012_\u001a47/\u001a;NCB\u001cV\u000f\u001d9mS\u0016\u0014X#\u00018\u0011\u0005U{\u0017B\u00019G\u0005EyeMZ:fi6\u000b\u0007oU;qa2LWM]\u0001\u0013_\u001a47/\u001a;NCB\u001cV\u000f\u001d9mS\u0016\u0014\b%A\u0003ti\u0006$X-F\u0001u!\t)\u0018E\u0004\u0002w/9\u0019q/!\u0001\u000f\u0005a|hBA=\u007f\u001d\tQX0D\u0001|\u0015\tah*\u0001\u0004=e>|GOP\u0005\u0002\u001b&\u00111\nT\u0005\u0003\u0013*K!a\u0012%\u0002\u001d\r{W\u000e]1di&|g\u000eV1tWB\u0011Q\u000bG\n\u00051\u0005%a\u000b\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\t\ty!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u0014\u00055!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003\u000b\t!\u0002\\8hO\u0016\u0014h*Y7f+\t\ti\u0002\u0005\u0003\u0002 \u0005\u001db\u0002BA\u0011\u0003G\u00012A_A\u0007\u0013\u0011\t)#!\u0004\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\u0011\t)#!\u0004\u0002)\u0011+g-Y;mi6\u000b\u0007PU3uef\u001cu.\u001e8u+\t\t\t\u0004\u0005\u0003\u0002\f\u0005M\u0012\u0002BA\u001b\u0003\u001b\u00111!\u00138u\u0003U!UMZ1vYRl\u0015\r\u001f*fiJL8i\\;oi\u0002\n\u0001\u0004R3gCVdGOU3uefLe\u000e^3sm\u0006d\u0017J\\'t\u0003e!UMZ1vYR\u0014V\r\u001e:z\u0013:$XM\u001d<bY&sWj\u001d\u0011\u0002%\u0011+g-Y;miJ+GO]=Q_2L7-_\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000fR\u0015!B:u_J,\u0017\u0002BA&\u0003\u000b\u0012!\u0004V5fe>\u0013'.Z2u'R|'/\u001a'j]\u0016\f'OU3uef\f1\u0003R3gCVdGOU3uef\u0004v\u000e\\5ds\u0002\u00121cQ8na\u0006\u001cG/[8o)\u0006\u001c8n\u0015;bi\u0016\u001c2!IA\u0005\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0002\u0019\rdW-\u00198feN#\u0018\r^:\u0015\u0005\u0005e\u0003CBA\u0006\u00037\ny&\u0003\u0003\u0002^\u00055!AB(qi&|g\u000e\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)\u0007T\u0001\u0004Y><\u0017\u0002BA5\u0003G\u0012Ab\u00117fC:,'o\u0015;biN\f!\u0002\u001e:b]NLG/[8o)Y\ty'a#\u0002\u000e\u0006=\u0015qTAX\u0003s\u000b9-a:\u0002j\u0006MH\u0003BA9\u0003\u0003\u0003b!a\u001d\u0002z\u0005uTBAA;\u0015\u0011\t9(!\u0004\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002|\u0005U$A\u0002$viV\u0014X\rE\u0002\u0002\u0000\u0005j\u0011\u0001\u0007\u0005\b\u0003\u0007#\u00039AAC\u0003\t)7\r\u0005\u0003\u0002t\u0005\u001d\u0015\u0002BAE\u0003k\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000bq#\u0003\u0019\u00010\t\u000b\u0015$\u0003\u0019A4\t\u000f\u0005EE\u00051\u0001\u0002\u0014\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\u0003BAK\u00037k!!a&\u000b\u0007\u0005eE*\u0001\u0004tKJ4XM]\u0005\u0005\u0003;\u000b9J\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u000f\u0005\u0005F\u00051\u0001\u0002$\u0006\tB/[3s)>\u0004\u0018nY!qa\u0016tG-\u001a:\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OS1!!+K\u0003\u0015!x\u000e]5d\u0013\u0011\ti+a*\u0003#QKWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'\u000fC\u0004\u00022\u0012\u0002\r!a-\u0002\u001fQLWM](cU\u0016\u001cGo\u0015;pe\u0016\u0004B!a\u0011\u00026&!\u0011qWA#\u0005=!\u0016.\u001a:PE*,7\r^*u_J,\u0007bBA^I\u0001\u0007\u0011QX\u0001\u0007G>tg-[4\u0011\t\u0005}\u00161Y\u0007\u0003\u0003\u0003T1!a/I\u0013\u0011\t)-!1\u0003\u001fQKWM\u001d+bg.\u001c8i\u001c8gS\u001eDq!!3%\u0001\u0004\tY-A\u0005uQJ|G\u000f\u001e7feB!\u0011QZAr\u001b\t\tyMC\u0002Z\u0003#TA!a5\u0002V\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u0003/\fI.A\u0004ti>\u0014\u0018mZ3\u000b\u00075\u000bYN\u0003\u0003\u0002^\u0006}\u0017AB1qC\u000eDWM\u0003\u0002\u0002b\u0006\u0019qN]4\n\t\u0005\u0015\u0018q\u001a\u0002\n)\"\u0014x\u000e\u001e;mKJDQ\u0001\u001c\u0013A\u00029Dq!a;%\u0001\u0004\ti/A\u000buS\u0016\u00148i\\7qC\u000e$\u0018n\u001c8NKR\u0014\u0018nY:\u0011\u0007U\u000by/C\u0002\u0002r\u001a\u0013Q\u0003V5fe\u000e{W\u000e]1di&|g.T3ue&\u001c7\u000fC\u0004\u0002v\u0012\u0002\r!a>\u0002\tQLW.\u001a\t\u0005\u0003s\u0014\t!\u0004\u0002\u0002|*\u0019\u0011,!@\u000b\t\u0005}\u0018\u0011\\\u0001\u0007G>lWn\u001c8\n\t\t\r\u00111 \u0002\u0005)&lW-\u000b\u0002\"K\tA1\t\\3b]2{wmE\u0005&\u0003\u0013\tiHa\u0003\u0003\u0012A!\u00111\u0002B\u0007\u0013\u0011\u0011y!!\u0004\u0003\u000fA\u0013x\u000eZ;diB!!1\u0003B\u000f\u001d\u0011\u0011)B!\u0007\u000f\u0007i\u00149\"\u0003\u0002\u0002\u0010%!!1DA\u0007\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\b\u0003\"\ta1+\u001a:jC2L'0\u00192mK*!!1DA\u0007\u00031aW-\u00193fe\u0016\u0003xn\u00195!\u0003%a\u0017m\u001d;Ti\u0006$8/\u0006\u0002\u0002Z\u0005QA.Y:u'R\fGo\u001d\u0011\u0015\r\t5\"q\u0006B\u0019!\r\ty(\n\u0005\b\u0003'R\u0003\u0019AA\u0019\u0011\u001d\u0011)C\u000ba\u0001\u00033\"bC!\u000e\u0003:\tm\"Q\bB \u0005\u0003\u0012\u0019E!\u0012\u0003H\t%#1\n\u000b\u0005\u0003c\u00129\u0004C\u0004\u0002\u00042\u0002\u001d!!\"\t\u000bqc\u0003\u0019\u00010\t\u000b\u0015d\u0003\u0019A4\t\u000f\u0005EE\u00061\u0001\u0002\u0014\"9\u0011\u0011\u0015\u0017A\u0002\u0005\r\u0006bBAYY\u0001\u0007\u00111\u0017\u0005\b\u0003wc\u0003\u0019AA_\u0011\u001d\tI\r\fa\u0001\u0003\u0017DQ\u0001\u001c\u0017A\u00029Dq!a;-\u0001\u0004\ti\u000fC\u0004\u0002v2\u0002\r!a>\u0002\u0015\u0011|7\t\\3b]2{w\r\u0006\u000e\u0003R\tU#q\u000bB-\u00057\u0012iFa\u0018\u0003b\t%$1\u000eB>\u0005{\u0012y\b\u0006\u0003\u0002r\tM\u0003bBAB[\u0001\u000f\u0011Q\u0011\u0005\u000696\u0002\rA\u0018\u0005\b\u0003Ck\u0003\u0019AAR\u0011\u001d\t\u0019&\fa\u0001\u0003cAQ!Z\u0017A\u0002\u001dDq!!%.\u0001\u0004\t\u0019\nC\u0003m[\u0001\u0007a\u000eC\u0004\u0002<6\u0002\rAa\u0019\u0011\t\u0005}&QM\u0005\u0005\u0005O\n\tMA\u000bD_6\u0004\u0018m\u0019;j_:$\u0016m]6t\u0007>tg-[4\t\u000f\u0005EV\u00061\u0001\u00024\"9!QN\u0017A\u0002\t=\u0014a\u00029vi6{G-\u001a\t\u0005\u0005c\u00129(\u0004\u0002\u0003t)!\u00111\u0018B;\u0015\u0011\tI*!7\n\t\te$1\u000f\u0002\u001d'\u0016<W.\u001a8u\u001b\u0016$\u0018\rZ1uC2\u000b\u0017p\\;u!V$Xj\u001c3f\u0011\u001d\tY/\fa\u0001\u0003[Dq!!3.\u0001\u0004\tY\rC\u0004\u0002v6\u0002\r!a>\u0002AMDw.\u001e7e\t>$U/\u00197D_6\u0004\u0018m\u0019;j_:4\u0016\r\\5eCRLwN\u001c\u000b\u0007\u0005\u000b\u0013YIa%\u0011\t\u0005-!qQ\u0005\u0005\u0005\u0013\u000biAA\u0004C_>dW-\u00198\t\u000f\u0005\u0015d\u00061\u0001\u0003\u000eB!\u0011\u0011\rBH\u0013\u0011\u0011\t*a\u0019\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\b\u0003ws\u0003\u0019\u0001B2\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0019\te%q\u0014BR\u0005K\u0013yKa-\u0011\t\u0005-!1T\u0005\u0005\u0005;\u000biA\u0001\u0003V]&$\bb\u0002BQ_\u0001\u0007\u0011QD\u0001\u0005i\u0006\u001c8\u000eC\u0003f_\u0001\u0007q\rC\u0004\u0003(>\u0002\rA!+\u0002\t\u0019\u0014x.\u001c\t\u0005\u0003\u0017\u0011Y+\u0003\u0003\u0003.\u00065!\u0001\u0002'p]\u001eDqA!-0\u0001\u0004\u0011I+\u0001\u0002u_\"9!QW\u0018A\u0002\u0005}\u0013!B:uCR\u001c\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0011\u0001B2paf$bA!\f\u0003@\n\u0005\u0007\"CA*cA\u0005\t\u0019AA\u0019\u0011%\u0011)#\rI\u0001\u0002\u0004\tI&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u001d'\u0006BA\u0019\u0005\u0013\\#Aa3\u0011\t\t5'q[\u0007\u0003\u0005\u001fTAA!5\u0003T\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0005+\fi!\u0001\u0006b]:|G/\u0019;j_:LAA!7\u0003P\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u001c\u0016\u0005\u00033\u0012I-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005K\u0004BAa:\u0003r6\u0011!\u0011\u001e\u0006\u0005\u0005W\u0014i/\u0001\u0003mC:<'B\u0001Bx\u0003\u0011Q\u0017M^1\n\t\u0005%\"\u0011^\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011IPa@\u0011\t\u0005-!1`\u0005\u0005\u0005{\fiAA\u0002B]fD\u0011b!\u00017\u0003\u0003\u0005\r!!\r\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00199\u0001\u0005\u0004\u0004\n\r=!\u0011`\u0007\u0003\u0007\u0017QAa!\u0004\u0002\u000e\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\rE11\u0002\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0006\u000e]\u0001\"CB\u0001q\u0005\u0005\t\u0019\u0001B}\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\t\u00158Q\u0004\u0005\n\u0007\u0003I\u0014\u0011!a\u0001\u0003c\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003c\ta!Z9vC2\u001cH\u0003\u0002BC\u0007OA\u0011b!\u0001<\u0003\u0003\u0005\rA!?\u0002\u0011\rcW-\u00198M_\u001e\u00042!a >'\u0015i4qFB\u001e!)\u0019\tda\u000e\u00022\u0005e#QF\u0007\u0003\u0007gQAa!\u000e\u0002\u000e\u00059!/\u001e8uS6,\u0017\u0002BB\u001d\u0007g\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u0019ida\u0011\u000e\u0005\r}\"\u0002BB!\u0005[\f!![8\n\t\t}1q\b\u000b\u0003\u0007W!\"A!:\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\t52QJB(\u0011\u001d\t\u0019\u0006\u0011a\u0001\u0003cAqA!\nA\u0001\u0004\tI&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\rU3Q\f\t\u0007\u0003\u0017\tYfa\u0016\u0011\u0011\u0005-1\u0011LA\u0019\u00033JAaa\u0017\u0002\u000e\t1A+\u001e9mKJB\u0011ba\u0018B\u0003\u0003\u0005\rA!\f\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004fA!!q]B4\u0013\u0011\u0019IG!;\u0003\r=\u0013'.Z2u\u0003E9W\r\u001e+jKJdun\u001a+p\u00072,\u0017M\u001c\u000b\t\u0007_\u001a)ha\u001e\u0004zA\u0019Qk!\u001d\n\u0007\rMdI\u0001\bUS\u0016\u0014Hj\\4U_\u000ecW-\u00198\t\u000f\u0005\u00154\t1\u0001\u0003\u000e\"9\u0011Q_\"A\u0002\u0005]\bbBB>\u0007\u0002\u0007!\u0011V\u0001\u0004]><\u0018A\u00033jeRL(+\u00198hKR11\u0011QBB\u0007\u000b\u0003\u0002\"a\u0003\u0004Z\t%&\u0011\u0016\u0005\b\u0003K\"\u0005\u0019\u0001BG\u0011\u001d\u0019Y\b\u0012a\u0001\u0005S\u000b\u0011b\u001d;bi\u0016|F%Z9\u0015\t\te51\u0012\u0005\t\u0007\u0003A\u0011\u0011!a\u0001i\u000611\u000f^1uK\u0002*\"!!<\u0002-QLWM]\"p[B\f7\r^5p]6+GO]5dg\u0002\"R\u0002VBK\u0007/\u001bIja'\u0004\u001e\u000e}\u0005\"\u0002/\u000e\u0001\u0004q\u0006\"B3\u000e\u0001\u00049\u0007\"\u00027\u000e\u0001\u0004q\u0007\"\u0002:\u000e\u0001\u0004!\bbBAv\u001b\u0001\u0007\u0011Q\u001e\u0005\b\u0003kl\u0001\u0019AA|\u0003A!\u0018m]6De\u0016\fG/[8o)&lW-\u0006\u0002\u0003*\u0006\tB/Y:l\u0007J,\u0017\r^5p]RKW.\u001a\u0011\u0002\u00151|w\rV8DY\u0016\fg.\u0006\u0002\u0004,B1\u00111BA.\u0007_\na\u0002\\8h)>\u001cE.Z1o?\u0012*\u0017\u000f\u0006\u0003\u0003\u001a\u000eE\u0006\"CB\u0001%\u0005\u0005\t\u0019ABV\u0003-awn\u001a+p\u00072,\u0017M\u001c\u0011)\u0007M\u00199\f\u0005\u0003\u0002\f\re\u0016\u0002BB^\u0003\u001b\u0011\u0001B^8mCRLG.Z\u0001\u0016[\u0006L(-Z+qI\u0006$X\rT8h)>\u001cE.Z1o)!\u0019Yk!1\u0004D\u000e\u001d\u0007bBAI)\u0001\u0007\u00111\u0013\u0005\b\u0007\u000b$\u0002\u0019\u0001BU\u0003%qwn^'jY2L7\u000fC\u0004\u0004JR\u0001\rA!+\u0002\u001dU\u0004H-\u0019;f\u0013:$XM\u001d<bYRq1QZBj\u0007+\u001c9n!7\u0004\\\u000euG\u0003BBh\u0007#\u0004R!a\u001d\u0002zQCq!a!\u0016\u0001\b\t)\tC\u0004\u0002vV\u0001\r!a>\t\u000f\u0005\u0005V\u00031\u0001\u0002$\"9\u0011\u0011W\u000bA\u0002\u0005M\u0006bBAI+\u0001\u0007\u00111\u0013\u0005\b\u0003w+\u0002\u0019AA_\u0011\u001d\tI-\u0006a\u0001\u0007?\u0004b!a\u0003\u0002\\\u0005-\u0007")
public final class CompactionTask
extends TierTask<CompactionTask> {
    private final CancellationContext ctx;
    private final TopicIdPartition topicIdPartition;
    private final OffsetMapSupplier offsetMapSupplier;
    private CompactionTaskState state;
    private final TierCompactionMetrics tierCompactionMetrics;
    private final Time time;
    private final long taskCreationTime;
    private volatile Option<TierLogToClean> logToClean;

    public static TierLogToClean getTierLogToClean(AbstractLog log, Time time, long now) {
        return CompactionTask$.MODULE$.getTierLogToClean(log, time, now);
    }

    public static TierObjectStoreLinearRetry DefaultRetryPolicy() {
        return CompactionTask$.MODULE$.DefaultRetryPolicy();
    }

    public static int DefaultRetryIntervalInMs() {
        return CompactionTask$.MODULE$.DefaultRetryIntervalInMs();
    }

    public static int DefaultMaxRetryCount() {
        return CompactionTask$.MODULE$.DefaultMaxRetryCount();
    }

    @Override
    public CancellationContext ctx() {
        return this.ctx;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public OffsetMapSupplier offsetMapSupplier() {
        return this.offsetMapSupplier;
    }

    public CompactionTaskState state() {
        return this.state;
    }

    public void state_$eq(CompactionTaskState x$1) {
        this.state = x$1;
    }

    public TierCompactionMetrics tierCompactionMetrics() {
        return this.tierCompactionMetrics;
    }

    @Override
    public String loggerName() {
        return CompactionTask.class.getName();
    }

    public long taskCreationTime() {
        return this.taskCreationTime;
    }

    public Option<TierLogToClean> logToClean() {
        return this.logToClean;
    }

    public void logToClean_$eq(Option<TierLogToClean> x$1) {
        this.logToClean = x$1;
    }

    public Option<TierLogToClean> maybeUpdateLogToClean(ReplicaManager replicaManager, long nowMillis, long updateInterval) {
        Option updatedNextLogToClean = (this.state() instanceof CleanLog ? replicaManager.getLog(this.topicPartition()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isTierCompactable())) : None$.MODULE$).flatMap((Function1 & Serializable)log -> {
            if (this.logToClean().isEmpty() || this.logToClean().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.stale(log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), updateInterval)))) {
                return new Some((Object)CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, $this.time, nowMillis));
            }
            return this.logToClean();
        });
        this.logToClean_$eq((Option<TierLogToClean>)updatedNextLogToClean);
        return updatedNextLogToClean;
    }

    @Override
    public Future<CompactionTask> transition(Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, TierTasksConfig config, Option<Throttler> throttler, ExecutionContext ec) {
        return (this.ctx().isCancelled() ? Future$.MODULE$.successful((Object)this.state()) : this.state().transition(this.ctx(), this.topicIdPartition(), replicaManager, tierTopicAppender, tierObjectStore, config, (Throttler)throttler.get(), this.offsetMapSupplier(), this.tierCompactionMetrics(), time, ec)).map((Function1 & Serializable)result -> {
            this.onSuccessfulTransition();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(CompactionTask.$anonfun$transition$2(this, result)));
            }
            this.state_$eq((CompactionTaskState)result);
            return this;
        }, ec).recover((PartialFunction)new Serializable(this, config, time){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CompactionTask $outer;
            private final TierTasksConfig config$1;
            private final Time time$1;

            /*
             * WARNING - void declaration
             */
            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof TierMetadataRetriableException) {
                    void retryTaskLater_nowMs;
                    void retryTaskLater_maxRetryBackoffMs;
                    TierMetadataRetriableException tierMetadataRetriableException = (TierMetadataRetriableException)((Object)x1);
                    CompactionTask compactionTask = this.$outer;
                    long l = this.time$1.hiResClockMs();
                    int n = this.config$1.maxRetryBackoffMs();
                    if (compactionTask == null) {
                        throw null;
                    }
                    compactionTask.retryTaskLater((int)retryTaskLater_maxRetryBackoffMs, 0, (long)retryTaskLater_nowMs, (Throwable)((Object)tierMetadataRetriableException));
                    return (B1)this.$outer;
                }
                if (x1 instanceof TierObjectStoreRetriableException) {
                    void retryTaskLater_nowMs;
                    void retryTaskLater_maxRetryBackoffMs;
                    TierObjectStoreRetriableException tierObjectStoreRetriableException = (TierObjectStoreRetriableException)((Object)x1);
                    CompactionTask compactionTask = this.$outer;
                    long l = this.time$1.hiResClockMs();
                    int n = this.config$1.maxRetryBackoffMs();
                    if (compactionTask == null) {
                        throw null;
                    }
                    compactionTask.retryTaskLater((int)retryTaskLater_maxRetryBackoffMs, 0, (long)retryTaskLater_nowMs, (Throwable)((Object)tierObjectStoreRetriableException));
                    return (B1)this.$outer;
                }
                if (x1 instanceof LogCleaningAbortedException) {
                    LogCleaningAbortedException logCleaningAbortedException = (LogCleaningAbortedException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$1(this)), (Throwable)logCleaningAbortedException);
                    }
                    return (B1)this.$outer;
                }
                if (x1 instanceof E2EChecksumInvalidException) {
                    void retryTaskLater_nowMs;
                    void retryTaskLater_maxRetryBackoffMs;
                    E2EChecksumInvalidException e2EChecksumInvalidException = (E2EChecksumInvalidException)x1;
                    this.$outer.tierCompactionMetrics().e2eChecksumInvalidCount().foreach((Function1 & Serializable)x$3 -> {
                        $anonfun$transition$3.$anonfun$applyOrElse$3(x$3);
                        return BoxedUnit.UNIT;
                    });
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$4(this)), (Throwable)e2EChecksumInvalidException);
                    }
                    Object var11_12 = null;
                    CompactionTask compactionTask2 = this.$outer;
                    long l = this.time$1.hiResClockMs();
                    int n = this.config$1.maxRetryBackoffMs();
                    if (compactionTask2 == null) {
                        throw null;
                    }
                    compactionTask2.retryTaskLater((int)retryTaskLater_maxRetryBackoffMs, 0, (long)retryTaskLater_nowMs, e2EChecksumInvalidException);
                    return (B1)this.$outer;
                }
                if (x1 instanceof TierLogCompactionFencedException) {
                    TierLogCompactionFencedException tierLogCompactionFencedException = (TierLogCompactionFencedException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$6(this)), (Throwable)tierLogCompactionFencedException);
                    }
                    Object var12_16 = null;
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 instanceof CancellationException) {
                    CancellationException cancellationException = (CancellationException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$8(this)), (Throwable)cancellationException);
                    }
                    Object var13_18 = null;
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 instanceof NotTierablePartitionException) {
                    NotTierablePartitionException notTierablePartitionException = (NotTierablePartitionException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$10(this)), (Throwable)notTierablePartitionException);
                    }
                    Object var14_20 = null;
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 != null) {
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask error_this = compactionTask;
                    if (error_this.logger().underlying().isErrorEnabled()) {
                        error_this.logger().underlying().error(error_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$12(this)), x1);
                    }
                    Object var15_21 = null;
                    this.$outer.cancelAndSetErrorState(x1);
                    return (B1)this.$outer;
                }
                return (B1)function1.apply(null);
            }

            public final boolean isDefinedAt(Throwable x1) {
                if (x1 instanceof TierMetadataRetriableException) {
                    return true;
                }
                if (x1 instanceof TierObjectStoreRetriableException) {
                    return true;
                }
                if (x1 instanceof LogCleaningAbortedException) {
                    return true;
                }
                if (x1 instanceof E2EChecksumInvalidException) {
                    return true;
                }
                if (x1 instanceof TierLogCompactionFencedException) {
                    return true;
                }
                if (x1 instanceof CancellationException) {
                    return true;
                }
                if (x1 instanceof NotTierablePartitionException) {
                    return true;
                }
                return x1 != null;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$1($anonfun$transition$3 $this) {
                return new StringBuilder(35).append($this.$outer.topicIdPartition()).append(": compaction operation was aborted.").toString();
            }

            public static final /* synthetic */ LogCleaningAbortedException $anonfun$applyOrElse$2(LogCleaningAbortedException x4$1) {
                return x4$1;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$3(Counter x$3) {
                x$3.inc();
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$4($anonfun$transition$3 $this) {
                return new StringBuilder(48).append($this.$outer.topicIdPartition()).append(": checksum mismatch while uploading new segment.").toString();
            }

            public static final /* synthetic */ E2EChecksumInvalidException $anonfun$applyOrElse$5(E2EChecksumInvalidException x5$1) {
                return x5$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$6($anonfun$transition$3 $this) {
                return new StringBuilder(40).append($this.$outer.topicIdPartition()).append(" was fenced, stopping compaction process").toString();
            }

            public static final /* synthetic */ TierLogCompactionFencedException $anonfun$applyOrElse$7(TierLogCompactionFencedException x6$1) {
                return x6$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$8($anonfun$transition$3 $this) {
                return new StringBuilder(64).append($this.$outer.topicIdPartition()).append(" was fenced by cancellation context, stopping compaction process").toString();
            }

            public static final /* synthetic */ CancellationException $anonfun$applyOrElse$9(CancellationException x7$1) {
                return x7$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$10($anonfun$transition$3 $this) {
                return new StringBuilder(47).append($this.$outer.topicIdPartition()).append(" is not tierable and cannot use tier compaction").toString();
            }

            public static final /* synthetic */ NotTierablePartitionException $anonfun$applyOrElse$11(NotTierablePartitionException x8$1) {
                return x8$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$12($anonfun$transition$3 $this) {
                return new StringBuilder(67).append($this.$outer.topicIdPartition()).append(": unhandled exception in CompactionTask. Moving task to error state").toString();
            }

            public static final /* synthetic */ Throwable $anonfun$applyOrElse$13(Throwable x9$1) {
                return x9$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.time$1 = time$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3$adapted(com.yammer.metrics.core.Counter )}, serializedLambda);
            }
        }, ec);
    }

    public String toString() {
        return new StringBuilder(36).append("CompactionTask(").append(this.topicIdPartition()).append(", state=").append(this.state().getClass().getName()).append(", cancelled=").append(this.ctx().isCancelled()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$transition$2(CompactionTask $this, CompactionTaskState result$1) {
        return new StringBuilder(23).append("Transitioned ").append($this.topicIdPartition()).append(" from ").append($this.state()).append(" to ").append(result$1).toString();
    }

    public CompactionTask(CancellationContext ctx, TopicIdPartition topicIdPartition, OffsetMapSupplier offsetMapSupplier, CompactionTaskState state, TierCompactionMetrics tierCompactionMetrics, Time time) {
        this.ctx = ctx;
        this.topicIdPartition = topicIdPartition;
        this.offsetMapSupplier = offsetMapSupplier;
        this.state = state;
        this.tierCompactionMetrics = tierCompactionMetrics;
        this.time = time;
        super(tierCompactionMetrics.retryRateOpt());
        this.taskCreationTime = time.milliseconds();
        this.logToClean = None$.MODULE$;
    }

    public static class CleanLog
    implements CompactionTaskState,
    Product,
    Serializable {
        private final int leaderEpoch;
        private final Option<CleanerStats> lastStats;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public Option<CleanerStats> lastStats() {
            return this.lastStats;
        }

        @Override
        public Option<CleanerStats> cleanerStats() {
            return this.lastStats();
        }

        @Override
        public Future<CompactionTaskState> transition(CancellationContext ctx, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, TierTasksConfig config, Throttler throttler, OffsetMapSupplier offsetMapSupplier, TierCompactionMetrics tierCompactionMetrics, Time time, ExecutionContext ec) {
            CompactionTask$ info_this = CompactionTask$.MODULE$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = CleanLog.$anonfun$transition$4(topicIdPartition);
                Object var13_13 = null;
                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            }
            Object var12_12 = null;
            if (config.compactionTaskConfig().isEmpty()) {
                throw new IllegalArgumentException("Compaction task config was unexpectedly empty");
            }
            return this.doCleanLog(ctx, tierTopicAppender, this.leaderEpoch(), topicIdPartition, replicaManager, offsetMapSupplier, (CompactionTasksConfig)config.compactionTaskConfig().get(), tierObjectStore, config.segmentMetadataLayoutPutMode(), tierCompactionMetrics, throttler, time, ec).map((Function1 & Serializable)state -> {
                CompactionTask$ info_this = CompactionTask$.MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = CleanLog.$anonfun$transition$6(topicIdPartition);
                    Object var3_3 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
                return state;
            }, ec);
        }

        public Future<CompactionTaskState> doCleanLog(CancellationContext ctx, TierTopicAppender tierTopicAppender, int leaderEpoch, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, OffsetMapSupplier offsetMapSupplier, CompactionTasksConfig config, TierObjectStore tierObjectStore, SegmentMetadataLayoutPutMode putMode, TierCompactionMetrics tierCompactionMetrics, Throttler throttler, Time time, ExecutionContext ec) {
            return Future$.MODULE$.apply((Function0 & Serializable)() -> {
                Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
                if (either instanceof Left) {
                    Errors error = (Errors)((Left)either).value();
                    throw new TierLogCompactionFencedException(topicIdPartition, (Throwable)error.exception());
                }
                if (either instanceof Right) {
                    Partition partition = (Partition)((Right)either).value();
                    return (CompactionTaskState)partition.log().map((Function1 & Serializable)log -> {
                        Some stats;
                        block38: {
                            int tierEpoch = log.tierPartitionState().tierEpoch();
                            if (tierEpoch > leaderEpoch) {
                                throw new TierLogCompactionFencedException(topicIdPartition, null);
                            }
                            if (tierEpoch < leaderEpoch) {
                                throw new TierMetadataRetriableException(new StringBuilder(45).append("Leadership not established for ").append(topicIdPartition).append(". Backing off.").toString());
                            }
                            if (partition.isUncleanLeader()) {
                                throw new TierMetadataRetriableException(new StringBuilder(49).append(topicIdPartition).append(" undergoing unclean leader recovery. Backing off.").toString());
                            }
                            if (log.isTierMetadataStateRecovering()) {
                                throw new TierMetadataRetriableException(new StringBuilder(48).append(topicIdPartition).append(" undergoing tier metadata recovery. Backing off.").toString());
                            }
                            if (log.isFrozenLogStartOffsetState()) {
                                throw new TierMetadataRetriableException(new StringBuilder(46).append(topicIdPartition).append(" undergoing tiered data recovery. Backing off.").toString());
                            }
                            OffsetMap offsetMap = offsetMapSupplier.getOffsetMap();
                            stats = this.lastStats();
                            try {
                                void var37_53;
                                void var35_52;
                                Tuple2<Object, CleanerStats> tuple2;
                                if (!log.isTierCompactable()) {
                                    CompactionTask$ warn_this = CompactionTask$.MODULE$;
                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$3(topicIdPartition);
                                        Object var48_18 = null;
                                        warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                                    }
                                    Object var39_17 = null;
                                    break block38;
                                }
                                if (log.tieredLogSegments().isEmpty()) {
                                    CompactionTask$ warn_this = CompactionTask$.MODULE$;
                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$4(topicIdPartition);
                                        Object var49_20 = null;
                                        warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                                    }
                                    Object var40_19 = null;
                                    throw new TierMetadataRetriableException(new StringBuilder(60).append("Log for ").append(topicIdPartition).append(" has no eligible tiered segments for tier compaction").toString());
                                }
                                TierLogToClean cleanable = CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, time, time.milliseconds());
                                Function1 & Serializable checkDone = (Function1 & Serializable)x$4 -> {
                                    CleanLog.$anonfun$doCleanLog$5(ctx, x$4);
                                    return BoxedUnit.UNIT;
                                };
                                TierObjectStoreLinearRetry retryPolicy = CompactionTask$.MODULE$.DefaultRetryPolicy();
                                TierCleaner cleaner = new TierCleaner(offsetMap, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, tierCompactionMetrics, time, tierObjectStore, putMode, tierTopicAppender, leaderEpoch, ctx, (Function1<TopicPartition, BoxedUnit>)checkDone, retryPolicy);
                                Option<Object> lockedOffset = log.lockOffsetFromDeletion();
                                if (lockedOffset.isEmpty()) {
                                    CompactionTask$ warn_this = CompactionTask$.MODULE$;
                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$6(topicIdPartition);
                                        Object var50_27 = null;
                                        warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                                    }
                                    Object var41_26 = null;
                                    throw new LogCleaningAbortedException();
                                }
                                cleanable.firstCleanableOffset_$eq(BoxesRunTime.unboxToLong((Object)lockedOffset.get()));
                                try {
                                    block39: {
                                        long tierEndOffset = log.tierPartitionState().endOffset();
                                        if (this.shouldDoDualCompactionValidation((AbstractLog)log, config) && cleanable.firstCleanableOffset() >= log.localLogStartOffset() && cleanable.firstCleanableOffset() <= tierEndOffset && log.tierableLogSegments().isEmpty()) {
                                            OffsetMap localOffsetMap = offsetMapSupplier.getOffsetMap();
                                            try {
                                                CompactionTask$ warn_this;
                                                void var30_36;
                                                CleanerStats stats2;
                                                CompactionTask$ info_this = CompactionTask$.MODULE$;
                                                if (info_this.logger().underlying().isInfoEnabled()) {
                                                    String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$7(topicIdPartition, cleanable, tierEndOffset);
                                                    Object var51_31 = null;
                                                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                                                }
                                                Object var42_30 = null;
                                                ExtendedOffsetMap baseOffsetMap = new ExtendedOffsetMap(localOffsetMap);
                                                Cleaner localCleaner = new Cleaner(-1, localOffsetMap, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, time, (Function1<TopicPartition, BoxedUnit>)checkDone, tierCompactionMetrics.cleanerMetrics());
                                                Tuple2 tuple22 = CleanLog.liftedTree1$1(localCleaner, log, cleanable, tierEndOffset, baseOffsetMap, stats2 = new CleanerStats(time, tierCompactionMetrics.cleanerMetrics()), offsetMapSupplier, localOffsetMap);
                                                if (tuple22 == null) {
                                                    throw new MatchError(null);
                                                }
                                                boolean offsetMapSuccess = tuple22._1$mcZ$sp();
                                                String failReason = (String)tuple22._2();
                                                if (var30_36 == false) {
                                                    CompactionTask$ warn_this2 = CompactionTask$.MODULE$;
                                                    if (warn_this2.logger().underlying().isWarnEnabled()) {
                                                        void var31_37;
                                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$8(log, (String)var31_37);
                                                        Object var52_39 = null;
                                                        warn_this2.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this2, msgWithLogIdent_msg));
                                                    }
                                                    Object var43_38 = null;
                                                    stats2.validationAborted();
                                                    break block39;
                                                }
                                                if (log.tierPartitionState().endOffset() != tierEndOffset) {
                                                    CompactionTask$ warn_this3 = CompactionTask$.MODULE$;
                                                    if (warn_this3.logger().underlying().isWarnEnabled()) {
                                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$9(log, tierEndOffset);
                                                        Object var53_41 = null;
                                                        warn_this3.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this3, msgWithLogIdent_msg));
                                                    }
                                                    Object var44_40 = null;
                                                    stats2.validationAborted();
                                                    break block39;
                                                }
                                                Enumeration.Value value = cleaner.validateLog((AbstractLog)log, cleanable.firstCleanableOffset(), tierEndOffset + 1L, baseOffsetMap, stats2);
                                                Enumeration.Value value2 = ValidateLogResult$.MODULE$.Passed();
                                                if (!(value2 != null ? !value2.equals(value) : value != null)) {
                                                    CompactionTask$ info_this2 = CompactionTask$.MODULE$;
                                                    if (info_this2.logger().underlying().isInfoEnabled()) {
                                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$10(topicIdPartition);
                                                        Object var54_44 = null;
                                                        info_this2.logger().underlying().info(Logging.msgWithLogIdent$(info_this2, msgWithLogIdent_msg));
                                                    }
                                                    Object var45_43 = null;
                                                    stats2.validationPassed();
                                                    break block39;
                                                }
                                                Enumeration.Value value3 = ValidateLogResult$.MODULE$.Failed();
                                                if (!(value3 != null ? !value3.equals(value) : value != null)) {
                                                    CompactionTask$ warn_this4 = CompactionTask$.MODULE$;
                                                    if (warn_this4.logger().underlying().isWarnEnabled()) {
                                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$11(log);
                                                        Object var55_46 = null;
                                                        warn_this4.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this4, msgWithLogIdent_msg));
                                                    }
                                                    Object var46_45 = null;
                                                    stats2.validationFailed();
                                                    break block39;
                                                }
                                                Enumeration.Value value4 = ValidateLogResult$.MODULE$.Aborted();
                                                if (value4 == null) {
                                                    if (value != null) {
                                                        break block39;
                                                    }
                                                } else if (!value4.equals(value)) break block39;
                                                if ((warn_this = CompactionTask$.MODULE$).logger().underlying().isWarnEnabled()) {
                                                    String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$12(log);
                                                    Object var56_48 = null;
                                                    warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                                                }
                                                Object var47_47 = null;
                                                stats2.validationAborted();
                                            }
                                            finally {
                                                offsetMapSupplier.reclaimOffsetMap(localOffsetMap);
                                            }
                                        }
                                    }
                                    tuple2 = cleaner.clean(cleanable);
                                }
                                finally {
                                    log.unlockOffsetFromDeletion(cleanable.firstCleanableOffset());
                                }
                                Tuple2<Object, CleanerStats> tuple23 = tuple2;
                                if (tuple23 == null) {
                                    throw new MatchError(null);
                                }
                                long nextDirtyOffset = tuple23._1$mcJ$sp();
                                CleanerStats cleanerStats = (CleanerStats)tuple23._2();
                                if (var35_52 != -1L) {
                                    this.recordStats(this.toString(), topicIdPartition, cleanable.firstDirtyOffset(), (long)var35_52, (CleanerStats)var37_53);
                                }
                                stats = new Some((Object)var37_53);
                            }
                            finally {
                                offsetMapSupplier.reclaimOffsetMap(offsetMap);
                            }
                        }
                        return new CleanLog(leaderEpoch, (Option<CleanerStats>)stats);
                    }).getOrElse((Function0 & Serializable)() -> this);
                }
                throw new MatchError(either);
            }, ec);
        }

        private boolean shouldDoDualCompactionValidation(AbstractLog log, CompactionTasksConfig config) {
            return log.config().confluentLogConfig().tierCleanerDualCompaction && config.dualCompactionValidationPercent() > 0 && log.tierPartitionState().totalSize() <= config.dualCompactionValidationMaxBytes() && new Random().nextInt(100) < config.dualCompactionValidationPercent();
        }

        public void recordStats(String task, TopicIdPartition topicIdPartition, long from, long to, CleanerStats stats) {
            String message = new StringBuilder(0).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Tier Compaction Task: %s cleaned log %s (dirty section = [%d, %d))%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{task, topicIdPartition.toString(), BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / stats.elapsedSecs() / (double)0x100000))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tAverage key size for records observed during this compaction run is %.2f bytes%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.keyBytesRead() / (double)stats.messagesRead()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000 / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000 / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tThrottled time: %,.1f seconds (%.1f%% of total time)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)stats.throttledSecs()), BoxesRunTime.boxToDouble((double)((double)100 * stats.throttledSecs() / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesWritten() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            CompactionTask$ info_this = CompactionTask$.MODULE$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, message));
            }
            Object var9_7 = null;
            if (stats.invalidMessagesRead() > 0L) {
                CompactionTask$ warn_this = CompactionTask$.MODULE$;
                if (warn_this.logger().underlying().isWarnEnabled()) {
                    String msgWithLogIdent_msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())}));
                    Object var11_9 = null;
                    warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                    return;
                }
                return;
            }
        }

        public String toString() {
            return new StringBuilder(22).append("CleanLog(leaderEpoch=").append(this.leaderEpoch()).append(")").toString();
        }

        public CleanLog copy(int leaderEpoch, Option<CleanerStats> lastStats) {
            return new CleanLog(leaderEpoch, lastStats);
        }

        public int copy$default$1() {
            return this.leaderEpoch();
        }

        public Option<CleanerStats> copy$default$2() {
            return this.lastStats();
        }

        public String productPrefix() {
            return "CleanLog";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.leaderEpoch());
                }
                case 1: {
                    return this.lastStats();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CleanLog;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "leaderEpoch";
                }
                case 1: {
                    return "lastStats";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)this.leaderEpoch()), (int)Statics.anyHash(this.lastStats())), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof CleanLog)) break block3;
                    CleanLog cleanLog = (CleanLog)x$1;
                    if (this.leaderEpoch() != cleanLog.leaderEpoch()) break block3;
                    Option<CleanerStats> option = this.lastStats();
                    Option<CleanerStats> option2 = cleanLog.lastStats();
                    if ((option != null ? !option.equals(option2) : option2 != null) || !cleanLog.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public static final /* synthetic */ String $anonfun$transition$4(TopicIdPartition topicIdPartition$1) {
            return new StringBuilder(33).append("Starting tier log compaction for ").append(topicIdPartition$1).toString();
        }

        public static final /* synthetic */ String $anonfun$transition$6(TopicIdPartition topicIdPartition$1) {
            return new StringBuilder(34).append("Completed tier log compaction for ").append(topicIdPartition$1).toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$3(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(80).append("Log for ").append(topicIdPartition$2).append(" is not tier compact enabled, but is attempting to clean tiered segments").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$4(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(96).append("Log for ").append(topicIdPartition$2).append(" was scheduled in tier CompactionTask but has no eligible tiered segments for compaction").toString();
        }

        public static final /* synthetic */ void $anonfun$doCleanLog$5(CancellationContext ctx$1, TopicPartition x$4) {
            if (ctx$1.isCancelled()) {
                throw new CancellationException("Operation cancelled");
            }
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$6(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(99).append("Log for ").append(topicIdPartition$2).append(" is still locked by previous compaction round. Abort current operation and will be retried.").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$7(TopicIdPartition topicIdPartition$2, TierLogToClean cleanable$1, long tierEndOffset$1) {
            return new StringBuilder(73).append("Starting dual compaction validation for ").append(topicIdPartition$2).append(" for offset range [").append(cleanable$1.firstCleanableOffset()).append(", end offset=").append(tierEndOffset$1).append("]").toString();
        }

        private static final /* synthetic */ Tuple2 liftedTree1$1(Cleaner localCleaner$1, AbstractLog log$2, TierLogToClean cleanable$1, long tierEndOffset$1, ExtendedOffsetMap baseOffsetMap$1, CleanerStats stats$1, OffsetMapSupplier offsetMapSupplier$1, OffsetMap localOffsetMap$1) {
            Tuple2 tuple2;
            try {
                if (!localCleaner$1.buildOffsetMap(log$2, cleanable$1.firstCleanableOffset(), tierEndOffset$1 + 1L, (OffsetMap)baseOffsetMap$1, stats$1)) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
                }
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(96).append("offset map is too small for storing all keys in offset range [").append(cleanable$1.firstCleanableOffset()).append(", ").append(tierEndOffset$1).append("]. ").append("Offset map memory: ").append(offsetMapSupplier$1.offsetMapMemory()).append(", slots: ").append(localOffsetMap$1.slots()).append(".").toString());
            }
            catch (Throwable e) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(84).append("exception encountered when building offset map for local data in offset range [").append(cleanable$1.firstCleanableOffset()).append(", ").append(tierEndOffset$1).append("]. ").append(e).toString());
            }
            return tuple2;
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$8(AbstractLog log$2, String failReason$1) {
            return new StringBuilder(39).append("Abort dual compaction validation for ").append(log$2).append(". ").append(failReason$1).toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$9(AbstractLog log$2, long tierEndOffset$1) {
            return new StringBuilder(110).append("Abort dual compaction validation for ").append(log$2).append(" because tierEndOffset changed. old tierEndOffset: ").append(tierEndOffset$1).append(", new tierEndOffset: ").append(log$2.tierPartitionState().endOffset()).append(".").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$10(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(38).append("Dual compaction validation for ").append(topicIdPartition$2).append(" passed").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$11(AbstractLog log$2) {
            return new StringBuilder(38).append("Dual compaction validation for ").append(log$2).append(" failed").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$12(AbstractLog log$2) {
            return new StringBuilder(56).append("Dual compaction validation is not able to complete for ").append(log$2).append(".").toString();
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public static final /* synthetic */ String $anonfun$recordStats$1(String message$1) {
            return message$1;
        }

        public CleanLog(int leaderEpoch, Option<CleanerStats> lastStats) {
            this.leaderEpoch = leaderEpoch;
            this.lastStats = lastStats;
            Product.$init$((Product)this);
        }
    }

    public static interface CompactionTaskState {
        public int leaderEpoch();

        public Option<CleanerStats> cleanerStats();

        public Future<CompactionTaskState> transition(CancellationContext var1, TopicIdPartition var2, ReplicaManager var3, TierTopicAppender var4, TierObjectStore var5, TierTasksConfig var6, Throttler var7, OffsetMapSupplier var8, TierCompactionMetrics var9, Time var10, ExecutionContext var11);
    }
}

