/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kafka.tier.topic.recovery.TierTopicHeadDataLossReport;
import kafka.tier.topic.recovery.ValidationSource;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;

public class TierTopicDataLossValidatorMetrics {
    private final Metrics metrics;
    private final Map<ValidationSource, DataLossDetectionMetricGroup> metricGroups;

    public TierTopicDataLossValidatorMetrics(final Metrics metrics) {
        this.metrics = metrics;
        this.metricGroups = new HashMap<ValidationSource, DataLossDetectionMetricGroup>(){
            {
                this.put(ValidationSource.ON_DEMAND_VALIDATION, new DataLossDetectionMetricGroup(metrics, ValidationSource.ON_DEMAND_VALIDATION));
                this.put(ValidationSource.UNCLEAN_RESTART_VALIDATION, new DataLossDetectionMetricGroup(metrics, ValidationSource.UNCLEAN_RESTART_VALIDATION));
                this.put(ValidationSource.BOOTSTRAP_VALIDATION, new DataLossDetectionMetricGroup(metrics, ValidationSource.BOOTSTRAP_VALIDATION));
            }
        };
    }

    public void recordDataLossReport(TierTopicHeadDataLossReport report) {
        this.recordDataLossReport(report.source(), report.hasDataLoss(), report.hasFailures(), report.affectedUserPartitionReplicaCount(), report.affectedUserPartitionLeaderCount(), report.userPartitionsWithFencingFailures().size(), report.failedTierTopicPartitions().size(), report.affectedTierTopicPartitionCount());
    }

    void recordDataLossReport(ValidationSource source, boolean dataLossDetected, boolean dataLossDetectionFailed, int affectedUserPartitionReplicaCount, int affectedUserPartitionLeaderCount, int failedFencingUserPartitionCount, int failedTierTopicPartitionCount, int affectedTierTopicPartitionCount) {
        this.getMetricGroupOrThrow(source).recordDataLossReport(dataLossDetected, dataLossDetectionFailed, affectedUserPartitionReplicaCount, affectedUserPartitionLeaderCount, failedFencingUserPartitionCount, failedTierTopicPartitionCount, affectedTierTopicPartitionCount);
        if (!dataLossDetected && !dataLossDetectionFailed) {
            this.clearAllExcept(Optional.of(source));
        }
    }

    public void recordDataLossReportUploadStatus(ValidationSource source, boolean success) {
        this.getMetricGroupOrThrow(source).recordDataLossReportUploadStatus(success);
        if (success) {
            for (Map.Entry<ValidationSource, DataLossDetectionMetricGroup> entry : this.metricGroups.entrySet()) {
                if (entry.getKey() == source) continue;
                entry.getValue().recordDataLossReportUploadStatus(true);
            }
        }
    }

    public void recordDataLossDetectionFailure(ValidationSource source, boolean hasFailures) {
        this.getMetricGroupOrThrow(source).recordDataLossDetectionFailure(hasFailures);
        if (!hasFailures) {
            for (Map.Entry<ValidationSource, DataLossDetectionMetricGroup> entry : this.metricGroups.entrySet()) {
                if (entry.getKey() == source) continue;
                entry.getValue().recordDataLossDetectionFailure(false);
            }
        }
    }

    public void clearValidationSource(ValidationSource source) {
        this.getMetricGroupOrThrow(source).clear();
    }

    public void clearAll() {
        this.clearAllExcept(Optional.empty());
    }

    private void clearAllExcept(Optional<ValidationSource> excludedSource) {
        for (Map.Entry<ValidationSource, DataLossDetectionMetricGroup> entry : this.metricGroups.entrySet()) {
            if (excludedSource.isPresent() && entry.getKey() == excludedSource.get()) continue;
            this.clearValidationSource(entry.getKey());
        }
    }

    DataLossDetectionMetricGroup getMetricGroupOrThrow(ValidationSource source) {
        DataLossDetectionMetricGroup metricGroup = this.metricGroups.get((Object)source);
        if (metricGroup == null) {
            throw new IllegalArgumentException("Can't find DataLossDetectionMetricGroup for ValidationSource: " + (Object)((Object)source));
        }
        return metricGroup;
    }

    public static class DataLossDetectionMetricGroup {
        public static final String DATA_LOSS_DETECTED_METRIC_NAME = "DataLossDetected";
        public static final String DATA_LOSS_DETECTION_FAILURE_METRIC_NAME = "DataLossDetectionFailure";
        public static final String AFFECTED_USER_PARTITION_REPLICA_COUNT_METRIC_NAME = "AffectedUserPartitionReplicaCount";
        public static final String AFFECTED_USER_PARTITION_LEADER_COUNT_METRIC_NAME = "AffectedUserPartitionLeaderCount";
        public static final String FAILED_FENCING_USER_PARTITIONS_COUNT_METRIC_NAME = "FailedFencingUserPartitionCount";
        public static final String FAILED_TIER_TOPIC_PARTITION_COUNT_METRIC_NAME = "FailedTierTopicPartitionCount";
        public static final String AFFECTED_TIER_TOPIC_PARTITION_COUNT_METRIC_NAME = "AffectedTierTopicPartitionCount";
        public static final String DATA_LOSS_REPORT_UPLOAD_FAILURE_METRIC_NAME = "DataLossReportUploadFailure";
        public DataLossDetectionMetric dataLossDetectedMetric;
        public DataLossDetectionMetric dataLossDetectionFailureMetric;
        public DataLossDetectionMetric affectedUserPartitionReplicaCountMetric;
        public DataLossDetectionMetric affectedUserPartitionLeaderCountMetric;
        public DataLossDetectionMetric failedFencingUserPartitionCountMetric;
        public DataLossDetectionMetric failedTierTopicPartitionCountMetric;
        public DataLossDetectionMetric affectedTierTopicPartitionCountMetric;
        public DataLossDetectionMetric dataLossReportUploadFailureMetric;

        public DataLossDetectionMetricGroup(Metrics metrics, ValidationSource validationSource) {
            this.dataLossDetectedMetric = new DataLossDetectionMetric(DataLossDetectionMetricGroup.metricName(validationSource, DATA_LOSS_DETECTED_METRIC_NAME), "Integer value indicating data loss detected by TierTopicDataLossValidator component. 0 means no data loss, 1 means data loss.", metrics);
            this.dataLossDetectionFailureMetric = new DataLossDetectionMetric(DataLossDetectionMetricGroup.metricName(validationSource, DATA_LOSS_DETECTION_FAILURE_METRIC_NAME), "Integer value indicating whether the TierTopicDataLossValidator encountered a failure when detecting data loss. 0 means no failure, 1 means failure.", metrics);
            this.affectedUserPartitionReplicaCountMetric = new DataLossDetectionMetric(DataLossDetectionMetricGroup.metricName(validationSource, AFFECTED_USER_PARTITION_REPLICA_COUNT_METRIC_NAME), "Integer value indicating number of user partition replicas found to have data loss.", metrics);
            this.affectedUserPartitionLeaderCountMetric = new DataLossDetectionMetric(DataLossDetectionMetricGroup.metricName(validationSource, AFFECTED_USER_PARTITION_LEADER_COUNT_METRIC_NAME), "Integer value indicating number of user partition leaders found to have data loss.", metrics);
            this.failedFencingUserPartitionCountMetric = new DataLossDetectionMetric(DataLossDetectionMetricGroup.metricName(validationSource, FAILED_FENCING_USER_PARTITIONS_COUNT_METRIC_NAME), "Integer value indicating the number of user partitions that have failed fencing.", metrics);
            this.failedTierTopicPartitionCountMetric = new DataLossDetectionMetric(DataLossDetectionMetricGroup.metricName(validationSource, FAILED_TIER_TOPIC_PARTITION_COUNT_METRIC_NAME), "Integer value indicating the number of tier topic partitions that have failed data loss detection.", metrics);
            this.affectedTierTopicPartitionCountMetric = new DataLossDetectionMetric(DataLossDetectionMetricGroup.metricName(validationSource, AFFECTED_TIER_TOPIC_PARTITION_COUNT_METRIC_NAME), "Integer value indicating number of tier topic partitions found to have data loss.", metrics);
            this.dataLossReportUploadFailureMetric = new DataLossDetectionMetric(DataLossDetectionMetricGroup.metricName(validationSource, DATA_LOSS_REPORT_UPLOAD_FAILURE_METRIC_NAME), "Integer value indicating whether the TierTopicDataLossValidator encountered a failure when uploading the data loss report to the object store. 0 means no failure, 1 means failure.", metrics);
        }

        public static String metricName(ValidationSource source, String suffix) {
            return source.metricPrefix() + suffix;
        }

        public void recordDataLossReport(boolean dataLossDetected, boolean dataLossDetectionFailed, int affectedUserPartitionReplicaCount, int affectedUserPartitionLeaderCount, int failedFencingUserPartitionCount, int failedTierTopicPartitionCount, int affectedTierTopicPartitionCount) {
            this.dataLossDetectedMetric.record(dataLossDetected ? 1 : 0);
            this.recordDataLossDetectionFailure(dataLossDetectionFailed);
            this.affectedUserPartitionReplicaCountMetric.record(affectedUserPartitionReplicaCount);
            this.affectedUserPartitionLeaderCountMetric.record(affectedUserPartitionLeaderCount);
            this.failedFencingUserPartitionCountMetric.record(failedFencingUserPartitionCount);
            this.failedTierTopicPartitionCountMetric.record(failedTierTopicPartitionCount);
            this.affectedTierTopicPartitionCountMetric.record(affectedTierTopicPartitionCount);
        }

        public void recordDataLossReportUploadStatus(boolean success) {
            this.dataLossReportUploadFailureMetric.record(success ? 0 : 1);
        }

        public void recordDataLossDetectionFailure(boolean hasFailures) {
            this.dataLossDetectionFailureMetric.record(hasFailures ? 1 : 0);
        }

        public void clear() {
            this.recordDataLossReport(false, false, 0, 0, 0, 0, 0);
            this.recordDataLossReportUploadStatus(true);
        }
    }

    public static class DataLossDetectionMetric {
        public static final String METRIC_GROUP_NAME = "TierTopicDataLossValidator";
        public final MetricName metricName;
        public final IntGauge gauge = new IntGauge(0);

        public DataLossDetectionMetric(String name, String description, Metrics metrics) {
            this.metricName = metrics.metricName(name, METRIC_GROUP_NAME, description, Collections.emptyMap());
            metrics.addMetricIfAbsent(this.metricName, null, (MetricValueProvider)this.gauge);
        }

        public void record(int value) {
            this.gauge.record(value);
        }

        public int value() {
            return this.gauge.value(null, -1L);
        }
    }

    private static class IntGauge
    implements Gauge<Integer> {
        private int value;

        IntGauge(Integer initialValue) {
            this.value = initialValue;
        }

        public synchronized Integer value(MetricConfig config, long now) {
            return this.value;
        }

        synchronized void record(int value) {
            this.value = value;
        }
    }
}

