/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.MirrorTopicMetadata;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.metadata.MirrorTopicInfo;
import kafka.catalog.metadata.TopicInfo;
import kafka.common.TenantHelpers;
import kafka.controller.ReplicaAssignment;
import kafka.server.link.ClusterLinkTopicState;
import kafka.zk.TopicZNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.Tuple2;

public class MirrorTopicChangeEvent
extends MetadataCollectorEvent {
    private final String logicalClusterId;
    private final String topic;
    private final String mirrorTopicState;

    public MirrorTopicChangeEvent(ZKMetadataCollector collector, String logicalClusterId, String topic, String mirrorTopicState, Time time) {
        super(collector, time);
        this.logicalClusterId = logicalClusterId;
        this.topic = topic;
        this.mirrorTopicState = mirrorTopicState;
    }

    public void run() throws Exception {
        ZKMetadataCollectorContext context = this.context();
        LOG.debug("Updating mirror topic state for topic {} with new state {}", (Object)this.topic, (Object)this.mirrorTopicState);
        MetadataEvent metadataEvent = context.localStore().topicMetadataEvent(this.topic);
        Timestamp eventTimestamp = Timestamps.fromMillis((long)this.eventObservedTimeMillis);
        HashSet<String> topicConfigOverrides = new HashSet<String>();
        if (metadataEvent != null) {
            metadataEvent = this.buildMetadataEventFromExistingMetadataEvent(this.mirrorTopicState, metadataEvent, eventTimestamp);
        } else {
            int replicas;
            int partitions;
            Uuid id;
            LogConfig logConfig = this.getLogConfigsForTopic(context, this.topic);
            Optional<Object> mirrorTopicInfo = Optional.empty();
            if (!context.cacheInitialized() && context.topicInfo(this.topic) != null) {
                TopicInfo topicInfo = context.removeTopicFromInitialSnapshot(this.topic);
                id = topicInfo.topicId();
                partitions = topicInfo.partitions();
                replicas = topicInfo.replicationFactors();
                if (this.mirrorTopicState != null && topicInfo.mirrorTopicInfo().isPresent()) {
                    MirrorTopicInfo mirror = topicInfo.mirrorTopicInfo().get();
                    mirrorTopicInfo = Optional.of(new MirrorTopicInfo(mirror.linkName(), mirror.linkId(), this.topic, mirror.sourceTopicId(), this.mirrorTopicState, mirror.remoteClusterId()));
                }
            } else {
                TopicZNode.TopicIdReplicaAssignment topicIdReplicaAssignment = this.getTopicIdReplicaAssignmentFromZk(context, this.topic);
                if (topicIdReplicaAssignment.topicId().isEmpty() || topicIdReplicaAssignment.assignment().isEmpty()) {
                    LOG.debug("Ignoring event {} as topic doesn't exist in ZK", (Object)this);
                    return;
                }
                id = (Uuid)topicIdReplicaAssignment.topicId().get();
                partitions = topicIdReplicaAssignment.assignment().size();
                replicas = ((ReplicaAssignment)((Tuple2)topicIdReplicaAssignment.assignment().head())._2).targetReplicaAssignment().replicas().size();
                Optional<ClusterLinkTopicState> mirrorTopic = this.getMirrorTopicState(context, this.topic);
                if (mirrorTopic.isPresent()) {
                    ClusterLinkTopicState mirrorState = mirrorTopic.get();
                    Uuid linkId = mirrorState.linkId();
                    String remoteClusterId = this.getRemoteClusterId(context, linkId);
                    mirrorTopicInfo = Optional.of(new MirrorTopicInfo(mirrorState.linkName(), linkId, this.topic, mirrorState.sourceTopicId(), this.mirrorTopicState, remoteClusterId));
                }
            }
            MirrorTopicMetadata mirrorTopicMetadata = null;
            if (mirrorTopicInfo.isPresent()) {
                MirrorTopicInfo mirrorInfo = (MirrorTopicInfo)mirrorTopicInfo.get();
                mirrorTopicMetadata = MetadataEventUtils.mirrorTopicMetadata(mirrorInfo.linkId(), mirrorInfo.linkName(), mirrorInfo.sourceTopicId(), mirrorInfo.sourceTopicName(), mirrorInfo.mirrorTopicState(), mirrorInfo.remoteClusterId(), eventTimestamp);
            }
            metadataEvent = MetadataEventUtils.topicMetadataEventFromLogConfig(logConfig, TenantHelpers.extractLogicalName(this.topic), id, partitions, replicas, mirrorTopicMetadata, context.config().fullConfigsEnable, eventTimestamp, null);
            topicConfigOverrides.addAll(this.filterCatalogConfigOverride(logConfig.overriddenConfigs));
        }
        context.localStore().addTopicMetadataEvent(this.logicalClusterId, this.topic, metadataEvent, topicConfigOverrides, Collections.emptySet());
        MetadataChange topicMetadataChange = MetadataEventUtils.entityUpdateEvent(this.logicalClusterId, metadataEvent);
        this.emitTopicDeltaEvent(context, topicMetadataChange);
    }

    private MetadataEvent buildMetadataEventFromExistingMetadataEvent(String mirrorTopicState, MetadataEvent metadataEvent, Timestamp eventTimestamp) {
        MirrorTopicMetadata mirrorTopicMetadata = mirrorTopicState == null ? MirrorTopicMetadata.getDefaultInstance() : MirrorTopicMetadata.newBuilder().mergeFrom(metadataEvent.getTopicMetadata().getMirrorTopicMetadata()).setMirrorTopicState(mirrorTopicState).setUpdateTime(eventTimestamp).build();
        TopicMetadata topicMetadata = TopicMetadata.newBuilder().mergeFrom(metadataEvent.getTopicMetadata()).setMirrorTopicMetadata(mirrorTopicMetadata).setUpdateTime(eventTimestamp).build();
        return MetadataEvent.newBuilder().setTopicMetadata(topicMetadata).build();
    }

    public String toString() {
        return "MirrorTopicChangeEvent(topic=" + this.topic + ", mirrorTopicState=" + this.mirrorTopicState + ")";
    }
}

