/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.Kafka$;
import kafka.common.TenantHelpers;
import kafka.controller.PartitionSLOMetrics;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class PartitionSLOMetrics$ {
    public static final PartitionSLOMetrics$ MODULE$ = new PartitionSLOMetrics$();
    private static final HashMap<String, PartitionSLOMetrics> partitionMetricsMap = HashMap$.MODULE$.empty();
    private static int brokerId = 0;
    private static final String globalPartitionMetricsKey = new StringBuilder(7).append("global_").append(Uuid.randomUuid().toString()).toString();
    private static boolean isActiveController = false;
    private static boolean isMultiTenantCluster = false;
    private static final String TenantPartitionAvailabilitySLOMetric = "TenantPartitionAvailability";
    private static final String GlobalPartitionAvailabilityMetric = "PartitionAvailability";
    private static final String GlobalUnderMinIsrPartitionCountMetric = "GlobalUnderMinIsrPartitionCount";
    private static final String GlobalPartitionCountMetric = "GlobalPartitionCount";
    private static final String GlobalOfflinePartitionsCount = "OfflinePartitionsCount";

    private HashMap<String, PartitionSLOMetrics> partitionMetricsMap() {
        return partitionMetricsMap;
    }

    private int brokerId() {
        return brokerId;
    }

    private void brokerId_$eq(int x$1) {
        brokerId = x$1;
    }

    private String globalPartitionMetricsKey() {
        return globalPartitionMetricsKey;
    }

    public boolean isActiveController() {
        return isActiveController;
    }

    public void isActiveController_$eq(boolean x$1) {
        isActiveController = x$1;
    }

    public boolean isMultiTenantCluster() {
        return isMultiTenantCluster;
    }

    public void isMultiTenantCluster_$eq(boolean x$1) {
        isMultiTenantCluster = x$1;
    }

    public String TenantPartitionAvailabilitySLOMetric() {
        return TenantPartitionAvailabilitySLOMetric;
    }

    public String GlobalPartitionAvailabilityMetric() {
        return GlobalPartitionAvailabilityMetric;
    }

    public String GlobalUnderMinIsrPartitionCountMetric() {
        return GlobalUnderMinIsrPartitionCountMetric;
    }

    public String GlobalPartitionCountMetric() {
        return GlobalPartitionCountMetric;
    }

    public String GlobalOfflinePartitionsCount() {
        return GlobalOfflinePartitionsCount;
    }

    public HashMap<String, PartitionSLOMetrics> getPartitionMetricsMap() {
        return this.partitionMetricsMap();
    }

    public Option<PartitionSLOMetrics> getPartitionMetrics(String key) {
        return this.partitionMetricsMap().get((Object)key);
    }

    public PartitionSLOMetrics apply(boolean perTenantMetrics, Map<String, String> tags) {
        PartitionSLOMetrics metricsInstance = new PartitionSLOMetrics(perTenantMetrics, tags);
        metricsInstance.createMetrics();
        return metricsInstance;
    }

    public void onControllerChange(int broker, boolean activeController, boolean multiTenant) {
        this.isActiveController_$eq(activeController);
        this.isMultiTenantCluster_$eq(multiTenant);
        this.brokerId_$eq(broker);
        Kafka$ info_this = Kafka$.MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = PartitionSLOMetrics$.$anonfun$onControllerChange$1();
            Object var6_5 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
        }
        Object var4_4 = null;
        if (this.isActiveController()) {
            this.getOrCreateMetrics(this.globalPartitionMetricsKey(), false);
            return;
        }
        Kafka$ info_this2 = Kafka$.MODULE$;
        if (info_this2.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = PartitionSLOMetrics$.$anonfun$onControllerChange$2();
            Object var7_7 = null;
            info_this2.logger().underlying().info(Logging.msgWithLogIdent$(info_this2, msgWithLogIdent_msg));
        }
        Object var5_6 = null;
        this.partitionMetricsMap().foreach((Function1 & Serializable)p -> {
            PartitionSLOMetrics$.$anonfun$onControllerChange$3(p);
            return BoxedUnit.UNIT;
        });
        this.partitionMetricsMap().clear();
    }

    public void updateGlobalPartitionMetrics(int partitionCount, int offlineCount, int underMinIsrCount) {
        Option tm = this.partitionMetricsMap().get((Object)this.globalPartitionMetricsKey());
        if (tm.isDefined()) {
            ((PartitionSLOMetrics)tm.get()).update(partitionCount, offlineCount, underMinIsrCount);
            return;
        }
    }

    public void updateTenantPartitionMetrics(String topic, int partitionCount, int offlinePartitionCount, int underMinIsrPartitionCount) {
        this.getTenantPartitionMetrics(topic).foreach((Function1 & Serializable)tm -> {
            tm.update(partitionCount, offlinePartitionCount, underMinIsrPartitionCount);
            return BoxedUnit.UNIT;
        });
    }

    public void updateTenantPartitionCount(String topic, int count) {
        this.getTenantPartitionMetrics(topic).foreach((Function1 & Serializable)tm -> {
            tm.updatePartitionCountIncremental(count);
            return BoxedUnit.UNIT;
        });
    }

    public void updateTenantOfflinePartitionCount(String topic, int count) {
        this.getTenantPartitionMetrics(topic).foreach((Function1 & Serializable)tm -> {
            tm.updateOfflinePartitionCountIncremental(count);
            return BoxedUnit.UNIT;
        });
    }

    public void updateTenantUnderMinIsrCount(String topic, int count) {
        this.getTenantPartitionMetrics(topic).foreach((Function1 & Serializable)tm -> {
            tm.updateUnderMinIsrCountIncremental(count);
            return BoxedUnit.UNIT;
        });
    }

    private Option<PartitionSLOMetrics> getTenantPartitionMetrics(String topic) {
        Option tenantName = Option$.MODULE$.apply((Object)TenantHelpers.extractTenantPrefix(topic, false));
        if (this.isMultiTenantCluster() && this.isActiveController() && tenantName.isDefined()) {
            return Option$.MODULE$.apply((Object)this.getOrCreateMetrics((String)tenantName.get(), true));
        }
        return None$.MODULE$;
    }

    private PartitionSLOMetrics getOrCreateMetrics(String name, boolean perTenantMetrics) {
        return (PartitionSLOMetrics)this.partitionMetricsMap().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> MODULE$.apply(perTenantMetrics, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)name)})))));
    }

    private boolean getOrCreateMetrics$default$2() {
        return true;
    }

    public static final /* synthetic */ String $anonfun$onControllerChange$1() {
        return new StringBuilder(123).append("Partition SLO metrics processing controller change event for the broker ").append(MODULE$.brokerId()).append(" with flags [isActiveController: ").append(MODULE$.isActiveController()).append(", isMultiTenant: ").append(MODULE$.isMultiTenantCluster()).append("]").toString();
    }

    public static final /* synthetic */ String $anonfun$onControllerChange$2() {
        return new StringBuilder(56).append("Unregistering the Partition SLO metrics from the broker ").append(MODULE$.brokerId()).toString();
    }

    public static final /* synthetic */ void $anonfun$onControllerChange$3(Tuple2 p) {
        ((PartitionSLOMetrics)p._2()).removeMetrics();
    }

    private PartitionSLOMetrics$() {
    }
}

