/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kafka.catalog.ZKMetadataCollector;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.state.TierPartitionState;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.RetriableException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}e\u0001\u0002\u0010 \u0001\u0011B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!)\u0005A!A!\u0002\u00131\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011U\u0003!\u0011!Q\u0001\nYCQ!\u0018\u0001\u0005\u0002yCqa\u001a\u0001C\u0002\u0013\u0005\u0001\u000e\u0003\u0004m\u0001\u0001\u0006I!\u001b\u0005\u0006[\u0002!\tA\u001c\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+Aq!a\u0007\u0001\t\u0003\ti\u0002C\u0005\u0002\"\u0001\t\n\u0011\"\u0001\u0002$!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA%\u0001\u0011\u0005\u00111\n\u0005\b\u00033\u0002A\u0011BA.\u0011\u001d\ty\u0006\u0001C\u0005\u0003CBq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004bBA?\u0001\u0011%\u0011q\u0010\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Cq!a$\u0001\t\u0013\t\t\nC\u0004\u0002\u0016\u0002!I!a&\t\u000f\u0005u\u0005\u0001\"\u0003\u0002\u0012\t!Bk\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJT!\u0001I\u0011\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u0013,!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fMB\u0011AfL\u0007\u0002[)\u0011a&I\u0001\u0006kRLGn]\u0005\u0003a5\u0012q\u0001T8hO&tw-\u0001\u0004d_:4\u0017n\u001a\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0005\naa]3sm\u0016\u0014\u0018BA\u001c5\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0005\u0002;w5\tq$\u0003\u0002=?\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002'I,\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\u0011\u0005iz\u0014B\u0001! \u0005M\u0011V\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0003U\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016\u0004\"AO\"\n\u0005\u0011{\"!\u0006)beRLG/[8o'R\fG/Z'bG\"Lg.Z\u0001\u0007G2LWM\u001c;\u0011\u0005i:\u0015B\u0001% \u00059!U\r\\3uS>t7\t\\5f]R\f1\u0003^5feR{\u0007/[2NC:\fw-\u001a:PaR\u00042AJ&N\u0013\tauE\u0001\u0004PaRLwN\u001c\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bQ\u0001^8qS\u000eT!AU\u0011\u0002\tQLWM]\u0005\u0003)>\u0013\u0001\u0003V5feR{\u0007/[2NC:\fw-\u001a:\u0002'i\\W*\u001a;bI\u0006$\u0018mQ8mY\u0016\u001cGo\u001c:\u0011\u0007\u0019Zu\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[C\u000591-\u0019;bY><\u0017B\u0001/Z\u0005MQ6*T3uC\u0012\fG/Y\"pY2,7\r^8s\u0003\u0019a\u0014N\\5u}QAq\fY1cG\u0012,g\r\u0005\u0002;\u0001!)\u0011\u0007\u0003a\u0001e!)\u0001\b\u0003a\u0001s!)Q\b\u0003a\u0001}!)\u0011\t\u0003a\u0001\u0005\")Q\t\u0003a\u0001\r\")\u0011\n\u0003a\u0001\u0015\")Q\u000b\u0003a\u0001-\u0006!\u0012n\u001d#fY\u0016$X\rV8qS\u000e,e.\u00192mK\u0012,\u0012!\u001b\t\u0003M)L!a[\u0014\u0003\u000f\t{w\u000e\\3b]\u0006)\u0012n\u001d#fY\u0016$X\rV8qS\u000e,e.\u00192mK\u0012\u0004\u0013\u0001B5oSR$Ba\u001c:\u0002\fA\u0011a\u0005]\u0005\u0003c\u001e\u0012A!\u00168ji\")1o\u0003a\u0001i\u0006A\u0012N\\5uS\u0006dGk\u001c9jGN$vNQ3EK2,G/\u001a3\u0011\u0007UD(0D\u0001w\u0015\t9x%\u0001\u0006d_2dWm\u0019;j_:L!!\u001f<\u0003\u0007M+G\u000fE\u0002|\u0003\u000bq1\u0001`A\u0001!\tix%D\u0001\u007f\u0015\ty8%\u0001\u0004=e>|GOP\u0005\u0004\u0003\u00079\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\b\u0005%!AB*ue&twMC\u0002\u0002\u0004\u001dBa!!\u0004\f\u0001\u0004!\u0018AI5oSRL\u0017\r\u001c+pa&\u001c7/\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g.\u0001\tuef$v\u000e]5d\t\u0016dW\r^5p]R\tq.\u0001\rf]F,X-^3U_BL7m\u001d$pe\u0012+G.\u001a;j_:$2a\\A\f\u0011\u0019\tI\"\u0004a\u0001i\u00061Ao\u001c9jGN\fqC]3tk6,G)\u001a7fi&|gNR8s)>\u0004\u0018nY:\u0015\u0007=\fy\u0002\u0003\u0005\u0002\u001a9\u0001\n\u00111\u0001u\u0003\u0005\u0012Xm];nK\u0012+G.\u001a;j_:4uN\u001d+pa&\u001c7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t)CK\u0002u\u0003OY#!!\u000b\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g9\u0013AC1o]>$\u0018\r^5p]&!\u0011qGA\u0017\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0014M\u0006LGNU3qY&\u001c\u0017\rR3mKRLwN\u001c\u000b\u0004_\u0006u\u0002bBA !\u0001\u0007\u0011\u0011I\u0001\te\u0016\u0004H.[2bgB!Q\u000f_A\"!\rQ\u0014QI\u0005\u0004\u0003\u000fz\"a\u0005)beRLG/[8o\u0003:$'+\u001a9mS\u000e\f\u0017AH7be.$v\u000e]5d\u0013:,G.[4jE2,gi\u001c:EK2,G/[8o)\u0015y\u0017QJA(\u0011\u0019\tI\"\u0005a\u0001i\"A\u0011\u0011K\t\u0005\u0002\u0004\t\u0019&\u0001\u0004sK\u0006\u001cxN\u001c\t\u0005M\u0005U#0C\u0002\u0002X\u001d\u0012\u0001\u0002\u00102z]\u0006lWMP\u0001\u001dSN$v\u000e]5d\u0013:,G.[4jE2,gi\u001c:EK2,G/[8o)\rI\u0017Q\f\u0005\u0006!J\u0001\rA_\u0001\u001aSN$v\u000e]5d\t\u0016dW\r^5p]&s\u0007K]8he\u0016\u001c8\u000fF\u0002j\u0003GBQ\u0001U\nA\u0002i\f!$[:U_BL7-U;fk\u0016$W\u000b\u001d$pe\u0012+G.\u001a;j_:$2![A5\u0011\u0015\u0001F\u00031\u0001{\u0003]\u0019w.\u001c9mKR,'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000eF\u0002p\u0003_Bq!a\u0010\u0016\u0001\u0004\t\t%\u0001\u000ejgR{\u0007/[2FY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000eF\u0002j\u0003kBQ\u0001\u0015\fA\u0002i\f!E]3uef$U\r\\3uS>tgi\u001c:J]\u0016d\u0017nZ5cY\u0016\u0014V\r\u001d7jG\u0006\u001cHcA8\u0002|!1\u0011\u0011D\fA\u0002Q\fa#Y:z]\u000e$U\r\\3uKRKWM]3e)>\u0004\u0018n\u0019\u000b\u0004_\u0006\u0005\u0005\"\u0002)\u0019\u0001\u0004Q\u0018A\u00079sKB\f'/Z\"p[BdW\r^3EK2,G/\u001a+pa&\u001cGcA8\u0002\b\")\u0001+\u0007a\u0001u\u0006\tb-\u001b8jg\"$v\u000e]5d\t\u0016dW\r^3\u0015\u0007=\fi\tC\u0003Q5\u0001\u0007!0A\bp]R{\u0007/[2EK2,G/[8o)\ry\u00171\u0013\u0005\u0007\u00033Y\u0002\u0019\u0001;\u0002'=t\u0007+\u0019:uSRLwN\u001c#fY\u0016$\u0018n\u001c8\u0015\u0007=\fI\n\u0003\u0004\u0002\u001cr\u0001\r\u0001^\u0001\u0012i>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0017a\u0004:fgVlW\rR3mKRLwN\\:")
public class TopicDeletionManager
implements Logging {
    private final KafkaConfig config;
    private final ControllerContext controllerContext;
    private final ReplicaStateMachine replicaStateMachine;
    private final PartitionStateMachine partitionStateMachine;
    public final DeletionClient kafka$controller$TopicDeletionManager$$client;
    private final Option<TierTopicManager> tierTopicManagerOpt;
    private final Option<ZKMetadataCollector> zkMetadataCollector;
    private final boolean isDeleteTopicEnabled;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Initializing manager with initial deletions: ").append(initialTopicsToBeDeleted).append(", ").append("initial ineligible deletions: ").append(initialTopicsIneligibleForDeletion).toString());
        if (this.isDeleteTopicEnabled()) {
            this.controllerContext.queueTopicDeletion(initialTopicsToBeDeleted);
            this.controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((IterableOnce)initialTopicsIneligibleForDeletion.$amp(this.controllerContext.topicsToBeDeleted()));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Removing ").append(initialTopicsToBeDeleted).append(" since delete topic is disabled").toString());
        this.kafka$controller$TopicDeletionManager$$client.deleteTopicDeletions((scala.collection.immutable.Seq<String>)initialTopicsToBeDeleted.toSeq(), this.controllerContext.epochZkVersion());
    }

    public void tryTopicDeletion() {
        if (this.isDeleteTopicEnabled()) {
            this.resumeDeletions();
            return;
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            this.controllerContext.queueTopicDeletion(topics);
            this.resumeDeletions();
            return;
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            Set topicsToResumeDeletion = (Set)topics.$amp(this.controllerContext.topicsToBeDeleted());
            if (topicsToResumeDeletion.nonEmpty()) {
                this.controllerContext.topicsIneligibleForDeletion().$minus$minus$eq((IterableOnce)topicsToResumeDeletion);
                this.resumeDeletions();
                return;
            }
            return;
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return (Set)Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        if (this.isDeleteTopicEnabled()) {
            Set replicasThatFailedToDelete = (Set)replicas.filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
            if (replicasThatFailedToDelete.nonEmpty()) {
                Set topics = (Set)replicasThatFailedToDelete.map((Function1 & Serializable)x$1 -> x$1.topic());
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Deletion failed for replicas ").append(replicasThatFailedToDelete.mkString(",")).append(". Halting deletion for topics ").append(topics).toString());
                this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasThatFailedToDelete.toSeq(), ReplicaDeletionIneligible$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
                this.markTopicIneligibleForDeletion((Set<String>)topics, (Function0<String>)(Function0 & Serializable)() -> "replica deletion failure");
                this.resumeDeletions();
                return;
            }
            return;
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics, Function0<String> reason) {
        if (this.isDeleteTopicEnabled()) {
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.controllerContext.topicsToBeDeleted().$amp(topics);
            this.controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((IterableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Halted deletion of topics ").append(newTopicsToHaltDeletion.mkString(",")).append(" due to ").append(reason.apply()).toString());
                return;
            }
            return;
        }
    }

    private boolean isTopicIneligibleForDeletion(String topic) {
        if (this.isDeleteTopicEnabled()) {
            return this.controllerContext.topicsIneligibleForDeletion().contains((Object)topic);
        }
        return true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        if (this.isDeleteTopicEnabled()) {
            return this.controllerContext.isAnyReplicaInState(topic, ReplicaDeletionStarted$.MODULE$);
        }
        return false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        if (this.isDeleteTopicEnabled()) {
            return this.controllerContext.isTopicQueuedUpForDeletion(topic);
        }
        return false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Deletion successfully completed for replicas ").append(successfullyDeletedReplicas.mkString(",")).toString());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)successfullyDeletedReplicas.toSeq(), ReplicaDeletionSuccessful$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.resumeDeletions();
    }

    private boolean isTopicEligibleForDeletion(String topic) {
        return this.controllerContext.isTopicQueuedUpForDeletion(topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic) && !this.controllerContext.topicsWithDeletionBeingCompleted().contains((Object)topic);
    }

    private void retryDeletionForIneligibleReplicas(Set<String> topics) {
        Set failedReplicas = (Set)topics.flatMap((Function1 & Serializable)x$2 -> $this.controllerContext.replicasInState((String)x$2, ReplicaDeletionIneligible$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("Retrying deletion of topics ").append(topics.mkString(",")).append(" since replicas ").append(failedReplicas.mkString(",")).append(" were not successfully deleted").toString());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)failedReplicas.toSeq(), OfflineReplica$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
    }

    private void asyncDeleteTieredTopic(String topic) {
        Set<PartitionAndReplica> replicasForDeletedTopic = this.controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        TierTopicManager tierTopicManager = (TierTopicManager)this.tierTopicManagerOpt.get();
        Uuid topicId = (Uuid)this.controllerContext.topicIds().apply((Object)topic);
        scala.collection.immutable.Set partitionsForDeletedTopic = ((IterableOnceOps)replicasForDeletedTopic.map((Function1 & Serializable)x$3 -> x$3.topicPartition())).toSet();
        ListBuffer appendResults = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        partitionsForDeletedTopic.foreach((Function1 & Serializable)partition -> {
            TopicIdPartition topicIdPartition = new TopicIdPartition(topic, CoreUtils$.MODULE$.toJavaUUID(topicId), partition.partition());
            TierPartitionDeleteInitiate deleteInitiate = new TierPartitionDeleteInitiate(topicIdPartition, $this.controllerContext.epoch(), UUID.randomUUID());
            return (ListBuffer)appendResults.$plus$eq(tierTopicManager.addMetadata(deleteInitiate));
        });
        CompletableFuture.allOf((CompletableFuture[])appendResults.toSeq().toArray(ClassTag$.MODULE$.apply(CompletableFuture.class))).whenComplete((BiConsumer)new BiConsumer<Void, Throwable>(this, appendResults, topic){
            private final /* synthetic */ TopicDeletionManager $outer;
            private final ListBuffer appendResults$1;
            private final String topic$1;

            public BiConsumer<Void, Throwable> andThen(BiConsumer<? super Void, ? super Throwable> x$1) {
                return BiConsumer.super.andThen(x$1);
            }

            public void accept(Void result, Throwable t) {
                block5: {
                    Object object = new Object();
                    try {
                        if (t != null) {
                            this.$outer.kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(t, this.topic$1);
                            break block5;
                        }
                        ListBuffer results = (ListBuffer)this.appendResults$1.map((Function1 & Serializable)appendResult -> {
                            try {
                                return (TierPartitionState.AppendResult)((Object)((Object)appendResult.get()));
                            }
                            catch (Exception e) {
                                $this.$outer.kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(e, $this.topic$1);
                                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                            }
                        });
                        if (results.forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$accept$2(x$4)))) {
                            this.$outer.kafka$controller$TopicDeletionManager$$client.completeDeleteTopic(this.topic$1);
                            break block5;
                        }
                        this.$outer.kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(new IllegalStateException(new StringBuilder(18).append("Unexpected result ").append(results).toString()), this.topic$1);
                        return;
                    }
                    catch (NonLocalReturnControl ex) {
                        if (ex.key() == object) {
                            ex.value$mcV$sp();
                            return;
                        }
                        throw ex;
                    }
                }
            }

            public static final /* synthetic */ boolean $anonfun$accept$2(TierPartitionState.AppendResult x$4) {
                TierPartitionState.AppendResult appendResult = x$4;
                TierPartitionState.AppendResult appendResult2 = TierPartitionState.AppendResult.ACCEPTED;
                return !(appendResult != null ? !((Object)((Object)appendResult)).equals((Object)((Object)appendResult2)) : appendResult2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.appendResults$1 = appendResults$1;
                this.topic$1 = topic$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1(kafka.controller.TopicDeletionManager$$anon$1 java.lang.Object java.util.concurrent.CompletableFuture ), $anonfun$accept$2$adapted(kafka.tier.state.TierPartitionState$AppendResult )}, serializedLambda);
            }
        });
    }

    private void prepareCompleteDeleteTopic(String topic) {
        this.kafka$controller$TopicDeletionManager$$client.mutePartitionModifications(topic);
        this.controllerContext.topicsWithDeletionBeingCompleted().$plus$eq((Object)topic);
        if (Predef$.MODULE$.Boolean2boolean(this.config.confluentConfig().tierFeature())) {
            this.asyncDeleteTieredTopic(topic);
            return;
        }
        this.finishTopicDelete(topic);
    }

    public void finishTopicDelete(String topic) {
        if (this.controllerContext.topicsWithDeletionBeingCompleted().contains((Object)topic)) {
            Set<PartitionAndReplica> replicasForDeletedTopic = this.controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
            this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletedTopic.toSeq(), NonExistentReplica$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
            this.kafka$controller$TopicDeletionManager$$client.deleteTopic(topic, this.controllerContext.epochZkVersion());
            this.controllerContext.removeTopic(topic);
            this.controllerContext.topicsWithDeletionBeingCompleted().$minus$eq((Object)topic);
            this.zkMetadataCollector.foreach((Function1 & Serializable)x$5 -> {
                x$5.onTopicDelete(CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava());
                return BoxedUnit.UNIT;
            });
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Deletion of topic ").append(topic).append(" successfully completed").toString());
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Attempt to complete deletion for topic ").append(topic).append(", but not being tracked in set ").append($this.controllerContext.topicsWithDeletionBeingCompleted().mkString(",")).toString());
    }

    private void onTopicDeletion(Set<String> topics) {
        Set unseenTopicsForDeletion = (Set)topics.diff(this.controllerContext.topicsWithDeletionStarted());
        if (unseenTopicsForDeletion.nonEmpty()) {
            Set unseenPartitionsForDeletion = (Set)unseenTopicsForDeletion.flatMap((Function1 & Serializable)topic -> $this.controllerContext.partitionsForTopic((String)topic));
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), OfflinePartition$.MODULE$);
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), NonExistentPartition$.MODULE$);
            this.controllerContext.beginTopicDeletion((Set<String>)unseenTopicsForDeletion);
        }
        this.kafka$controller$TopicDeletionManager$$client.sendMetadataUpdate((Set<TopicPartition>)((Set)topics.flatMap((Function1 & Serializable)topic -> $this.controllerContext.partitionsForTopic((String)topic))));
        this.onPartitionDeletion(topics);
    }

    private void onPartitionDeletion(Set<String> topicsToBeDeleted) {
        ListBuffer allDeadReplicas = ListBuffer$.MODULE$.empty();
        ListBuffer allReplicasForDeletionRetry = ListBuffer$.MODULE$.empty();
        scala.collection.mutable.Set allTopicsIneligibleForDeletion = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
        topicsToBeDeleted.foreach((Function1 & Serializable)topic -> {
            void var7_7;
            void var6_6;
            Tuple2 tuple2 = $this.controllerContext.replicasForTopic((String)topic).partition((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.controllerContext.isReplicaOnline(r.replica(), r.topicPartition())));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Set aliveReplicas = (Set)tuple2._1();
            Set deadReplicas = (Set)tuple2._2();
            Set<PartitionAndReplica> successfullyDeletedReplicas = $this.controllerContext.replicasInState((String)topic, ReplicaDeletionSuccessful$.MODULE$);
            Set replicasForDeletionRetry = (Set)var6_6.diff(successfullyDeletedReplicas);
            allDeadReplicas.$plus$plus$eq((IterableOnce)var7_7);
            allReplicasForDeletionRetry.$plus$plus$eq((IterableOnce)replicasForDeletionRetry);
            if (var7_7.nonEmpty()) {
                this.debug((Function0<String>)((Function0 & Serializable)() -> TopicDeletionManager.$anonfun$onPartitionDeletion$3((Set)var7_7, topic)));
                return allTopicsIneligibleForDeletion.$plus$eq(topic);
            }
            return BoxedUnit.UNIT;
        });
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allDeadReplicas, ReplicaDeletionIneligible$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allReplicasForDeletionRetry, OfflineReplica$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allReplicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        if (allTopicsIneligibleForDeletion.nonEmpty()) {
            this.markTopicIneligibleForDeletion((Set<String>)allTopicsIneligibleForDeletion, (Function0<String>)(Function0 & Serializable)() -> "offline replicas");
            return;
        }
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = (Set)((SetOps)Set$.MODULE$.empty()).$plus$plus(this.controllerContext.topicsToBeDeleted());
        scala.collection.mutable.Set topicsEligibleForRetry = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
        scala.collection.mutable.Set topicsEligibleForDeletion = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
        if (topicsQueuedForDeletion.nonEmpty()) {
            topicsQueuedForDeletion.foreach((Function1 & Serializable)topic -> {
                TopicDeletionManager.$anonfun$resumeDeletions$1(this, topic);
                return BoxedUnit.UNIT;
            });
        }
        topicsQueuedForDeletion.diff(this.controllerContext.topicsWithDeletionBeingCompleted()).foreach((Function1 & Serializable)topic -> {
            if ($this.controllerContext.areAllReplicasInState((String)topic, ReplicaDeletionSuccessful$.MODULE$)) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("All replicas for ").append((String)topic).append(" have been successfully deleted. Preparing to complete topic deletion.").toString());
                this.prepareCompleteDeleteTopic((String)topic);
            } else if (!$this.controllerContext.isAnyReplicaInState((String)topic, ReplicaDeletionStarted$.MODULE$) && $this.controllerContext.isAnyReplicaInState((String)topic, ReplicaDeletionIneligible$.MODULE$)) {
                topicsEligibleForRetry.$plus$eq(topic);
            }
            if (this.isTopicEligibleForDeletion((String)topic)) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Deletion of topic ").append((String)topic).append(" (re)started").toString());
                return topicsEligibleForDeletion.$plus$eq(topic);
            }
            return BoxedUnit.UNIT;
        });
        if (topicsEligibleForRetry.nonEmpty()) {
            this.retryDeletionForIneligibleReplicas((Set<String>)topicsEligibleForRetry);
        }
        if (topicsEligibleForDeletion.nonEmpty()) {
            this.onTopicDeletion((Set<String>)topicsEligibleForDeletion);
            return;
        }
    }

    public final void kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(Throwable t, String topic$1) {
        if (t instanceof RetriableException ? true : t.getCause() != null && t.getCause() instanceof RetriableException) {
            try {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Retrying topic deletion for tiered topic ").append(topic$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                this.controllerContext.topicsWithDeletionBeingCompleted().$minus$eq((Object)topic$1);
                this.kafka$controller$TopicDeletionManager$$client.retryDeletion();
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Error deleting tiered topic ").append(topic$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
        }
        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Error deleting tiered topic ").append(topic$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
    }

    public static final /* synthetic */ String $anonfun$onPartitionDeletion$3(Set deadReplicas$1, String topic$3) {
        return new StringBuilder(33).append("Dead Replicas (").append(deadReplicas$1.mkString(",")).append(") found for topic ").append(topic$3).toString();
    }

    public static final /* synthetic */ void $anonfun$resumeDeletions$1(TopicDeletionManager $this, String topic) {
        Uuid topicId = $this.controllerContext.topicId(topic);
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Handling deletion of topic ").append(topic).append(" with topicId ").append(topicId).toString());
    }

    public TopicDeletionManager(KafkaConfig config, ControllerContext controllerContext, ReplicaStateMachine replicaStateMachine, PartitionStateMachine partitionStateMachine, DeletionClient client, Option<TierTopicManager> tierTopicManagerOpt, Option<ZKMetadataCollector> zkMetadataCollector) {
        this.config = config;
        this.controllerContext = controllerContext;
        this.replicaStateMachine = replicaStateMachine;
        this.partitionStateMachine = partitionStateMachine;
        this.kafka$controller$TopicDeletionManager$$client = client;
        this.tierTopicManagerOpt = tierTopicManagerOpt;
        this.zkMetadataCollector = zkMetadataCollector;
        this.logIdent_$eq(new StringBuilder(26).append("[Topic Deletion Manager ").append(config.brokerId()).append("] ").toString());
        this.isDeleteTopicEnabled = Predef$.MODULE$.Boolean2boolean(config.deleteTopicEnable());
    }
}

