/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.common.TenantHelpers;
import kafka.metrics.ConsumerLagEmitter$;
import kafka.metrics.ConsumerLagEmitterSummary;
import kafka.metrics.MemberTopicPartition;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.GaugeSuite;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r5u!\u0002/^\u0011\u0003\u0011g!\u00023^\u0011\u0003)\u0007\"\u00027\u0002\t\u0003i\u0007\"\u00028\u0002\t\u0003y\u0007\"CB\n\u0003E\u0005I\u0011AB\u000b\u0011%\u0019Y#\u0001b\u0001\n\u0003\u0019i\u0003\u0003\u0005\u00044\u0005\u0001\u000b\u0011BB\u0018\u0011%\u0019)$\u0001b\u0001\n\u0003\u0019i\u0003\u0003\u0005\u00048\u0005\u0001\u000b\u0011BB\u0018\u0011%\u0019I$\u0001b\u0001\n\u0003\u0019i\u0003\u0003\u0005\u0004<\u0005\u0001\u000b\u0011BB\u0018\u0011%\u0019i$\u0001b\u0001\n\u0003\u0019i\u0003\u0003\u0005\u0004@\u0005\u0001\u000b\u0011BB\u0018\u0011%\u0019\t%\u0001b\u0001\n\u0003\u0019i\u0003\u0003\u0005\u0004D\u0005\u0001\u000b\u0011BB\u0018\u0011%\u0019)%\u0001b\u0001\n\u0003\u0019i\u0003\u0003\u0005\u0004H\u0005\u0001\u000b\u0011BB\u0018\u0011%\u0019I%\u0001b\u0001\n\u0003\u0019i\u0003\u0003\u0005\u0004L\u0005\u0001\u000b\u0011BB\u0018\u0011%\u0019i%\u0001b\u0001\n\u0003\u0019i\u0003\u0003\u0005\u0004P\u0005\u0001\u000b\u0011BB\u0018\u0011%\u0019\t&\u0001b\u0001\n\u0003\u0019i\u0003\u0003\u0005\u0004T\u0005\u0001\u000b\u0011BB\u0018\u0011%\u0019)&\u0001b\u0001\n\u0003\u0019i\u0003\u0003\u0005\u0004X\u0005\u0001\u000b\u0011BB\u0018\u0011%\u0019I&\u0001b\u0001\n\u0003\t9\f\u0003\u0005\u0004\\\u0005\u0001\u000b\u0011BA]\u0011%\u0019i&\u0001b\u0001\n\u0003\t9\f\u0003\u0005\u0004`\u0005\u0001\u000b\u0011BA]\u0011)\u0019\t'\u0001b\u0001\n\u0003i61\r\u0005\t\u0007_\n\u0001\u0015!\u0003\u0004f!I1\u0011O\u0001C\u0002\u0013%11\r\u0005\t\u0007g\n\u0001\u0015!\u0003\u0004f!I1QO\u0001C\u0002\u0013%1q\u000f\u0005\t\u0007\u000b\u000b\u0001\u0015!\u0003\u0004z!I1qQ\u0001C\u0002\u0013%1q\u000f\u0005\t\u0007\u0013\u000b\u0001\u0015!\u0003\u0004z!I11R\u0001\u0012\u0002\u0013\u00051Q\u0003\u0004\u0005Iv\u0003\u0011\u000f\u0003\u0005_M\t\u0015\r\u0011\"\u0001s\u0011!yhE!A!\u0002\u0013\u0019\bBCA\u0001M\t\u0015\r\u0011\"\u0001\u0002\u0004!Q\u00111\u0004\u0014\u0003\u0002\u0003\u0006I!!\u0002\t\u0015\u0005uaE!b\u0001\n\u0003\ty\u0002\u0003\u0006\u00022\u0019\u0012\t\u0011)A\u0005\u0003CA!\"a\r'\u0005\u000b\u0007I\u0011AA\u001b\u0011)\t9E\nB\u0001B\u0003%\u0011q\u0007\u0005\u000b\u0003\u00132#Q1A\u0005\u0002\u0005-\u0003BCA*M\t\u0005\t\u0015!\u0003\u0002N!Q\u0011Q\u000b\u0014\u0003\u0006\u0004%\t!a\u0016\t\u0015\u0005\u001ddE!A!\u0002\u0013\tI\u0006\u0003\u0004mM\u0011\u0005\u0011\u0011\u000e\u0005\u000b\u0003o2#\u0019!C\u0001;\u0006e\u0004\u0002CAZM\u0001\u0006I!a\u001f\t\u0013\u0005Uf\u00051A\u0005\n\u0005]\u0006\"CA`M\u0001\u0007I\u0011BAa\u0011!\tiM\nQ!\n\u0005e\u0006\"CAlM\u0001\u0007I\u0011BA\\\u0011%\tIN\na\u0001\n\u0013\tY\u000e\u0003\u0005\u0002`\u001a\u0002\u000b\u0015BA]\u0011%\t\u0019O\na\u0001\n\u0013\t9\fC\u0005\u0002f\u001a\u0002\r\u0011\"\u0003\u0002h\"A\u00111\u001e\u0014!B\u0013\tI\fC\u0005\u0002p\u001a\u0002\r\u0011\"\u0003\u00028\"I\u0011\u0011\u001f\u0014A\u0002\u0013%\u00111\u001f\u0005\t\u0003o4\u0003\u0015)\u0003\u0002:\"I\u00111 \u0014A\u0002\u0013%\u00111\n\u0005\n\u0003{4\u0003\u0019!C\u0005\u0003\u007fD\u0001Ba\u0001'A\u0003&\u0011Q\n\u0005\n\u0005\u000f1\u0003\u0019!C\u0005\u0003\u0017B\u0011B!\u0003'\u0001\u0004%IAa\u0003\t\u0011\t=a\u0005)Q\u0005\u0003\u001bB\u0011Ba\u0005'\u0001\u0004%I!a\u0013\t\u0013\tUa\u00051A\u0005\n\t]\u0001\u0002\u0003B\u000eM\u0001\u0006K!!\u0014\t\u0013\t}aE1A\u0005\n\t\u0005\u0002\u0002\u0003B\u0015M\u0001\u0006IAa\t\t\u0013\t-bE1A\u0005\n\t5\u0002\u0002\u0003B\u001bM\u0001\u0006IAa\f\t\u0013\t]bE1A\u0005\u0002\te\u0002\u0002\u0003B$M\u0001\u0006IAa\u000f\t\u000f\t%c\u0005\"\u0001\u0003L!9!Q\n\u0014\u0005\u0002\t-\u0003b\u0002B(M\u0011\u0005!1\n\u0005\t\u0005#2C\u0011A/\u0003T!9!1\f\u0014\u0005\n\tu\u0003b\u0002B>M\u0011%!Q\u0010\u0005\b\u0005_3C\u0011\u0002BY\u0011\u001d\u0011yM\nC\u0005\u0005#DqA!6'\t\u0013\u00119\u000e\u0003\u0005\u0003Z\u001a\"\t!\u0018Bn\u0011\u001d\u00119O\nC\u0005\u0005S\f!cQ8ogVlWM\u001d'bO\u0016k\u0017\u000e\u001e;fe*\u0011alX\u0001\b[\u0016$(/[2t\u0015\u0005\u0001\u0017!B6bM.\f7\u0001\u0001\t\u0003G\u0006i\u0011!\u0018\u0002\u0013\u0007>t7/^7fe2\u000bw-R7jiR,'o\u0005\u0002\u0002MB\u0011qM[\u0007\u0002Q*\t\u0011.A\u0003tG\u0006d\u0017-\u0003\u0002lQ\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u00012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0017A\u0014yO!=\u0003t\nU(q\u001f\t\u0003G\u001a\u001a\"A\n4\u0016\u0003M\u0004\"\u0001^?\u000e\u0003UT!A\u0018<\u000b\u0005]D\u0018AB2p[6|gN\u0003\u0002as*\u0011!p_\u0001\u0007CB\f7\r[3\u000b\u0003q\f1a\u001c:h\u0013\tqXOA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\n\u0001B]3hSN$(/_\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u00185\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0003d_J,'b\u00010\u0002\u0010)!\u0011\u0011CA\n\u0003\u0019I\u0018-\\7fe*\u0011\u0011QC\u0001\u0004G>l\u0017\u0002BA\r\u0003\u0013\u0011q\"T3ue&\u001c7OU3hSN$(/_\u0001\ne\u0016<\u0017n\u001d;ss\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003[i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0005kRLGNC\u0002\u0002,a\faa]3sm\u0016\u0014\u0018\u0002BA\u0018\u0003K\u0011\u0011bU2iK\u0012,H.\u001a:\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%\u0001\the>,\boQ8pe\u0012Lg.\u0019;peV\u0011\u0011q\u0007\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003\u00159'o\\;q\u0015\r\t\t\u0005_\u0001\fG>|'\u000fZ5oCR|'/\u0003\u0003\u0002F\u0005m\"\u0001E$s_V\u00048i\\8sI&t\u0017\r^8s\u0003E9'o\\;q\u0007>|'\u000fZ5oCR|'\u000fI\u0001\u000fK6LG/\u00138uKJ4\u0018\r\\'t+\t\ti\u0005E\u0002h\u0003\u001fJ1!!\u0015i\u0005\u0011auN\\4\u0002\u001f\u0015l\u0017\u000e^%oi\u0016\u0014h/\u00197Ng\u0002\nQ!\u00193nS:,\"!!\u0017\u0011\t\u0005m\u00131M\u0007\u0003\u0003;RA!!\u0016\u0002`)\u0019\u0011\u0011\r=\u0002\u000f\rd\u0017.\u001a8ug&!\u0011QMA/\u0005\u0015\tE-\\5o\u0003\u0019\tG-\\5oAQi\u0001/a\u001b\u0002n\u0005=\u0014\u0011OA:\u0003kBQAX\u001aA\u0002MDq!!\u00014\u0001\u0004\t)\u0001C\u0004\u0002\u001eM\u0002\r!!\t\t\u000f\u0005M2\u00071\u0001\u00028!I\u0011\u0011J\u001a\u0011\u0002\u0003\u0007\u0011Q\n\u0005\b\u0003+\u001a\u0004\u0019AA-\u0003I\u0019wN\\:v[\u0016\u0014H*Y4NKR\u0014\u0018nY:\u0016\u0005\u0005m\u0004\u0003CA?\u0003\u000f\u000bY)!)\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000bq!\\;uC\ndWMC\u0002\u0002\u0006\"\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI)a \u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u000e\u0006me\u0002BAH\u0003/\u00032!!%i\u001b\t\t\u0019JC\u0002\u0002\u0016\u0006\fa\u0001\u0010:p_Rt\u0014bAAMQ\u00061\u0001K]3eK\u001aLA!!(\u0002 \n11\u000b\u001e:j]\u001eT1!!'i!!\t\u0019+!+\u0002.\u00065SBAAS\u0015\r\t9+^\u0001\nS:$XM\u001d8bYNLA!a+\u0002&\nQq)Y;hKN+\u0018\u000e^3\u0011\u0007\r\fy+C\u0002\u00022v\u0013A#T3nE\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>t\u0017aE2p]N,X.\u001a:MC\u001elU\r\u001e:jGN\u0004\u0013\u0001E;qI\u0006$X\rZ$s_V\u00048+\u001b>f+\t\tI\fE\u0002h\u0003wK1!!0i\u0005\rIe\u000e^\u0001\u0015kB$\u0017\r^3e\u000fJ|W\u000f]*ju\u0016|F%Z9\u0015\t\u0005\r\u0017\u0011\u001a\t\u0004O\u0006\u0015\u0017bAAdQ\n!QK\\5u\u0011%\tYmNA\u0001\u0002\u0004\tI,A\u0002yIE\n\u0011#\u001e9eCR,Gm\u0012:pkB\u001c\u0016N_3!Q\rA\u0014\u0011\u001b\t\u0004O\u0006M\u0017bAAkQ\nAao\u001c7bi&dW-\u0001\u000bsK\n\fG.\u00198dS:<wI]8vaNK'0Z\u0001\u0019e\u0016\u0014\u0017\r\\1oG&twm\u0012:pkB\u001c\u0016N_3`I\u0015\fH\u0003BAb\u0003;D\u0011\"a3;\u0003\u0003\u0005\r!!/\u0002+I,'-\u00197b]\u000eLgnZ$s_V\u00048+\u001b>fA!\u001a1(!5\u0002\u001f\u0019\f\u0017\u000e\\3e\u000fJ|W\u000f]*ju\u0016\f1CZ1jY\u0016$wI]8vaNK'0Z0%KF$B!a1\u0002j\"I\u00111Z\u001f\u0002\u0002\u0003\u0007\u0011\u0011X\u0001\u0011M\u0006LG.\u001a3He>,\boU5{K\u0002B3APAi\u0003A)\u0007\u0010]5sK\u0012<%o\\;q'&TX-\u0001\u000bfqBL'/\u001a3He>,\boU5{K~#S-\u001d\u000b\u0005\u0003\u0007\f)\u0010C\u0005\u0002L\u0002\u000b\t\u00111\u0001\u0002:\u0006\tR\r\u001f9je\u0016$wI]8vaNK'0\u001a\u0011)\u0007\u0005\u000b\t.A\u0006nKR\u0014\u0018nY:TSj,\u0017aD7fiJL7m]*ju\u0016|F%Z9\u0015\t\u0005\r'\u0011\u0001\u0005\n\u0003\u0017\u001c\u0015\u0011!a\u0001\u0003\u001b\nA\"\\3ue&\u001c7oU5{K\u0002B3\u0001RAi\u00035)\u00070Z2vi&|g\u000eV5nK\u0006\tR\r_3dkRLwN\u001c+j[\u0016|F%Z9\u0015\t\u0005\r'Q\u0002\u0005\n\u0003\u00174\u0015\u0011!a\u0001\u0003\u001b\na\"\u001a=fGV$\u0018n\u001c8US6,\u0007\u0005K\u0002H\u0003#\f1\u0003\\1tiN+8mY3tg\u001a,HNU;o\u001bN\fq\u0003\\1tiN+8mY3tg\u001a,HNU;o\u001bN|F%Z9\u0015\t\u0005\r'\u0011\u0004\u0005\n\u0003\u0017L\u0015\u0011!a\u0001\u0003\u001b\nA\u0003\\1tiN+8mY3tg\u001a,HNU;o\u001bN\u0004\u0003f\u0001&\u0002R\u0006QQ.Z7cKJ\u001c\u0016N_3\u0016\u0005\t\r\u0002\u0003BA\u0004\u0005KIAAa\n\u0002\n\tQQ*\u001a;sS\u000et\u0015-\\3\u0002\u00175,WNY3s'&TX\rI\u0001\u0014[\u0016l'-\u001a:TSj,\u0007*[:u_\u001e\u0014\u0018-\\\u000b\u0003\u0005_\u0001B!a\u0002\u00032%!!1GA\u0005\u0005%A\u0015n\u001d;pOJ\fW.\u0001\u000bnK6\u0014WM]*ju\u0016D\u0015n\u001d;pOJ\fW\u000eI\u0001\u0013Y\u0006\u0014x-Z:u\u000fJ|W\u000f]:Rk\u0016,X-\u0006\u0002\u0003<A1\u0011Q\u0010B\u001f\u0005\u0003JAAa\u0010\u0002\u0000\ti\u0001K]5pe&$\u00180U;fk\u0016\u0004ra\u001aB\"\u0003\u0017\u000bI,C\u0002\u0003F!\u0014a\u0001V;qY\u0016\u0014\u0014a\u00057be\u001e,7\u000f^$s_V\u00048/U;fk\u0016\u0004\u0013!B:uCJ$HCAAb\u0003!\u0019\b.\u001e;e_^t\u0017aD3nSR\u001cuN\\:v[\u0016\u0014H*Y4\u00021\u0019,Go\u00195PM\u001a\u001cX\r^:B]\u0012\u0014VmY8sI2\u000bw\r\u0006\u0002\u0003VA\u00191Ma\u0016\n\u0007\teSLA\rD_:\u001cX/\\3s\u0019\u0006<W)\\5ui\u0016\u00148+^7nCJL\u0018AE7bW\u0016\u0014V-];fgR\u001cuN\u001c;fqR$BAa\u0018\u0003lA!!\u0011\rB4\u001b\t\u0011\u0019GC\u0002\u0003fY\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0005S\u0012\u0019G\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\t\u000f\t5T\u000b1\u0001\u0003p\u00051\u0011\r]5LKf\u0004BA!\u001d\u0003x5\u0011!1\u000f\u0006\u0004\u0005k2\u0018\u0001\u00039s_R|7m\u001c7\n\t\te$1\u000f\u0002\b\u0003BL7*Z=t\u00039!Wm]2sS\n,wI]8vaN$BAa \u0003&B1!\u0011\u0011BF\u0005#sAAa!\u0003\b:!\u0011\u0011\u0013BC\u0013\u0005I\u0017b\u0001BEQ\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002BG\u0005\u001f\u0013A\u0001T5ti*\u0019!\u0011\u00125\u0011\t\tM%q\u0014\b\u0005\u0005+\u0013Y*\u0004\u0002\u0003\u0018*\u0019!\u0011\u0014<\u0002\u000f5,7o]1hK&!!Q\u0014BL\u0003i!Um]2sS\n,wI]8vaN\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\u0011\tKa)\u0003\u001d\u0011+7o\u0019:jE\u0016$wI]8va*!!Q\u0014BL\u0011\u001d\u00119K\u0016a\u0001\u0005S\u000baa\u001d;bi\u0016\u001c\bCBAG\u0005W\u000bY)\u0003\u0003\u0003.\u0006}%aA*fi\u0006ya-\u001a;dQ\u0006cGn\u00144gg\u0016$8\u000f\u0006\u0003\u00034\n-\u0007\u0003CA?\u0003\u000f\u0013)L!0\u0011\t\t]&\u0011X\u0007\u0002m&\u0019!1\u0018<\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B!!q\u0018Bc\u001d\u0011\u0011)J!1\n\t\t\r'qS\u0001\u0018\u001f\u001a47/\u001a;GKR\u001c\u0007NU3ta>t7/\u001a#bi\u0006LAAa2\u0003J\nirJ\u001a4tKR4U\r^2i%\u0016\u001c\bo\u001c8tKB\u000b'\u000f^5uS>t7O\u0003\u0003\u0003D\n]\u0005b\u0002Bg/\u0002\u0007\u00111R\u0001\bOJ|W\u000f]%e\u0003A\u0019'/Z1uK\u001e\u000bWoZ3Tk&$X\r\u0006\u0003\u0002\"\nM\u0007b\u0002Bg1\u0002\u0007\u00111R\u0001\u0013GV\u0014(/\u001a8u\u001b\u0016$(/[2t'&TX\r\u0006\u0002\u0002N\u0005aS.Y=cKB\u0013XMZ5y)>\u0004\u0018n\u0019)beRLG/[8og^KG\u000f\u001b+f]\u0006tGOR;oGRLwN\u001c\u000b\u0005\u0005;\u0014)\u000fE\u0004h\u0005?\u0014\u0019Oa9\n\u0007\t\u0005\bNA\u0005Gk:\u001cG/[8ocA1!\u0011\u0011BF\u0005kCqA!4[\u0001\u0004\tY)\u0001\rva\u0012\fG/\u001a'be\u001e,7\u000f^$s_V\u00048/U;fk\u0016$b!a1\u0003l\n5\bb\u0002Bg7\u0002\u0007\u00111\u0012\u0005\b\u0005?Y\u0006\u0019AA]\u0011\u0015q6\u00011\u0001t\u0011\u001d\t\ta\u0001a\u0001\u0003\u000bAq!a\r\u0004\u0001\u0004\t9\u0004C\u0005\u0002J\r\u0001\n\u00111\u0001\u0002N!9!\u0011`\u0002A\u0002\tm\u0018AC1e[&t\u0007K]8qgBA!Q`B\u0003\u0003\u0017\u001b9!\u0004\u0002\u0003\u0000*!\u0011qEB\u0001\u0015\t\u0019\u0019!\u0001\u0003kCZ\f\u0017\u0002BAE\u0005\u007f\u0004Ba!\u0003\u0004\u00105\u001111\u0002\u0006\u0005\u0007\u001b\u0019\t!\u0001\u0003mC:<\u0017\u0002BB\t\u0007\u0017\u0011aa\u00142kK\u000e$\u0018aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r]!\u0006BA'\u00073Y#aa\u0007\u0011\t\ru1qE\u0007\u0003\u0007?QAa!\t\u0004$\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007KA\u0017AC1o]>$\u0018\r^5p]&!1\u0011FB\u0010\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016\u0007>t7/^7fe2\u000bw-T3ue&\u001cg*Y7f+\t\u0019y\u0003\u0005\u0003\u0004\n\rE\u0012\u0002BAO\u0007\u0017\tacQ8ogVlWM\u001d'bO6+GO]5d\u001d\u0006lW\rI\u0001\u0010\u001b\u0016$(/[2He>,\bOT1nK\u0006\u0001R*\u001a;sS\u000e<%o\\;q\u001d\u0006lW\rI\u0001\u001b+B$\u0017\r^3e\u000fJ|W\u000f]*ju\u0016lU\r\u001e:jG:\u000bW.Z\u0001\u001c+B$\u0017\r^3e\u000fJ|W\u000f]*ju\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002=I+'-\u00197b]\u000eLgnZ$s_V\u00048+\u001b>f\u001b\u0016$(/[2OC6,\u0017a\b*fE\u0006d\u0017M\\2j]\u001e<%o\\;q'&TX-T3ue&\u001cg*Y7fA\u0005Ib)Y5mK\u0012<%o\\;q'&TX-T3ue&\u001cg*Y7f\u0003i1\u0015-\u001b7fI\u001e\u0013x.\u001e9TSj,W*\u001a;sS\u000et\u0015-\\3!\u0003i)\u0005\u0010]5sK\u0012<%o\\;q'&TX-T3ue&\u001cg*Y7f\u0003m)\u0005\u0010]5sK\u0012<%o\\;q'&TX-T3ue&\u001cg*Y7fA\u0005)R*\u001a;sS\u000e\u001c8+\u001b>f\u001b\u0016$(/[2OC6,\u0017AF'fiJL7m]*ju\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002/\u0015CXmY;uS>tG+[7f\u001b\u0016$(/[2OC6,\u0017\u0001G#yK\u000e,H/[8o)&lW-T3ue&\u001cg*Y7fA\u00051C+[7f'&t7-\u001a'bgR\u001cVoY2fgN4W\u000f\u001c*v]6\u001bX*\u001a;sS\u000et\u0015-\\3\u0002OQKW.Z*j]\u000e,G*Y:u'V\u001c7-Z:tMVd'+\u001e8Ng6+GO]5d\u001d\u0006lW\rI\u0001\u0015\u001b\u0016l'-\u001a:TSj,W*\u001a;sS\u000et\u0015-\\3\u0002+5+WNY3s'&TX-T3ue&\u001cg*Y7fA\u00051B*\u0019:hKN$xI]8vaN\fV/Z;f'&TX-A\fMCJ<Wm\u001d;He>,\bo])vKV,7+\u001b>fA\u0005YB*\u0019:hKN$xI]8vaN\fV/Z;f)\"\u0014Xm\u001d5pY\u0012\fA\u0004T1sO\u0016\u001cHo\u0012:pkB\u001c\u0018+^3vKRC'/Z:i_2$\u0007%A\u0006WC2LGm\u0015;bi\u0016\u001cXCAB3!\u0019\u00199g!\u001c\u000405\u00111\u0011\u000e\u0006\u0005\u0007W\n\u0019)A\u0005j[6,H/\u00192mK&!!QVB5\u000311\u0016\r\\5e'R\fG/Z:!\u0003E\u0011VMY1mC:\u001c\u0017N\\4Ti\u0006$Xm]\u0001\u0013%\u0016\u0014\u0017\r\\1oG&twm\u0015;bi\u0016\u001c\b%A\u0002m_\u001e,\"a!\u001f\u0011\t\rm4\u0011Q\u0007\u0003\u0007{R1aa |\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\u0019\u0019i! \u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002\u001b\u001d\fWoZ3Tk&$X\rT8h\u000399\u0017-^4f'VLG/\u001a'pO\u0002\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0004")
public class ConsumerLagEmitter {
    private final Metrics metrics;
    private final MetricsRegistry registry;
    private final Scheduler scheduler;
    private final GroupCoordinator groupCoordinator;
    private final long emitIntervalMs;
    private final Admin admin;
    private final scala.collection.mutable.Map<String, GaugeSuite<MemberTopicPartition, Object>> consumerLagMetrics;
    private volatile int kafka$metrics$ConsumerLagEmitter$$updatedGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$failedGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$expiredGroupSize;
    private volatile long kafka$metrics$ConsumerLagEmitter$$metricsSize;
    private volatile long kafka$metrics$ConsumerLagEmitter$$executionTime;
    private volatile long kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs;
    private final MetricName memberSize;
    private final Histogram memberSizeHistogram;
    private final PriorityQueue<Tuple2<String, Object>> largestGroupsQueue;

    public static long $lessinit$greater$default$5() {
        return 60000L;
    }

    public static int LargestGroupsQueueThreshold() {
        return ConsumerLagEmitter$.MODULE$.LargestGroupsQueueThreshold();
    }

    public static int LargestGroupsQueueSize() {
        return ConsumerLagEmitter$.MODULE$.LargestGroupsQueueSize();
    }

    public static String MemberSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.MemberSizeMetricName();
    }

    public static String TimeSinceLastSuccessfulRunMsMetricName() {
        return ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName();
    }

    public static String ExecutionTimeMetricName() {
        return ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName();
    }

    public static String MetricsSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName();
    }

    public static String ExpiredGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName();
    }

    public static String FailedGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName();
    }

    public static String RebalancingGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName();
    }

    public static String UpdatedGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName();
    }

    public static String MetricGroupName() {
        return ConsumerLagEmitter$.MODULE$.MetricGroupName();
    }

    public static String ConsumerLagMetricName() {
        return ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName();
    }

    public static long apply$default$4() {
        return 60000L;
    }

    public static ConsumerLagEmitter apply(Metrics metrics, MetricsRegistry registry, GroupCoordinator groupCoordinator, long emitIntervalMs, Map<String, Object> adminProps) {
        return ConsumerLagEmitter$.MODULE$.apply(metrics, registry, groupCoordinator, emitIntervalMs, adminProps);
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetricsRegistry registry() {
        return this.registry;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    public long emitIntervalMs() {
        return this.emitIntervalMs;
    }

    public Admin admin() {
        return this.admin;
    }

    public scala.collection.mutable.Map<String, GaugeSuite<MemberTopicPartition, Object>> consumerLagMetrics() {
        return this.consumerLagMetrics;
    }

    public int kafka$metrics$ConsumerLagEmitter$$updatedGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize;
    }

    private void updatedGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize;
    }

    private void rebalancingGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$failedGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize;
    }

    private void failedGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$expiredGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize;
    }

    private void expiredGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$metricsSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$metricsSize;
    }

    private void metricsSize_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$metricsSize = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$executionTime() {
        return this.kafka$metrics$ConsumerLagEmitter$$executionTime;
    }

    private void executionTime_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$executionTime = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs() {
        return this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs;
    }

    private void lastSuccessfulRunMs_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs = x$1;
    }

    private MetricName memberSize() {
        return this.memberSize;
    }

    private Histogram memberSizeHistogram() {
        return this.memberSizeHistogram;
    }

    public PriorityQueue<Tuple2<String, Object>> largestGroupsQueue() {
        return this.largestGroupsQueue;
    }

    public void start() {
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter starting up.");
        this.scheduler().startup();
        this.scheduler().schedule("emit-consumer-lag-", () -> this.emitConsumerLag(), this.emitIntervalMs(), this.emitIntervalMs());
    }

    public void shutdown() {
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter shutting down.");
        this.consumerLagMetrics().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(x$2, gaugeSuite) -> {
            gaugeSuite.close();
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.registry().removeMetric(this.memberSize());
        this.scheduler().shutdown();
        if (this.admin() != null) {
            this.admin().close();
        }
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter shutdown complete.");
    }

    public void emitConsumerLag() {
        try {
            ConsumerLagEmitterSummary result = this.fetchOffsetsAndRecordLag();
            this.updatedGroupSize_$eq(result.updatedGroupSize());
            this.rebalancingGroupSize_$eq(result.rebalancingGroupSize());
            this.failedGroupSize_$eq(result.failedGroupSize());
            this.expiredGroupSize_$eq(result.expiredGroupSize());
            this.metricsSize_$eq(result.metricsSize());
            this.executionTime_$eq(result.executionTime());
            this.lastSuccessfulRunMs_$eq(System.currentTimeMillis());
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info(new StringBuilder(113).append("Updated lag of ").append(this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize()).append(" groups, ").append("ignored ").append(this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize()).append(" rebalancing groups, ").append("failed to update ").append(this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize()).append(" groups due to errors, ").append("and expired ").append(this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize()).append(" groups.").toString());
            return;
        }
        catch (Throwable t) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().error("Could not update consumer lag metrics.", t);
            return;
        }
    }

    public ConsumerLagEmitterSummary fetchOffsetsAndRecordLag() {
        long startTime = System.currentTimeMillis();
        scala.collection.mutable.Map groupsToCurrentOffsets = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        scala.collection.mutable.Set rebalancingGroups = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        scala.collection.mutable.Set failedGroups = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        List<DescribeGroupsResponseData.DescribedGroup> describedGroups = this.describeGroups(ConsumerLagEmitter$.MODULE$.ValidStates());
        this.memberSizeHistogram().clear();
        this.largestGroupsQueue().clear();
        describedGroups.foreach((Function1 & Serializable)describedGroup -> {
            String groupId = describedGroup.groupId();
            if (describedGroup.errorCode() == Errors.NOT_COORDINATOR.code()) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(69).append("Ignoring group ").append(groupId).append(" because it is not hosted on this coordinator anymore.").toString());
                return BoxedUnit.UNIT;
            }
            if (describedGroup.errorCode() != Errors.NONE.code()) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(62).append("Could not describe group ").append(groupId).append(" due to ").append(Errors.forCode((short)describedGroup.errorCode())).append(". ").append("Will retry in the next run.").toString());
                return failedGroups.$plus$eq((Object)groupId);
            }
            int memberSize = describedGroup.members().size();
            this.memberSizeHistogram().update(memberSize);
            this.updateLargestGroupsQueue(groupId, memberSize);
            String string = describedGroup.protocolType();
            String string2 = "consumer";
            if (string == null || !string.equals(string2)) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(44).append("Group ").append(groupId).append(" is not a consumer group. Ignoring it.").toString());
                return BoxedUnit.UNIT;
            }
            if (ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$RebalancingStates().contains((Object)describedGroup.groupState())) {
                return rebalancingGroups.$plus$eq((Object)groupId);
            }
            String string3 = describedGroup.groupState();
            String string4 = ConsumerGroupState.STABLE.toString();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Growable growable;
                try {
                    scala.collection.mutable.Map<TopicPartition, OffsetFetchResponseData.OffsetFetchResponsePartitions> currentOffsets = this.fetchAllOffsets(groupId);
                    scala.collection.mutable.Map memberTopicPartitions = (scala.collection.mutable.Map)groupsToCurrentOffsets.getOrElse((Object)groupId, (Function0 & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.empty());
                    Function1<List<TopicPartition>, List<TopicPartition>> maybePrefixTopicPartitions = this.maybePrefixTopicPartitionsWithTenantFunction(groupId);
                    CollectionConverters$.MODULE$.ListHasAsScala(describedGroup.members()).asScala().foreach((Function1 & Serializable)member -> {
                        ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$3(maybePrefixTopicPartitions, currentOffsets, groupId, memberTopicPartitions, member);
                        return BoxedUnit.UNIT;
                    });
                    if (!memberTopicPartitions.nonEmpty()) {
                        return BoxedUnit.UNIT;
                    }
                    growable = groupsToCurrentOffsets.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupId), (Object)memberTopicPartitions));
                }
                catch (NotCoordinatorException notCoordinatorException) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(69).append("Ignoring group ").append(groupId).append(" because it is not hosted on this coordinator anymore.").toString());
                    return BoxedUnit.UNIT;
                }
                catch (Throwable t) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(70).append("Could not fetch offsets of group ").append(groupId).append(" due to ").append(t.getMessage()).append(". Will retry in the next run.").toString());
                    growable = failedGroups.$plus$eq((Object)groupId);
                }
                return growable;
            }
            return BoxedUnit.UNIT;
        });
        if (!this.largestGroupsQueue().isEmpty()) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info(new StringBuilder(45).append("Top ").append(ConsumerLagEmitter$.MODULE$.LargestGroupsQueueSize()).append(" largest groups with more than ").append(ConsumerLagEmitter$.MODULE$.LargestGroupsQueueThreshold()).append(" members:\n").append(this.largestGroupsQueue().reverseIterator().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String groupId = (String)x0$1._1();
                    int memberSize = x0$1._2$mcI$sp();
                    return new StringBuilder(20).append("Group ").append(groupId).append(" has ").append(memberSize).append(" members.").toString();
                }
                throw new MatchError(null);
            }).mkString("\n")).toString());
        }
        if (groupsToCurrentOffsets.nonEmpty()) {
            Map latestOffsetSpec = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)groupsToCurrentOffsets.flatMap((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    return (scala.collection.mutable.Map)((scala.collection.mutable.Map)x0$2._2()).map((Function1 & Serializable)x0$3 -> {
                        if (x0$3 != null) {
                            MemberTopicPartition memberTopicPartition = (MemberTopicPartition)x0$3._1();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberTopicPartition.topicPartition()), (Object)new OffsetSpec.LatestSpec());
                        }
                        throw new MatchError(null);
                    });
                }
                throw new MatchError(null);
            })).asJava();
            ListOffsetsResult result = this.admin().listOffsets(latestOffsetSpec);
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(groupId, memberTopicPartitions) -> {
                GaugeSuite groupGaugeSuite = (GaugeSuite)this.consumerLagMetrics().getOrElse(groupId, (Function0 & Serializable)() -> this.createGaugeSuite((String)groupId));
                Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(memberTopicPartition, currentOffset) -> {
                    ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$10(result, groupGaugeSuite, memberTopicPartition, BoxesRunTime.unboxToLong((Object)currentOffset));
                    return BoxedUnit.UNIT;
                };
                memberTopicPartitions.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
                Object var5_5 = null;
                return (scala.collection.mutable.Map)this.consumerLagMetrics().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupId), (Object)groupGaugeSuite));
            };
            groupsToCurrentOffsets.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var12_8 = null;
        }
        scala.collection.immutable.Set expiredGroups = ((MapOps)this.consumerLagMetrics().filterNot((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$11(groupsToCurrentOffsets, rebalancingGroups, failedGroups, x0$4)))).keys().toSet();
        expiredGroups.foreach((Function1 & Serializable)groupId -> {
            ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$13(this, groupId);
            return BoxedUnit.UNIT;
        });
        long executionTime = System.currentTimeMillis() - startTime;
        return new ConsumerLagEmitterSummary(groupsToCurrentOffsets.keySet().size(), rebalancingGroups.size(), failedGroups.size(), expiredGroups.size(), this.currentMetricsSize(), executionTime);
    }

    private RequestContext makeRequestContext(ApiKeys apiKey) {
        return new RequestContext(new RequestHeader(apiKey, apiKey.latestVersion(), ConsumerLagEmitter$.MODULE$.MetricGroupName(), 0), "-1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
    }

    private List<DescribeGroupsResponseData.DescribedGroup> describeGroups(scala.collection.immutable.Set<String> states) {
        try {
            return (List)((CompletableFuture)this.groupCoordinator().listGroups(this.makeRequestContext(ApiKeys.LIST_GROUPS), new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)states.toList()).asJava())).thenCompose(listGroupsResult -> {
                if (listGroupsResult.errorCode() != Errors.NONE.code()) {
                    CompletableFuture future = new CompletableFuture();
                    future.completeExceptionally((Throwable)Errors.forCode((short)listGroupsResult.errorCode()).exception());
                    return future;
                }
                if (listGroupsResult.groups().isEmpty()) {
                    CompletableFuture<List> future = new CompletableFuture<List>();
                    future.complete(package$.MODULE$.List().empty());
                    return future;
                }
                return this.groupCoordinator().describeGroups(this.makeRequestContext(ApiKeys.DESCRIBE_GROUPS), CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(listGroupsResult.groups()).asScala().map((Function1 & Serializable)x$4 -> x$4.groupId())).asJava()).thenApply(x$5 -> CollectionConverters$.MODULE$.ListHasAsScala(x$5).asScala().toList());
            })).get(30L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            if (throwable instanceof ExecutionException && (executionException = (ExecutionException)throwable).getCause() != null) {
                throw executionException.getCause();
            }
            throw throwable;
        }
    }

    private scala.collection.mutable.Map<TopicPartition, OffsetFetchResponseData.OffsetFetchResponsePartitions> fetchAllOffsets(String groupId) {
        try {
            return (scala.collection.mutable.Map)((CompletableFuture)this.groupCoordinator().fetchAllOffsets(this.makeRequestContext(ApiKeys.OFFSET_FETCH), new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupId), false).thenApply(response -> {
                HashMap byTopicPartitions = new HashMap();
                response.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                    TopicPartition tp = new TopicPartition(topic.name(), partition.partitionIndex());
                    byTopicPartitions.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), partition));
                }));
                return byTopicPartitions;
            })).get(30L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            if (throwable instanceof ExecutionException && (executionException = (ExecutionException)throwable).getCause() != null) {
                throw executionException.getCause();
            }
            throw throwable;
        }
    }

    private GaugeSuite<MemberTopicPartition, Object> createGaugeSuite(String groupId) {
        return new GaugeSuite(ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$gaugeSuiteLog(), new StringBuilder(21).append("consumer-lag-emitter-").append(groupId).toString(), this.metrics(), memberTopicPartition -> this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName(), "tenant-metrics", "The group member's consumer lag in offsets.", CollectionConverters$.MODULE$.MutableMapHasAsJava(memberTopicPartition.tags()).asJava()));
    }

    private long currentMetricsSize() {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.consumerLagMetrics().map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ConsumerLagEmitter.$anonfun$currentMetricsSize$1(x0$1)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Function1<List<TopicPartition>, List<TopicPartition>> maybePrefixTopicPartitionsWithTenantFunction(String groupId) {
        if (TenantHelpers.isTenantPrefixed(groupId)) {
            return arg_0 -> ConsumerLagEmitter.$anonfun$maybePrefixTopicPartitionsWithTenantFunction$1(TenantHelpers.extractTenantPrefix(groupId), arg_0);
        }
        return (Function1 & Serializable)topicPartitions -> topicPartitions;
    }

    private void updateLargestGroupsQueue(String groupId, int memberSize) {
        if (memberSize > ConsumerLagEmitter$.MODULE$.LargestGroupsQueueThreshold()) {
            this.largestGroupsQueue().enqueue((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)groupId, (Object)BoxesRunTime.boxToInteger((int)memberSize))}));
        }
        if (this.largestGroupsQueue().size() > ConsumerLagEmitter$.MODULE$.LargestGroupsQueueSize()) {
            this.largestGroupsQueue().dequeue();
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$largestGroupsQueue$1(Tuple2 x$1) {
        return -x$1._2$mcI$sp();
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$3(Function1 maybePrefixTopicPartitions$1, scala.collection.mutable.Map currentOffsets$1, String groupId$1, scala.collection.mutable.Map memberTopicPartitions$1, DescribeGroupsResponseData.DescribedGroupMember member) {
        try {
            ConsumerPartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(member.memberAssignment()));
            ((List)maybePrefixTopicPartitions$1.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala(assignment.partitions()).asScala().toList())).foreach((Function1 & Serializable)topicPartition -> {
                Option option = currentOffsets$1.get(topicPartition);
                if (option instanceof Some) {
                    Errors error;
                    OffsetFetchResponseData.OffsetFetchResponsePartitions currentOffset = (OffsetFetchResponseData.OffsetFetchResponsePartitions)((Some)option).value();
                    Errors errors = error = Errors.forCode((short)currentOffset.errorCode());
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(93).append("Could not get committed offset for group ").append(groupId$1).append(" and partition ").append(topicPartition).append(" due to ").append(error).append(". Will retry in the next run.").toString());
                        return BoxedUnit.UNIT;
                    }
                    MemberTopicPartition memberTopicPartition = new MemberTopicPartition(groupId$1, (Option<String>)Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), (TopicPartition)topicPartition);
                    return memberTopicPartitions$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberTopicPartition), (Object)BoxesRunTime.boxToLong((long)currentOffset.committedOffset())));
                }
                if (None$.MODULE$.equals(option)) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(72).append("Group coordinator does not have offsets for group ").append(groupId$1).append(" and topic partition ").append(topicPartition).append(".").toString());
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            });
            return;
        }
        catch (SchemaException e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(66).append("Failed to deserialize assignment(length=").append(member.memberAssignment().length).append(") for group ").append(groupId$1).append(" and member ").append(member.memberId()).append(": ").append(e.getMessage()).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$10(ListOffsetsResult result$1, GaugeSuite groupGaugeSuite$1, MemberTopicPartition memberTopicPartition, long currentOffset) {
        try {
            long latestOffset = ((ListOffsetsResult.ListOffsetsResultInfo)result$1.partitionResult(memberTopicPartition.topicPartition()).get()).offset();
            long consumerLag = latestOffset - currentOffset;
            if (consumerLag >= 0L) {
                groupGaugeSuite$1.update((Object)memberTopicPartition, (Object)BoxesRunTime.boxToLong((long)consumerLag));
                return;
            }
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().warn(new StringBuilder(115).append("Consumer lag of member ").append(memberTopicPartition).append(" is negative. Latest offset is ").append(latestOffset).append(" ").append("and committed offset is ").append(currentOffset).append(". The topic may have been recreated.").toString());
            groupGaugeSuite$1.update((Object)memberTopicPartition, (Object)BoxesRunTime.boxToLong((long)0L));
        }
        catch (ExecutionException e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(45).append("Could not list offsets for partition ").append(memberTopicPartition.topicPartition()).append(" due to ").append(e.getCause().getMessage()).toString());
            return;
        }
        catch (InterruptedException e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(45).append("Unable to list offsets for partition ").append(memberTopicPartition.topicPartition()).append(" due to ").append(e.getCause()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetsAndRecordLag$11(scala.collection.mutable.Map groupsToCurrentOffsets$1, scala.collection.mutable.Set rebalancingGroups$1, scala.collection.mutable.Set failedGroups$1, Tuple2 x0$4) {
        if (x0$4 != null) {
            String groupId = (String)x0$4._1();
            GaugeSuite groupGaugeSuite = (GaugeSuite)x0$4._2();
            if (groupsToCurrentOffsets$1.contains((Object)groupId)) {
                Set currentMemberTopicPartitions = ((MapOps)groupsToCurrentOffsets$1.apply((Object)groupId)).keySet();
                ((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(groupGaugeSuite.keySet()).asScala().diff(currentMemberTopicPartitions)).foreach((Function1 & Serializable)x$1 -> {
                    groupGaugeSuite.remove((Object)x$1);
                    return BoxedUnit.UNIT;
                });
                groupGaugeSuite.flush();
                return groupGaugeSuite.keySet().size() != 0;
            }
            return rebalancingGroups$1.contains((Object)groupId) || failedGroups$1.contains((Object)groupId);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$13(ConsumerLagEmitter $this, String groupId) {
        $this.consumerLagMetrics().remove((Object)groupId).foreach((Function1 & Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$currentMetricsSize$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((GaugeSuite)x0$1._2()).keySet().size();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ List $anonfun$maybePrefixTopicPartitionsWithTenantFunction$1(String prefix$1, List topicPartitions) {
        return topicPartitions.map((Function1 & Serializable)x$6 -> TenantHelpers.prefixWithTenant(prefix$1, x$6));
    }

    public ConsumerLagEmitter(Metrics metrics, MetricsRegistry registry, Scheduler scheduler, GroupCoordinator groupCoordinator, long emitIntervalMs, Admin admin) {
        this.metrics = metrics;
        this.registry = registry;
        this.scheduler = scheduler;
        this.groupCoordinator = groupCoordinator;
        this.emitIntervalMs = emitIntervalMs;
        this.admin = admin;
        this.consumerLagMetrics = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$failedGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$metricsSize = 0L;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$metricsSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$executionTime = 0L;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$executionTime();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs = System.currentTimeMillis();
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return System.currentTimeMillis() - this.$outer.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.memberSize = KafkaYammerMetrics.getMetricName((String)"kafka.coordinator.group", (String)ConsumerLagEmitter$.MODULE$.MetricGroupName(), (String)ConsumerLagEmitter$.MODULE$.MemberSizeMetricName(), null);
        this.memberSizeHistogram = registry.newHistogram(this.memberSize(), false);
        this.largestGroupsQueue = PriorityQueue$.MODULE$.empty(package$.MODULE$.Ordering().by((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ConsumerLagEmitter.$anonfun$largestGroupsQueue$1(x$1)), (Ordering)Ordering.Int$.MODULE$));
    }
}

