/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.util.Map;
import java.util.Optional;
import kafka.network.AbstractAutoTuningQuota;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Sensor;

class ListenerAutoTuningQuota
extends AbstractAutoTuningQuota {
    static final int DEFAULT_CONNECTION_RATE_QUOTA_ADJUSTMENT = 5;

    ListenerAutoTuningQuota(Sensor connectionRateThrottleSensor, Sensor connectionRateLimitSensor) {
        super(connectionRateThrottleSensor, connectionRateLimitSensor);
    }

    @Override
    String quotaName(String listenerName) {
        return listenerName + "-connection-rate";
    }

    @Override
    protected void validate(Map<String, ?> configs) {
        double rate = this.nextMax(configs);
        if (rate <= 0.0) {
            throw new ConfigException(String.format("Invalid MaxConnectionCreationRateProp %s", rate));
        }
        double floor = this.nextFloor(configs);
        if (floor <= 0.0) {
            throw new ConfigException(String.format("Invalid MaxConnectionCreationRateFloorProp %s", floor));
        }
    }

    @Override
    double nextMax(Map<String, ?> configs) {
        return Optional.ofNullable(configs.get("max.connection.creation.rate")).map(v -> Double.valueOf(String.valueOf(v))).orElse((Double)Double.MAX_VALUE);
    }

    @Override
    double nextFloor(Map<String, ?> configs) {
        return Optional.ofNullable(configs.get(KafkaConfig.MaxConnectionCreationRateFloorProp())).map(v -> Double.valueOf(String.valueOf(v))).orElse(this.nextMax(configs));
    }

    @Override
    double nextStep(Map<String, ?> configs) {
        return 5.0;
    }
}

