/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.operators;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kafka.restore.operators.FtpsSegmentView;
import kafka.restore.operators.SegmentStateAndPath;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierUtils;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import org.apache.kafka.common.TopicPartition;

public class RestorePartitionOperator {
    private FtpsSegmentView ftpsSegmentView;

    public RestorePartitionOperator(TopicPartition topicPartition, String stateFileName, long fromTimestamp) throws Exception {
        this.ftpsSegmentView = new FtpsSegmentView(topicPartition, new File(stateFileName), fromTimestamp);
    }

    public Map<UUID, SegmentStateAndPath> restore() throws Exception {
        Long newLogStartOffset = null;
        HashMap<UUID, SegmentStateAndPath> segmentPathMap = new HashMap<UUID, SegmentStateAndPath>();
        for (int index = 0; index < this.ftpsSegmentView.segmentStateList().size(); ++index) {
            SegmentState segmentState = this.ftpsSegmentView.segmentStateList().get(index);
            if (newLogStartOffset == null) {
                newLogStartOffset = segmentState.baseOffset();
            }
            if (segmentState.state() != TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE && segmentState.state() != TierObjectMetadata.State.SEGMENT_DELETE_INITIATE) continue;
            TierUtils.updateSegmentState(this.ftpsSegmentView.topicIdPartition(), segmentState, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, this.ftpsSegmentView.stateFileChannel(), false, Long.MAX_VALUE);
            ObjectMetadata objectMetadata = new ObjectMetadata(this.ftpsSegmentView.topicIdPartition(), segmentState);
            segmentPathMap.put(segmentState.objectId(), new SegmentStateAndPath(this.ftpsSegmentView.topicIdPartition(), segmentState, objectMetadata.toFragmentLocation("", FragmentType.SEGMENT).get().objectPath()));
        }
        this.ftpsSegmentView.updateFtpsHeaderLogStartOffset(newLogStartOffset);
        this.ftpsSegmentView.close();
        return segmentPathMap;
    }

    public FtpsSegmentView operatorContext() {
        return this.ftpsSegmentView;
    }

    public SegmentState segmentStateByObjectID(UUID objectId) {
        return this.ftpsSegmentView.segmentStateMap().get(objectId);
    }
}

