/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.ClusterLinkQuotas;
import kafka.server.ClusterLinkTenantContext;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkMetrics;
import org.apache.kafka.common.TopicPartition;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\r4Aa\u0003\u0007\u0001#!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0011!9\u0003A!A!\u0002\u0013A\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b]\u0002A\u0011\u0001\u001d\t\u000by\u0002A\u0011B \t\u000b\r\u0003A\u0011\t#\t\u000b5\u0003A\u0011\t(\t\u000b}\u0003A\u0011\t1\t\u000b\u0005\u0004A\u0011\t2\u0003=\rcWo\u001d;fe2Kgn\u001b*fa2L7-Y)v_R\f\u0017\tZ1qi\u0016\u0014(BA\u0007\u000f\u0003\u0019\u0019XM\u001d<fe*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0011\u0002\u0004\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\u00033ii\u0011\u0001D\u0005\u000371\u0011ABU3qY&\u001c\u0017-U;pi\u0006\fa!];pi\u0006\u001c\bCA\r\u001f\u0013\tyBBA\tDYV\u001cH/\u001a:MS:\\\u0017+^8uCN\fq!\\3ue&\u001c7\u000f\u0005\u0002#K5\t1E\u0003\u0002%\u0019\u0005!A.\u001b8l\u0013\t13E\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018A\u0002;f]\u0006tG\u000fE\u0002\u0014S-J!A\u000b\u000b\u0003\r=\u0003H/[8o!\ta3G\u0004\u0002.cA\u0011a\u0006F\u0007\u0002_)\u0011\u0001\u0007E\u0001\u0007yI|w\u000e\u001e \n\u0005I\"\u0012A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!A\r\u000b\u0002\u00111Lgn\u001b(b[\u0016\fa\u0001P5oSRtD#B\u001d;wqj\u0004CA\r\u0001\u0011\u0015aR\u00011\u0001\u001e\u0011\u0015\u0001S\u00011\u0001\"\u0011\u00159S\u00011\u0001)\u0011\u00151T\u00011\u0001,\u0003e\u0019G.^:uKJd\u0015N\\6SKBd\u0017nY1D_:$X\r\u001f;\u0015\u0003\u0001\u0003\"!G!\n\u0005\tc!\u0001G\"mkN$XM\u001d'j].$VM\\1oi\u000e{g\u000e^3yi\u00061!/Z2pe\u0012$\"!\u0012%\u0011\u0005M1\u0015BA$\u0015\u0005\u0011)f.\u001b;\t\u000b%;\u0001\u0019\u0001&\u0002\u000bY\fG.^3\u0011\u0005MY\u0015B\u0001'\u0015\u0005\u0011auN\\4\u0002\u0017%\u001cH\u000b\u001b:piRdW\r\u001a\u000b\u0003\u001fJ\u0003\"a\u0005)\n\u0005E#\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006'\"\u0001\r\u0001V\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\t)V,D\u0001W\u0015\t9\u0006,\u0001\u0004d_6lwN\u001c\u0006\u0003\u001feS!AW.\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0016aA8sO&\u0011aL\u0016\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=I7/U;pi\u0006,\u0005pY3fI\u0016$W#A(\u0002'5\f'o\u001b*fa2L7-\u0019+ie>$H\u000f\\3\u0015\u0003\u0015\u0003")
public class ClusterLinkReplicaQuotaAdapter
implements ReplicaQuota {
    private final ClusterLinkQuotas quotas;
    private final ClusterLinkMetrics metrics;
    private final Option<String> tenant;
    private final String linkName;

    private ClusterLinkTenantContext clusterLinkReplicaContext() {
        return new ClusterLinkTenantContext(this.tenant, this.linkName);
    }

    @Override
    public void record(long value) {
        this.quotas.produce().record(this.clusterLinkReplicaContext(), value);
    }

    @Override
    public boolean isThrottled(TopicPartition topicPartition) {
        return this.quotas.produce().isThrottled(this.clusterLinkReplicaContext(), topicPartition);
    }

    @Override
    public boolean isQuotaExceeded() {
        return this.quotas.produce().isQuotaExceeded(this.clusterLinkReplicaContext()) || this.quotas.request().isQuotaExceeded(this.clusterLinkReplicaContext());
    }

    @Override
    public void markReplicaThrottle() {
        ClusterLinkTenantContext tenantContext = this.clusterLinkReplicaContext();
        if (this.quotas.request().isQuotaExceeded(tenantContext)) {
            this.metrics.linkFetcherRequestThrottleSensor().record();
        }
        if (this.quotas.produce().isQuotaExceeded(tenantContext)) {
            this.metrics.linkFetcherProduceThrottleSensor().record();
            return;
        }
    }

    public ClusterLinkReplicaQuotaAdapter(ClusterLinkQuotas quotas, ClusterLinkMetrics metrics, Option<String> tenant, String linkName) {
        this.quotas = quotas;
        this.metrics = metrics;
        this.tenant = tenant;
        this.linkName = linkName;
    }
}

