/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.cluster.BrokerEndPoint;
import kafka.server.BrokerBlockingSender;
import kafka.server.LeaderEndPoint;
import kafka.server.LeaderEndpointSupplier;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.RemoteLeaderRequestBuilder;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;

public class RemoteLeaderEndpointSupplier
implements LeaderEndpointSupplier {
    private static final Logger log = LoggerFactory.getLogger(RemoteLeaderEndpointSupplier.class);
    private final Metrics metrics;
    private final Time time;
    private final ReplicaManager replicaManager;

    public RemoteLeaderEndpointSupplier(ReplicaManager replicaManager, Metrics metrics, Time time) {
        this.replicaManager = replicaManager;
        this.metrics = metrics;
        this.time = time;
    }

    @Override
    public LeaderEndPoint get(int nodeId, int leaderId, String context) {
        if (context.isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty context to be supplied.");
        }
        Node leaderNode = (Node)this.replicaManager.metadataCache().getAliveBrokerNode(leaderId, this.replicaManager.config().interBrokerListenerName()).getOrElse(Node::noNode);
        if (leaderNode == Node.noNode()) {
            throw new RuntimeException(String.format("No broker node found for leaderId %d when building RemoteLeaderEndPoint.", leaderId));
        }
        BrokerEndPoint brokerEndPoint = new BrokerEndPoint(leaderNode.id(), leaderNode.host(), leaderNode.port());
        BrokerBlockingSender blockingSender = new BrokerBlockingSender(brokerEndPoint, this.replicaManager.config(), this.metrics, this.time, -1, String.format("%s-%d-to-%d-", context, nodeId, leaderId), new LogContext(), context);
        RemoteLeaderRequestBuilder requestBuilder = new RemoteLeaderRequestBuilder(this.replicaManager.config(), (Function0<MetadataVersion>)((Function0)() -> this.replicaManager.metadataCache().metadataVersion()), this.replicaManager.brokerEpochSupplier());
        RemoteLeaderEndPoint leaderEndPoint = new RemoteLeaderEndPoint(String.format("[RemoteLeaderEndPoint NodeId=%d]", leaderNode.id()), blockingSender, null, requestBuilder, null, this.replicaManager.config(), this.replicaManager, null, (Function0<MetadataVersion>)((Function0)() -> this.replicaManager.metadataCache().metadataVersion()));
        log.debug("Created a remote LeaderEndPoint for broker {}", (Object)leaderId);
        return leaderEndPoint;
    }
}

