/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.flink.watch.v1alpha1.TypeMeta;
import io.confluent.flink.watch.v1alpha1.WatchEvent;
import io.confluent.flink.watch.v1alpha1.WatchGrpc;
import io.confluent.flink.watch.v1alpha1.WatchRequest;
import io.confluent.flink.watch.v1alpha1.WatchResponse;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kafka.server.RmRegionalMetadataWatcher$;
import kafka.server.Subscription;
import kafka.server.Watch;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ew!\u0002\u0011\"\u0011\u00031c!\u0002\u0015\"\u0011\u0003I\u0003\"\u0002\u001c\u0002\t\u00039\u0004\u0002\u0003\u001d\u0002\u0005\u0004%\t!I\u001d\t\r9\u000b\u0001\u0015!\u0003;\u0011!y\u0015A1A\u0005\u0002\u0005\u0002\u0006B\u0002+\u0002A\u0003%\u0011\u000bC\u0003V\u0003\u0011\u0005aK\u0002\u0003)C\tA\u0006\"\u0002\u001c\t\t\u0003I\u0006\"\u0003.\t\u0001\u0004\u0005\r\u0011\"\u0003\\\u0011%y\u0006\u00021AA\u0002\u0013%\u0001\rC\u0005g\u0011\u0001\u0007\t\u0011)Q\u00059\"Aq\r\u0003b\u0001\n\u0003\t\u0003\u000e\u0003\u0004p\u0011\u0001\u0006I!\u001b\u0005\u0006a\"!\t!\u001d\u0005\u0006i\"!\t!\u001e\u0005\b\u0003;AA\u0011AA\u0010\r\u0019\t\t\u0003\u0003\u0003\u0002$!IAO\u0005BC\u0002\u0013\u0005\u0011q\n\u0005\u000b\u0003/\u0012\"\u0011!Q\u0001\n\u0005E\u0003\"C>\u0013\u0005\u000b\u0007I\u0011AA-\u0011)\tiF\u0005B\u0001B\u0003%\u00111\f\u0005\u0007mI!\t!a\u0018\t\u0013\u0005%$C1A\u0005\u000e\u0005-\u0004\u0002CA@%\u0001\u0006i!!\u001c\t\u000f\u0005\u0005%\u0003\"\u0011\u0002\u0004\"9\u0011\u0011\u0012\n\u0005\n\u0005-\u0005bBAM%\u0011\u0005\u00131\u0014\u0005\b\u0003s\u0013B\u0011IA\u0010\u0011\u001d\tYL\u0005C\u0001\u0003WBq!!0\u0013\t\u0003\ty,A\rS[J+w-[8oC2lU\r^1eCR\fw+\u0019;dQ\u0016\u0014(B\u0001\u0012$\u0003\u0019\u0019XM\u001d<fe*\tA%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u001d\nQ\"A\u0011\u00033Ik'+Z4j_:\fG.T3uC\u0012\fG/Y,bi\u000eDWM]\n\u0004\u0003)\u0002\u0004CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g\r\u0005\u00022i5\t!G\u0003\u00024G\u0005)Q\u000f^5mg&\u0011QG\r\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta%\u0001\nxCR\u001c\u0007n\u00117jK:$h*Y7f\u0017\u0016LX#\u0001\u001e\u0011\u0007m\u001aeI\u0004\u0002=\u00036\tQH\u0003\u0002?\u007f\u0005!qM\u001d9d\u0015\u0005\u0001\u0015AA5p\u0013\t\u0011U(\u0001\u0005NKR\fG-\u0019;b\u0013\t!UIA\u0002LKfT!AQ\u001f\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u00027b]\u001eT\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\n11\u000b\u001e:j]\u001e\f1c^1uG\"\u001cE.[3oi:\u000bW.Z&fs\u0002\nQd\u001d;biV\u001c\u0018J\u001c;fe:\fGn\u0015;sK\u0006l7i\\7qY\u0016$X\rZ\u000b\u0002#B\u0011AHU\u0005\u0003'v\u0012aa\u0015;biV\u001c\u0018AH:uCR,8/\u00138uKJt\u0017\r\\*ue\u0016\fWnQ8na2,G/\u001a3!\u0003\u0015\t\u0007\u000f\u001d7z)\r9\u0016q\u001a\t\u0003O!\u00192\u0001\u0003\u00161)\u00059\u0016aB2iC:tW\r\\\u000b\u00029B\u0011A(X\u0005\u0003=v\u0012a\"T1oC\u001e,Gm\u00115b]:,G.A\u0006dQ\u0006tg.\u001a7`I\u0015\fHCA1e!\tY#-\u0003\u0002dY\t!QK\\5u\u0011\u001d)7\"!AA\u0002q\u000b1\u0001\u001f\u00132\u0003!\u0019\u0007.\u00198oK2\u0004\u0013\u0001C2iC:tW\r\\:\u0016\u0003%\u00042A[7]\u001b\u0005Y'B\u00017K\u0003\u0011)H/\u001b7\n\u00059\\'\u0001\u0002'jgR\f\u0011b\u00195b]:,Gn\u001d\u0011\u0002\u0013\r|gNZ5hkJ,GCA1s\u0011\u0015\u0019x\u00021\u0001]\u0003)qWm^\"iC:tW\r\\\u0001\u0006o\u0006$8\r[\u000b\u0004m\u0006\rA\u0003B<{\u0003+\u0001\"a\u0012=\n\u0005eD%!D!vi>\u001cEn\\:fC\ndW\rC\u0003|!\u0001\u0007A0\u0001\u0007tk\n\u001c8M]5qi&|g\u000eE\u0002({~L!A`\u0011\u0003\u0019M+(m]2sSB$\u0018n\u001c8\u0011\t\u0005\u0005\u00111\u0001\u0007\u0001\t\u001d\t)\u0001\u0005b\u0001\u0003\u000f\u0011\u0011\u0001V\t\u0005\u0003\u0013\ty\u0001E\u0002,\u0003\u0017I1!!\u0004-\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aKA\t\u0013\r\t\u0019\u0002\f\u0002\u0004\u0003:L\bB\u0002;\u0011\u0001\u0004\t9\u0002\u0005\u0003(\u00033y\u0018bAA\u000eC\t)q+\u0019;dQ\u0006)1\r\\8tKR\t\u0011MA\nXCR\u001c\u0007n\u0015;sK\u0006lwJY:feZ,'/\u0006\u0003\u0002&\u0005U3#\u0002\n\u0002(\u00055\u0002cA$\u0002*%\u0019\u00111\u0006%\u0003\r=\u0013'.Z2u!\u0019\ty#!\u000e\u0002:5\u0011\u0011\u0011\u0007\u0006\u0004\u0003gi\u0014\u0001B:uk\nLA!a\u000e\u00022\tq1\u000b\u001e:fC6|%m]3sm\u0016\u0014\b\u0003BA\u001e\u0003\u0017j!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\tmF\nG\u000e\u001d5bc)\u0019A/a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0006M2Lgn\u001b\u0006\u0004\u0003\u0013z\u0014!C2p]\u001adW/\u001a8u\u0013\u0011\ti%!\u0010\u0003\u001b]\u000bGo\u00195SKN\u0004xN\\:f+\t\t\t\u0006E\u0003(\u00033\t\u0019\u0006\u0005\u0003\u0002\u0002\u0005UCaBA\u0003%\t\u0007\u0011qA\u0001\u0007o\u0006$8\r\u001b\u0011\u0016\u0005\u0005m\u0003\u0003B\u0014~\u0003'\nQb];cg\u000e\u0014\u0018\u000e\u001d;j_:\u0004CCBA1\u0003K\n9\u0007E\u0003\u0002dI\t\u0019&D\u0001\t\u0011\u0019!x\u00031\u0001\u0002R!11p\u0006a\u0001\u00037\n!cY1oG\u0016dG.\u0019;j_:4U\u000f^;sKV\u0011\u0011Q\u000e\t\u0007\u0003_\n)(!\u001f\u000e\u0005\u0005E$bAA:W\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005]\u0014\u0011\u000f\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007cA$\u0002|%\u0019\u0011Q\u0010%\u0003\tY{\u0017\u000eZ\u0001\u0014G\u0006t7-\u001a7mCRLwN\u001c$viV\u0014X\rI\u0001\u0007_:tU\r\u001f;\u0015\u0007\u0005\f)\tC\u0004\u0002\bj\u0001\r!!\u000f\u0002\u0011I,7\u000f]8og\u0016\f1\u0002Z3tKJL\u0017\r\\5{KR1\u00111KAG\u0003/Cq!a$\u001c\u0001\u0004\t\t*A\u0003fm\u0016tG\u000f\u0005\u0003\u0002<\u0005M\u0015\u0002BAK\u0003{\u0011!bV1uG\",e/\u001a8u\u0011\u0019Y8\u00041\u0001\u0002\\\u00059qN\\#se>\u0014HcA1\u0002\u001e\"9\u0011q\u0014\u000fA\u0002\u0005\u0005\u0016!\u0001;\u0011\t\u0005\r\u00161\u0017\b\u0005\u0003K\u000byK\u0004\u0003\u0002(\u00065VBAAU\u0015\r\tY+J\u0001\u0007yI|w\u000e\u001e \n\u00035J1!!--\u0003\u001d\u0001\u0018mY6bO\u0016LA!!.\u00028\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003cc\u0013aC8o\u0007>l\u0007\u000f\\3uK\u0012\fQcZ3u\u0007\u0006t7-\u001a7mCRLwN\u001c$viV\u0014X-\u0001\u000fhKR\u001cE.[3oi\u000e\u000bgnY3mY\u0006$\u0018n\u001c8NKN\u001c\u0018mZ3\u0016\u0005\u0005\u0005\u0007\u0003BAb\u0003\u0017tA!!2\u0002HB\u0019\u0011q\u0015\u0017\n\u0007\u0005%G&\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u001b\u00065'bAAeY!)!l\u0002a\u00019\u0002")
public final class RmRegionalMetadataWatcher
implements Logging {
    private ManagedChannel channel;
    private final List<ManagedChannel> channels = new ArrayList<ManagedChannel>();
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static RmRegionalMetadataWatcher apply(ManagedChannel channel) {
        return RmRegionalMetadataWatcher$.MODULE$.apply(channel);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ManagedChannel channel() {
        return this.channel;
    }

    private void channel_$eq(ManagedChannel x$1) {
        this.channel = x$1;
    }

    public List<ManagedChannel> channels() {
        return this.channels;
    }

    public void configure(ManagedChannel newChannel) {
        newChannel.notifyWhenStateChanged(ConnectivityState.IDLE, () -> {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = RmRegionalMetadataWatcher.$anonfun$configure$2(this);
                Object var1_1 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                return;
            }
        });
        this.channels().add(newChannel);
        this.channel_$eq(newChannel);
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = RmRegionalMetadataWatcher.$anonfun$configure$3(this);
            Object var2_2 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            return;
        }
    }

    public <T> AutoCloseable watch(Subscription<T> subscription, Watch<T> watch) {
        HashSet<String> fieldSelectorSet = new HashSet<String>();
        subscription.fieldSelector().entrySet().stream().forEach(e -> fieldSelectorSet.add(new StringBuilder(1).append((String)e.getKey()).append("=").append(e.getValue()).toString()));
        WatchRequest watchRequest = WatchRequest.newBuilder().setSubscriptionId(subscription.subscriptionId()).setObjectType(TypeMeta.newBuilder().setApiVersion(subscription.apiVersion()).setKind(subscription.kind()).build()).addAllFieldSelector(fieldSelectorSet).setIncludeSnapshot(subscription.includeSnapshot()).build();
        WatchStreamObserver watchObserver = new WatchStreamObserver(this, watch, subscription);
        Context.CancellableContext withCancellation = Context.current().withCancellation();
        Metadata metadata = new Metadata();
        metadata.put(RmRegionalMetadataWatcher$.MODULE$.watchClientNameKey(), (Object)subscription.clientName());
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = RmRegionalMetadataWatcher.$anonfun$watch$2(watchRequest, subscription);
            Object var8_8 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        withCancellation.run(() -> ((WatchGrpc.WatchStub)WatchGrpc.newStub((Channel)this.channel()).withWaitForReady().withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).watch(watchRequest, watchObserver));
        return () -> {
            try {
                withCancellation.cancel((Throwable)new StatusException(Status.CANCELLED.withDescription(watchObserver.getClientCancellationMessage())));
                watchObserver.getCancellationFuture().get();
            }
            finally {
                withCancellation.close();
            }
        };
    }

    public void close() {
        this.channels().forEach(c -> {
            if (c != null) {
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = "Closing watcher channel.";
                    Object var2_2 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                c.shutdownNow();
                return;
            }
        });
    }

    public static final /* synthetic */ String $anonfun$configure$2(RmRegionalMetadataWatcher $this) {
        return new StringBuilder(31).append("Connection state changed to [").append($this.channel().getState(false)).append("].").toString();
    }

    public static final /* synthetic */ String $anonfun$configure$3(RmRegionalMetadataWatcher $this) {
        return new StringBuilder(72).append("Configured new watcher channel. There are currently ").append($this.channels()).append(".size open channels.").toString();
    }

    public static final /* synthetic */ String $anonfun$watch$2(WatchRequest watchRequest$1, Subscription subscription$1) {
        return new StringBuilder(35).append("starting watch ").append(watchRequest$1).append(" for subscription [").append(subscription$1).append("]").toString();
    }

    public static final /* synthetic */ String $anonfun$close$3() {
        return "Closing watcher channel.";
    }

    private class WatchStreamObserver<T>
    implements StreamObserver<WatchResponse> {
        private final Watch<T> watch;
        private final Subscription<T> subscription;
        private final CompletableFuture<Void> cancellationFuture;
        public final /* synthetic */ RmRegionalMetadataWatcher $outer;

        public Watch<T> watch() {
            return this.watch;
        }

        public Subscription<T> subscription() {
            return this.subscription;
        }

        private final CompletableFuture<Void> cancellationFuture() {
            return this.cancellationFuture;
        }

        public void onNext(WatchResponse response) {
            CollectionConverters$.MODULE$.ListHasAsScala(response.getEventsList()).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)WatchStreamObserver.$anonfun$onNext$1(check$ifrefutable$1))).foreach((Function1 & Serializable)event -> {
                WatchStreamObserver.$anonfun$onNext$2(this, event);
                return BoxedUnit.UNIT;
            });
        }

        private T deserialize(WatchEvent event, Subscription<T> subscription) {
            return (T)subscription.deserializer().apply((Object)event.getRawJsonObject().toByteArray());
        }

        /*
         * Unable to fully structure code
         */
        public void onError(Throwable t) {
            v0 = this.kafka$server$RmRegionalMetadataWatcher$WatchStreamObserver$$$outer();
            if (v0 == null) {
                throw null;
            }
            error_this = v0;
            if (error_this.logger().underlying().isErrorEnabled()) {
                msgWithLogIdent_msg = "Error occurred while watching.";
                var5_3 = null;
                error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg), t);
            }
            var4_2 = null;
            status = Status.fromThrowable((Throwable)t);
            if (status.getCode() != Status.Code.CANCELLED) ** GOTO lbl-1000
            v1 = this.getClientCancellationMessage();
            var3_5 = status.getDescription();
            if (!(v1 != null ? v1.equals(var3_5) == false : var3_5 != null)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) {
                this.watch().onError(t);
            }
            this.cancellationFuture().complete(null);
        }

        public void onCompleted() {
            RmRegionalMetadataWatcher rmRegionalMetadataWatcher = this.kafka$server$RmRegionalMetadataWatcher$WatchStreamObserver$$$outer();
            if (rmRegionalMetadataWatcher == null) {
                throw null;
            }
            RmRegionalMetadataWatcher error_this = rmRegionalMetadataWatcher;
            if (error_this.logger().underlying().isErrorEnabled()) {
                String msgWithLogIdent_msg = "Watch stream completed unexpectedly.";
                Object var2_2 = null;
                error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg));
            }
            Object var1_1 = null;
            this.watch().onError((Throwable)new StatusException(RmRegionalMetadataWatcher$.MODULE$.statusInternalStreamCompleted()));
            this.cancellationFuture().complete(null);
        }

        public CompletableFuture<Void> getCancellationFuture() {
            return this.cancellationFuture();
        }

        public String getClientCancellationMessage() {
            return new StringBuilder(61).append("Subscription [").append(this.subscription()).append(".subscriptionId] has been explicitly cancelled.").toString();
        }

        public /* synthetic */ RmRegionalMetadataWatcher kafka$server$RmRegionalMetadataWatcher$WatchStreamObserver$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$onNext$1(WatchEvent check$ifrefutable$1) {
            return check$ifrefutable$1 != null;
        }

        public static final /* synthetic */ String $anonfun$onNext$3(WatchStreamObserver $this, WatchEvent event$1) {
            return new StringBuilder(57).append("Received event [{").append(event$1).append("}] for subscription [{").append($this.subscription()).append(".subscriptionId}].").toString();
        }

        public static final /* synthetic */ String $anonfun$onNext$4(WatchEvent event$1) {
            return new StringBuilder(52).append("Ignoring unknown watch event type [{").append(event$1).append(".getEventType}].").toString();
        }

        public static final /* synthetic */ void $anonfun$onNext$2(WatchStreamObserver $this, WatchEvent event) {
            RmRegionalMetadataWatcher rmRegionalMetadataWatcher = $this.kafka$server$RmRegionalMetadataWatcher$WatchStreamObserver$$$outer();
            if (rmRegionalMetadataWatcher == null) {
                throw null;
            }
            RmRegionalMetadataWatcher debug_this = rmRegionalMetadataWatcher;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = WatchStreamObserver.$anonfun$onNext$3($this, event);
                Object var5_3 = null;
                debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
            }
            Object var3_2 = null;
            WatchEvent.EventType eventType = event.getEventType();
            if (((Object)((Object)WatchEvent.EventType.CREATED)).equals((Object)eventType)) {
                $this.watch().onCreated($this.deserialize(event, $this.subscription()));
                return;
            }
            if (((Object)((Object)WatchEvent.EventType.SNAPSHOT)).equals((Object)eventType)) {
                $this.watch().onCreated($this.deserialize(event, $this.subscription()));
                return;
            }
            if (((Object)((Object)WatchEvent.EventType.UPDATED)).equals((Object)eventType)) {
                $this.watch().onUpdated($this.deserialize(event, $this.subscription()));
                return;
            }
            if (((Object)((Object)WatchEvent.EventType.DELETED)).equals((Object)eventType)) {
                $this.watch().onDeleted($this.deserialize(event, $this.subscription()));
                return;
            }
            if (((Object)((Object)WatchEvent.EventType.END_OF_SNAPSHOT)).equals((Object)eventType)) {
                $this.watch().onEndOfSnapshot();
                return;
            }
            RmRegionalMetadataWatcher rmRegionalMetadataWatcher2 = $this.kafka$server$RmRegionalMetadataWatcher$WatchStreamObserver$$$outer();
            if (rmRegionalMetadataWatcher2 == null) {
                throw null;
            }
            RmRegionalMetadataWatcher warn_this = rmRegionalMetadataWatcher2;
            if (warn_this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = WatchStreamObserver.$anonfun$onNext$4(event);
                Object var6_6 = null;
                warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                return;
            }
        }

        public static final /* synthetic */ String $anonfun$onError$1() {
            return "Error occurred while watching.";
        }

        public static final /* synthetic */ Throwable $anonfun$onError$2(Throwable t$1) {
            return t$1;
        }

        public static final /* synthetic */ String $anonfun$onCompleted$1() {
            return "Watch stream completed unexpectedly.";
        }

        public WatchStreamObserver(RmRegionalMetadataWatcher $outer, Watch<T> watch, Subscription<T> subscription) {
            this.watch = watch;
            this.subscription = subscription;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.cancellationFuture = new CompletableFuture();
        }
    }
}

