/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.client;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kafka.tier.client.TierTopicClient;
import kafka.tier.topic.TierTopicManagerConfig;
import org.apache.kafka.clients.producer.KafkaProducerWrapperWithTime;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierTopicProducerSupplier
implements Supplier<Producer<byte[], byte[]>> {
    private static final String CLIENT_TYPE = "producer";
    private static final String SEPARATOR = "-";
    private final TierTopicManagerConfig config;
    private final AtomicInteger instanceId = new AtomicInteger(0);
    private final Time time;
    private static final Logger log = LoggerFactory.getLogger(TierTopicProducerSupplier.class);

    public TierTopicProducerSupplier(TierTopicManagerConfig config, Time time) {
        this.config = config;
        this.time = time;
    }

    @Override
    public Producer<byte[], byte[]> get() {
        String clientId = TierTopicProducerSupplier.clientId(this.config.clusterId, this.config.brokerId, this.instanceId.getAndIncrement());
        return new KafkaProducerWrapperWithTime(TierTopicProducerSupplier.properties(this.config, clientId), this.time);
    }

    public static String clientId(String clusterId, int brokerId, long instanceId) {
        return TierTopicClient.clientIdPrefix(CLIENT_TYPE) + SEPARATOR + clusterId + SEPARATOR + brokerId + SEPARATOR + instanceId;
    }

    public static void addBaseProperties(Properties properties, String clientId, Integer requestTimeoutMs, Boolean enableIdempotence) {
        properties.put("key.serializer", ByteArraySerializer.class.getName());
        properties.put("value.serializer", ByteArraySerializer.class.getName());
        properties.put("acks", "all");
        properties.put("retries", Integer.toString(Integer.MAX_VALUE));
        properties.put("retry.backoff.ms", Integer.toString(2000));
        properties.put("delivery.timeout.ms", Integer.toString(Integer.MAX_VALUE));
        properties.put("client.id", clientId);
        properties.put("request.timeout.ms", requestTimeoutMs);
        properties.put("enable.idempotence", enableIdempotence.toString());
        properties.put("max.in.flight.requests.per.connection", (Object)1);
        log.info("Tier Topic Producer created with idempotence set as {}", (Object)enableIdempotence);
    }

    public static Properties properties(TierTopicManagerConfig config, String clientId) {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> configEntry : config.interBrokerClientConfigs.get().entrySet()) {
            properties.put(configEntry.getKey(), configEntry.getValue());
        }
        TierTopicProducerSupplier.addBaseProperties(properties, clientId, config.requestTimeoutMs, config.enableProducerIdempotence);
        properties.put("enable.metrics.push", "false");
        properties.remove("metric.reporters");
        return properties;
    }
}

