/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.checksum.CheckedFileIO;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.log.MergedLog;
import kafka.restore.ResetTierPartitionState;
import kafka.tier.TopicIdPartition;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.tools.common.RestoreRawInputInfoLocal;
import kafka.tier.tools.common.RestoreRawInputInfoRemoteURI;
import kafka.tier.topic.recovery.SelectRemoteFileTierPartitionStateOutput;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierPartitionStateRestoreRawInputGenerator {
    public static final String GENERATOR_OUTPUT_JSON_FILE = "output.json";
    public static final String GENERATOR_OUTPUT_JSON_FILE_DOC = "The path to an output file where the raw input for tier state restoration will be emitted in JSON format.";
    private static final Logger LOGGER = LoggerFactory.getLogger(TierPartitionStateRestoreRawInputGenerator.class);

    public static void main(String[] args) throws Exception {
        block2: {
            ArgumentParser parser = TierPartitionStateRestoreRawInputGenerator.createArgParser();
            try {
                TierPartitionStateRestoreRawInputGenerator.run(parser.parseArgs(args));
            }
            catch (ArgumentParserException e) {
                parser.handleError(e);
                if (e instanceof HelpScreenException) break block2;
                throw e;
            }
        }
    }

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)TierPartitionStateRestoreRawInputGenerator.class.getName()).defaultHelp(true).description("Provides a command to generate the raw input for tier state restoration, using (1) the output of the fencing command and (2) a root directory containing the tier partition state files to be restored.");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("fence.json")}).dest("fence.json").type(String.class).required(true).help("The path to a JSON file containing the output of the successful fencing command.");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(GENERATOR_OUTPUT_JSON_FILE)}).dest(GENERATOR_OUTPUT_JSON_FILE).type(String.class).required(true).help(GENERATOR_OUTPUT_JSON_FILE_DOC);
        MutuallyExclusiveGroup ftpsFileDestGroup = parser.addMutuallyExclusiveGroup().required(true);
        ftpsFileDestGroup.addArgument(new String[]{RecoveryUtils.makeArgument("restore.tier.state.root.dir")}).dest("restore.tier.state.root.dir").type(String.class).help("The path to the local root directory containing the tier partition state files to be restored. The files should be organized under the root directory as: /path/to/ftps_root_dir/<TOPIC>-<PARTITION>/<TIER-STATE-FILE>. There should be exactly one <TIER-STATE-FILE> under each <TOPIC-PARTITION> sub directory.");
        ftpsFileDestGroup.addArgument(new String[]{RecoveryUtils.makeArgument("restore.remote.tier.state.uris.file")}).dest("restore.remote.tier.state.uris.file").type(String.class).help("The path to the file containing a map of topic partitions to its respective tier partition state file path in the remote object store");
        return parser;
    }

    private static void run(Namespace args) throws Exception {
        String generatorOutputJsonPath = TierPartitionStateRestoreRawInputGenerator.getOutputFilePath(args);
        if (args.getString("restore.tier.state.root.dir") != null) {
            List<RestoreRawInputInfoLocal> restoreInputs = TierPartitionStateRestoreRawInputGenerator.generateRestoreRawInput(args);
            try (FileOutputStream fos = new FileOutputStream(generatorOutputJsonPath);){
                RestoreRawInputInfoLocal.writeJsonToFile(restoreInputs, fos);
            }
        } else if (args.getString("restore.remote.tier.state.uris.file") != null) {
            List<RestoreRawInputInfoRemoteURI> restoreInputs = TierPartitionStateRestoreRawInputGenerator.generateRestoreRawInputRemoteURI(args);
            try (FileOutputStream fos = new FileOutputStream(generatorOutputJsonPath);){
                RestoreRawInputInfoRemoteURI.writeJsonToFile(restoreInputs, fos);
            }
        } else {
            throw new IllegalArgumentException("Either restore.tier.state.root.dir or restore.remote.tier.state.uris.file should be specified");
        }
    }

    public static List<RestoreRawInputInfoLocal> generateRestoreRawInput(Namespace args) throws IOException {
        List<FenceEventInfo> fencingEvents = TierPartitionStateRestoreRawInputGenerator.getFencingEvents(args);
        Path restoreTierStateRootDir = TierPartitionStateRestoreRawInputGenerator.getRestoreTierStateRootDir(args);
        return TierPartitionStateRestoreRawInputGenerator.generateRestoreRawInput(fencingEvents, restoreTierStateRootDir);
    }

    public static List<RestoreRawInputInfoRemoteURI> generateRestoreRawInputRemoteURI(Namespace args) throws IOException {
        List<FenceEventInfo> fencingEvents = TierPartitionStateRestoreRawInputGenerator.getFencingEvents(args);
        Map<TopicIdPartition, String> remoteURIsInfo = TierPartitionStateRestoreRawInputGenerator.getRemoteURIsInfo(args);
        return TierPartitionStateRestoreRawInputGenerator.generateRestoreRawInputRemoteURI(fencingEvents, remoteURIsInfo);
    }

    private static File[] listOrThrow(Path dir, FileFilter filter) throws IOException {
        File[] files = dir.toFile().listFiles(filter);
        if (files == null) {
            throw new IOException("Could not list items under the directory: " + dir);
        }
        return files;
    }

    private static Set<String> getValidTierStateFiles(Path topicPartitionDir) {
        HashSet<String> validTierStateFiles = new HashSet<String>();
        Path validTierStateFileBase = MergedLog.tierStateFile(topicPartitionDir.toFile(), 0L, "").toPath();
        for (Algorithm algorithm : Algorithm.values()) {
            String validTierStateFile = CheckedFileIO.validPath((Algorithm)algorithm, (Path)validTierStateFileBase).toString();
            validTierStateFiles.add(validTierStateFile);
            validTierStateFiles.add(ResetTierPartitionState.outputFilePath(validTierStateFile));
        }
        return validTierStateFiles;
    }

    static List<RestoreRawInputInfoLocal> generateRestoreRawInput(List<FenceEventInfo> fencingEvents, Path restoreTierStateRootDir) throws IOException {
        File[] files;
        HashSet<String> restoreTopicPartitionDirs = new HashSet<String>();
        for (File dir : files = TierPartitionStateRestoreRawInputGenerator.listOrThrow(restoreTierStateRootDir, File::isDirectory)) {
            restoreTopicPartitionDirs.add(dir.getName());
        }
        InvalidInputException exception = new InvalidInputException(restoreTierStateRootDir.toString());
        ArrayList<RestoreRawInputInfoLocal> restoreInputs = new ArrayList<RestoreRawInputInfoLocal>();
        for (FenceEventInfo event : fencingEvents) {
            TopicPartition fencedTopicPartition = new TopicPartition(event.topic, event.partition);
            Path fencedTopicPartitionDir = Paths.get(restoreTierStateRootDir.toString(), MergedLog.logDirName(fencedTopicPartition));
            String fencedTopicPartitionDirName = fencedTopicPartitionDir.toFile().getName();
            if (restoreTopicPartitionDirs.contains(fencedTopicPartitionDirName)) {
                File[] tierStateFilesOnDisk = TierPartitionStateRestoreRawInputGenerator.listOrThrow(fencedTopicPartitionDir, File::isFile);
                Set<String> validTierStateFiles = TierPartitionStateRestoreRawInputGenerator.getValidTierStateFiles(fencedTopicPartitionDir);
                int numValidFilesOnDisk = 0;
                File chosenTierStateFileOnDisk = null;
                for (File fileOnDisk : tierStateFilesOnDisk) {
                    if (!validTierStateFiles.contains(fileOnDisk.getAbsolutePath())) continue;
                    chosenTierStateFileOnDisk = fileOnDisk;
                    ++numValidFilesOnDisk;
                }
                if (numValidFilesOnDisk == 1 && chosenTierStateFileOnDisk.length() > 0L) {
                    restoreInputs.add(new RestoreRawInputInfoLocal(event, chosenTierStateFileOnDisk.toPath()));
                    continue;
                }
                if (numValidFilesOnDisk == 0) {
                    System.err.println("ERROR! Found no valid tier state file under: " + fencedTopicPartitionDir);
                } else if (numValidFilesOnDisk > 1) {
                    System.err.println("ERROR! Found more than 1 valid tier state file under: " + fencedTopicPartitionDir);
                } else if (chosenTierStateFileOnDisk.length() == 0L) {
                    System.err.println("ERROR! Found empty tier state file: " + chosenTierStateFileOnDisk.getAbsolutePath());
                }
                exception.partitionsWithIncorrectTierStateFiles.add(fencedTopicPartition);
                continue;
            }
            System.err.println("ERROR! Missing sub-directory: " + fencedTopicPartitionDir);
            exception.partitionsWithMissingDirs.add(fencedTopicPartition);
        }
        if (!exception.isEmpty()) {
            throw new IllegalArgumentException("Invalid input provided.", exception);
        }
        return restoreInputs;
    }

    static List<RestoreRawInputInfoRemoteURI> generateRestoreRawInputRemoteURI(List<FenceEventInfo> fencingEvents, Map<TopicIdPartition, String> remoteURIsInfo) {
        ArrayList<RestoreRawInputInfoRemoteURI> restoreInputs = new ArrayList<RestoreRawInputInfoRemoteURI>();
        if (fencingEvents.size() != remoteURIsInfo.size()) {
            LOGGER.error("Sizes of fencing events and remote URIs is not matching");
            return restoreInputs;
        }
        HashMap<TopicPartition, FenceEventInfo> fencedTopicPartitionsMap = new HashMap<TopicPartition, FenceEventInfo>();
        for (FenceEventInfo fenceEventInfo : fencingEvents) {
            TopicPartition fencedTopicPartition = new TopicPartition(fenceEventInfo.topic, fenceEventInfo.partition);
            fencedTopicPartitionsMap.put(fencedTopicPartition, fenceEventInfo);
        }
        for (Map.Entry entry : remoteURIsInfo.entrySet()) {
            TopicPartition remoteURITopicPartition = new TopicPartition(((TopicIdPartition)entry.getKey()).topic(), ((TopicIdPartition)entry.getKey()).partition());
            FenceEventInfo fenceEventInfo = (FenceEventInfo)fencedTopicPartitionsMap.get(remoteURITopicPartition);
            if (fenceEventInfo != null) {
                restoreInputs.add(new RestoreRawInputInfoRemoteURI(fenceEventInfo, entry));
                continue;
            }
            throw new InvalidInputException("Topic partition " + remoteURITopicPartition + " should be fenced before restoring");
        }
        return restoreInputs;
    }

    private static Path getRestoreTierStateRootDir(Namespace args) {
        String restoreTierStateRootDirPath = args.getString("restore.tier.state.root.dir");
        Path restoreTierStateRootDir = Paths.get(restoreTierStateRootDirPath, new String[0]);
        if (!restoreTierStateRootDir.toFile().exists()) {
            throw new IllegalArgumentException("Restore tier state root dir does not exist: " + restoreTierStateRootDirPath);
        }
        return restoreTierStateRootDir;
    }

    private static String getOutputFilePath(Namespace args) throws IOException {
        String outputFilePath = args.getString(GENERATOR_OUTPUT_JSON_FILE);
        File outputFile = new File(outputFilePath);
        if (outputFile.exists() && !outputFile.delete()) {
            throw new IOException("Cannot overwrite existing file at " + outputFilePath);
        }
        if (!outputFile.createNewFile()) {
            throw new IOException("Could not create output file at path " + outputFilePath);
        }
        return outputFilePath;
    }

    private static List<FenceEventInfo> getFencingEvents(Namespace args) {
        String fencingOutputJsonPathStr = args.getString("fence.json");
        Path fencingOutputJsonPath = Paths.get(fencingOutputJsonPathStr, new String[0]);
        if (Files.notExists(fencingOutputJsonPath, new LinkOption[0]) || !Files.isRegularFile(fencingOutputJsonPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Fencing output file does not exist: " + fencingOutputJsonPath);
        }
        try {
            return FenceEventInfo.readJsonFromFile(fencingOutputJsonPath);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Couldn't parse provided input JSON from: " + fencingOutputJsonPath, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Incorrect JSON file provided: " + fencingOutputJsonPath, e);
        }
    }

    private static Map<TopicIdPartition, String> getRemoteURIsInfo(Namespace args) throws IOException {
        String restoreRemoteURIInfoPathStr = args.getString("restore.remote.tier.state.uris.file");
        Path restoreRemoteURIInfoPath = Paths.get(restoreRemoteURIInfoPathStr, new String[0]);
        if (Files.notExists(restoreRemoteURIInfoPath, new LinkOption[0]) || !Files.isRegularFile(restoreRemoteURIInfoPath, new LinkOption[0])) {
            throw new IllegalArgumentException("File containing remote URIs info does not exist: " + restoreRemoteURIInfoPath);
        }
        return SelectRemoteFileTierPartitionStateOutput.readFromFile(restoreRemoteURIInfoPath).selectedFTPS();
    }

    public static class InvalidInputException
    extends RuntimeException {
        private final String restoreTierStateRootDir;
        public final List<TopicPartition> partitionsWithMissingDirs = new ArrayList<TopicPartition>();
        public final List<TopicPartition> partitionsWithIncorrectTierStateFiles = new ArrayList<TopicPartition>();

        public InvalidInputException(String restoreTierStateRootDir) {
            this.restoreTierStateRootDir = restoreTierStateRootDir;
        }

        public boolean isEmpty() {
            return this.partitionsWithMissingDirs.isEmpty() && this.partitionsWithIncorrectTierStateFiles.isEmpty();
        }

        @Override
        public String toString() {
            String newLine = System.lineSeparator();
            StringBuilder errorMsg = new StringBuilder("The following errors were encountered:");
            errorMsg.append(newLine);
            errorMsg.append(newLine);
            if (!this.partitionsWithMissingDirs.isEmpty()) {
                String partitionsWithMissingDirsStr = this.partitionsWithMissingDirs.stream().map(TopicPartition::toString).collect(Collectors.joining(", "));
                errorMsg.append(String.format("Sub-directories for the following topic partitions are missing under %s: %s", this.restoreTierStateRootDir, partitionsWithMissingDirsStr));
            }
            if (!this.partitionsWithIncorrectTierStateFiles.isEmpty()) {
                if (!this.partitionsWithMissingDirs.isEmpty()) {
                    errorMsg.append(newLine);
                    errorMsg.append(newLine);
                }
                String partitionsWithIncorrectTierStateFilesStr = this.partitionsWithIncorrectTierStateFiles.stream().map(TopicPartition::toString).collect(Collectors.joining(", "));
                errorMsg.append(String.format("Restore tier state file for the following topic partitions are either missing or incorrect: %s", partitionsWithIncorrectTierStateFilesStr));
            }
            return errorMsg.toString();
        }
    }
}

