/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.util.Map;
import java.util.stream.Collectors;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.topic.TierTopicConsumerRewindPolicy;

public class TierTopicConsumerRewindUtils {
    static IsValidRewind validateRewindOffsetByPolicy(OffsetAndEpoch rewindOffsetAndEpoch, OffsetAndEpoch localOffsetAndEpoch, OffsetAndEpoch flushedOffsetAndEpoch, TierTopicConsumerRewindPolicy policy) {
        if (localOffsetAndEpoch == null || flushedOffsetAndEpoch == null) {
            switch (policy) {
                case SKIP_MISSING_PARTITIONS: {
                    return IsValidRewind.SKIPPED;
                }
                case FAIL_ON_MISSING_PARTITIONS: {
                    return IsValidRewind.FAILED_MISSING;
                }
            }
        }
        if (rewindOffsetAndEpoch.offset() > flushedOffsetAndEpoch.offset() || rewindOffsetAndEpoch.offset() > localOffsetAndEpoch.offset()) {
            return IsValidRewind.FAILED_AHEAD;
        }
        return IsValidRewind.VALID;
    }

    public static String rewindPositionsAsString(Map<Integer, OffsetAndEpoch> partitionToPosition) {
        return partitionToPosition.entrySet().stream().map(entry -> String.format("tp=%s:(offset=%s,epoch=%s)", entry.getKey(), ((OffsetAndEpoch)entry.getValue()).offset(), ((OffsetAndEpoch)entry.getValue()).epoch())).collect(Collectors.joining(", "));
    }

    static enum IsValidRewind {
        VALID,
        FAILED_MISSING,
        FAILED_AHEAD,
        SKIPPED;

    }
}

