/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo;
import kafka.zk.FeatureZNode$;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.SocketServerConfigs;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Factory;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BrokerIdZNode$ {
    public static final BrokerIdZNode$ MODULE$ = new BrokerIdZNode$();
    private static final String HostKey = "host";
    private static final String PortKey = "port";
    private static final String VersionKey = "version";
    private static final String EndpointsKey = "endpoints";
    private static final String RackKey = "rack";
    private static final String JmxPortKey = "jmx_port";
    private static final String ListenerSecurityProtocolMapKey = "listener_security_protocol_map";
    private static final String TimestampKey = "timestamp";
    private static final String FeaturesKey = "features";
    private static final String TagsKey = "tags";

    private String HostKey() {
        return HostKey;
    }

    private String PortKey() {
        return PortKey;
    }

    private String VersionKey() {
        return VersionKey;
    }

    private String EndpointsKey() {
        return EndpointsKey;
    }

    private String RackKey() {
        return RackKey;
    }

    private String JmxPortKey() {
        return JmxPortKey;
    }

    private String ListenerSecurityProtocolMapKey() {
        return ListenerSecurityProtocolMapKey;
    }

    private String TimestampKey() {
        return TimestampKey;
    }

    private String FeaturesKey() {
        return FeaturesKey;
    }

    private String TagsKey() {
        return TagsKey;
    }

    public String path(int id) {
        return new StringBuilder(1).append(BrokerIdsZNode$.MODULE$.path()).append("/").append(id).toString();
    }

    public byte[] encode(int version, String host, int port, Seq<EndPoint> advertisedEndpoints, int jmxPort, Option<String> rack2, Features<SupportedVersionRange> features, Map<String, String> tags) {
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey()), (Object)BoxesRunTime.boxToInteger((int)version)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HostKey()), (Object)host), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PortKey()), (Object)BoxesRunTime.boxToInteger((int)port)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.EndpointsKey()), (Object)CollectionConverters$.MODULE$.BufferHasAsJava(((IterableOnceOps)advertisedEndpoints.map((Function1 & Serializable)x$1 -> x$1.connectionString())).toBuffer()).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.JmxPortKey()), (Object)BoxesRunTime.boxToInteger((int)jmxPort)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TimestampKey()), (Object)Long.toString(Time.SYSTEM.milliseconds())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TagsKey()), (Object)CollectionConverters$.MODULE$.MapHasAsJava(tags).asJava())}));
        rack2.foreach((Function1 & Serializable)rack -> {
            if (version >= 3) {
                return jsonMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.RackKey()), rack));
            }
            return BoxedUnit.UNIT;
        });
        if (version >= 4) {
            jsonMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ListenerSecurityProtocolMapKey()), (Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)advertisedEndpoints.map((Function1 & Serializable)endPoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endPoint.listenerName().value()), (Object)endPoint.securityProtocol().name))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava()));
        }
        if (version >= 5) {
            jsonMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FeaturesKey()), (Object)features.toMap()));
        }
        return Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.MutableMapHasAsJava(jsonMap).asJava());
    }

    public byte[] encode(BrokerInfo brokerInfo) {
        Broker broker = brokerInfo.broker();
        EndPoint plaintextEndpoint = (EndPoint)broker.endPoints().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BrokerIdZNode$.$anonfun$encode$4(x$2))).getOrElse((Function0 & Serializable)() -> new EndPoint(null, -1, null, null));
        return this.encode(brokerInfo.version(), plaintextEndpoint.host(), plaintextEndpoint.port(), broker.endPoints(), brokerInfo.jmxPort(), broker.rack(), broker.features(), (Map<String, String>)broker.tags());
    }

    private java.util.Map<String, java.util.Map<String, Short>> featuresAsJavaMap(JsonObject brokerInfo) {
        return FeatureZNode$.MODULE$.asJavaMap((Map<String, Map<String, Object>>)((Map)brokerInfo.get(this.FeaturesKey()).flatMap((Function1 & Serializable)x$3 -> {
            void decodeMap_factory;
            Factory decodeMap_factory2 = scala.collection.Map$.MODULE$.mapFactory();
            DecodeJson$DecodeInt$ decodeMap_decodeJson = DecodeJson$DecodeInt$.MODULE$;
            Object var1_2 = null;
            Object var2_1 = null;
            Factory factory = scala.collection.Map$.MODULE$.mapFactory();
            DecodeJson decodeMap_decodeJson2 = new DecodeJson<M>(decodeMap_decodeJson, decodeMap_factory2){
                private final DecodeJson decodeJson$3;
                private final Factory factory$2;

                public Object decode(JsonNode node) {
                    return DecodeJson.decode$(this, node);
                }

                public final Either<String, M> decodeEither(JsonNode node) {
                    return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeMap$1(node, this.decodeJson$3, this.factory$2);
                }
                {
                    this.decodeJson$3 = decodeJson$3;
                    this.factory$2 = factory$2;
                }
            };
            Object var3_4 = null;
            factory = null;
            DecodeJson decodeOption_decodeJson = new /* invalid duplicate definition of identical inner class */;
            Object var5_5 = null;
            return (Option)x$3.to(new DecodeJson<Option<E>>(decodeOption_decodeJson){
                private final DecodeJson decodeJson$1;

                public Object decode(JsonNode node) {
                    return DecodeJson.decode$(this, node);
                }

                public final Either<String, Option<E>> decodeEither(JsonNode node) {
                    return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeOption$1(node, this.decodeJson$1);
                }
                {
                    this.decodeJson$1 = decodeJson$1;
                }
            });
        }).map((Function1 & Serializable)theMap -> theMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String featureName = (String)x0$1._1();
                Map versionsInfo = (Map)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)versionsInfo.map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        String label = (String)x0$2._1();
                        int version = x0$2._2$mcI$sp();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)label), (Object)BoxesRunTime.boxToShort((short)((short)version)));
                    }
                    throw new MatchError(null);
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).getOrElse((Function0 & Serializable)() -> (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$))));
    }

    /*
     * WARNING - void declaration
     */
    public BrokerInfo decode(int id, byte[] jsonBytes) {
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either instanceof Right) {
            .colon.colon colon2;
            JsonObject brokerInfo = ((JsonValue)((Right)either).value()).asJsonObject();
            int version = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            int jmxPort = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.JmxPortKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < 1) {
                throw new KafkaException(new StringBuilder(44).append("Unsupported version of broker registration: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            if (version == 1) {
                String host = brokerInfo.apply(this.HostKey()).to(DecodeJson$DecodeString$.MODULE$);
                int port = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.PortKey()).to(DecodeJson$DecodeInt$.MODULE$));
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                EndPoint endPoint = new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
                colon2 = new .colon.colon((Object)endPoint, (List)Nil$.MODULE$);
            } else {
                void decodeSeq_factory;
                HashMap hashMap;
                Option<JsonValue> option = brokerInfo.get(this.ListenerSecurityProtocolMapKey());
                if (None$.MODULE$.equals(option)) {
                    hashMap = SocketServerConfigs.DEFAULT_NAME_TO_SECURITY_PROTO;
                } else if (option instanceof Some) {
                    void decodeMap_factory;
                    JsonValue m = (JsonValue)((Some)option).value();
                    HashMap result = new HashMap();
                    Factory factory = scala.collection.Map$.MODULE$.mapFactory();
                    DecodeJson$DecodeString$ decodeMap_decodeJson = DecodeJson$DecodeString$.MODULE$;
                    Object var21_15 = null;
                    factory = null;
                    ((IterableOnceOps)m.to(new /* invalid duplicate definition of identical inner class */)).foreach((Function1 & Serializable)x0$1 -> {
                        if (x0$1 != null) {
                            String k = (String)x0$1._1();
                            String v = (String)x0$1._2();
                            return result.put(new ListenerName(k), SecurityProtocol.forName((String)v));
                        }
                        throw new MatchError(null);
                    });
                    hashMap = result;
                } else {
                    throw new MatchError(option);
                }
                HashMap securityProtocolMap = hashMap;
                Factory factory = Seq$.MODULE$.iterableFactory();
                DecodeJson$DecodeString$ decodeSeq_decodeJson = DecodeJson$DecodeString$.MODULE$;
                Object var23_18 = null;
                factory = null;
                String listenersString = ((IterableOnceOps)brokerInfo.apply(this.EndpointsKey()).to(new DecodeJson<S>(decodeSeq_decodeJson, (Factory)decodeSeq_factory){
                    private final DecodeJson decodeJson$2;
                    private final Factory factory$1;

                    public Object decode(JsonNode node) {
                        return DecodeJson.decode$(this, node);
                    }

                    public final Either<String, S> decodeEither(JsonNode node) {
                        return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeSeq$1(node, this.decodeJson$2, this.factory$1);
                    }
                    {
                        this.decodeJson$2 = decodeJson$2;
                        this.factory$1 = factory$1;
                    }
                })).mkString(",");
                colon2 = (Seq)CollectionConverters$.MODULE$.ListHasAsScala(SocketServerConfigs.listenerListToEndPoints((String)listenersString, (java.util.Map)securityProtocolMap)).asScala().map((Function1 & Serializable)x$4 -> EndPoint$.MODULE$.fromJava((Endpoint)x$4));
            }
            .colon.colon endpoints = colon2;
            Option rack = brokerInfo.get(this.RackKey()).flatMap((Function1 & Serializable)x$5 -> {
                DecodeJson$DecodeString$ decodeOption_decodeJson = DecodeJson$DecodeString$.MODULE$;
                Object var1_1 = null;
                return (Option)x$5.to(new /* invalid duplicate definition of identical inner class */);
            });
            java.util.Map<String, java.util.Map<String, Short>> features = this.featuresAsJavaMap(brokerInfo);
            scala.collection.immutable.Map tags = (scala.collection.immutable.Map)brokerInfo.get(this.TagsKey()).map((Function1 & Serializable)x$6 -> {
                Factory decodeMap_factory = scala.collection.immutable.Map$.MODULE$.mapFactory();
                DecodeJson$DecodeString$ decodeMap_decodeJson = DecodeJson$DecodeString$.MODULE$;
                Object var1_2 = null;
                Object var2_1 = null;
                return (scala.collection.immutable.Map)x$6.to(new /* invalid duplicate definition of identical inner class */);
            }).getOrElse((Function0 & Serializable)() -> scala.collection.immutable.Map$.MODULE$.empty());
            return new BrokerInfo(new Broker(id, (Seq<EndPoint>)endpoints, (Option<String>)rack, (Features<SupportedVersionRange>)Features.fromSupportedFeaturesMap(features), (scala.collection.immutable.Map<String, String>)tags), version, jmxPort);
        }
        if (either instanceof Left) {
            JsonProcessingException e = (JsonProcessingException)((Object)((Left)either).value());
            throw new KafkaException(new StringBuilder(52).append("Failed to parse ZooKeeper registration for broker ").append(id).append(": ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString(), (Throwable)e);
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ boolean $anonfun$encode$4(EndPoint x$2) {
        SecurityProtocol securityProtocol = x$2.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    private BrokerIdZNode$() {
    }
}

