/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import kafka.catalog.LocalStore;
import kafka.common.TenantHelpers;

public class InMemoryLocalStore
implements LocalStore {
    private final Map<String, MetadataEvent> topicToMetadataEvents = new ConcurrentHashMap<String, MetadataEvent>();
    private final Map<String, Set<String>> topicToConfigOverrides = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> logicalClusterToTopics = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, MetadataEvent> clusterLinkToMetadataEvents = new ConcurrentHashMap<String, MetadataEvent>();
    private final Map<String, Set<String>> logicalClusterToClusterLinks = new ConcurrentHashMap<String, Set<String>>();
    private final Set<String> allLogicalClusters = ConcurrentHashMap.newKeySet();

    @Override
    public void addTopicMetadataEvent(String logicalCluster, String topic, MetadataEvent metadataEvent) {
        this.addTopicMetadataEvent(logicalCluster, topic, metadataEvent, Collections.emptySet(), Collections.emptySet());
    }

    @Override
    public void addClusterLinkMetadataEvent(String logicalCluster, String clusterLink, MetadataEvent metadataEvent) {
        this.verifyEntityAndLogicalCluster(logicalCluster, clusterLink, EntityType.CLUSTER_LINK);
        this.clusterLinkToMetadataEvents.put(clusterLink, metadataEvent);
        this.logicalClusterToClusterLinks.computeIfAbsent(logicalCluster, k -> new TreeSet()).add(clusterLink);
        this.allLogicalClusters.add(logicalCluster);
    }

    @Override
    public void addTopicMetadataEvent(String logicalCluster, String topic, MetadataEvent metadataEvent, Set<String> topicConfigOverride, Set<String> topicConfigReset) {
        this.verifyEntityAndLogicalCluster(logicalCluster, topic, EntityType.TOPIC);
        this.topicToMetadataEvents.put(topic, metadataEvent);
        this.logicalClusterToTopics.computeIfAbsent(logicalCluster, k -> new TreeSet()).add(topic);
        this.allLogicalClusters.add(logicalCluster);
        if (topicConfigOverride != null && !topicConfigOverride.isEmpty()) {
            this.topicToConfigOverrides.computeIfAbsent(topic, k -> new HashSet()).addAll(topicConfigOverride);
        }
        if (topicConfigReset != null && !topicConfigReset.isEmpty()) {
            topicConfigReset.forEach(this.topicToConfigOverrides.get(topic)::remove);
        }
    }

    @Override
    public Set<String> topics(String logicalCluster) {
        return this.logicalClusterToTopics.getOrDefault(logicalCluster, Collections.emptySet());
    }

    @Override
    public Set<String> clusterLinks(String logicalCluster) {
        return this.logicalClusterToClusterLinks.getOrDefault(logicalCluster, Collections.emptySet());
    }

    @Override
    public Set<String> logicalClusters() {
        return this.allLogicalClusters;
    }

    @Override
    public MetadataEvent topicMetadataEvent(String topic) {
        return this.topicToMetadataEvents.get(topic);
    }

    @Override
    public MetadataEvent clusterLinkMetadataEvent(String clusterLink) {
        return this.clusterLinkToMetadataEvents.get(clusterLink);
    }

    @Override
    public Set<String> topicConfigOverrides(String topic) {
        Set<String> configOverride = this.topicToConfigOverrides.get(topic);
        if (configOverride != null) {
            return Collections.unmodifiableSet(configOverride);
        }
        return Collections.emptySet();
    }

    @Override
    public MetadataEvent removeTopicMetadataEvent(String logicalCluster, String topic) {
        this.verifyEntityAndLogicalCluster(logicalCluster, topic, EntityType.TOPIC);
        MetadataEvent toRemove = this.topicToMetadataEvents.remove(topic);
        if (toRemove != null) {
            this.logicalClusterToTopics.get(logicalCluster).remove(topic);
            if (this.logicalClusterToTopics.get(logicalCluster).isEmpty()) {
                this.logicalClusterToTopics.remove(logicalCluster);
                Set<String> remainingLkcsForClusterLinks = this.logicalClusterToClusterLinks.get(logicalCluster);
                if (remainingLkcsForClusterLinks == null || remainingLkcsForClusterLinks.isEmpty()) {
                    this.allLogicalClusters.remove(logicalCluster);
                }
            }
            this.topicToConfigOverrides.remove(topic);
        }
        return toRemove;
    }

    @Override
    public MetadataEvent removeClusterLinkMetadataEvent(String logicalCluster, String clusterLink) {
        this.verifyEntityAndLogicalCluster(logicalCluster, clusterLink, EntityType.CLUSTER_LINK);
        MetadataEvent toRemove = this.clusterLinkToMetadataEvents.remove(clusterLink);
        if (toRemove != null) {
            this.logicalClusterToClusterLinks.get(logicalCluster).remove(clusterLink);
            if (this.logicalClusterToClusterLinks.get(logicalCluster).isEmpty()) {
                this.logicalClusterToClusterLinks.remove(logicalCluster);
                Set<String> remainingLkcsForTopics = this.logicalClusterToTopics.get(logicalCluster);
                if (remainingLkcsForTopics == null || remainingLkcsForTopics.isEmpty()) {
                    this.allLogicalClusters.remove(logicalCluster);
                }
            }
        }
        return toRemove;
    }

    @Override
    public void clear() {
        this.topicToMetadataEvents.clear();
        this.topicToConfigOverrides.clear();
        this.logicalClusterToTopics.clear();
        this.clusterLinkToMetadataEvents.clear();
        this.logicalClusterToClusterLinks.clear();
        this.allLogicalClusters.clear();
    }

    @Override
    public int size() {
        return this.topicToMetadataEvents.size() + this.clusterLinkToMetadataEvents.size();
    }

    private void verifyEntityAndLogicalCluster(String logicalCluster, String entity, EntityType entityType) {
        if (!TenantHelpers.isTenantPrefixed(entity)) {
            throw new IllegalArgumentException(String.format("Provided %s %s does not have tenant prefix.", entityType.entityType(), entity));
        }
        if (!entity.startsWith(logicalCluster)) {
            throw new IllegalArgumentException(String.format("Provided %s %s doesn't belongs to logical cluster %s", entityType.entityType(), entity, logicalCluster));
        }
    }

    private static enum EntityType {
        TOPIC("topic"),
        CLUSTER_LINK("cluster link");

        private final String entityType;

        private EntityType(String entityType) {
            this.entityType = entityType;
        }

        private String entityType() {
            return this.entityType;
        }
    }
}

