/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.kafka.common.TopicPartition;

public class TenantHelpers {
    public static final Pattern TENANT_PREFIX_REGEX = Pattern.compile("^(lkc-[0-9a-z]+_).+");
    private static final char TENANT_PREFIX_DELIMITER = '_';
    public static final Function<String, String> NAME_TO_NULL_CALLBACK = name -> null;
    public static final Function<String, String> NAME_TO_TENANT_CALLBACK = name -> TenantHelpers.extractTenantPrefix(name);
    public static final Function<String, String> NAME_TO_TENANT_CALLBACK_NO_DELIMITER = name -> TenantHelpers.extractTenantPrefix(name, false);

    public static boolean isTenantPrefixed(String name) {
        return TENANT_PREFIX_REGEX.matcher(name).matches();
    }

    public static boolean isTenantPrefixed(TopicPartition topicPartition) {
        return TenantHelpers.isTenantPrefixed(topicPartition.topic());
    }

    public static String extractTenantPrefix(String name, boolean includeDelimiter) {
        if (!name.startsWith("lkc-")) {
            return null;
        }
        int delimIndex = name.indexOf(95);
        if (delimIndex == -1) {
            return null;
        }
        return includeDelimiter ? name.substring(0, delimIndex + 1) : name.substring(0, delimIndex);
    }

    public static String extractTenantPrefix(String name) {
        return TenantHelpers.extractTenantPrefix(name, true);
    }

    public static TopicPartition prefixWithTenant(String prefix, TopicPartition tp) {
        if (tp.topic().startsWith(prefix)) {
            return tp;
        }
        return new TopicPartition(prefix + tp.topic(), tp.partition());
    }

    public static String extractLogicalName(String name) {
        if (!name.startsWith("lkc-")) {
            return name;
        }
        int delimIndex = name.indexOf(95);
        if (delimIndex == -1) {
            return null;
        }
        return name.substring(delimIndex + 1);
    }
}

