/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.events;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.durability.events.serdes.BaseInfo;
import io.confluent.kafka.durability.events.serdes.HealthCheck;
import java.nio.ByteBuffer;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DurabilityEventType$;
import kafka.durability.events.HealthCheckEvent$;
import org.apache.kafka.common.TopicIdPartition;
import scala.Enumeration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001\u0002\f\u0018\u0001yA\u0011b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0018\t\u0013A\u0002!\u0011!Q\u0001\nE:\u0004\"\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u0019:\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011}\u0002!Q1A\u0005B\u0001C\u0011\"\u0011\u0001\u0003\u0002\u0003\u0006I!\r\"\t\u0011\r\u0003!Q1A\u0005\u0002\u0011C\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006\r\u0002!\ta\u0012\u0005\u0006!\u0002!\t%\u0015\u0005\u0006;\u0002!IA\u0018\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006S\u0002!\tE\u001b\u0005\u0006q\u0002!\t%_\u0004\u0006u^A\ta\u001f\u0004\u0006-]A\t\u0001 \u0005\u0007\rF!\t!!\u0001\t\u000f\u0005\r\u0011\u0003\"\u0001\u0002\u0006!9\u00111A\t\u0005\u0002\u0005]\u0001bBA\u0002#\u0011\u0005\u0011Q\u0005\u0002\u0011\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7.\u0012<f]RT!\u0001G\r\u0002\r\u00154XM\u001c;t\u0015\tQ2$\u0001\u0006ekJ\f'-\u001b7jifT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0004\u0005\u0002!C5\tq#\u0003\u0002#/\t9\u0012IY:ue\u0006\u001cG\u000fR;sC\nLG.\u001b;z\u000bZ,g\u000e^\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\"!J\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\r\r|W.\\8o\u0015\ta\u0012F\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018'\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0003\u0002$C\u00059a/\u001a:tS>t\u0007C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$aA%oi&\u0011\u0001'I\u0001\u0006KB|7\r[\u0005\u0003q\u0005\nQ\u0002[5hQ^\u000bG/\u001a:nCJ\\\u0007C\u0001\u001a=\u0013\ti4G\u0001\u0003M_:<\u0017A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r^\u0001\u0007]>$W-\u00133\u0016\u0003E\nqA\\8eK&#\u0007%\u0003\u0002@C\u0005IA/[7f'R\fW\u000e]\u000b\u0002w\u0005QA/[7f'R\fW\u000e\u001d\u0011\u0002\rqJg.\u001b;?)!A\u0015JS&M\u001b:{\u0005C\u0001\u0011\u0001\u0011\u0015\u0019#\u00021\u0001%\u0011\u0015\u0001$\u00021\u00012\u0011\u0015A$\u00021\u00012\u0011\u0015Q$\u00021\u0001<\u0011\u0015q$\u00021\u0001<\u0011\u0015y$\u00021\u00012\u0011\u0015\u0019%\u00021\u0001<\u0003)awnZ4fe:\u000bW.Z\u000b\u0002%B\u00111K\u0017\b\u0003)b\u0003\"!V\u001a\u000e\u0003YS!aV\u000f\u0002\rq\u0012xn\u001c;?\u0013\tI6'\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-4\u0003%\u0019XM]5bY&TX\rF\u0001`!\t\u0001W-D\u0001b\u0015\t\u00117-A\u0002oS>T\u0011\u0001Z\u0001\u0005U\u00064\u0018-\u0003\u0002gC\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\u001bA\f\u0017\u0010\\8bI\n+hMZ3s+\u0005y\u0016!C3wK:$H+\u001f9f+\u0005Y\u0007C\u00017v\u001d\ti7O\u0004\u0002oe:\u0011q.\u001d\b\u0003+BL\u0011\u0001H\u0005\u00035mI!\u0001G\r\n\u0005Q<\u0012a\u0005#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;UsB,\u0017B\u0001<x\u0005M!UO]1cS2LG/_#wK:$H+\u001f9f\u0015\t!x#\u0001\u0005u_N#(/\u001b8h)\u0005\u0011\u0016\u0001\u0005%fC2$\bn\u00115fG.,e/\u001a8u!\t\u0001\u0013c\u0005\u0002\u0012{B\u0011!G`\u0005\u0003\u007fN\u0012a!\u00118z%\u00164G#A>\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001f!\u000b9!a\u0003\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+Aa!!\u0003\u0014\u0001\u0004!\u0013AA5e\u0011\u0015\u00014\u00031\u00012\u0011\u0015A4\u00031\u00012\u0011\u0015Q4\u00031\u0001<\u0011\u0015q4\u00031\u0001<\u0011\u0015y4\u00031\u00012\u0011\u0015\u00195\u00031\u0001<)5A\u0015\u0011DA\u000e\u0003;\ty\"!\t\u0002$!1\u0011\u0011\u0002\u000bA\u0002\u0011BQ\u0001\u000f\u000bA\u0002EBQA\u000f\u000bA\u0002mBQA\u0010\u000bA\u0002mBQa\u0010\u000bA\u0002EBQa\u0011\u000bA\u0002m\"R\u0001SA\u0014\u0003SAa!!\u0003\u0016\u0001\u0004!\u0003bBA\u0016+\u0001\u0007\u0011QF\u0001\u0005I\u0006$\u0018\r\u0005\u0003\u00020\u0005\rSBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\rM,'\u000fZ3t\u0015\rA\u0012q\u0007\u0006\u00045\u0005e\"b\u0001\u000f\u0002<)!\u0011QHA \u0003%\u0019wN\u001c4mk\u0016tGO\u0003\u0002\u0002B\u0005\u0011\u0011n\\\u0005\u0005\u0003\u000b\n\tDA\u0006IK\u0006dG\u000f[\"iK\u000e\\\u0007")
public class HealthCheckEvent
extends AbstractDurabilityEvent {
    private final long highWatermark;
    private final long logStartOffset;
    private final long timeStamp;

    public static HealthCheckEvent apply(TopicIdPartition id, HealthCheck data) {
        return HealthCheckEvent$.MODULE$.apply(id, data);
    }

    public static HealthCheckEvent apply(TopicIdPartition id, int epoch, long highWatermark, long logStartOffset, int nodeId, long timeStamp) {
        return HealthCheckEvent$.MODULE$.apply(id, epoch, highWatermark, logStartOffset, nodeId, timeStamp);
    }

    public static HealthCheckEvent apply(TopicIdPartition id, int version, int epoch, long highWatermark, long logStartOffset, int nodeId, long timeStamp) {
        return new HealthCheckEvent(id, version, epoch, highWatermark, logStartOffset, nodeId, timeStamp);
    }

    @Override
    public int nodeId() {
        return super.nodeId();
    }

    public long timeStamp() {
        return this.timeStamp;
    }

    @Override
    public String loggerName() {
        return HealthCheckEvent.class.getName();
    }

    private ByteBuffer serialize() {
        FlatBufferBuilder builder = new FlatBufferBuilder(this.KEY_INITIAL_LENGTH()).forceDefaults(true);
        HealthCheck.startHealthCheck((FlatBufferBuilder)builder);
        HealthCheck.addNodeId((FlatBufferBuilder)builder, (int)this.nodeId());
        HealthCheck.addTimeStamp((FlatBufferBuilder)builder, (long)this.timeStamp());
        int info = BaseInfo.createBaseInfo((FlatBufferBuilder)builder, (int)super.version(), (int)super.epoch(), (long)this.highWatermark, (long)this.logStartOffset);
        HealthCheck.addInfo((FlatBufferBuilder)builder, (int)info);
        int entryId = HealthCheck.endHealthCheck((FlatBufferBuilder)builder);
        builder.finish(entryId);
        return HealthCheck.getRootAsHealthCheck((ByteBuffer)builder.dataBuffer()).getByteBuffer().duplicate();
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.serialize();
    }

    @Override
    public Enumeration.Value eventType() {
        return DurabilityEventType$.MODULE$.HealthCheckType();
    }

    public String toString() {
        return new StringBuilder(98).append("[TopicIdPartition: ").append(super.topicIdPartition()).append(", version: ").append(super.version()).append(", epoch: ").append(super.epoch()).append(", highWatermark: ").append(this.highWatermark).append(", ").append("logStartOffset: ").append(this.logStartOffset).append(", nodeId: ").append(this.nodeId()).append(", timeStamp: ").append(this.timeStamp()).append("]").toString();
    }

    public HealthCheckEvent(TopicIdPartition topicIdPartition, int version, int epoch, long highWatermark, long logStartOffset, int nodeId, long timeStamp) {
        this.highWatermark = highWatermark;
        this.logStartOffset = logStartOffset;
        this.timeStamp = timeStamp;
        super(topicIdPartition, epoch, nodeId, version);
    }
}

