/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import kafka.restore.MessageEmitter;
import kafka.restore.messages.ReconcileFtpsResponse;
import kafka.restore.messages.UploadFtpsToStoreRequest;
import kafka.restore.snapshot.FtpsStateForRestore;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;

public class SegmentsRepairedToFtpsReconciledTransition
extends AbstractTransition {
    public SegmentsRepairedToFtpsReconciledTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.SEGMENTS_REPAIRED;
    }

    @Override
    public State getTargetState() {
        return State.FTPS_RECONCILED;
    }

    @Override
    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        Object responseObject = event.getData("message_response");
        if (!(responseObject instanceof ReconcileFtpsResponse)) {
            return false;
        }
        ReconcileFtpsResponse response = (ReconcileFtpsResponse)event.getData("message_response");
        fsm.addMetadata("segment_count_reconciled", response.getSegmentCountReconciled());
        String ftpsFile = (String)fsm.getMetadata("ftps_file_path");
        LOGGER.debug(String.format("[%s-%d]: ftpsFile from META_FTPS_FILE_PATH = %s", response.getTopic(), response.getPartition(), ftpsFile));
        if (this.shouldRestoreFromFtpsSnapshot(fsm)) {
            FtpsStateForRestore ftpsForRestore = (FtpsStateForRestore)fsm.getMetadata("ftps_for_restore");
            ftpsFile = ftpsForRestore.updatedFtpsState.flushedPath();
            LOGGER.debug(String.format("[%s-%d]: ftpsFile from ftpsForRestore.updatedFtpsState = %s", response.getTopic(), response.getPartition(), ftpsFile));
        }
        UploadFtpsToStoreRequest request = new UploadFtpsToStoreRequest(0, response.getTopic(), response.getPartition(), ftpsFile);
        LOGGER.debug(String.format("[%s-%d]: %s handled the event, %s in queue", response.getTopic(), response.getPartition(), this.getName(), request.name()));
        this.messageEmitter.submitRequest(request);
        return true;
    }
}

