/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import kafka.api.LeaderAndIsr$;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedOperation;
import kafka.server.ZkAdminManager;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u000554Aa\u0003\u0007\u0001#!Aa\u0003\u0001B\u0001B\u0003%q\u0003\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0011!9\u0003A!A!\u0002\u0013A\u0003\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u000b5\u0003A\u0011\u0001(\t\u000bQ\u0003A\u0011I+\t\u000be\u0003A\u0011\t.\t\u000bm\u0003A\u0011\t.\t\u000bq\u0003A\u0011B/\t\u000b!\u0004A\u0011B5\u0003/\u0011+G.Y=fI\u000e\u0013X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001c(BA\u0007\u000f\u0003\u0019\u0019XM\u001d<fe*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005a\u0011BA\u000b\r\u0005A!U\r\\1zK\u0012|\u0005/\u001a:bi&|g.A\u0004eK2\f\u00170T:\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\t1{gnZ\u0001\u000fGJ,\u0017\r^3NKR\fG-\u0019;b!\ry\"\u0005J\u0007\u0002A)\u0011\u0011%G\u0001\u000bG>dG.Z2uS>t\u0017BA\u0012!\u0005\r\u0019V-\u001d\t\u0003'\u0015J!A\n\u0007\u00031\r\u0013X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001cX*\u001a;bI\u0006$\u0018-\u0001\u0007bI6Lg.T1oC\u001e,'\u000f\u0005\u0002\u0014S%\u0011!\u0006\u0004\u0002\u000f5.\fE-\\5o\u001b\u0006t\u0017mZ3s\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u0019[=R\u0015B\u0001\u0018\u001a\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003 aIj\u0014BA\u0019!\u0005\ri\u0015\r\u001d\t\u0003gir!\u0001\u000e\u001d\u0011\u0005UJR\"\u0001\u001c\u000b\u0005]\u0002\u0012A\u0002\u001fs_>$h(\u0003\u0002:3\u00051\u0001K]3eK\u001aL!a\u000f\u001f\u0003\rM#(/\u001b8h\u0015\tI\u0014\u0004\u0005\u0002?\u00116\tqH\u0003\u0002A\u0003\u0006A!/Z9vKN$8O\u0003\u0002C\u0007\u000611m\\7n_:T!a\u0004#\u000b\u0005\u00153\u0015AB1qC\u000eDWMC\u0001H\u0003\ry'oZ\u0005\u0003\u0013~\u0012\u0001\"\u00119j\u000bJ\u0014xN\u001d\t\u00031-K!\u0001T\r\u0003\tUs\u0017\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b=\u0003\u0016KU*\u0011\u0005M\u0001\u0001\"\u0002\f\u0006\u0001\u00049\u0002\"B\u000f\u0006\u0001\u0004q\u0002\"B\u0014\u0006\u0001\u0004A\u0003\"B\u0016\u0006\u0001\u0004a\u0013a\u0003;ss\u000e{W\u000e\u001d7fi\u0016$\u0012A\u0016\t\u00031]K!\u0001W\r\u0003\u000f\t{w\u000e\\3b]\u0006QqN\\\"p[BdW\r^3\u0015\u0003)\u000bAb\u001c8FqBL'/\u0019;j_:\f!#\\5tg&tw\rT3bI\u0016\u00148i\\;oiR\u0019a,Y2\u0011\u0005ay\u0016B\u00011\u001a\u0005\rIe\u000e\u001e\u0005\u0006E&\u0001\rAM\u0001\u0006i>\u0004\u0018n\u0019\u0005\u0006I&\u0001\r!Z\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bcA\u0010g=&\u0011q\r\t\u0002\u0004'\u0016$\u0018aD5t\u001b&\u001c8/\u001b8h\u0019\u0016\fG-\u001a:\u0015\u0007YS7\u000eC\u0003c\u0015\u0001\u0007!\u0007C\u0003m\u0015\u0001\u0007a,A\u0005qCJ$\u0018\u000e^5p]\u0002")
public class DelayedCreatePartitions
extends DelayedOperation {
    private final Seq<CreatePartitionsMetadata> createMetadata;
    private final ZkAdminManager adminManager;
    private final Function1<Map<String, ApiError>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Trying to complete operation for ").append($this.createMetadata).toString());
        int leaderlessPartitionCount = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.createMetadata.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedCreatePartitions.$anonfun$tryComplete$2(x$1)))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)DelayedCreatePartitions.$anonfun$tryComplete$3(this, BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
        if (leaderlessPartitionCount == 0) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "All partitions have a leader, completing the delayed operation");
            return this.forceComplete();
        }
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append(leaderlessPartitionCount).append(" partitions do not have a leader, not completing the delayed operation").toString());
        return false;
    }

    @Override
    public void onComplete() {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Completing operation for ").append($this.createMetadata).toString());
        scala.collection.immutable.Map results = ((IterableOnceOps)this.createMetadata.map((Function1 & Serializable)metadata -> {
            if (metadata.error().isSuccess() && this.missingLeaderCount(metadata.topic(), metadata.partitions()) > 0) {
                return new Tuple2((Object)metadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null));
            }
            return new Tuple2((Object)metadata.topic(), (Object)metadata.error());
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.responseCallback.apply((Object)results);
    }

    @Override
    public void onExpiration() {
    }

    private int missingLeaderCount(String topic, Set<Object> partitions) {
        return BoxesRunTime.unboxToInt((Object)partitions.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(x0$1, x1$1) -> {
            if (this.isMissingLeader(topic, x1$1)) {
                return x0$1 + 1;
            }
            return x0$1;
        }));
    }

    private boolean isMissingLeader(String topic, int partition) {
        return this.adminManager.metadataCache().getPartitionInfo(topic, partition).forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DelayedCreatePartitions.$anonfun$isMissingLeader$1(x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$2(CreatePartitionsMetadata x$1) {
        return x$1.error().isSuccess();
    }

    public static final /* synthetic */ int $anonfun$tryComplete$3(DelayedCreatePartitions $this, int x0$1, CreatePartitionsMetadata x1$1) {
        return x0$1 + $this.missingLeaderCount(x1$1.topic(), x1$1.partitions());
    }

    public static final /* synthetic */ boolean $anonfun$isMissingLeader$1(UpdateMetadataRequestData.UpdateMetadataPartitionState x$2) {
        return x$2.leader() == LeaderAndIsr$.MODULE$.NoLeader();
    }

    public DelayedCreatePartitions(long delayMs, Seq<CreatePartitionsMetadata> createMetadata, ZkAdminManager adminManager, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        this.createMetadata = createMetadata;
        this.adminManager = adminManager;
        this.responseCallback = responseCallback;
        super(delayMs, (Option<Lock>)None$.MODULE$);
    }
}

