/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kafka.server.FetchContext;
import kafka.server.FetchContext$;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.FetchSessionCache;
import kafka.server.FetchSessionCacheShard;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.PartitionFetchMetadata;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005e4A!\u0003\u0006\u0001\u001f!AA\u0004\u0001BC\u0002\u0013%Q\u0004\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003\u001f\u0011!Y\u0003A!b\u0001\n\u0013a\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u000bI\u0002A\u0011A\u001a\t\u000bI\u0002A\u0011A\u001c\t\u000by\u0002A\u0011A \t\u000by\u0003A\u0011B0\u0003\u0019\u0019+Go\u00195NC:\fw-\u001a:\u000b\u0005-a\u0011AB:feZ,'OC\u0001\u000e\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011qCG\u0007\u00021)\u0011\u0011\u0004D\u0001\u0006kRLGn]\u0005\u00037a\u0011q\u0001T8hO&tw-\u0001\u0003uS6,W#\u0001\u0010\u0011\u0005}AS\"\u0001\u0011\u000b\u0005e\t#B\u0001\u0012$\u0003\u0019\u0019w.\\7p]*\u0011Q\u0002\n\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014x-\u0003\u0002*A\t!A+[7f\u0003\u0015!\u0018.\\3!\u0003\u0015\u0019\u0017m\u00195f+\u0005i\u0003C\u0001\u00180\u001b\u0005Q\u0011B\u0001\u0019\u000b\u0005E1U\r^2i'\u0016\u001c8/[8o\u0007\u0006\u001c\u0007.Z\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\u0002\rqJg.\u001b;?)\r!TG\u000e\t\u0003]\u0001AQ\u0001H\u0003A\u0002yAQaK\u0003A\u00025\"2\u0001\u000e\u001d:\u0011\u0015ab\u00011\u0001\u001f\u0011\u0015Qd\u00011\u0001<\u0003)\u0019\u0017m\u00195f'\"\f'\u000f\u001a\t\u0003]qJ!!\u0010\u0006\u0003-\u0019+Go\u00195TKN\u001c\u0018n\u001c8DC\u000eDWm\u00155be\u0012\f!B\\3x\u0007>tG/\u001a=u)\u0015\u00015\t\u0013)V!\tq\u0013)\u0003\u0002C\u0015\taa)\u001a;dQ\u000e{g\u000e^3yi\")Ai\u0002a\u0001\u000b\u0006\u0019b-\u001a;dQJ+\u0017/^3tiZ+'o]5p]B\u0011\u0011CR\u0005\u0003\u000fJ\u0011Qa\u00155peRDQ!S\u0004A\u0002)\u000bABZ3uG\"\u0014V-];fgR\u0004\"a\u0013(\u000e\u00031S!!T\u0011\u0002\u000f5,7o]1hK&\u0011q\n\u0014\u0002\u0011\r\u0016$8\r\u001b*fcV,7\u000f\u001e#bi\u0006DQ!U\u0004A\u0002I\u000b!\"[:G_2dwn^3s!\t\t2+\u0003\u0002U%\t9!i\\8mK\u0006t\u0007\"\u0002,\b\u0001\u00049\u0016A\u0003;pa&\u001cg*Y7fgB\u0011\u0001l\u0017\b\u0003]eK!A\u0017\u0006\u0002\u0019\u0019+Go\u00195TKN\u001c\u0018n\u001c8\n\u0005qk&A\u0004+P!&\u001buLT!N\u000b~k\u0015\t\u0015\u0006\u00035*\tQ\u0003]1si&$\u0018n\u001c8t)>dunZ*ue&tw\r\u0006\u0002aWB\u0011\u0011\r\u001b\b\u0003E\u001a\u0004\"a\u0019\n\u000e\u0003\u0011T!!\u001a\b\u0002\rq\u0012xn\u001c;?\u0013\t9'#\u0001\u0004Qe\u0016$WMZ\u0005\u0003S*\u0014aa\u0015;sS:<'BA4\u0013\u0011\u0015a\u0007\u00021\u0001n\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0004]N,X\"A8\u000b\u0005A\f\u0018\u0001B;uS2T\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u_\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0005Y<X\"A\u0011\n\u0005a\f#\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0001")
public class FetchManager
implements Logging {
    private final Time time;
    private final FetchSessionCache cache;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchSessionCache cache() {
        return this.cache;
    }

    /*
     * WARNING - void declaration
     */
    public FetchContext newContext(short fetchRequestVersion, FetchRequestData fetchRequest, boolean isFollower, Map<Uuid, String> topicNames) {
        boolean fetchRequestUsesTopicIds;
        int sessionId = fetchRequest.sessionId();
        int sessionEpoch = fetchRequest.sessionEpoch();
        boolean bl = fetchRequestUsesTopicIds = fetchRequestVersion >= 13;
        if (sessionEpoch == 0 || sessionEpoch == -1) {
            FetchContext fetchContext;
            ObjectRef removedFetchSessionStr = ObjectRef.create((Object)"");
            if (sessionId != 0 && this.cache().getCacheShard(sessionId).remove(sessionId).isDefined()) {
                removedFetchSessionStr.elem = new StringBuilder(24).append(" Removed fetch session ").append(sessionId).append(".").toString();
            }
            Map<TopicIdPartition, PartitionFetchMetadata> fetchPartitions = FetchContext$.MODULE$.createFetchPartitions(fetchRequestUsesTopicIds, fetchRequest, topicNames);
            ObjectRef suffix = ObjectRef.create((Object)"");
            if (sessionEpoch == -1) {
                suffix.elem = " Will not try to create a new session.";
                fetchContext = new SessionlessFetchContext(fetchPartitions);
            } else {
                fetchContext = new FullFetchContext(this.time(), this.cache(), fetchPartitions, fetchRequestUsesTopicIds, isFollower);
            }
            FetchContext context = fetchContext;
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Created a new full FetchContext with ").append(this.partitionsToLogString(fetchPartitions.keySet())).append(".").append((String)removedFetchSessionStr$1.elem).append((String)suffix$1.elem).toString());
            return context;
        }
        FetchSessionCacheShard cacheShard = this.cache().getCacheShard(sessionId);
        synchronized (cacheShard) {
            SessionErrorContext sessionErrorContext;
            Option<FetchSession> option = cacheShard.get(sessionId);
            if (None$.MODULE$.equals(option)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Session error for ").append(sessionId).append(": no such session ID found.").toString());
                sessionErrorContext = new SessionErrorContext(Errors.FETCH_SESSION_ID_NOT_FOUND);
            } else if (option instanceof Some) {
                FetchSession session = (FetchSession)((Some)option).value();
                synchronized (session) {
                    FetchContext fetchContext;
                    if (session.epoch() != sessionEpoch) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Session error for ").append(sessionId).append(": expected epoch ").append(session.epoch()).append(", but got ").append(sessionEpoch).append(" instead.").toString());
                        fetchContext = new SessionErrorContext(Errors.INVALID_FETCH_SESSION_EPOCH);
                    } else if (session.usesTopicIds() && !fetchRequestUsesTopicIds || !session.usesTopicIds() && fetchRequestUsesTopicIds) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Session error for ").append(sessionId).append(": expected  ").append((Object)(session.usesTopicIds() ? "to use topic IDs" : "to not use topic IDs")).append(", but request version ").append(fetchRequestVersion).append(" means that we can not.").toString());
                        fetchContext = new SessionErrorContext(Errors.FETCH_SESSION_TOPIC_ID_ERROR);
                    } else {
                        void var20_18;
                        Tuple3<ArrayList<TopicIdPartition>, ArrayList<TopicIdPartition>, ArrayList<TopicIdPartition>> tuple3 = session.update(fetchRequestUsesTopicIds, fetchRequest, topicNames);
                        if (tuple3 == null) {
                            throw new MatchError(null);
                        }
                        ArrayList added = (ArrayList)tuple3._1();
                        ArrayList updated = (ArrayList)tuple3._2();
                        ArrayList removed = (ArrayList)tuple3._3();
                        if (session.isEmpty()) {
                            this.debug((Function0<String>)((Function0 & Serializable)() -> FetchManager.$anonfun$newContext$5(this, session, (ArrayList)var20_18)));
                            cacheShard.remove(session);
                            Map<TopicIdPartition, PartitionFetchMetadata> fetchData = FetchContext$.MODULE$.createFetchPartitions(fetchRequestUsesTopicIds, fetchRequest, topicNames);
                            fetchContext = new SessionlessFetchContext(fetchData);
                        } else {
                            void var19_17;
                            void var18_16;
                            cacheShard.touch(session, this.time().milliseconds());
                            session.epoch_$eq(FetchMetadata.nextEpoch((int)session.epoch()));
                            this.debug((Function0<String>)((Function0 & Serializable)() -> FetchManager.$anonfun$newContext$6(this, session, (ArrayList)var18_16, (ArrayList)var19_17, (ArrayList)var20_18)));
                            fetchContext = new IncrementalFetchContext(this.time(), sessionEpoch, session, topicNames);
                        }
                    }
                    SessionErrorContext sessionErrorContext2 = fetchContext;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 14, 15] lbl56 : MonitorExitStatement: MONITOREXIT : session
                    sessionErrorContext = sessionErrorContext2;
                }
            } else {
                throw new MatchError(option);
            }
            SessionErrorContext sessionErrorContext3 = sessionErrorContext;
            return sessionErrorContext3;
        }
    }

    private String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchSession$.MODULE$.partitionsToLogString(partitions, this.isTraceEnabled());
    }

    public static final /* synthetic */ String $anonfun$newContext$5(FetchManager $this, FetchSession session$2, ArrayList removed$2) {
        return new StringBuilder(123).append("Created a new sessionless FetchContext and closing session id ").append(session$2.id()).append(", ").append("epoch ").append(session$2.epoch()).append(": after removing ").append($this.partitionsToLogString(removed$2)).append(", ").append("there are no more partitions left.").toString();
    }

    public static final /* synthetic */ String $anonfun$newContext$6(FetchManager $this, FetchSession session$2, ArrayList added$2, ArrayList updated$2, ArrayList removed$2) {
        return new StringBuilder(90).append("Created a new incremental FetchContext for session id ").append(session$2.id()).append(", ").append("epoch ").append(session$2.epoch()).append(": added ").append($this.partitionsToLogString(added$2)).append(", ").append("updated ").append($this.partitionsToLogString(updated$2)).append(", ").append("removed ").append($this.partitionsToLogString(removed$2)).toString();
    }

    public FetchManager(Time time, FetchSessionCache cache) {
        this.time = time;
        this.cache = cache;
    }

    public FetchManager(Time time, FetchSessionCacheShard cacheShard) {
        this(time, new FetchSessionCache((Seq<FetchSessionCacheShard>)new .colon.colon((Object)cacheShard, (List)Nil$.MODULE$)));
    }
}

