/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.k2.kafka.K2MetadataStore;
import io.confluent.k2.kafka.K2Stack;
import io.confluent.k2.kafka.K2TopicMetadata;
import java.io.Serializable;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import kafka.server.metadata.K2MetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.ConfluentPartitionsPerTopicListener;
import org.apache.kafka.server.util.KafkaScheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0005\u00055e\u0001\u0002\f\u0018\u0001qA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u000by\u0003A\u0011A0\t\u000b!\u0004A\u0011K5\t\u000fU\u0004!\u0019!C\u0005m\"1a\u0010\u0001Q\u0001\n]D\u0001b \u0001A\u0002\u0013%\u0011\u0011\u0001\u0005\n\u0003[\u0001\u0001\u0019!C\u0005\u0003_A\u0001\"!\b\u0001A\u0003&\u00111\u0001\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011!\tI\u0005\u0001C\u0001/\u0005\u001d\u0003bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\ty\u0007\u0001C\u0005\u0003cBq!! \u0001\t\u0013\ty\bC\u0004\u0002\u0006\u0002!\t!a\u0012\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\nA2JM'fi\u0006$\u0017\r^1DC\u000eDW\rU8qk2\fGo\u001c:\u000b\u0005aI\u0012AB:feZ,'OC\u0001\u001b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u000f$!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fMB\u0011AeJ\u0007\u0002K)\u0011a%G\u0001\u0006kRLGn]\u0005\u0003Q\u0015\u0012q\u0001T8hO&tw-\u0001\blC\u001a\\\u0017mU2iK\u0012,H.\u001a:\u0011\u0005-\"T\"\u0001\u0017\u000b\u00055r\u0013\u0001B;uS2T!\u0001G\u0018\u000b\u0005i\u0001$BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001eL!!\u000e\u0017\u0003\u001d-\u000bgm[1TG\",G-\u001e7fe\u0006)1\u000f^1dWB\u0011\u0001\bQ\u0007\u0002s)\u0011!D\u000f\u0006\u0003wq\n!a\u001b\u001a\u000b\u0005ur\u0014!C2p]\u001adW/\u001a8u\u0015\u0005y\u0014AA5p\u0013\t\t\u0015HA\u0004LeM#\u0018mY6\u0002\u001f-\u0014T.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\"\u0001R$\u000e\u0003\u0015S!AR\f\u0002\u00115,G/\u00193bi\u0006L!\u0001S#\u0003\u001f-\u0013T*\u001a;bI\u0006$\u0018mQ1dQ\u0016\f1C]3ge\u0016\u001c\b\u000eU3sS>$W*\u001b7mSN\u0004\"AH&\n\u00051{\"\u0001\u0002'p]\u001e\fA\u0001^5nKB\u0011qjU\u0007\u0002!*\u0011a%\u0015\u0006\u0003%>\naaY8n[>t\u0017B\u0001+Q\u0005\u0011!\u0016.\\3\u0002G\r|gN\u001a7vK:$\b+\u0019:uSRLwN\\:QKJ$v\u000e]5d\u0019&\u001cH/\u001a8feB\u0019adV-\n\u0005a{\"AB(qi&|g\u000e\u0005\u0002[96\t1L\u0003\u0002G_%\u0011Ql\u0017\u0002$\u0007>tg\r\\;f]R\u0004\u0016M\u001d;ji&|gn\u001d)feR{\u0007/[2MSN$XM\\3s\u0003\u0019a\u0014N\\5u}Q9\u0001MY2eK\u001a<\u0007CA1\u0001\u001b\u00059\u0002\"B\u0015\b\u0001\u0004Q\u0003\"\u0002\u001c\b\u0001\u00049\u0004\"\u0002\"\b\u0001\u0004\u0019\u0005\"B%\b\u0001\u0004Q\u0005\"B'\b\u0001\u0004q\u0005\"B+\b\u0001\u00041\u0016A\u00037pO\u001e,'OT1nKV\t!\u000e\u0005\u0002le:\u0011A\u000e\u001d\t\u0003[~i\u0011A\u001c\u0006\u0003_n\ta\u0001\u0010:p_Rt\u0014BA9 \u0003\u0019\u0001&/\u001a3fM&\u00111\u000f\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E|\u0012a\u0005;pa&\u001c'+\u001a4sKNDG+[7f_V$X#A<\u0011\u0005adX\"A=\u000b\u00055S(\"A>\u0002\t)\fg/Y\u0005\u0003{f\u0014\u0001\u0002R;sCRLwN\\\u0001\u0015i>\u0004\u0018n\u0019*fMJ,7\u000f\u001b+j[\u0016|W\u000f\u001e\u0011\u00029-\u0014T*\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0006\u000fZ1uKJ4U\u000f^;sKV\u0011\u00111\u0001\t\u0005=]\u000b)\u0001\r\u0003\u0002\b\u0005e\u0001CBA\u0005\u0003#\t)\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003[iLA!a\u0005\u0002\f\ty1k\u00195fIVdW\r\u001a$viV\u0014X\r\u0005\u0003\u0002\u0018\u0005eA\u0002\u0001\u0003\f\u00037i\u0011\u0011!A\u0001\u0006\u0003\tyBA\u0002`IE\nQd\u001b\u001aNKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z+qI\u0006$XM\u001d$viV\u0014X\rI\t\u0005\u0003C\t9\u0003E\u0002\u001f\u0003GI1!!\n \u0005\u001dqu\u000e\u001e5j]\u001e\u00042AHA\u0015\u0013\r\tYc\b\u0002\u0004\u0003:L\u0018\u0001I63\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3Va\u0012\fG/\u001a:GkR,(/Z0%KF$B!!\r\u00028A\u0019a$a\r\n\u0007\u0005UrD\u0001\u0003V]&$\b\"CA\u001d\u0019\u0005\u0005\t\u0019AA\u001e\u0003\rAH%\r\t\u0005=]\u000bi\u0004\r\u0003\u0002@\u0005\r\u0003CBA\u0005\u0003#\t\t\u0005\u0005\u0003\u0002\u0018\u0005\rC\u0001DA\u000e\u0003o\t\t\u0011!A\u0003\u0002\u0005}\u0011aB:uCJ$X\u000f\u001d\u000b\u0003\u0003c\tq\u0003Z8Q_B,H.\u0019;f\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002KQ\u0014\u0018M\\:ji&|g.\u00113eSRLwN\\1m!\u0006\u0014H/\u001b;j_:\u001c%/Z1uS>tGCBA\u0019\u0003\u001f\n\u0019\u0006\u0003\u0004\u0002RA\u0001\rAS\u0001\fgR\f'\u000f^'jY2L7\u000fC\u0004\u0002VA\u0001\r!a\u0016\u0002/A\f'\u000f^5uS>t7I]3bi&|g\u000eV8qS\u000e\u001c\bCBA-\u00037\ny&\u0004\u0002\u0002\u0010%!\u0011QLA\b\u0005\u0011a\u0015n\u001d;\u0011\u0007a\n\t'C\u0002\u0002de\u0012qb\u0013\u001aU_BL7-T3uC\u0012\fG/Y\u0001\"iJ\fgn]5uS>tGk\u001c9jG\u0012+G.\u001a;j_:|%o\u0011:fCRLwN\u001c\u000b\u0007\u0003c\tI'a\u001b\t\r\u0005E\u0013\u00031\u0001K\u0011\u001d\ti'\u0005a\u0001\u0003/\n\u0001\u0004Z3mKRLgnZ(s\u0007J,\u0017\r^5oOR{\u0007/[2t\u0003m\u0019\b\u000f\\5u\u001f:d\u0017N\\3B]\u0012$&/\u00198tSRLwN\\5oOR!\u00111OA=!\u001dq\u0012QOA,\u0003/J1!a\u001e \u0005\u0019!V\u000f\u001d7fe!9\u00111\u0010\nA\u0002\u0005]\u0013!C1mYR{\u0007/[2t\u0003I\u0019X\r^;q\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0015\t\u0005E\u0012\u0011\u0011\u0005\b\u0003\u0007\u001b\u0002\u0019AA,\u0003Yyg\u000e\\5oK>\u00138I]3bi&tw\rV8qS\u000e\u001c\u0018!B2m_N,\u0017aL7bs\n,7+\u001a8e\rVdG.\u00169eCR,Gk\u001c)beRLG/[8ogB+'\u000fV8qS\u000ed\u0015n\u001d;f]\u0016\u0014H\u0003BA\u0019\u0003\u0017Cq!a!\u0016\u0001\u0004\t9\u0006")
public class K2MetadataCachePopulator
implements Logging {
    private final KafkaScheduler kafkaScheduler;
    private final K2Stack stack;
    private final K2MetadataCache k2metadataCache;
    private final long refreshPeriodMillis;
    private final Time time;
    private final Option<ConfluentPartitionsPerTopicListener> confluentPartitionsPerTopicListener;
    private final Duration topicRefreshTimeout;
    private Option<ScheduledFuture<?>> k2MetadataCacheUpdaterFuture;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return this.getClass().getName();
    }

    private Duration topicRefreshTimeout() {
        return this.topicRefreshTimeout;
    }

    private Option<ScheduledFuture<?>> k2MetadataCacheUpdaterFuture() {
        return this.k2MetadataCacheUpdaterFuture;
    }

    private void k2MetadataCacheUpdaterFuture_$eq(Option<ScheduledFuture<?>> x$1) {
        this.k2MetadataCacheUpdaterFuture = x$1;
    }

    public void startup() {
        this.k2MetadataCacheUpdaterFuture_$eq((Option<ScheduledFuture<?>>)new Some((Object)this.kafkaScheduler.schedule("k2metadatacacheupdater", () -> this.doPopulateMetadataCache(), 0L, this.refreshPeriodMillis)));
    }

    /*
     * WARNING - void declaration
     */
    public void doPopulateMetadataCache() {
        long startMillis = this.time.milliseconds();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Querying topic metadata store for all topics for K2 metadata cache update");
        try {
            void var6_5;
            void var5_4;
            List allTopics = (List)this.stack.topicMetadata().listTopics(K2MetadataStore.Filter.NONE).block(Duration.ofMillis(this.refreshPeriodMillis));
            Tuple2<List<K2TopicMetadata>, List<K2TopicMetadata>> tuple2 = this.splitOnlineAndTransitioning(allTopics);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            List onlineOrCreatingTopics = (List)tuple2._1();
            List deletingOrCreatingTopics = (List)tuple2._2();
            this.setupMetadataCache((List<K2TopicMetadata>)var5_4);
            this.transitionTopicDeletionOrCreation(startMillis, (List<K2TopicMetadata>)var6_5);
            this.transitionAdditionalPartitionCreation(startMillis, (List<K2TopicMetadata>)var5_4);
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Error refreshing partition assignments", (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    private void transitionAdditionalPartitionCreation(long startMillis, List<K2TopicMetadata> partitionCreationTopics) {
        Object object = new Object();
        try {
            Collections.shuffle(partitionCreationTopics);
            CollectionConverters$.MODULE$.ListHasAsScala(partitionCreationTopics).asScala().foreach((Function1 & Serializable)topic -> {
                K2MetadataCachePopulator.$anonfun$transitionAdditionalPartitionCreation$1(this, startMillis, object, topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private void transitionTopicDeletionOrCreation(long startMillis, List<K2TopicMetadata> deletingOrCreatingTopics) {
        Object object = new Object();
        try {
            Collections.shuffle(deletingOrCreatingTopics);
            CollectionConverters$.MODULE$.ListHasAsScala(deletingOrCreatingTopics).asScala().foreach((Function1 & Serializable)topic -> {
                K2MetadataCachePopulator.$anonfun$transitionTopicDeletionOrCreation$1(this, startMillis, object, topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private Tuple2<List<K2TopicMetadata>, List<K2TopicMetadata>> splitOnlineAndTransitioning(List<K2TopicMetadata> allTopics) {
        ArrayList onlineOrCreatingTopics = new ArrayList();
        ArrayList deletingOrCreatingTopics = new ArrayList();
        IntRef numCreatingTopics = IntRef.create((int)0);
        allTopics.forEach(topic -> {
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState = topic.k2TopicLifecycleState();
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2 = K2TopicMetadata.K2TopicLifecycleState.DELETING;
            if (!(k2TopicLifecycleState != null ? !k2TopicLifecycleState.equals(k2TopicLifecycleState2) : k2TopicLifecycleState2 != null)) {
                deletingOrCreatingTopics.add(topic);
                return;
            }
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState3 = topic.k2TopicLifecycleState();
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState4 = K2TopicMetadata.K2TopicLifecycleState.CREATING;
            if (!(k2TopicLifecycleState3 != null ? !k2TopicLifecycleState3.equals(k2TopicLifecycleState4) : k2TopicLifecycleState4 != null)) {
                deletingOrCreatingTopics.add(topic);
                onlineOrCreatingTopics.add(topic);
                ++numCreatingTopics$1.elem;
                return;
            }
            onlineOrCreatingTopics.add(topic);
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(138).append("Updating K2 metadata cache with all online/creating topics from queried topics with size = ").append(onlineOrCreatingTopics.size()).append(", of which ").append(numCreatingTopics$1.elem).append(" are in the process of being created").toString());
        if (onlineOrCreatingTopics.size() < 20) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Updating K2 metadata cache with online/creating topics ").append(onlineOrCreatingTopics).toString());
        } else {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Updating K2 metadata cache with online/creating topics ").append(onlineOrCreatingTopics).toString());
        }
        return new Tuple2(onlineOrCreatingTopics, deletingOrCreatingTopics);
    }

    private void setupMetadataCache(List<K2TopicMetadata> onlineOrCreatingTopics) {
        try {
            Map assignment = (Map)this.stack.partitionMapper().assignments(onlineOrCreatingTopics).block(this.topicRefreshTimeout());
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Generated partition mappings: ").append(assignment).toString());
            this.k2metadataCache.setTopicsAndAssignments(onlineOrCreatingTopics, assignment);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Updated K2 metadata cache with ").append($this.k2metadataCache.topicIdsToNames().size()).append(" online/creating topics plus assignments").toString());
            this.maybeSendFullUpdateToPartitionsPerTopicListener(onlineOrCreatingTopics);
            return;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Error updating topic assignments", (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
            return;
        }
    }

    public void close() {
        this.k2MetadataCacheUpdaterFuture().foreach((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.cancel(true)));
    }

    private void maybeSendFullUpdateToPartitionsPerTopicListener(List<K2TopicMetadata> onlineOrCreatingTopics) {
        this.confluentPartitionsPerTopicListener.foreach((Function1 & Serializable)listener -> {
            K2MetadataCachePopulator.$anonfun$maybeSendFullUpdateToPartitionsPerTopicListener$1(this, onlineOrCreatingTopics, listener);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$transitionAdditionalPartitionCreation$1(K2MetadataCachePopulator $this, long startMillis$1, Object nonLocalReturnKey1$1, K2TopicMetadata topic) {
        block7: {
            block10: {
                block8: {
                    K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState;
                    K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2;
                    block9: {
                        if ($this.time.milliseconds() - startMillis$1 >= $this.refreshPeriodMillis) break block7;
                        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState3 = topic.k2TopicLifecycleState();
                        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState4 = K2TopicMetadata.K2TopicLifecycleState.ONLINE;
                        if (!(k2TopicLifecycleState3 == null ? k2TopicLifecycleState4 != null : !k2TopicLifecycleState3.equals(k2TopicLifecycleState4))) break block8;
                        k2TopicLifecycleState2 = topic.k2TopicLifecycleState();
                        k2TopicLifecycleState = K2TopicMetadata.K2TopicLifecycleState.CREATING;
                        if (k2TopicLifecycleState2 != null) break block9;
                        if (k2TopicLifecycleState != null) {
                            return;
                        }
                        break block8;
                    }
                    if (!k2TopicLifecycleState2.equals(k2TopicLifecycleState)) break block10;
                }
                if (topic.numPartitions() < topic.lastExpandedToPartitionCount()) {
                    try {
                        Boolean finishedPartitionCreation = (Boolean)$this.stack.k2ControllerHandler().tryToFinishAdditionalPartitionCreation(topic.topicId(), topic.lastExpandedToPartitionCount()).block(Duration.ofMillis($this.refreshPeriodMillis));
                        if (!Predef$.MODULE$.Boolean2boolean(finishedPartitionCreation)) {
                            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(119).append("Unsuccessfully created additional partitions for ").append(topic.topicName()).append(" with id=").append(topic.topicId()).append(", ").append("old partition count is ").append(topic.numPartitions()).append(", ").append("requested new partition count is ").append(topic.lastExpandedToPartitionCount()).append(".").toString());
                            return;
                        }
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(107).append("Successfully created additional partitions for ").append(topic.topicName()).append(" with id=").append(topic.topicId()).append(", ").append("old partition count is ").append(topic.numPartitions()).append(", ").append("new partition count is ").append(topic.lastExpandedToPartitionCount()).append(".").toString());
                    }
                    catch (Throwable t) {
                        $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(128).append("Couldn't finish creating additional partitions for topic: ").append(topic.topicName()).append(" with id=").append(topic.topicId()).append(", ").append("old partition count is ").append(topic.numPartitions()).append(", ").append("requested new partition count is ").append(topic.lastExpandedToPartitionCount()).append(".").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                        throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                    }
                    return;
                }
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$transitionTopicDeletionOrCreation$1(K2MetadataCachePopulator $this, long startMillis$2, Object nonLocalReturnKey2$1, K2TopicMetadata topic) {
        if ($this.time.milliseconds() - startMillis$2 < $this.refreshPeriodMillis) {
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState = topic.k2TopicLifecycleState();
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2 = K2TopicMetadata.K2TopicLifecycleState.CREATING;
            if (!(k2TopicLifecycleState != null ? !k2TopicLifecycleState.equals(k2TopicLifecycleState2) : k2TopicLifecycleState2 != null)) {
                try {
                    Boolean finishedCreating = (Boolean)$this.stack.k2ControllerHandler().tryToFinishTopicCreation(topic.topicId(), Math.max(topic.numPartitions(), topic.lastExpandedToPartitionCount())).block(Duration.ofMillis($this.refreshPeriodMillis));
                    if (!Predef$.MODULE$.Boolean2boolean(finishedCreating)) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Unsuccessful moving topic ").append(topic.topicName()).append(" with id=").append(topic.topicId()).append(" online").toString());
                        return;
                    }
                    $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Successfully moved topic ").append(topic.topicName()).append(" with id=").append(topic.topicId()).append(" online").toString());
                }
                catch (Throwable t) {
                    $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Couldn't finish creating topic ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
                }
                return;
            }
            try {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Trying to finish deletion of topic ").append(topic).toString());
                Boolean finishedDeleting = (Boolean)$this.stack.k2ControllerHandler().tryToFinishTopicDeletion(topic.topicId(), Math.max(topic.numPartitions(), topic.lastExpandedToPartitionCount())).block(Duration.ofMillis($this.refreshPeriodMillis));
                if (!Predef$.MODULE$.Boolean2boolean(finishedDeleting)) {
                    $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Unsuccessful finishing deletion of topic ").append(topic).append(" (probably due to a conflict)").toString());
                    return;
                }
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Successfully finished deletion of topic ").append(topic).toString());
            }
            catch (Throwable t) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Couldn't finish deleting topic ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeSendFullUpdateToPartitionsPerTopicListener$1(K2MetadataCachePopulator $this, List onlineOrCreatingTopics$2, ConfluentPartitionsPerTopicListener listener) {
        Iterator topicNamesAndNumberOfPartitionsIterator = onlineOrCreatingTopics$2.stream().map(tm -> new AbstractMap.SimpleEntry<String, Integer>(tm.topicName(), Predef$.MODULE$.int2Integer(tm.numPartitions()))).iterator();
        listener.fullUpdate(topicNamesAndNumberOfPartitionsIterator, Collections.emptyMap(), Collections.emptySet());
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("Sent full update to PartitionsPerTopicListener for ").append($this.k2metadataCache.topicIdsToNames().size()).append(" online/creating topics").toString());
    }

    public K2MetadataCachePopulator(KafkaScheduler kafkaScheduler, K2Stack stack, K2MetadataCache k2metadataCache, long refreshPeriodMillis, Time time, Option<ConfluentPartitionsPerTopicListener> confluentPartitionsPerTopicListener) {
        this.kafkaScheduler = kafkaScheduler;
        this.stack = stack;
        this.k2metadataCache = k2metadataCache;
        this.refreshPeriodMillis = refreshPeriodMillis;
        this.time = time;
        this.confluentPartitionsPerTopicListener = confluentPartitionsPerTopicListener;
        this.topicRefreshTimeout = Duration.ofMillis(60000L);
        this.k2MetadataCacheUpdaterFuture = None$.MODULE$;
    }
}

