/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import kafka.server.ClusterLinkQuotas;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkBatchingAdmin;
import kafka.server.link.ClusterLinkCheckAvailabilityTaskType$;
import kafka.server.link.ClusterLinkCheckLinkAvailability;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNonBatchingAdmin;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTaskManager;
import kafka.server.link.LazyResource;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskType;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tmg!\u0002\u001e<\u0003\u0003\u0011\u0005\u0002C,\u0001\u0005\u000b\u0007I\u0011\u0001-\t\u0011q\u0003!\u0011!Q\u0001\neC\u0001\"\u0018\u0001\u0003\u0006\u0004%\tA\u0018\u0005\tK\u0002\u0011\t\u0011)A\u0005?\"Aa\r\u0001BC\u0002\u0013\u0005q\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003i\u0011!a\u0007A!b\u0001\n\u0003i\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u00028\t\u0011I\u0004!Q1A\u0005\u0002MD\u0001\" \u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\t}\u0002\u0011\t\u0011)A\u0005\u007f\"Q\u00111\u0002\u0001\u0003\u0002\u0004%I!!\u0004\t\u0015\u0005=\u0001A!a\u0001\n\u0013\t\t\u0002C\u0005\u0002\u001e\u0001\u0011\t\u0011)Q\u0005o\"Q\u0011q\u0005\u0001\u0003\u0002\u0003\u0006I!!\u000b\t\u0015\u0005\u0005\u0003A!A!\u0002\u0013\t\u0019\u0005C\u0004\u0002L\u0001!\t!!\u0014\t\u0017\u0005\r\u0004\u00011AA\u0002\u0013%\u0011Q\r\u0005\f\u0003[\u0002\u0001\u0019!a\u0001\n\u0013\ty\u0007C\u0006\u0002t\u0001\u0001\r\u0011!Q!\n\u0005\u001d\u0004\"CA<\u0001\t\u0007I\u0011AA=\u0011!\t\t\t\u0001Q\u0001\n\u0005m\u0004\"CAB\u0001\t\u0007I\u0011AAC\u0011!\ti\t\u0001Q\u0001\n\u0005\u001d\u0005\"CAH\u0001\u0001\u0007I\u0011BAI\u0011%\tY\n\u0001a\u0001\n\u0013\ti\n\u0003\u0005\u0002\"\u0002\u0001\u000b\u0015BAJ\u0011%\t\u0019\u000b\u0001b\u0001\n\u0013\t)\u000b\u0003\u0005\u0002H\u0002\u0001\u000b\u0011BAT\u0011-\t9\u000e\u0001a\u0001\u0002\u0004%I!!7\t\u0017\u0005e\b\u00011AA\u0002\u0013%\u00111 \u0005\f\u0003o\u0004\u0001\u0019!A!B\u0013\tY\u000eC\u0005\u0003\b\u0001\u0011\r\u0011\"\u0005\u0003\n!A!q\u0003\u0001!\u0002\u0013\u0011Y\u0001C\u0004\u0003\u001a\u0001!\tAa\u0007\t\u000f\tu\u0001\u0001\"\u0003\u0003\u001c!9!q\u0004\u0001\u0007\u0012\tm\u0001b\u0002B\u0011\u0001\u0019E!1\u0004\u0005\b\u0005G\u0001A\u0011\u0001B\u000e\u0011\u001d\u0011)\u0003\u0001C\u0005\u0005OAqAa\u0011\u0001\r#\u0011)\u0005C\u0004\u0003J\u00011\tBa\u0007\t\u000f\t-\u0003\u0001\"\u0005\u0003N!A!1\u000e\u0001\u0005\u0002m\u0012i\u0007C\u0004\u0003\u0000\u0001!IA!!\t\u0011\t\r\u0005\u0001\"\u0001<\u0005\u0003CqA!\"\u0001\t\u0003\u00119\tC\u0004\u0003\u0018\u0002!IAa\u0007\t\u000f\te\u0005\u0001\"\u0003\u0003\u001c!9!1\u0014\u0001\u0005\u0002\tu\u0005b\u0002BS\u0001\u0011\u0005#q\u0015\u0005\t\u0005S\u0003A\u0011I\u001e\u0003,\"9!\u0011\u0017\u0001\u0005\u0002\u00055\u0001b\u0002BZ\u0001\u0011\u0005#Q\u0017\u0005\b\u0005\u0003\u0004a\u0011\u0003Bb\u0011\u001d\u00119\r\u0001C!\u0005\u0013DqA!7\u0001\t\u0013\u0011YB\u0001\u0011BEN$(/Y2u\u00072,8\u000f^3s\u0019&t7n\u00117jK:$X*\u00198bO\u0016\u0014(B\u0001\u001f>\u0003\u0011a\u0017N\\6\u000b\u0005yz\u0014AB:feZ,'OC\u0001A\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\"J#B\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n1\u0011I\\=SK\u001a\u0004\"A\u0013(\u000f\u0005-cU\"A\u001e\n\u00055[\u0014AE\"mkN$XM\u001d'j].4\u0015m\u0019;pefL!a\u0014)\u0003\u001b\rc\u0017.\u001a8u\u001b\u0006t\u0017mZ3s\u0015\ti5\b\u0005\u0002S+6\t1K\u0003\u0002U\u007f\u0005)Q\u000f^5mg&\u0011ak\u0015\u0002\b\u0019><w-\u001b8h\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0016\u0003e\u0003\"a\u0013.\n\u0005m[$AE\"mkN$XM\u001d'j].l\u0015M\\1hKJ\f1c\u00197vgR,'\u000fT5oW6\u000bg.Y4fe\u0002\n\u0001\u0002\\5oW\u0012\u000bG/Y\u000b\u0002?B\u0011\u0001mY\u0007\u0002C*\u0011!mP\u0001\u0003u.L!\u0001Z1\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0011\u0002\\5oW\u0012\u000bG/\u0019\u0011\u0002\u00171Lgn['fiJL7m]\u000b\u0002QB\u00111*[\u0005\u0003Un\u0012!c\u00117vgR,'\u000fT5oW6+GO]5dg\u0006aA.\u001b8l\u001b\u0016$(/[2tA\u0005YA/Y:l\u001b\u0006t\u0017mZ3s+\u0005q\u0007CA&p\u0013\t\u00018H\u0001\fDYV\u001cH/\u001a:MS:\\G+Y:l\u001b\u0006t\u0017mZ3s\u00031!\u0018m]6NC:\fw-\u001a:!\u0003I\u0011X-\\8uK\u0006#W.\u001b8GC\u000e$xN]=\u0016\u0003Q\u0004B\u0001R;xu&\u0011a/\u0012\u0002\n\rVt7\r^5p]F\u0002\"a\u0013=\n\u0005e\\$!E\"mkN$XM\u001d'j].\u001cuN\u001c4jOB\u00111j_\u0005\u0003yn\u0012ac\u00117vgR,'\u000fT5oW\u0006#W.\u001b8DY&,g\u000e^\u0001\u0014e\u0016lw\u000e^3BI6LgNR1di>\u0014\u0018\u0010I\u0001\u0012Y>\u001c\u0017\r\\!e[&tg)Y2u_JL\b#\u0002#\u0002\u0002\u0005\u0015\u0011bAA\u0002\u000b\nIa)\u001e8di&|g\u000e\r\t\u0004\u0017\u0006\u001d\u0011bAA\u0005w\t)2\t\\;ti\u0016\u0014H*\u001b8l\u0019>\u001c\u0017\r\\!e[&t\u0017A\u00037j].\u001cuN\u001c4jOV\tq/\u0001\bmS:\\7i\u001c8gS\u001e|F%Z9\u0015\t\u0005M\u0011\u0011\u0004\t\u0004\t\u0006U\u0011bAA\f\u000b\n!QK\\5u\u0011!\tY\"DA\u0001\u0002\u00049\u0018a\u0001=%c\u0005YA.\u001b8l\u0007>tg-[4!Q\rq\u0011\u0011\u0005\t\u0004\t\u0006\r\u0012bAA\u0013\u000b\nAao\u001c7bi&dW-\u0001\u0003uS6,\u0007\u0003BA\u0016\u0003{i!!!\f\u000b\u0007Q\u000byC\u0003\u0003\u00022\u0005M\u0012AB2p[6|gNC\u0002A\u0003kQA!a\u000e\u0002:\u00051\u0011\r]1dQ\u0016T!!a\u000f\u0002\u0007=\u0014x-\u0003\u0003\u0002@\u00055\"\u0001\u0002+j[\u0016\fa!];pi\u0006\u001c\b\u0003BA#\u0003\u000fj\u0011!P\u0005\u0004\u0003\u0013j$!E\"mkN$XM\u001d'j].\fVo\u001c;bg\u00061A(\u001b8jiz\"B#a\u0014\u0002R\u0005M\u0013QKA,\u00033\nY&!\u0018\u0002`\u0005\u0005\u0004CA&\u0001\u0011\u00159\u0016\u00031\u0001Z\u0011\u0015i\u0016\u00031\u0001`\u0011\u00151\u0017\u00031\u0001i\u0011\u0015a\u0017\u00031\u0001o\u0011\u0015\u0011\u0018\u00031\u0001u\u0011\u0015q\u0018\u00031\u0001\u0000\u0011\u0019\tY!\u0005a\u0001o\"9\u0011qE\tA\u0002\u0005%\u0002bBA!#\u0001\u0007\u00111I\u0001\u0006C\u0012l\u0017N\\\u000b\u0003\u0003O\u0002B\u0001RA5u&\u0019\u00111N#\u0003\r=\u0003H/[8o\u0003%\tG-\\5o?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005E\u0004\"CA\u000e'\u0005\u0005\t\u0019AA4\u0003\u0019\tG-\\5oA!\u001aA#!\t\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA>!\rY\u0015QP\u0005\u0004\u0003\u007fZ$\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\n\u0001C]3n_R,')\u0019;dQ\u0006#W.\u001b8\u0016\u0005\u0005\u001d\u0005cA&\u0002\n&\u0019\u00111R\u001e\u0003+\rcWo\u001d;fe2Kgn\u001b\"bi\u000eD\u0017\tZ7j]\u0006\t\"/Z7pi\u0016\u0014\u0015\r^2i\u0003\u0012l\u0017N\u001c\u0011\u00029\rdWo\u001d;fe2Kgn[\"iK\u000e\\\u0017I^1jY\u0006\u0014\u0017\u000e\\5usV\u0011\u00111\u0013\t\u0006\t\u0006%\u0014Q\u0013\t\u0004\u0017\u0006]\u0015bAAMw\t\u00013\t\\;ti\u0016\u0014H*\u001b8l\u0007\",7m\u001b'j].\fe/Y5mC\nLG.\u001b;z\u0003\u0001\u001aG.^:uKJd\u0015N\\6DQ\u0016\u001c7.\u0011<bS2\f'-\u001b7jif|F%Z9\u0015\t\u0005M\u0011q\u0014\u0005\n\u00037Q\u0012\u0011!a\u0001\u0003'\u000bQd\u00197vgR,'\u000fT5oW\u000eCWmY6Bm\u0006LG.\u00192jY&$\u0018\u0010I\u0001\u000eY\u0006T\u0018PU3t_V\u00148-Z:\u0016\u0005\u0005\u001d\u0006CBAU\u0003g\u000b9,\u0004\u0002\u0002,*!\u0011QVAX\u0003\u001diW\u000f^1cY\u0016T1!!-F\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003k\u000bYK\u0001\u0004Ck\u001a4WM\u001d\u0019\u0005\u0003s\u000b\u0019\rE\u0003L\u0003w\u000by,C\u0002\u0002>n\u0012A\u0002T1{sJ+7o\\;sG\u0016\u0004B!!1\u0002D2\u0001AaCAc;\u0005\u0005\t\u0011!B\u0001\u0003\u0013\u00141a\u0018\u00132\u00039a\u0017M_=SKN|WO]2fg\u0002\nB!a3\u0002RB\u0019A)!4\n\u0007\u0005=WIA\u0004O_RD\u0017N\\4\u0011\u0007\u0011\u000b\u0019.C\u0002\u0002V\u0016\u00131!\u00118z\u0003aa\u0017M_=SKN|WO]2f%\u0016\f\u0007/\u001a:GkR,(/Z\u000b\u0003\u00037\u0004D!!8\u0002tB1\u0011q\\Aw\u0003cl!!!9\u000b\t\u0005\r\u0018Q]\u0001\u000bG>t7-\u001e:sK:$(\u0002BAt\u0003S\fA!\u001e;jY*\u0011\u00111^\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002p\u0006\u0005(aD*dQ\u0016$W\u000f\\3e\rV$XO]3\u0011\t\u0005\u0005\u00171\u001f\u0003\f\u0003k\u0004\u0013\u0011!A\u0001\u0006\u0003\tIMA\u0002`II\n\u0011\u0004\\1{sJ+7o\\;sG\u0016\u0014V-\u00199fe\u001a+H/\u001e:fA\u0005aB.\u0019>z%\u0016\u001cx.\u001e:dKJ+\u0017\r]3s\rV$XO]3`I\u0015\fH\u0003BA\n\u0003{D\u0011\"a\u0007 \u0003\u0003\u0005\r!a@1\t\t\u0005!Q\u0001\t\u0007\u0003?\fiOa\u0001\u0011\t\u0005\u0005'Q\u0001\u0003\r\u0003k\fi0!A\u0001\u0002\u000b\u0005\u0011\u0011Z\u0001\u0005Y>\u001c7.\u0006\u0002\u0003\fA!!Q\u0002B\n\u001b\t\u0011yA\u0003\u0003\u0003\u0012\u0005%\u0018\u0001\u00027b]\u001eLAA!\u0006\u0003\u0010\t1qJ\u00196fGR\fQ\u0001\\8dW\u0002\nqa\u001d;beR,\b\u000f\u0006\u0002\u0002\u0014\u0005\u00112\u000f^1siV\u0004\u0018i\u0019;jm\u0016$\u0016m]6t\u0003q\u0019H/\u0019:ukB\fE\rZ5uS>t\u0017\r\\!di&4X\rV1tWN\fae\u001d;beR,\b/\u00113eSRLwN\\1m\u0003\u000e$\u0018N^3Pe&s\u0017m\u0019;jm\u0016$\u0016m]6t\u0003!\u0019\b.\u001e;e_^t\u0017aE:ikR$wn\u001e8BGRLg/\u001a+bg.\u001cH\u0003BA\n\u0005SAqAa\u000b)\u0001\u0004\u0011i#\u0001\u0004sK\u0006\u001cxN\u001c\t\u0005\u0005_\u0011iD\u0004\u0003\u00032\te\u0002c\u0001B\u001a\u000b6\u0011!Q\u0007\u0006\u0004\u0005o\t\u0015A\u0002\u001fs_>$h(C\u0002\u0003<\u0015\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B \u0005\u0003\u0012aa\u0015;sS:<'b\u0001B\u001e\u000b\u0006i2\u000f[;uI><h.\u00113eSRLwN\\1m\u0003\u000e$\u0018N^3UCN\\7\u000f\u0006\u0003\u0002\u0014\t\u001d\u0003b\u0002B\u0016S\u0001\u0007!QF\u0001(g\",H\u000fZ8x]\u0006#G-\u001b;j_:\fG.Q2uSZ,wJ]%oC\u000e$\u0018N^3UCN\\7/\u0001\u0007tG\",G-\u001e7f)\u0006\u001c8\u000e\u0006\u0004\u0002\u0014\t=#\u0011\f\u0005\b\u0005#Z\u0003\u0019\u0001B*\u0003!!\u0018m]6UsB,\u0007cA&\u0003V%\u0019!qK\u001e\u0003\u0011Q\u000b7o\u001b+za\u0016DqAa\u0017,\u0001\u0004\u0011i&\u0001\u0003uCN\\\u0007\u0003\u0002B0\u0005Kr1a\u0013B1\u0013\r\u0011\u0019gO\u0001\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\t\t\u001d$\u0011\u000e\u0002\r!\u0016\u0014\u0018n\u001c3jGR\u000b7o\u001b\u0006\u0004\u0005GZ\u0014a\u0003:fG>tg-[4ve\u0016$b!a\u0005\u0003p\tM\u0004B\u0002B9Y\u0001\u0007q/A\u0005oK^\u001cuN\u001c4jO\"9!Q\u000f\u0017A\u0002\t]\u0014aC;qI\u0006$X\rZ&fsN\u0004bA!\u001f\u0003|\t5RBAAX\u0013\u0011\u0011i(a,\u0003\u0007M+G/A\u000edYV\u001cH/\u001a:MS:\\\u0017\tZ7j]>\u0013X\t_2faRLwN\\\u000b\u0002u\u0006Ys-\u001a;DYV\u001cH/\u001a:MS:\\\u0017\tZ7j]\u001a{'O\u0011:pW\u0016\u0014(+Z9vKN$\b*\u00198eY&tw-\u0001\u0014hKR\u0014V-\\8uK\u0006#W.\u001b8G_J\u0014%o\\6feJ+\u0017/^3ti\"\u000bg\u000e\u001a7j]\u001e,\"A!#\u0011\t\t-%1S\u0007\u0003\u0005\u001bSA!a\u0019\u0003\u0010*!!\u0011SA\u001a\u0003\u001d\u0019G.[3oiNLAA!&\u0003\u000e\nq1i\u001c8gYV,g\u000e^!e[&t\u0017!E2sK\u0006$X-\u00118e'\u0016$\u0018\tZ7j]\u0006Q1\r\\8tK\u0006#W.\u001b8\u0002\u0011%\u001c\u0018i\u0019;jm\u0016$\"Aa(\u0011\u0007\u0011\u0013\t+C\u0002\u0003$\u0016\u0013qAQ8pY\u0016\fg.A\fjg\u0006\u001bG/\u001b<f\u0019&t7nQ8pe\u0012Lg.\u0019;peV\u0011!qT\u0001\u0015_:\fe/Y5mC\nLG.\u001b;z\u0007\"\fgnZ3\u0015\t\u0005M!Q\u0016\u0005\b\u0005_#\u0004\u0019\u0001BP\u0003-I7/\u0011<bS2\f'\r\\3\u0002\u001b\r,(O]3oi\u000e{gNZ5h\u0003=!\u0018m]6EKN\u001c'/\u001b9uS>tG\u0003\u0002B\\\u0005\u007f\u0003R\u0001RA5\u0005s\u00032a\u0013B^\u0013\r\u0011il\u000f\u0002\u0010)\u0006\u001c8\u000eR3tGJL\u0007\u000f^5p]\"9!\u0011\u000b\u001cA\u0002\tM\u0013\u0001\t;bg.$Um]2sSB$\u0018n\u001c8G_J\fE\rZ5uS>t\u0017\r\u001c+bg.$BAa.\u0003F\"9!\u0011K\u001cA\u0002\tM\u0013\u0001\u0006:fO&\u001cH/\u001a:MCjL(+Z:pkJ\u001cW\r\u0006\u0003\u0002\u0014\t-\u0007b\u0002Bgq\u0001\u0007!qZ\u0001\rY\u0006T\u0018PU3t_V\u00148-\u001a\u0019\u0005\u0005#\u0014)\u000eE\u0003L\u0003w\u0013\u0019\u000e\u0005\u0003\u0002B\nUG\u0001\u0004Bl\u0005\u0017\f\t\u0011!A\u0003\u0002\u0005%'aA0%g\u0005)2\u000f[;uI><h.\u00133mKJ+7o\\;sG\u0016\u001c\b")
public abstract class AbstractClusterLinkClientManager
implements ClusterLinkFactory.ClientManager,
Logging {
    private final ClusterLinkManager clusterLinkManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkMetrics linkMetrics;
    private final ClusterLinkTaskManager taskManager;
    private final Function1<ClusterLinkConfig, ClusterLinkAdminClient> remoteAdminFactory;
    private volatile ClusterLinkConfig linkConfig;
    private final Time time;
    private final ClusterLinkQuotas quotas;
    private volatile Option<ClusterLinkAdminClient> admin;
    private final ClusterLinkScheduler scheduler;
    private final ClusterLinkBatchAdmin remoteBatchAdmin;
    private Option<ClusterLinkCheckLinkAvailability> clusterLinkCheckAvailability;
    private final Buffer<LazyResource<?>> lazyResources;
    private ScheduledFuture<?> lazyResourceReaperFuture;
    private final Object lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkMetrics linkMetrics() {
        return this.linkMetrics;
    }

    @Override
    public ClusterLinkTaskManager taskManager() {
        return this.taskManager;
    }

    public Function1<ClusterLinkConfig, ClusterLinkAdminClient> remoteAdminFactory() {
        return this.remoteAdminFactory;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private void linkConfig_$eq(ClusterLinkConfig x$1) {
        this.linkConfig = x$1;
    }

    private Option<ClusterLinkAdminClient> admin() {
        return this.admin;
    }

    private void admin_$eq(Option<ClusterLinkAdminClient> x$1) {
        this.admin = x$1;
    }

    @Override
    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public ClusterLinkBatchAdmin remoteBatchAdmin() {
        return this.remoteBatchAdmin;
    }

    private Option<ClusterLinkCheckLinkAvailability> clusterLinkCheckAvailability() {
        return this.clusterLinkCheckAvailability;
    }

    private void clusterLinkCheckAvailability_$eq(Option<ClusterLinkCheckLinkAvailability> x$1) {
        this.clusterLinkCheckAvailability = x$1;
    }

    private Buffer<LazyResource<?>> lazyResources() {
        return this.lazyResources;
    }

    private ScheduledFuture<?> lazyResourceReaperFuture() {
        return this.lazyResourceReaperFuture;
    }

    private void lazyResourceReaperFuture_$eq(ScheduledFuture<?> x$1) {
        this.lazyResourceReaperFuture = x$1;
    }

    public Object lock() {
        return this.lock;
    }

    @Override
    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Starting ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).toString());
        if (this.isActive()) {
            this.createAndSetAdmin();
            this.startupActiveTasks();
        } else {
            this.admin_$eq((Option<ClusterLinkAdminClient>)None$.MODULE$);
        }
        this.startupAdditionalActiveOrInactiveTasks();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Startup of ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void startupActiveTasks() {
        this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckLinkAvailability>)new Some((Object)new ClusterLinkCheckLinkAvailability((Function0<ClusterLinkConfig>)(Function0 & Serializable)() -> this.currentConfig(), this.linkMetrics(), this.clusterLinkManager(), Predef$.MODULE$.Integer2int(this.currentConfig().availabilityCheckMs()), this.scheduler(), this.linkData(), this.remoteBatchAdmin(), this.taskManager().localBatchAdmin(), this.time, this.quotas.requestQuotaAdapter(this.linkData()))));
        this.scheduleTask(ClusterLinkCheckAvailabilityTaskType$.MODULE$, (ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckAvailability().get());
        this.startupAdditionalActiveTasks();
        this.lazyResourceReaperFuture_$eq(this.scheduler().schedule("ShutdownIdleResources", () -> this.shutdownIdleResources(), this.currentConfig().clientsMaxIdleMs(), this.currentConfig().clientsMaxIdleMs()));
    }

    public abstract void startupAdditionalActiveTasks();

    public abstract void startupAdditionalActiveOrInactiveTasks();

    @Override
    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Shutting down ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).toString());
        this.taskManager().clusterLinkPeriodicTasks().shutdownTasks(this.linkData().linkId(), "client manager shutdown", this.taskManager().clusterLinkPeriodicTasks().shutdownTasks$default$3());
        this.shutdownAdditionalActiveOrInactiveTasks();
        if (this.isActive()) {
            this.shutdownActiveTasks("client manager shutdown");
            this.closeAdmin();
            this.admin_$eq(null);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Shutdown of ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void shutdownActiveTasks(String reason) {
        this.clusterLinkCheckAvailability().foreach((Function1 & Serializable)task -> {
            AbstractClusterLinkClientManager.$anonfun$shutdownActiveTasks$1(this, reason, task);
            return BoxedUnit.UNIT;
        });
        this.clusterLinkCheckAvailability().foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckLinkAvailability>)None$.MODULE$);
        this.shutdownAdditionalActiveTasks(reason);
        Option$.MODULE$.apply(this.lazyResourceReaperFuture()).foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.cancel(true)));
        this.lazyResourceReaperFuture_$eq(null);
    }

    public abstract void shutdownAdditionalActiveTasks(String var1);

    public abstract void shutdownAdditionalActiveOrInactiveTasks();

    public void scheduleTask(TaskType taskType, ClusterLinkScheduler.PeriodicTask task) {
        this.taskManager().clusterLinkPeriodicTasks().addTask(taskType, this.linkData(), task);
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        Object object = this.lock();
        synchronized (object) {
            boolean oldActive = this.isActive();
            this.linkConfig_$eq(newConfig);
            boolean newActive = this.isActive();
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Reconfiguring ").append(this.getClass().getSimpleName()).append(". oldActive=").append(oldActive).append(" and newActive=").append(newActive).toString());
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(oldActive, newActive);
            if (oldActive || newActive) {
                if (!oldActive && newActive) {
                    this.createAndSetAdmin();
                    this.startupActiveTasks();
                } else if (oldActive && !newActive) {
                    this.shutdownActiveTasks("link paused");
                    this.closeAdmin();
                    this.admin_$eq((Option<ClusterLinkAdminClient>)None$.MODULE$);
                } else if (oldActive && newActive) {
                    if (updatedKeys.diff(ClusterLinkConfig$.MODULE$.ReplicationProps()).nonEmpty()) {
                        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Reconfiguring AdminClient and restarting tasks for ").append(this.getClass().getSimpleName()).toString());
                        this.createAndSetAdmin();
                        this.shutdownActiveTasks("link reconfiguration");
                        this.startupActiveTasks();
                    }
                } else {
                    throw new MatchError((Object)sp2);
                }
            }
            return;
        }
    }

    private ClusterLinkAdminClient clusterLinkAdminOrException() {
        Option<ClusterLinkAdminClient> currentAdmin = this.admin();
        if (currentAdmin == null) {
            throw new IllegalStateException(new StringBuilder(37).append("Client manager for cluster link data ").append(this.linkData()).toString());
        }
        return (ClusterLinkAdminClient)currentAdmin.getOrElse((Function0 & Serializable)() -> {
            throw new ClusterLinkPausedException(new StringBuilder(27).append("Cluster link for ").append(this.linkData().linkName()).append(" is paused").toString());
        });
    }

    public ClusterLinkAdminClient getClusterLinkAdminForBrokerRequestHandling() {
        return this.clusterLinkAdminOrException();
    }

    public ConfluentAdmin getRemoteAdminForBrokerRequestHandling() {
        return this.clusterLinkAdminOrException().admin();
    }

    private void createAndSetAdmin() {
        this.closeAdmin();
        this.admin_$eq((Option<ClusterLinkAdminClient>)new Some(this.remoteAdminFactory().apply((Object)this.linkConfig())));
    }

    private void closeAdmin() {
        Option<ClusterLinkAdminClient> curAdmin = this.admin();
        if (curAdmin != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.remoteBatchAdmin().closeRequests(), this, Level.WARN);
            curAdmin.foreach((Function1 & Serializable)a -> {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> a.close(), this, Level.WARN);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public boolean isActive() {
        return !Predef$.MODULE$.Boolean2boolean(this.linkConfig().clusterLinkPaused());
    }

    @Override
    public boolean isActiveLinkCoordinator() {
        return this.isActive() && this.clusterLinkManager().metadataManager().isLinkCoordinator(this.linkData().linkName());
    }

    @Override
    public void onAvailabilityChange(boolean isAvailable) {
        Object object = this.lock();
        synchronized (object) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Processing link availability change to ").append(isAvailable).toString());
            this.shutdownActiveTasks("link unavailable");
            if (!Predef$.MODULE$.Boolean2boolean(this.linkConfig().clusterLinkPaused())) {
                if (isAvailable) {
                    this.startupActiveTasks();
                } else {
                    int intervalMs = Math.max(10, Math.min((int)Predef$.MODULE$.Long2long(this.linkConfig().reconnectBackoffMaxMs()), Predef$.MODULE$.Integer2int(this.linkConfig().availabilityCheckMs())));
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(105).append("Link is unavailable, starting availability checks with periodic interval ").append(intervalMs).append(" ms until link becomes available").toString());
                    this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckLinkAvailability>)new Some((Object)new ClusterLinkCheckLinkAvailability((Function0<ClusterLinkConfig>)(Function0 & Serializable)() -> this.linkConfig(), this.linkMetrics(), this.clusterLinkManager(), intervalMs, this.scheduler(), this.linkData(), this.remoteBatchAdmin(), this.taskManager().localBatchAdmin(), this.time, this.quotas.requestQuotaAdapter(this.linkData()))));
                    ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckAvailability().get()).startup();
                }
            }
            return;
        }
    }

    @Override
    public ClusterLinkConfig currentConfig() {
        return this.linkConfig();
    }

    @Override
    public Option<TaskDescription> taskDescription(TaskType taskType) {
        if (ClusterLinkCheckAvailabilityTaskType$.MODULE$.equals(taskType)) {
            return this.clusterLinkCheckAvailability().flatMap((Function1 & Serializable)x$5 -> x$5.taskDescription());
        }
        return this.taskDescriptionForAdditionalTask(taskType);
    }

    public abstract Option<TaskDescription> taskDescriptionForAdditionalTask(TaskType var1);

    @Override
    public void registerLazyResource(LazyResource<?> lazyResource) {
        this.lazyResources().$plus$eq(lazyResource);
    }

    private void shutdownIdleResources() {
        this.lazyResources().foreach((Function1 & Serializable)x$6 -> {
            x$6.closeIdleResource();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$shutdownActiveTasks$1(AbstractClusterLinkClientManager $this, String reason$1, ClusterLinkCheckLinkAvailability task) {
        $this.taskManager().clusterLinkPeriodicTasks().shutdownTasks($this.linkData().linkId(), reason$1, (Set<ClusterLinkScheduler.PeriodicTask>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkScheduler.PeriodicTask[]{task}))));
    }

    /*
     * WARNING - void declaration
     */
    public AbstractClusterLinkClientManager(ClusterLinkManager clusterLinkManager, ClusterLinkData linkData, ClusterLinkMetrics linkMetrics, ClusterLinkTaskManager taskManager, Function1<ClusterLinkConfig, ClusterLinkAdminClient> remoteAdminFactory, Function0<ClusterLinkLocalAdmin> localAdminFactory, ClusterLinkConfig linkConfig, Time time, ClusterLinkQuotas quotas) {
        ClusterLinkBatchAdmin clusterLinkBatchAdmin;
        this.clusterLinkManager = clusterLinkManager;
        this.linkData = linkData;
        this.linkMetrics = linkMetrics;
        this.taskManager = taskManager;
        this.remoteAdminFactory = remoteAdminFactory;
        this.linkConfig = linkConfig;
        this.time = time;
        this.quotas = quotas;
        this.scheduler = taskManager.scheduler();
        Function0 & Serializable intersect = (Function0 & Serializable)() -> this.linkMetrics().remoteAdminRequestTimeSensor();
        Function0 & Serializable intersect2 = (Function0 & Serializable)() -> this.linkMetrics().remoteAdminQueueTimeSensor();
        ClusterLinkScheduler clusterLinkScheduler = this.scheduler();
        JFunction0.mcI.sp & Serializable intersect3 = (JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int(this.clusterLinkManager().brokerConfig().clusterLinkAdminMaxInFlightRequests());
        JFunction0.mcI.sp & Serializable intersect4 = (JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int(this.clusterLinkManager().brokerConfig().clusterLinkAdminRequestBatchSize());
        Function0 & Serializable apply_admin = (Function0 & Serializable)() -> this.clusterLinkAdminOrException().admin();
        if (Predef$.MODULE$.Integer2int(this.clusterLinkManager().brokerConfig().clusterLinkAdminRequestBatchSize()) <= 1) {
            clusterLinkBatchAdmin = new ClusterLinkNonBatchingAdmin((Function0<ConfluentAdmin>)apply_admin);
        } else {
            void apply_requestTimeSensor;
            void apply_queueTimeSensor;
            void apply_maxInFlight;
            void apply_adminBatchSize;
            void apply_scheduler;
            if (apply_scheduler == null) {
                throw new IllegalArgumentException("Scheduler must be provided for batching admin");
            }
            clusterLinkBatchAdmin = new ClusterLinkBatchingAdmin((Function0<ConfluentAdmin>)apply_admin, (Function0<Object>)apply_adminBatchSize, (Function0<Object>)apply_maxInFlight, (ClusterLinkScheduler)apply_scheduler, time, (Function0<Sensor>)apply_queueTimeSensor, (Function0<Sensor>)apply_requestTimeSensor);
        }
        Object var10_15 = null;
        intersect4 = null;
        intersect3 = null;
        clusterLinkScheduler = null;
        intersect2 = null;
        intersect = null;
        this.remoteBatchAdmin = clusterLinkBatchAdmin;
        this.clusterLinkCheckAvailability = None$.MODULE$;
        this.lazyResources = (Buffer)Buffer$.MODULE$.empty();
        this.lock = new Object();
    }
}

