/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import kafka.server.link.AuthenticationErrorUnavailableLinkReason;
import kafka.server.link.BootstrapTcpConnectionFailedUnavailableLinkReason;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionCheckerResult;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.InvalidBootstrapInternalEndpointUnavailableLinkReason;
import kafka.server.link.LinkType;
import kafka.server.link.LinkType$Cloud$;
import kafka.server.link.TimeoutUnavailableLinkReason;
import kafka.server.link.UnavailableLinkReason;
import kafka.server.link.UnknownUnavailableLinkReason;
import kafka.server.link.UnresolvableBootstrapUnavailableLinkReason;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkConnectionChecker$
implements Logging {
    public static final ClusterLinkConnectionChecker$ MODULE$ = new ClusterLinkConnectionChecker$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Option<ClusterLinkConnectionCheckerResult> check(DescribeClusterResult describeClusterResult, ClusterLinkConfig config, Option<ClusterLinkFactory.LinkMetrics> linkMetrics, boolean connectionToRemoteCluster, Function0<Object> intranetConnectivityDeniedChecker, Option<String> tenantPrefix) {
        try {
            describeClusterResult.clusterId().get();
            return Option$.MODULE$.empty();
        }
        catch (Throwable ex) {
            Object var12_24;
            Object var11_23;
            List list;
            Option option;
            ApiException apiException;
            block15: {
                List list2;
                apiException = ClusterLinkUtils$.MODULE$.apiException(ex, "Basic describeCluster check failed");
                if (this.logger().underlying().isWarnEnabled()) {
                    String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$check$1(ex, apiException);
                    Object var20_9 = null;
                    this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                if (apiException instanceof AuthenticationException) {
                    return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, new AuthenticationErrorUnavailableLinkReason(config)));
                }
                if (apiException instanceof AuthorizationException) {
                    return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, new InvalidBootstrapInternalEndpointUnavailableLinkReason(config)));
                }
                List<String> checkBasicNetworking_checkAddresses_bootstrapServers = config.bootstrapServersToConnect(intranetConnectivityDeniedChecker);
                String checkBasicNetworking_checkAddresses_dnsLookupConfig = config.getString("client.dns.lookup");
                ClientDnsLookup checkBasicNetworking_checkAddresses_dnsLookup = checkBasicNetworking_checkAddresses_dnsLookupConfig == null ? ClientDnsLookup.USE_ALL_DNS_IPS : ClientDnsLookup.forConfig((String)checkBasicNetworking_checkAddresses_dnsLookupConfig);
                ArrayList checkBasicNetworking_checkAddresses_invalidAddresses = new ArrayList();
                try {
                    list2 = ClientUtils.parseAndValidateAddresses(checkBasicNetworking_checkAddresses_bootstrapServers, (ClientDnsLookup)checkBasicNetworking_checkAddresses_dnsLookup);
                }
                catch (ConfigException checkBasicNetworking_checkAddresses_ex) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkAddresses$1(checkBasicNetworking_checkAddresses_ex);
                        Object var21_16 = null;
                        this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                    }
                    option = Option$.MODULE$.apply((Object)new UnresolvableBootstrapUnavailableLinkReason(config));
                    list = null;
                    break block15;
                }
                catch (Throwable checkBasicNetworking_checkAddresses_ex) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkAddresses$2(checkBasicNetworking_checkAddresses_ex);
                        Object var22_19 = null;
                        this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                    }
                    option = Option$.MODULE$.apply((Object)new UnknownUnavailableLinkReason(config));
                    list = null;
                    break block15;
                }
                List checkBasicNetworking_checkAddresses_validatedAddresses = list2;
                CollectionConverters$.MODULE$.ListHasAsScala(checkBasicNetworking_checkAddresses_validatedAddresses).asScala().foreach((Function1 & Serializable)inetSocketAddress -> {
                    if (tenantPrefix.isDefined() && ClusterLinkUtils$.MODULE$.isInternalNetworkOrPort((InetSocketAddress)inetSocketAddress)) {
                        return BoxesRunTime.boxToBoolean((boolean)checkBasicNetworking_checkAddresses_invalidAddresses.add(inetSocketAddress));
                    }
                    return BoxedUnit.UNIT;
                });
                if (!checkBasicNetworking_checkAddresses_invalidAddresses.isEmpty()) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkAddresses$4(checkBasicNetworking_checkAddresses_invalidAddresses);
                        Object var23_21 = null;
                        this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                    }
                    option = Option$.MODULE$.apply((Object)new InvalidBootstrapInternalEndpointUnavailableLinkReason(config));
                    list = null;
                } else {
                    option = None$.MODULE$;
                    list = checkBasicNetworking_checkAddresses_validatedAddresses;
                }
            }
            Object var13_10 = null;
            Object var14_11 = null;
            Object var15_12 = null;
            Object var16_13 = null;
            Object var17_20 = null;
            Object var18_15 = null;
            Object var19_18 = null;
            List list3 = list;
            Option checkBasicNetworking_dnsErr = option;
            List checkBasicNetworking_validatedAddresses = list3;
            UnavailableLinkReason unavailableLinkReason = (UnavailableLinkReason)var11_23.getOrElse((Function0 & Serializable)() -> (UnavailableLinkReason)MODULE$.checkTcpConnection(var12_24, config).getOrElse((Function0 & Serializable)() -> new UnknownUnavailableLinkReason(config)));
            var11_23 = null;
            var12_24 = null;
            UnavailableLinkReason reason = unavailableLinkReason;
            ClusterLinkError clusterLinkError = reason.clusterLinkError();
            ClusterLinkError clusterLinkError2 = ClusterLinkError.UNKNOWN;
            if (!(clusterLinkError != null ? !clusterLinkError.equals(clusterLinkError2) : clusterLinkError2 != null) && apiException instanceof TimeoutException) {
                if (this.isSecuritySettingsMissingForCloudLink(config, linkMetrics, connectionToRemoteCluster)) {
                    return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, new AuthenticationErrorUnavailableLinkReason(config)));
                }
                return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, new TimeoutUnavailableLinkReason(config)));
            }
            return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, reason));
        }
    }

    public DescribeClusterResult doBasicDescribeCluster(ClusterLinkBatchAdmin admin) {
        return admin.describeCluster();
    }

    public boolean isSecuritySettingsMissingForCloudLink(ClusterLinkConfig config, Option<ClusterLinkFactory.LinkMetrics> linkMetrics, boolean connectionToRemoteCluster) {
        boolean bl;
        ClusterLinkFactory.LinkMetrics clusterLinkMetrics;
        if (linkMetrics instanceof Some && (clusterLinkMetrics = (ClusterLinkFactory.LinkMetrics)((Some)linkMetrics).value()) instanceof ClusterLinkMetrics) {
            LinkType linkType = ((ClusterLinkMetrics)clusterLinkMetrics).linkType();
            LinkType$Cloud$ linkType$Cloud$ = LinkType$Cloud$.MODULE$;
            bl = linkType != null && linkType.equals(linkType$Cloud$);
        } else {
            bl = false;
        }
        return bl && connectionToRemoteCluster && (this.isSecurityConfigNull(config, "security.protocol", false) || this.isSecurityConfigNull(config, "sasl.mechanism", false) || this.isSecurityConfigNull(config, "sasl.jaas.config", true));
    }

    private boolean isSecurityConfigNull(ClusterLinkConfig config, String securityConfig, boolean isPasswordConfig) {
        boolean configIsNull;
        boolean bl = configIsNull = securityConfig == null;
        if (!configIsNull) {
            String string = isPasswordConfig ? config.getPassword(securityConfig).value() : config.getString(securityConfig);
            String string2 = "null";
            return string != null && string.equals(string2);
        }
        return configIsNull;
    }

    private boolean isSecurityConfigNull$default$3() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private UnavailableLinkReason checkBasicNetworking(ClusterLinkConfig config, Function0<Object> intranetConnectivityDeniedChecker, Option<String> tenantPrefix) {
        void var5_18;
        void var4_17;
        List list;
        Option option;
        block8: {
            List list2;
            List<String> checkAddresses_bootstrapServers = config.bootstrapServersToConnect(intranetConnectivityDeniedChecker);
            String checkAddresses_dnsLookupConfig = config.getString("client.dns.lookup");
            ClientDnsLookup checkAddresses_dnsLookup = checkAddresses_dnsLookupConfig == null ? ClientDnsLookup.USE_ALL_DNS_IPS : ClientDnsLookup.forConfig((String)checkAddresses_dnsLookupConfig);
            ArrayList checkAddresses_invalidAddresses = new ArrayList();
            try {
                list2 = ClientUtils.parseAndValidateAddresses(checkAddresses_bootstrapServers, (ClientDnsLookup)checkAddresses_dnsLookup);
            }
            catch (ConfigException checkAddresses_ex) {
                if (this.logger().underlying().isWarnEnabled()) {
                    String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkAddresses$1(checkAddresses_ex);
                    Object var13_10 = null;
                    this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                option = Option$.MODULE$.apply((Object)new UnresolvableBootstrapUnavailableLinkReason(config));
                list = null;
                break block8;
            }
            catch (Throwable checkAddresses_ex) {
                if (this.logger().underlying().isWarnEnabled()) {
                    String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkAddresses$2(checkAddresses_ex);
                    Object var14_13 = null;
                    this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                option = Option$.MODULE$.apply((Object)new UnknownUnavailableLinkReason(config));
                list = null;
                break block8;
            }
            List checkAddresses_validatedAddresses = list2;
            CollectionConverters$.MODULE$.ListHasAsScala(checkAddresses_validatedAddresses).asScala().foreach((Function1 & Serializable)inetSocketAddress -> {
                if (tenantPrefix.isDefined() && ClusterLinkUtils$.MODULE$.isInternalNetworkOrPort((InetSocketAddress)inetSocketAddress)) {
                    return BoxesRunTime.boxToBoolean((boolean)checkBasicNetworking_checkAddresses_invalidAddresses.add(inetSocketAddress));
                }
                return BoxedUnit.UNIT;
            });
            if (!checkAddresses_invalidAddresses.isEmpty()) {
                if (this.logger().underlying().isWarnEnabled()) {
                    String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkAddresses$4(checkAddresses_invalidAddresses);
                    Object var15_15 = null;
                    this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                option = Option$.MODULE$.apply((Object)new InvalidBootstrapInternalEndpointUnavailableLinkReason(config));
                list = null;
            } else {
                option = None$.MODULE$;
                list = checkAddresses_validatedAddresses;
            }
        }
        Object var6_4 = null;
        Object var7_5 = null;
        Object var8_6 = null;
        Object var9_7 = null;
        Object var10_14 = null;
        Object var11_9 = null;
        Object var12_12 = null;
        List list3 = list;
        Option dnsErr = option;
        List validatedAddresses = list3;
        return (UnavailableLinkReason)var4_17.getOrElse(() -> ClusterLinkConnectionChecker$.$anonfun$checkBasicNetworking$1((List)var5_18, config));
    }

    public Option<UnavailableLinkReason> checkTcpConnection(List<InetSocketAddress> validatedAddresses, ClusterLinkConfig config) {
        try {
            this.tryTcpConnectionToBootstrapServers(validatedAddresses);
            return None$.MODULE$;
        }
        catch (ConnectException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$1(ex);
                Object var7_4 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Option$.MODULE$.apply((Object)new BootstrapTcpConnectionFailedUnavailableLinkReason(config));
        }
        catch (SocketTimeoutException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$2(ex);
                Object var8_6 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Option$.MODULE$.apply((Object)new BootstrapTcpConnectionFailedUnavailableLinkReason(config));
        }
        catch (BindException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$3(ex);
                Object var9_8 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Option$.MODULE$.apply((Object)new BootstrapTcpConnectionFailedUnavailableLinkReason(config));
        }
        catch (Throwable ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$4(ex);
                Object var10_10 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Option$.MODULE$.apply((Object)new UnknownUnavailableLinkReason(config));
        }
    }

    public Tuple2<Option<UnavailableLinkReason>, List<InetSocketAddress>> checkAddresses(ClusterLinkConfig config, Function0<Object> intranetConnectivityDeniedChecker, Option<String> tenantPrefix) {
        List list;
        List<String> bootstrapServers = config.bootstrapServersToConnect(intranetConnectivityDeniedChecker);
        String dnsLookupConfig = config.getString("client.dns.lookup");
        ClientDnsLookup dnsLookup = dnsLookupConfig == null ? ClientDnsLookup.USE_ALL_DNS_IPS : ClientDnsLookup.forConfig((String)dnsLookupConfig);
        ArrayList invalidAddresses = new ArrayList();
        try {
            list = ClientUtils.parseAndValidateAddresses(bootstrapServers, (ClientDnsLookup)dnsLookup);
        }
        catch (ConfigException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkAddresses$1(ex);
                Object var11_9 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return new Tuple2((Object)Option$.MODULE$.apply((Object)new UnresolvableBootstrapUnavailableLinkReason(config)), null);
        }
        catch (Throwable ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkAddresses$2(ex);
                Object var12_11 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return new Tuple2((Object)Option$.MODULE$.apply((Object)new UnknownUnavailableLinkReason(config)), null);
        }
        List validatedAddresses = list;
        CollectionConverters$.MODULE$.ListHasAsScala(validatedAddresses).asScala().foreach((Function1 & Serializable)inetSocketAddress -> {
            if (tenantPrefix.isDefined() && ClusterLinkUtils$.MODULE$.isInternalNetworkOrPort((InetSocketAddress)inetSocketAddress)) {
                return BoxesRunTime.boxToBoolean((boolean)checkBasicNetworking_checkAddresses_invalidAddresses.add(inetSocketAddress));
            }
            return BoxedUnit.UNIT;
        });
        if (!invalidAddresses.isEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ClusterLinkConnectionChecker$.$anonfun$checkAddresses$4(invalidAddresses);
                Object var13_13 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return new Tuple2((Object)Option$.MODULE$.apply((Object)new InvalidBootstrapInternalEndpointUnavailableLinkReason(config)), null);
        }
        return new Tuple2((Object)None$.MODULE$, (Object)validatedAddresses);
    }

    private void tryTcpConnectionToBootstrapServers(List<InetSocketAddress> validatedAddresses) {
        CollectionConverters$.MODULE$.ListHasAsScala(validatedAddresses).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkConnectionChecker$.$anonfun$tryTcpConnectionToBootstrapServers$1(check$ifrefutable$1))).foreach((Function1 & Serializable)endpoint -> {
            ClusterLinkConnectionChecker$.$anonfun$tryTcpConnectionToBootstrapServers$2(endpoint);
            return BoxedUnit.UNIT;
        });
    }

    public int tcpConnectionTimeoutsMs() {
        return 5000;
    }

    public static final /* synthetic */ String $anonfun$check$1(Throwable ex$1, ApiException apiException$1) {
        return new StringBuilder(67).append("Failed to contact remote cluster with exception ").append(ex$1).append(" and api exception ").append((Object)apiException$1).toString();
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$1(ConnectException ex$2) {
        return new StringBuilder(30).append("Failed to connect to endpoint ").append(ex$2).toString();
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$2(SocketTimeoutException ex$3) {
        return new StringBuilder(30).append("Failed to connect to endpoint ").append(ex$3).toString();
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$3(BindException ex$4) {
        return new StringBuilder(27).append("Failed to bind to endpoint ").append(ex$4).toString();
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$4(Throwable ex$5) {
        return new StringBuilder(53).append("Failed to connect to endpoint with unknown exception ").append(ex$5).toString();
    }

    public static final /* synthetic */ String $anonfun$checkAddresses$1(ConfigException ex$6) {
        return new StringBuilder(23).append("Failed to validate DNS ").append((Object)ex$6).toString();
    }

    public static final /* synthetic */ String $anonfun$checkAddresses$2(Throwable ex$7) {
        return new StringBuilder(49).append("Failed to validate DNS with an unknown exception ").append(ex$7).toString();
    }

    public static final /* synthetic */ String $anonfun$checkAddresses$4(ArrayList invalidAddresses$1) {
        return new StringBuilder(95).append("Invalid bootstrap addresses or ports that cannot be used for cluster links on Confluent Cloud: ").append(invalidAddresses$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$tryTcpConnectionToBootstrapServers$1(InetSocketAddress check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$tryTcpConnectionToBootstrapServers$2(InetSocketAddress endpoint) {
        try (Socket clientSocket = new Socket();){
            clientSocket.connect(endpoint, 5000);
        }
    }

    private ClusterLinkConnectionChecker$() {
    }
}

