/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkRepairMirrorsTaskType$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicLinkPendingRepairMirror$;
import kafka.server.link.TopicLinkState;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005-g\u0001B\r\u001b\u0001\u0005B\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AA\b\u0001B\u0001B\u0003%Q\bC\u0005A\u0001\t\u0005\t\u0015!\u0003B\u001d\"Iq\n\u0001B\u0001B\u0003%\u0001\u000b\u0016\u0005\n+\u0002\u0011\t\u0011)A\u0005-jCQ\u0001\u0018\u0001\u0005\u0002uCq!\u001a\u0001A\u0002\u0013%a\rC\u0004n\u0001\u0001\u0007I\u0011\u00028\t\rQ\u0004\u0001\u0015)\u0003h\u0011\u001dI\bA1A\u0005\niDaA \u0001!\u0002\u0013Y\bbB@\u0001\t#R\u0012\u0011\u0001\u0005\b\u0003/\u0001A\u0011BA\r\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003KAq!a\u0011\u0001\t\u0013\t)\u0005C\u0004\u0002t\u0001!I!!\u001e\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|!9\u00111\u0013\u0001\u0005R\u0005U\u0005bBAQ\u0001\u0011\u0005\u00131U\u0004\n\u0003KS\u0012\u0011!E\u0001\u0003O3\u0001\"\u0007\u000e\u0002\u0002#\u0005\u0011\u0011\u0016\u0005\u00079Z!\t!!-\t\u0013\u0005Mf#%A\u0005\u0002\u0005U&aF\"mkN$XM\u001d'j].\u0014V\r]1je6K'O]8s\u0015\tYB$\u0001\u0003mS:\\'BA\u000f\u001f\u0003\u0019\u0019XM\u001d<fe*\tq$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012(\u001d\t!S%D\u0001\u001b\u0013\t1#$\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0005\u0003Q%\u0012A\u0002U3sS>$\u0017n\u0019+bg.T!A\n\u000e\u0002\u000bQ|\u0007/[2\u0011\u00051*dBA\u00174!\tq\u0013'D\u00010\u0015\t\u0001\u0004%\u0001\u0004=e>|GO\u0010\u0006\u0002e\u0005)1oY1mC&\u0011A'M\u0001\u0007!J,G-\u001a4\n\u0005Y:$AB*ue&twM\u0003\u00025c\u0005i1\r\\5f]Rl\u0015M\\1hKJ\u0004\"\u0001\n\u001e\n\u0005mR\"\u0001H\"mkN$XM\u001d'j].$Um\u001d;DY&,g\u000e^'b]\u0006<WM]\u0001\u000bY>\u001c\u0017\r\\!e[&t\u0007C\u0001\u0013?\u0013\ty$DA\u000bDYV\u001cH/\u001a:MS:\\')\u0019;dQ\u0006#W.\u001b8\u0002\tQLW.\u001a\t\u0003\u00052k\u0011a\u0011\u0006\u0003\t\u0016\u000bQ!\u001e;jYNT!AR$\u0002\r\r|W.\\8o\u0015\ty\u0002J\u0003\u0002J\u0015\u00061\u0011\r]1dQ\u0016T\u0011aS\u0001\u0004_J<\u0017BA'D\u0005\u0011!\u0016.\\3\n\u0005\u0001;\u0013!B9v_R\f\u0007CA)S\u001b\u0005a\u0012BA*\u001d\u0005]\u0019E.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-\u0003\u0002PO\u0005Q\u0011N\u001c;feZ\fG.T:\u0011\u0005]CV\"A\u0019\n\u0005e\u000b$aA%oi&\u00111lJ\u0001\u0012e\u0016\u001c8\r[3ek2,G)\u001a7bs6\u001b\u0018A\u0002\u001fj]&$h\bF\u0004_?\u0002\f'm\u00193\u0011\u0005\u0011\u0002\u0001\"\u0002\u0016\b\u0001\u0004Y\u0003\"\u0002\u001d\b\u0001\u0004I\u0004\"\u0002\u001f\b\u0001\u0004i\u0004\"\u0002!\b\u0001\u0004\t\u0005\"B(\b\u0001\u0004\u0001\u0006bB+\b!\u0003\u0005\rAV\u0001\ti\u0006\u001c8\u000eR3tGV\tq\rE\u0002XQ*L!![\u0019\u0003\r=\u0003H/[8o!\t!3.\u0003\u0002m5\tyA+Y:l\t\u0016\u001c8M]5qi&|g.\u0001\u0007uCN\\G)Z:d?\u0012*\u0017\u000f\u0006\u0002peB\u0011q\u000b]\u0005\u0003cF\u0012A!\u00168ji\"91/CA\u0001\u0002\u00049\u0017a\u0001=%c\u0005IA/Y:l\t\u0016\u001c8\r\t\u0015\u0003\u0015Y\u0004\"aV<\n\u0005a\f$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002/\u0015D8-Z:tSZ,Gj\\4hS:<\u0007*\u00198eY\u0016\u0014X#A>\u0011\u0005\u0011b\u0018BA?\u001b\u0005])\u0005pY3tg&4X\rT8hO&tw\rS1oI2,'/\u0001\rfq\u000e,7o]5wK2{wmZ5oO\"\u000bg\u000e\u001a7fe\u0002\n1A];o)\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005MabAA\u0004K9!\u0011\u0011BA\t\u001d\u0011\tY!a\u0004\u000f\u00079\ni!C\u0001 \u0013\tib$\u0003\u0002\u001c9%\u0019\u0011QC\u0015\u0003\u0015Q\u000b7o\u001b*fgVdG/A\u0007qK:$\u0017N\\4SKB\f\u0017N\u001d\u000b\u0005\u00037\t\t\u0003E\u0002X\u0003;I1!a\b2\u0005\u001d\u0011un\u001c7fC:DQA\u000b\bA\u0002-\n\u0011\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8t)\u0019\t\u0019!a\n\u00022!9\u0011\u0011F\bA\u0002\u0005-\u0012a\u0003;bg.\u001cuN\u001c;fqR\u0004B!!\u0002\u0002.%\u0019\u0011qF\u0015\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003gy\u0001\u0019AA\u001b\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006Y\u0005]\u00121H\u0005\u0004\u0003s9$aA*fiB!\u0011QHA \u001b\u0005)\u0015bAA!\u000b\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!\u00075b]\u0012dWMU3qY&\u001c\u0017m\u0015;biV\u001c(+Z:vYR$b!a\u0001\u0002H\u0005%\u0003bBA\u0015!\u0001\u0007\u00111\u0006\u0005\b\u0003\u0017\u0002\u0002\u0019AA'\u0003A\u0001\u0018M\u001d;ji&|gNU3tk2$8\u000f\u0005\u0005\u0002P\u0005e\u00131HA/\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013\u0001B;uS2T!!a\u0016\u0002\t)\fg/Y\u0005\u0005\u00037\n\tFA\u0002NCB\u0004b!!\u0010\u0002`\u0005\r\u0014bAA1\u000b\nY1*\u00194lC\u001a+H/\u001e:f!\u0011\t)'a\u001c\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\nQ!\u00193nS:T1!!\u001cH\u0003\u001d\u0019G.[3oiNLA!!\u001d\u0002h\ty\u0001+\u0019:uSRLwN\u001c*fgVdG/A\u000bqe>\u001cWm]:D_6\u0004H.\u001a;fIR{\u0007/[2\u0015\t\u0005\r\u0011q\u000f\u0005\b\u0003S\t\u0002\u0019AA\u0016\u0003aA\u0017M\u001c3mK\u0006cG/\u001a:NSJ\u0014xN]:SKN,H\u000e\u001e\u000b\u0007\u0003\u0007\ti(a \t\u000f\u0005%\"\u00031\u0001\u0002,!9\u0011\u0011\u0011\nA\u0002\u0005\r\u0015\u0001\u0004;pa&\u001c'+Z:vYR\u001c\bcBA(\u00033Z\u0013Q\u0011\t\u0007\u0003{\ty&a\"\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017SA!!$\u0002V\u0005!A.\u00198h\u0013\u0011\t\t*a#\u0003\tY{\u0017\u000eZ\u0001\r_:\u001cu.\u001c9mKRLwN\u001c\u000b\u0004_\u0006]\u0005bBAM'\u0001\u0007\u00111T\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u0007\r\ni*C\u0002\u0002 &\u00121cQ8na2,G/\u001a3UCN\\'+Z:vYR\fq\u0002^1tW\u0012+7o\u0019:jaRLwN\u001c\u000b\u0002O\u000692\t\\;ti\u0016\u0014H*\u001b8l%\u0016\u0004\u0018-\u001b:NSJ\u0014xN\u001d\t\u0003IY\u00192AFAV!\r9\u0016QV\u0005\u0004\u0003_\u000b$AB!osJ+g\r\u0006\u0002\u0002(\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"!a.+\u0007Y\u000bIl\u000b\u0002\u0002<B!\u0011QXAd\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017!C;oG\",7m[3e\u0015\r\t)-M\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAe\u0003\u007f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ClusterLinkRepairMirror
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkBatchAdmin localAdmin;
    private volatile Option<TaskDescription> taskDesc;
    private final ExcessiveLoggingHandler excessiveLoggingHandler;

    public static int $lessinit$greater$default$6() {
        return 1000;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    private ExcessiveLoggingHandler excessiveLoggingHandler() {
        return this.excessiveLoggingHandler;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        if (this.pendingRepair(this.topic) && this.clientManager.metadataManager().isLinkCoordinator(this.clientManager.linkData().linkName())) {
            return this.processPartitions(new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty())), this.clientManager.metadataManager().topicPartitions(this.topic));
        }
        Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
        return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    private boolean pendingRepair(String topic) {
        return this.clientManager.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkRepairMirror.$anonfun$pendingRepair$1(x$1)));
    }

    private ClusterLinkScheduler.TaskResult processPartitions(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<TopicPartition> partitions) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Processing failed mirror partitions: ").append(partitions).toString());
        ReplicaStatusResult result = this.localAdmin.replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(partitions).asJava());
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleReplicaStatusResult((ClusterLinkScheduler.TaskContext)tc, result.partitionResults()), taskContext));
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleReplicaStatusResult(ClusterLinkScheduler.TaskContext taskContext, java.util.Map<TopicPartition, KafkaFuture<PartitionResult>> partitionResults) {
        Left resultOrError;
        Left left;
        try {
            scala.collection.mutable.Map res = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitionResults).asScala().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition tp = (TopicPartition)x0$1._1();
                    KafkaFuture future = (KafkaFuture)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), future.get());
                }
                throw new MatchError(null);
            });
            left = new Left((Object)res);
        }
        catch (ExecutionException e) {
            this.excessiveLoggingHandler().handle(e, this, new StringBuilder(77).append("Encountered exception when trying to handle replica status for mirror topic ").append(this.topic).append(".").toString());
            left = resultOrError = new Right((Object)ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg("Failed to get replicas status of mirror partitions", true, e));
        }
        if (resultOrError instanceof Right) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Right)resultOrError).value();
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        if (resultOrError instanceof Left) {
            if (((scala.collection.mutable.Map)resultOrError.value()).count((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkRepairMirror.$anonfun$handleReplicaStatusResult$2(x0$2))) == 0) {
                return this.processCompletedTopic(taskContext);
            }
            Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
        }
        throw new MatchError((Object)resultOrError);
    }

    private ClusterLinkScheduler.TaskResult processCompletedTopic(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Resuming failed mirrors after repair for ").append($this.topic).toString());
        AlterMirrorsResult result = this.localAdmin.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)AlterMirrorOp.COMPLETE_REPAIR))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleAlterMirrorsResult((ClusterLinkScheduler.TaskContext)tc, result.values()), taskContext));
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleAlterMirrorsResult(ClusterLinkScheduler.TaskContext taskContext, java.util.Map<String, KafkaFuture<Void>> topicResults) {
        Set nonRetriableErrorTopics = (Set)Set$.MODULE$.empty();
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicResults).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    return None$.MODULE$;
                }
                catch (RetriableException e) {
                    String errMsg = new StringBuilder(49).append("Failed to complete repair of failed mirror topic ").append(topic).toString();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> errMsg, (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                }
                catch (Exception e) {
                    String errMsg = new StringBuilder(49).append("Failed to complete repair of failed mirror topic ").append(topic).toString();
                    this.excessiveLoggingHandler().handle(e, this, errMsg);
                    nonRetriableErrorTopics.$plus$eq((Object)topic);
                    return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                }
            }
            throw new MatchError(null);
        });
        if (nonRetriableErrorTopics.nonEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(117).append("Failed to complete repair of failed mirror topics ").append(nonRetriableErrorTopics).append(". Did not log the errors for ").append(this.excessiveLoggingHandler().ignoredWarnLogCount()).append(" of them to prevent excessive logging.").toString());
        }
        Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)errs);
        return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.clientManager.metrics(), ClusterLinkRepairMirrorsTaskType$.MODULE$, true, "repair the failed mirror"));
        if (!this.pendingRepair(this.topic)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Repair mirror task completed for topic '").append($this.topic).append("'.'").toString());
            this.shutdown();
            return;
        }
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    public static final /* synthetic */ boolean $anonfun$pendingRepair$1(ClusterLinkTopicState x$1) {
        TopicLinkState topicLinkState = x$1.state();
        TopicLinkPendingRepairMirror$ topicLinkPendingRepairMirror$ = TopicLinkPendingRepairMirror$.MODULE$;
        return topicLinkState != null && topicLinkState.equals(topicLinkPendingRepairMirror$);
    }

    public static final /* synthetic */ boolean $anonfun$handleReplicaStatusResult$2(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((PartitionResult)x0$2._2()).replicas().stream().filter(x$2 -> x$2.isLeader()).findAny().flatMap(x$3 -> x$3.mirrorInfo()).filter(x$4 -> {
                ReplicaStatus.MirrorInfo.State state = x$4.state();
                ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.FAILED;
                return !(state != null ? !state.equals(state2) : state2 != null);
            }).isPresent();
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkRepairMirror(String topic, ClusterLinkDestClientManager clientManager, ClusterLinkBatchAdmin localAdmin, Time time, ClusterLinkRequestQuota quota, int intervalMs) {
        void apply_now;
        void apply_ttlMs;
        this.topic = topic;
        this.clientManager = clientManager;
        this.localAdmin = localAdmin;
        super(clientManager.scheduler(), "ClusterLinkRepairMirror", intervalMs, time, quota);
        this.taskDesc = None$.MODULE$;
        ExcessiveLoggingHandler$ apply$default$3_this = ExcessiveLoggingHandler$.MODULE$;
        Object var11_7 = null;
        Function0<Object> function0 = apply$default$3_this.nowDefault();
        long l = ExcessiveLoggingHandler$.MODULE$.ttlMsDefault();
        int apply_capacity = 1000;
        this.excessiveLoggingHandler = new ExcessiveLoggingHandler(apply_capacity, (long)apply_ttlMs, (Function0<Object>)apply_now);
    }
}

