/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import io.confluent.kafka.storage.tier.serdes.PartitionForceRestore;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;

public class TierPartitionForceRestore
extends AbstractTierMetadata {
    public static final byte VERSION_V0 = 0;
    public static final byte VERSION_V1 = 1;
    private static final byte CURRENT_VERSION = 1;
    private static final int INITIAL_BUFFER_SIZE = 144;
    private final TopicIdPartition topicIdPartition;
    private final PartitionForceRestore metadata;

    public TierPartitionForceRestore(TopicIdPartition topicIdPartition, UUID messageId, long startOffset, long endOffset, kafka.tier.state.OffsetAndEpoch stateOffsetAndEpoch, String contentHash, Boolean restoreLogStartOffset, byte checksumAlgorithmId) {
        FlatBufferBuilder builder = new FlatBufferBuilder(144).forceDefaults(true);
        int contentHashId = builder.createString((CharSequence)contentHash);
        PartitionForceRestore.startPartitionForceRestore((FlatBufferBuilder)builder);
        PartitionForceRestore.addVersion((FlatBufferBuilder)builder, (byte)1);
        PartitionForceRestore.addStartOffset((FlatBufferBuilder)builder, (long)startOffset);
        PartitionForceRestore.addEndOffset((FlatBufferBuilder)builder, (long)endOffset);
        int messageIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)messageId.getMostSignificantBits(), (long)messageId.getLeastSignificantBits());
        PartitionForceRestore.addMessageId((FlatBufferBuilder)builder, (int)messageIdOffset);
        int offsetAndEpochId = OffsetAndEpoch.createOffsetAndEpoch((FlatBufferBuilder)builder, (long)stateOffsetAndEpoch.offset(), (int)stateOffsetAndEpoch.epoch().orElse(-1));
        PartitionForceRestore.addStateOffsetAndEpoch((FlatBufferBuilder)builder, (int)offsetAndEpochId);
        PartitionForceRestore.addContentHash((FlatBufferBuilder)builder, (int)contentHashId);
        PartitionForceRestore.addRestoreLogStartOffset((FlatBufferBuilder)builder, (boolean)restoreLogStartOffset);
        PartitionForceRestore.addChecksumAlgorithmId((FlatBufferBuilder)builder, (byte)checksumAlgorithmId);
        int entryId = PartitionForceRestore.endPartitionForceRestore((FlatBufferBuilder)builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = PartitionForceRestore.getRootAsPartitionForceRestore((ByteBuffer)builder.dataBuffer());
    }

    public TierPartitionForceRestore(TopicIdPartition topicIdPartition, PartitionForceRestore metadata) {
        if (metadata.stateOffsetAndEpoch() == null) {
            throw new IllegalArgumentException("TierPartitionForceRestore must contain a stateOffsetAndEpoch.");
        }
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public static int initialBufferSize() {
        return 144;
    }

    public long startOffset() {
        return this.metadata.startOffset();
    }

    public long endOffset() {
        return this.metadata.endOffset();
    }

    public String contentHash() {
        return this.metadata.contentHash();
    }

    public byte version() {
        return this.metadata.version();
    }

    public boolean restoreLogStartOffset() {
        return this.metadata.restoreLogStartOffset();
    }

    public Algorithm checksumAlgorithm() {
        return Algorithm.toAlgorithm((Byte)this.metadata.checksumAlgorithmId());
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.PartitionForceRestore;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public int tierEpoch() {
        return -1;
    }

    @Override
    public kafka.tier.state.OffsetAndEpoch stateOffsetAndEpoch() {
        return new kafka.tier.state.OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.messageId().mostSignificantBits(), this.metadata.messageId().leastSignificantBits());
    }

    public String toString() {
        return "TierPartitionForceRestore(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", messageIdAsBase64=" + this.messageIdAsBase64() + ", startOffset=" + this.startOffset() + ", endOffset=" + this.endOffset() + ", stateOffsetAndEpoch=" + this.stateOffsetAndEpoch() + ", contentHash=" + this.contentHash() + ", restoreLogStartOffset=" + this.metadata.restoreLogStartOffset() + ", checksumAlgorithm=" + this.checksumAlgorithm() + ")";
    }
}

