/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.snapshot;

import java.util.Collections;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;

public class TierTopicSnapshotMetrics {
    public static final String ACTIVE_STATE_INDICATOR_PREFIX = "ActiveIndicator";
    public static final String CONSUMER_LAG_METRIC_PREFIX = "ConsumerLag";
    public static final String FAILURE_METRIC_PREFIX = "FailureTotal";
    public static final String TTPS_SNAPSHOT_UPLOADED_PREFIX = "UploadedTotal";
    private static final String METRIC_GROUP_NAME = "TierTopicSnapshot";
    private final Metrics metrics;
    private final LongGauge activeStateIndicatorMetric = new LongGauge(0L);
    private final LongGauge consumerLagMetric = new LongGauge(0L);
    private MetricName consumerLagMetricName;
    private MetricName activeStateIndicatorMetricName;
    private Sensor snapshotUploaded;
    private Sensor snapshotManagerFailed;

    public TierTopicSnapshotMetrics(Metrics metrics) {
        this.metrics = metrics;
        this.register();
    }

    private void register() {
        this.addSensors();
        this.addGaugeMetrics();
    }

    private void addSensors() {
        this.addSnapshotUploadedSensor();
        this.addSnapshotMangerFailureSensor();
    }

    private void addSnapshotMangerFailureSensor() {
        this.snapshotManagerFailed = this.metrics.sensor(FAILURE_METRIC_PREFIX);
        MetricName snapshotFailureCountTotalMetricName = this.metrics.metricName(FAILURE_METRIC_PREFIX, METRIC_GROUP_NAME, "The total number of TTPS snapshot failures");
        this.snapshotManagerFailed.add(snapshotFailureCountTotalMetricName, (MeasurableStat)new CumulativeCount());
    }

    private void addSnapshotUploadedSensor() {
        this.snapshotUploaded = this.metrics.sensor(TTPS_SNAPSHOT_UPLOADED_PREFIX);
        MetricName snapshotUploadCountTotalMetricName = this.metrics.metricName(TTPS_SNAPSHOT_UPLOADED_PREFIX, METRIC_GROUP_NAME, "The total number of TTPS snapshot uploaded");
        this.snapshotUploaded.add(snapshotUploadCountTotalMetricName, (MeasurableStat)new CumulativeCount());
    }

    private void addGaugeMetrics() {
        this.addActiveIndicatorGaugeMetric();
        this.addConsumerLagGaugeMetric();
    }

    private void addActiveIndicatorGaugeMetric() {
        this.activeStateIndicatorMetricName = this.metrics.metricName(ACTIVE_STATE_INDICATOR_PREFIX, METRIC_GROUP_NAME, "Integer to indicate whether the tier topic snapshot manager is active or not", Collections.emptyMap());
        this.metrics.addMetricIfAbsent(this.activeStateIndicatorMetricName, null, (MetricValueProvider)this.activeStateIndicatorMetric);
    }

    private void addConsumerLagGaugeMetric() {
        this.consumerLagMetricName = this.metrics.metricName(CONSUMER_LAG_METRIC_PREFIX, METRIC_GROUP_NAME, "Long value indicating total lag for TierTopicSnapshotManager's consumer", Collections.emptyMap());
        this.metrics.addMetricIfAbsent(this.consumerLagMetricName, null, (MetricValueProvider)this.consumerLagMetric);
    }

    public void deRegister() {
        this.metrics.removeMetric(this.activeStateIndicatorMetricName);
        this.metrics.removeMetric(this.consumerLagMetricName);
        this.metrics.removeSensor(TTPS_SNAPSHOT_UPLOADED_PREFIX);
        this.metrics.removeSensor(FAILURE_METRIC_PREFIX);
    }

    public void markTTPSActive() {
        this.activeStateIndicatorMetric.record(1L);
    }

    public void markTTPSInActive() {
        this.activeStateIndicatorMetric.record(0L);
    }

    public void recordSnapshotUpload() {
        this.snapshotUploaded.record();
    }

    public void recordSnapshotManagerFailure() {
        this.snapshotManagerFailed.record();
    }

    public void recordConsumerLag(long lag) {
        this.consumerLagMetric.record(lag);
    }

    static class LongGauge
    implements Gauge<Long> {
        private volatile long value;

        LongGauge(Long initialValue) {
            this.value = initialValue;
        }

        public synchronized Long value(MetricConfig config, long now) {
            return this.value;
        }

        public synchronized long record(long value) {
            this.value = value;
            return this.value;
        }
    }
}

