/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.utils.CoreUtils;

public class TierOffsetsRecoveryUploadMetadata
implements ObjectStoreMetadata {
    private static final String OBJECT_PATH_DELIMITER = "/";
    private static final String SUFFIX_DELIMITER = ".";
    private static final String RECOVERY_DIR_PREFIX = "recovery-";
    private static final String TIER_OFFSETS_DIR = "tier-offsets";
    private static final String FILE_NAME = "tier.offsets";
    private final String logDir;
    private final String identifier;
    private final Integer broker;

    public TierOffsetsRecoveryUploadMetadata(String logDir, String identifier, Integer broker) {
        this.logDir = logDir;
        this.identifier = identifier;
        this.broker = broker;
    }

    public String logDir() {
        return this.logDir;
    }

    public String identifier() {
        return this.identifier;
    }

    public Integer broker() {
        return this.broker;
    }

    public static String pathPrefix(String keyPrefix, String identifier, Integer broker, String logDir) {
        return String.join((CharSequence)OBJECT_PATH_DELIMITER, keyPrefix + TierObjectStore.DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix(), RECOVERY_DIR_PREFIX + identifier, broker.toString(), TIER_OFFSETS_DIR, CoreUtils.toBase64(logDir.getBytes()));
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        return String.join((CharSequence)OBJECT_PATH_DELIMITER, TierOffsetsRecoveryUploadMetadata.pathPrefix(keyPrefix, this.identifier, this.broker, this.logDir), "tier.offsets." + objectType.suffix());
    }

    public static TierOffsetsRecoveryUploadMetadata fromPath(String filePath) {
        String errorMessage = String.format("The filePath: %s does not have the expected format.", filePath);
        String prefixDelimiter = TierObjectStore.DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix() + OBJECT_PATH_DELIMITER;
        String[] prefix = filePath.split(prefixDelimiter, 2);
        String[] attributes = prefix[1].split(OBJECT_PATH_DELIMITER);
        String identifier = attributes[0].split(RECOVERY_DIR_PREFIX)[1];
        Integer broker = Integer.parseInt(attributes[1]);
        TierOffsetsRecoveryUploadMetadata.validateAssertion(attributes[2].equals(TIER_OFFSETS_DIR), errorMessage);
        String logDir = new String(Base64.getDecoder().decode(attributes[3].getBytes()));
        TierOffsetsRecoveryUploadMetadata.validateAssertion(attributes[4].startsWith(FILE_NAME), errorMessage);
        return new TierOffsetsRecoveryUploadMetadata(logDir, identifier, broker);
    }

    private static void validateAssertion(Boolean assertion, String errorMessage) {
        if (!assertion.booleanValue()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.TIER_OFFSETS_UPLOAD) {
            throw new UnsupportedOperationException(String.format("TierOffsetsRecoveryUploadMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
        return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("broker", String.valueOf(this.broker));
        metadata.put("identifier", this.identifier);
        metadata.put("logdir", this.logDir);
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierOffsetsRecoveryUploadMetadata that = (TierOffsetsRecoveryUploadMetadata)o;
        return this.logDir.equals(that.logDir) && this.identifier.equals(that.identifier) && this.broker.equals(that.broker);
    }

    public int hashCode() {
        return Objects.hash(this.logDir, this.identifier, this.broker);
    }

    public String toString() {
        return "TierOffsetsRecoveryUploadMetadata{broker=" + this.broker + ", identifier=" + this.identifier + ", logDir=" + this.logDir + '}';
    }
}

