/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kafka.tier.domain.TierPartitionUnfreezeLogStartOffset;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierPartitionUnfreezeLogStartOffsetTrigger;
import org.apache.kafka.clients.producer.Producer;

public abstract class UnfreezeLogStartOffsetRawInput<T, E> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void injectStateFromRawInput(Properties props, String tierTopicName, File outputFile, List<T> inputs) throws Exception {
        Object fos = null;
        try (Producer<byte[], byte[]> producer = null;){
            producer = RecoveryUtils.createTierTopicProducer(props, TierPartitionUnfreezeLogStartOffsetTrigger.class.getSimpleName());
            int numTierTopicPartitions = RecoveryUtils.getNumPartitions(producer, tierTopicName);
            ArrayList<E> outputs = new ArrayList<E>();
            for (T input : inputs) {
                File file = this.getFtpsForTopicPartition(input);
                TierPartitionUnfreezeLogStartOffset event = TierPartitionUnfreezeLogStartOffsetTrigger.injectState(tierTopicName, numTierTopicPartitions, producer, file);
                E output = this.getUnfreezeTriggerOutput(input, event.toString());
                outputs.add(output);
            }
            this.writeOutputFile(outputs, outputFile);
        }
    }

    protected abstract List<T> getUnfreezeLogStartOffsetTriggerInput(Path var1);

    protected abstract File getFtpsForTopicPartition(T var1);

    protected abstract E getUnfreezeTriggerOutput(T var1, String var2);

    protected abstract void writeOutputFile(List<E> var1, File var2) throws IOException;
}

