/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import java.util.Objects;

public class AclBindingKey
extends AuthKey {
    private final ResourcePattern resourcePattern;
    private final Scope scope;

    @JsonCreator
    public AclBindingKey(@JsonProperty(value="resourcePattern") ResourcePattern resourcePattern, @JsonProperty(value="scope") Scope scope) {
        this.resourcePattern = resourcePattern;
        this.scope = scope;
    }

    @JsonProperty
    public ResourcePattern resourcePattern() {
        return this.resourcePattern;
    }

    @JsonProperty
    public Scope scope() {
        return this.scope;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.ACL_BINDING;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AclBindingKey that = (AclBindingKey)o;
        return Objects.equals(this.resourcePattern, that.resourcePattern) && Objects.equals(this.scope, that.scope);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.resourcePattern, this.scope);
    }

    public String toString() {
        return "AclBindingKey{resourcePattern=" + this.resourcePattern + ", scope=" + this.scope + '}';
    }
}

