/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.store.MetadataStoreStatus;
import java.util.Objects;

public class StatusValue
extends AuthValue {
    private final MetadataStoreStatus status;
    private final int generationId;
    private final Integer writerBrokerId;
    private final String errorMessage;

    @JsonCreator
    public StatusValue(@JsonProperty(value="status") MetadataStoreStatus status, @JsonProperty(value="generationId") int generationId, @JsonProperty(value="writerBrokerId") Integer writerBrokerId, @JsonProperty(value="errorMessage") String errorMessage) {
        this.status = status;
        this.generationId = generationId;
        this.writerBrokerId = writerBrokerId;
        this.errorMessage = status == MetadataStoreStatus.FAILED && errorMessage == null ? "Unknown error" : errorMessage;
    }

    @JsonProperty
    public MetadataStoreStatus status() {
        return this.status;
    }

    @JsonProperty
    public int generationId() {
        return this.generationId;
    }

    @JsonProperty
    public Integer writerBrokerId() {
        return this.writerBrokerId;
    }

    @JsonProperty
    public String errorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.STATUS;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatusValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatusValue that = (StatusValue)o;
        return Objects.equals((Object)this.status, (Object)that.status) && Objects.equals(this.generationId, that.generationId) && Objects.equals(this.writerBrokerId, that.writerBrokerId) && Objects.equals(this.errorMessage, that.errorMessage);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(new Object[]{this.status, this.generationId, this.writerBrokerId, this.errorMessage});
    }

    public String toString() {
        return "StatusValue(status=" + (Object)((Object)this.status) + ", generationId=" + this.generationId + ", writerBrokerId=" + this.writerBrokerId + ", errorMessage=" + this.errorMessage + ')';
    }
}

