/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class MirrorTopicChangeRecordJsonConverter {
    public static MirrorTopicChangeRecord read(JsonNode _node, short _version) {
        MirrorTopicChangeRecord _object = new MirrorTopicChangeRecord();
        JsonNode _topicIdNode = _node.get("topicId");
        if (_topicIdNode == null) {
            throw new RuntimeException("MirrorTopicChangeRecord: unable to locate field 'topicId', which is mandatory in version " + _version);
        }
        if (!_topicIdNode.isTextual()) {
            throw new RuntimeException("MirrorTopicChangeRecord expected a JSON string type, but got " + _node.getNodeType());
        }
        _object.topicId = Uuid.fromString((String)_topicIdNode.asText());
        JsonNode _topicNameNode = _node.get("topicName");
        if (_topicNameNode == null) {
            throw new RuntimeException("MirrorTopicChangeRecord: unable to locate field 'topicName', which is mandatory in version " + _version);
        }
        if (!_topicNameNode.isTextual()) {
            throw new RuntimeException("MirrorTopicChangeRecord expected a string type, but got " + _node.getNodeType());
        }
        _object.topicName = _topicNameNode.asText();
        JsonNode _clusterLinkIdNode = _node.get("clusterLinkId");
        if (_clusterLinkIdNode == null) {
            throw new RuntimeException("MirrorTopicChangeRecord: unable to locate field 'clusterLinkId', which is mandatory in version " + _version);
        }
        if (!_clusterLinkIdNode.isTextual()) {
            throw new RuntimeException("MirrorTopicChangeRecord expected a JSON string type, but got " + _node.getNodeType());
        }
        _object.clusterLinkId = Uuid.fromString((String)_clusterLinkIdNode.asText());
        JsonNode _clusterLinkNameNode = _node.get("clusterLinkName");
        if (_clusterLinkNameNode == null) {
            throw new RuntimeException("MirrorTopicChangeRecord: unable to locate field 'clusterLinkName', which is mandatory in version " + _version);
        }
        if (!_clusterLinkNameNode.isTextual()) {
            throw new RuntimeException("MirrorTopicChangeRecord expected a string type, but got " + _node.getNodeType());
        }
        _object.clusterLinkName = _clusterLinkNameNode.asText();
        JsonNode _timeMsNode = _node.get("timeMs");
        if (_timeMsNode == null) {
            throw new RuntimeException("MirrorTopicChangeRecord: unable to locate field 'timeMs', which is mandatory in version " + _version);
        }
        _object.timeMs = MessageUtil.jsonNodeToLong((JsonNode)_timeMsNode, (String)"MirrorTopicChangeRecord");
        JsonNode _mirrorTopicStateNode = _node.get("mirrorTopicState");
        if (_mirrorTopicStateNode == null) {
            throw new RuntimeException("MirrorTopicChangeRecord: unable to locate field 'mirrorTopicState', which is mandatory in version " + _version);
        }
        if (!_mirrorTopicStateNode.isTextual()) {
            throw new RuntimeException("MirrorTopicChangeRecord expected a string type, but got " + _node.getNodeType());
        }
        _object.mirrorTopicState = _mirrorTopicStateNode.asText();
        JsonNode _bumpPartitionLeaderEpochsNode = _node.get("bumpPartitionLeaderEpochs");
        if (_bumpPartitionLeaderEpochsNode == null) {
            if (_version >= 2) {
                throw new RuntimeException("MirrorTopicChangeRecord: unable to locate field 'bumpPartitionLeaderEpochs', which is mandatory in version " + _version);
            }
            _object.bumpPartitionLeaderEpochs = false;
        } else {
            if (!_bumpPartitionLeaderEpochsNode.isBoolean()) {
                throw new RuntimeException("MirrorTopicChangeRecord expected Boolean type, but got " + _node.getNodeType());
            }
            _object.bumpPartitionLeaderEpochs = _bumpPartitionLeaderEpochsNode.asBoolean();
        }
        JsonNode _previousToPausedStateNode = _node.get("previousToPausedState");
        if (_previousToPausedStateNode == null) {
            _object.previousToPausedState = null;
        } else if (_previousToPausedStateNode.isNull()) {
            _object.previousToPausedState = null;
        } else {
            if (!_previousToPausedStateNode.isTextual()) {
                throw new RuntimeException("MirrorTopicChangeRecord expected a string type, but got " + _node.getNodeType());
            }
            _object.previousToPausedState = _previousToPausedStateNode.asText();
        }
        JsonNode _stoppedLogEndOffsetsNode = _node.get("stoppedLogEndOffsets");
        if (_stoppedLogEndOffsetsNode == null) {
            _object.stoppedLogEndOffsets = null;
        } else if (_stoppedLogEndOffsetsNode.isNull()) {
            _object.stoppedLogEndOffsets = null;
        } else {
            if (!_stoppedLogEndOffsetsNode.isArray()) {
                throw new RuntimeException("MirrorTopicChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Long> _collection = new ArrayList<Long>(_stoppedLogEndOffsetsNode.size());
            _object.stoppedLogEndOffsets = _collection;
            for (JsonNode _element : _stoppedLogEndOffsetsNode) {
                _collection.add(MessageUtil.jsonNodeToLong((JsonNode)_element, (String)"MirrorTopicChangeRecord element"));
            }
        }
        JsonNode _promotedNode = _node.get("promoted");
        if (_promotedNode == null) {
            _object.promoted = false;
        } else {
            if (!_promotedNode.isBoolean()) {
                throw new RuntimeException("MirrorTopicChangeRecord expected Boolean type, but got " + _node.getNodeType());
            }
            _object.promoted = _promotedNode.asBoolean();
        }
        JsonNode _topicLevelPauseNode = _node.get("topicLevelPause");
        if (_topicLevelPauseNode == null) {
            _object.topicLevelPause = false;
        } else {
            if (!_topicLevelPauseNode.isBoolean()) {
                throw new RuntimeException("MirrorTopicChangeRecord expected Boolean type, but got " + _node.getNodeType());
            }
            _object.topicLevelPause = _topicLevelPauseNode.asBoolean();
        }
        JsonNode _linkLevelPauseNode = _node.get("linkLevelPause");
        if (_linkLevelPauseNode == null) {
            _object.linkLevelPause = false;
        } else {
            if (!_linkLevelPauseNode.isBoolean()) {
                throw new RuntimeException("MirrorTopicChangeRecord expected Boolean type, but got " + _node.getNodeType());
            }
            _object.linkLevelPause = _linkLevelPauseNode.asBoolean();
        }
        JsonNode _mirrorStartOffsetsNode = _node.get("mirrorStartOffsets");
        if (_mirrorStartOffsetsNode == null) {
            _object.mirrorStartOffsets = null;
        } else if (_mirrorStartOffsetsNode.isNull()) {
            _object.mirrorStartOffsets = null;
        } else {
            if (!_mirrorStartOffsetsNode.isArray()) {
                throw new RuntimeException("MirrorTopicChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Long> _collection = new ArrayList<Long>(_mirrorStartOffsetsNode.size());
            _object.mirrorStartOffsets = _collection;
            for (JsonNode _element : _mirrorStartOffsetsNode) {
                _collection.add(MessageUtil.jsonNodeToLong((JsonNode)_element, (String)"MirrorTopicChangeRecord element"));
            }
        }
        JsonNode _mirrorTopicErrorNode = _node.get("mirrorTopicError");
        _object.mirrorTopicError = _mirrorTopicErrorNode == null ? (short)-1 : MessageUtil.jsonNodeToShort((JsonNode)_mirrorTopicErrorNode, (String)"MirrorTopicChangeRecord");
        JsonNode _nextStateNode = _node.get("nextState");
        if (_nextStateNode == null) {
            _object.nextState = null;
        } else if (_nextStateNode.isNull()) {
            _object.nextState = null;
        } else {
            if (!_nextStateNode.isTextual()) {
                throw new RuntimeException("MirrorTopicChangeRecord expected a string type, but got " + _node.getNodeType());
            }
            _object.nextState = _nextStateNode.asText();
        }
        JsonNode _stoppedEpochsNode = _node.get("stoppedEpochs");
        if (_stoppedEpochsNode == null) {
            _object.stoppedEpochs = null;
        } else if (_stoppedEpochsNode.isNull()) {
            _object.stoppedEpochs = null;
        } else {
            if (!_stoppedEpochsNode.isArray()) {
                throw new RuntimeException("MirrorTopicChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_stoppedEpochsNode.size());
            _object.stoppedEpochs = _collection;
            for (Object _element : _stoppedEpochsNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"MirrorTopicChangeRecord element"));
            }
        }
        JsonNode _truncationOffsetsNode = _node.get("truncationOffsets");
        if (_truncationOffsetsNode == null) {
            _object.truncationOffsets = null;
        } else if (_truncationOffsetsNode.isNull()) {
            _object.truncationOffsets = null;
        } else {
            if (!_truncationOffsetsNode.isArray()) {
                throw new RuntimeException("MirrorTopicChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Long> _collection = new ArrayList<Long>(_truncationOffsetsNode.size());
            _object.truncationOffsets = _collection;
            for (JsonNode _element : _truncationOffsetsNode) {
                _collection.add(MessageUtil.jsonNodeToLong((JsonNode)_element, (String)"MirrorTopicChangeRecord element"));
            }
        }
        JsonNode _truncationEpochsNode = _node.get("truncationEpochs");
        if (_truncationEpochsNode == null) {
            _object.truncationEpochs = null;
        } else if (_truncationEpochsNode.isNull()) {
            _object.truncationEpochs = null;
        } else {
            if (!_truncationEpochsNode.isArray()) {
                throw new RuntimeException("MirrorTopicChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_truncationEpochsNode.size());
            _object.truncationEpochs = _collection;
            for (JsonNode _element : _truncationEpochsNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"MirrorTopicChangeRecord element"));
            }
        }
        JsonNode _stoppedSequenceNumberNode = _node.get("stoppedSequenceNumber");
        _object.stoppedSequenceNumber = _stoppedSequenceNumberNode == null ? 0L : MessageUtil.jsonNodeToLong((JsonNode)_stoppedSequenceNumberNode, (String)"MirrorTopicChangeRecord");
        return _object;
    }

    public static JsonNode write(MirrorTopicChangeRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
        _node.set("topicName", (JsonNode)new TextNode(_object.topicName));
        _node.set("clusterLinkId", (JsonNode)new TextNode(_object.clusterLinkId.toString()));
        _node.set("clusterLinkName", (JsonNode)new TextNode(_object.clusterLinkName));
        _node.set("timeMs", (JsonNode)new LongNode(_object.timeMs));
        _node.set("mirrorTopicState", (JsonNode)new TextNode(_object.mirrorTopicState));
        if (_version >= 2) {
            _node.set("bumpPartitionLeaderEpochs", (JsonNode)BooleanNode.valueOf((boolean)_object.bumpPartitionLeaderEpochs));
        } else if (_object.bumpPartitionLeaderEpochs) {
            throw new UnsupportedVersionException("Attempted to write a non-default bumpPartitionLeaderEpochs at version " + _version);
        }
        if (_object.previousToPausedState != null) {
            _node.set("previousToPausedState", (JsonNode)new TextNode(_object.previousToPausedState));
        }
        if (_object.stoppedLogEndOffsets != null) {
            ArrayNode _stoppedLogEndOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Long l : _object.stoppedLogEndOffsets) {
                _stoppedLogEndOffsetsArray.add((JsonNode)new LongNode(l.longValue()));
            }
            _node.set("stoppedLogEndOffsets", (JsonNode)_stoppedLogEndOffsetsArray);
        }
        if (_object.promoted) {
            _node.set("promoted", (JsonNode)BooleanNode.valueOf((boolean)_object.promoted));
        }
        if (_object.topicLevelPause) {
            _node.set("topicLevelPause", (JsonNode)BooleanNode.valueOf((boolean)_object.topicLevelPause));
        }
        if (_object.linkLevelPause) {
            _node.set("linkLevelPause", (JsonNode)BooleanNode.valueOf((boolean)_object.linkLevelPause));
        }
        if (_object.mirrorStartOffsets != null) {
            ArrayNode _mirrorStartOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Long l : _object.mirrorStartOffsets) {
                _mirrorStartOffsetsArray.add((JsonNode)new LongNode(l.longValue()));
            }
            _node.set("mirrorStartOffsets", (JsonNode)_mirrorStartOffsetsArray);
        }
        if (_object.mirrorTopicError != -1) {
            _node.set("mirrorTopicError", (JsonNode)new ShortNode(_object.mirrorTopicError));
        }
        if (_object.nextState != null) {
            _node.set("nextState", (JsonNode)new TextNode(_object.nextState));
        }
        if (_object.stoppedEpochs != null) {
            ArrayNode _stoppedEpochsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.stoppedEpochs) {
                _stoppedEpochsArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("stoppedEpochs", (JsonNode)_stoppedEpochsArray);
        }
        if (_object.truncationOffsets != null) {
            ArrayNode _truncationOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Long l : _object.truncationOffsets) {
                _truncationOffsetsArray.add((JsonNode)new LongNode(l.longValue()));
            }
            _node.set("truncationOffsets", (JsonNode)_truncationOffsetsArray);
        }
        if (_object.truncationEpochs != null) {
            ArrayNode _truncationEpochsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.truncationEpochs) {
                _truncationEpochsArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("truncationEpochs", (JsonNode)_truncationEpochsArray);
        }
        if (_object.stoppedSequenceNumber != 0L) {
            _node.set("stoppedSequenceNumber", (JsonNode)new LongNode(_object.stoppedSequenceNumber));
        }
        return _node;
    }

    public static JsonNode write(MirrorTopicChangeRecord _object, short _version) {
        return MirrorTopicChangeRecordJsonConverter.write(_object, _version, true);
    }
}

