/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class TenantRecord
implements ApiMessage {
    int cellId;
    String tenantId;
    List<Integer> cellIds;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("cell_id", (Type)Type.INT32, "Deprecated : The single cell where all tenant partitions are hosted."), new Field("tenant_id", (Type)Type.COMPACT_STRING, "The tenant id for the tenant being registered."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("tenant_id", (Type)Type.COMPACT_STRING, "The tenant id for the tenant being registered."), new Field("cell_ids", (Type)new CompactArrayOf((Type)Type.INT32), "The array of cells where all tenant partitions are hosted."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public TenantRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public TenantRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public TenantRecord() {
        this.cellId = 0;
        this.tenantId = "";
        this.cellIds = new ArrayList<Integer>(0);
    }

    public short apiKey() {
        return 10018;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.cellId = _version <= 0 ? _readable.readInt() : 0;
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field tenantId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field tenantId had invalid length " + length);
        }
        this.tenantId = _readable.readString(length);
        if (_version >= 1) {
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field cellIds was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.cellIds = newCollection;
        } else {
            this.cellIds = new ArrayList<Integer>(0);
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version <= 0) {
            _writable.writeInt(this.cellId);
        } else if (this.cellId != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default cellId at version " + _version);
        }
        Object _stringBytes = _cache.getSerializedValue((Object)this.tenantId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        if (_version >= 1) {
            _writable.writeUnsignedVarint(this.cellIds.size() + 1);
            _stringBytes = this.cellIds.iterator();
            while (_stringBytes.hasNext()) {
                Integer cellIdsElement = (Integer)_stringBytes.next();
                _writable.writeInt(cellIdsElement.intValue());
            }
        } else if (!this.cellIds.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default cellIds at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        if (_version <= 0) {
            _size.addBytes(4);
        }
        if ((_stringBytes = this.tenantId.getBytes(StandardCharsets.UTF_8)).length > Short.MAX_VALUE) {
            throw new RuntimeException("'tenantId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.tenantId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        if (_version >= 1) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.cellIds.size() + 1)));
            _size.addBytes(this.cellIds.size() * 4);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TenantRecord)) {
            return false;
        }
        TenantRecord other = (TenantRecord)obj;
        if (this.cellId != other.cellId) {
            return false;
        }
        if (this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId)) {
            return false;
        }
        if (this.cellIds == null ? other.cellIds != null : !this.cellIds.equals(other.cellIds)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.cellId;
        hashCode = 31 * hashCode + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        hashCode = 31 * hashCode + (this.cellIds == null ? 0 : this.cellIds.hashCode());
        return hashCode;
    }

    public TenantRecord duplicate() {
        TenantRecord _duplicate = new TenantRecord();
        _duplicate.cellId = this.cellId;
        _duplicate.tenantId = this.tenantId;
        ArrayList<Integer> newCellIds = new ArrayList<Integer>(this.cellIds.size());
        for (Integer _element : this.cellIds) {
            newCellIds.add(_element);
        }
        _duplicate.cellIds = newCellIds;
        return _duplicate;
    }

    public String toString() {
        return "TenantRecord(cellId=" + this.cellId + ", tenantId=" + (this.tenantId == null ? "null" : "'" + this.tenantId.toString() + "'") + ", cellIds=" + MessageUtil.deepToString(this.cellIds.iterator()) + ")";
    }

    public int cellId() {
        return this.cellId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public List<Integer> cellIds() {
        return this.cellIds;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public TenantRecord setCellId(int v) {
        this.cellId = v;
        return this;
    }

    public TenantRecord setTenantId(String v) {
        this.tenantId = v;
        return this;
    }

    public TenantRecord setCellIds(List<Integer> v) {
        this.cellIds = v;
        return this;
    }
}

