/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.TenantRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class TenantRecordJsonConverter {
    public static TenantRecord read(JsonNode _node, short _version) {
        TenantRecord _object = new TenantRecord();
        JsonNode _cellIdNode = _node.get("cellId");
        if (_cellIdNode == null) {
            if (_version <= 0) {
                throw new RuntimeException("TenantRecord: unable to locate field 'cellId', which is mandatory in version " + _version);
            }
            _object.cellId = 0;
        } else {
            _object.cellId = MessageUtil.jsonNodeToInt((JsonNode)_cellIdNode, (String)"TenantRecord");
        }
        JsonNode _tenantIdNode = _node.get("tenantId");
        if (_tenantIdNode == null) {
            throw new RuntimeException("TenantRecord: unable to locate field 'tenantId', which is mandatory in version " + _version);
        }
        if (!_tenantIdNode.isTextual()) {
            throw new RuntimeException("TenantRecord expected a string type, but got " + _node.getNodeType());
        }
        _object.tenantId = _tenantIdNode.asText();
        JsonNode _cellIdsNode = _node.get("cellIds");
        if (_cellIdsNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("TenantRecord: unable to locate field 'cellIds', which is mandatory in version " + _version);
            }
            _object.cellIds = new ArrayList<Integer>(0);
        } else {
            if (!_cellIdsNode.isArray()) {
                throw new RuntimeException("TenantRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_cellIdsNode.size());
            _object.cellIds = _collection;
            for (JsonNode _element : _cellIdsNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"TenantRecord element"));
            }
        }
        return _object;
    }

    public static JsonNode write(TenantRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_version <= 0) {
            _node.set("cellId", (JsonNode)new IntNode(_object.cellId));
        } else if (_object.cellId != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default cellId at version " + _version);
        }
        _node.set("tenantId", (JsonNode)new TextNode(_object.tenantId));
        if (_version >= 1) {
            ArrayNode _cellIdsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.cellIds) {
                _cellIdsArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("cellIds", (JsonNode)_cellIdsArray);
        } else if (!_object.cellIds.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default cellIds at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(TenantRecord _object, short _version) {
        return TenantRecordJsonConverter.write(_object, _version, true);
    }
}

