/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.server.common.MetadataVersion;

public final class AclsDelta {
    private final AclsImage image;
    private final Map<Uuid, Optional<ConfluentStandardAcl>> changes = new LinkedHashMap<Uuid, Optional<ConfluentStandardAcl>>();

    public AclsDelta(AclsImage image) {
        this.image = image;
    }

    public Map<Uuid, Optional<ConfluentStandardAcl>> changes() {
        return this.changes;
    }

    void finishSnapshot() {
        for (Map.Entry<Uuid, ConfluentStandardAcl> entry : this.image.acls().entrySet()) {
            if (this.changes.containsKey(entry.getKey())) continue;
            this.changes.put(entry.getKey(), Optional.empty());
        }
    }

    public void handleMetadataVersionChange(MetadataVersion newVersion) {
    }

    public void replay(AccessControlEntryRecord record) {
        StandardAclWithId aclWithId = StandardAclWithId.fromRecord(record);
        this.changes.put(aclWithId.id(), Optional.of(aclWithId.acl()));
    }

    public void replay(RemoveAccessControlEntryRecord record) {
        if (this.image.acls().containsKey(record.id())) {
            this.changes.put(record.id(), Optional.empty());
        } else if (this.changes.containsKey(record.id())) {
            this.changes.remove(record.id());
        } else {
            throw new IllegalStateException("Failed to find existing ACL with ID " + record.id() + " in either image or changes");
        }
    }

    public void replay(RemoveClusterLinkRecord record) {
        Uuid linkId = record.clusterLinkId();
        if (linkId.equals((Object)Uuid.ZERO_UUID)) {
            throw new IllegalStateException("Trying to remove link information from ACLs for invalid link ID " + linkId);
        }
        HashSet localAcls = new HashSet();
        HashMap<Uuid, ConfluentStandardAcl> linkedAcls = new HashMap<Uuid, ConfluentStandardAcl>();
        this.image.acls().forEach((aclId, a) -> {
            Optional<ConfluentStandardAcl> acl = this.changes.getOrDefault(aclId, Optional.of(a));
            if (acl.isPresent()) {
                if (!acl.get().hasLinkId()) {
                    localAcls.add(acl.get());
                } else if (acl.get().clusterLinkId().equals(Optional.of(linkId))) {
                    linkedAcls.put((Uuid)aclId, acl.get());
                }
            }
        });
        this.changes.forEach((aclId, acl) -> {
            if (acl.isPresent()) {
                if (!((ConfluentStandardAcl)acl.get()).hasLinkId()) {
                    localAcls.add(acl.get());
                }
                if (((ConfluentStandardAcl)acl.get()).clusterLinkId().equals(Optional.of(linkId))) {
                    linkedAcls.put((Uuid)aclId, (ConfluentStandardAcl)acl.get());
                }
            }
        });
        linkedAcls.forEach((aclId, acl) -> {
            if (localAcls.contains(acl.toLocalAcl())) {
                this.changes.put((Uuid)aclId, Optional.empty());
            } else {
                this.changes.put((Uuid)aclId, Optional.of(acl.toLocalAcl()));
            }
        });
    }

    public AclsImage apply() {
        HashMap<Uuid, ConfluentStandardAcl> newAcls = new HashMap<Uuid, ConfluentStandardAcl>();
        for (Map.Entry<Uuid, ConfluentStandardAcl> entry : this.image.acls().entrySet()) {
            Optional<ConfluentStandardAcl> change = this.changes.get(entry.getKey());
            if (change == null) {
                newAcls.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!change.isPresent()) continue;
            newAcls.put(entry.getKey(), change.get());
        }
        for (Map.Entry<Uuid, Object> entry : this.changes.entrySet()) {
            if (newAcls.containsKey(entry.getKey()) || !((Optional)entry.getValue()).isPresent()) continue;
            newAcls.put(entry.getKey(), (ConfluentStandardAcl)((Optional)entry.getValue()).get());
        }
        return new AclsImage(newAcls);
    }

    public String toString() {
        return "AclsDelta(, changes=" + this.changes.entrySet().stream().map(e -> e.getKey() + "=" + e.getValue()).collect(Collectors.joining(", ")) + ")";
    }
}

