/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.metadata.CellMigrationRecord;
import org.apache.kafka.common.metadata.CellRecord;
import org.apache.kafka.common.metadata.RemoveCellRecord;
import org.apache.kafka.image.CellImage;

public class CellDelta {
    private final CellImage image;
    private final Map<Integer, Cell> changedCells;
    private final Set<Integer> deletedCells;
    private Optional<Byte> cellMigrationStateChange;

    public CellDelta(CellImage image) {
        this.image = image;
        this.changedCells = new HashMap<Integer, Cell>();
        this.deletedCells = new HashSet<Integer>();
        this.cellMigrationStateChange = Optional.empty();
    }

    public Map<Integer, Cell> changedCells() {
        return this.changedCells;
    }

    public Set<Integer> deletedCells() {
        return this.deletedCells;
    }

    public void replay(CellRecord record) {
        Cell cell = new Cell(record.cellId(), new HashSet<Integer>(record.brokers()), CellState.toEnum((byte)record.state()), record.minSize(), record.maxSize());
        this.changedCells.put(record.cellId(), cell);
        this.deletedCells.remove(record.cellId());
    }

    public void replay(RemoveCellRecord record) {
        this.changedCells.remove(record.cellId());
        this.deletedCells.add(record.cellId());
    }

    public void replay(CellMigrationRecord record) {
        this.cellMigrationStateChange = Optional.of(record.state());
    }

    public CellImage apply() {
        HashMap<Integer, Cell> newCellIdToCell = new HashMap<Integer, Cell>(this.image.cellIdToCell());
        newCellIdToCell.putAll(this.changedCells);
        this.deletedCells.forEach(id -> {
            Cell cfr_ignored_0 = (Cell)newCellIdToCell.remove(id);
        });
        return new CellImage(newCellIdToCell, this.cellMigrationStateChange.orElseGet(() -> this.image.cellMigrationState()));
    }

    public void finishSnapshot() {
        for (int cellId : this.image.cellIdToCell().keySet()) {
            if (this.changedCells.containsKey(cellId)) continue;
            this.deletedCells.add(cellId);
        }
    }

    public String toString() {
        return "CellImage(changedCells=" + this.changedCells + ", deletedCells=" + this.deletedCells + ", cellMigrationStateChange=" + this.cellMigrationStateChange + ")";
    }
}

