/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MirrorTopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;

public final class TopicDelta {
    private final TopicImage image;
    private final Map<Integer, PartitionRegistration> partitionChanges = new HashMap<Integer, PartitionRegistration>();
    private MirrorTopicDelta mirrorTopicDelta = MirrorTopicDelta.Unchanged.INSTANCE;

    public TopicDelta(TopicImage image) {
        this.image = image;
    }

    public TopicImage image() {
        return this.image;
    }

    public Map<Integer, PartitionRegistration> partitionChanges() {
        return this.partitionChanges;
    }

    public Map<Integer, PartitionRegistration> newPartitions() {
        return this.partitionChanges.entrySet().stream().filter(entry -> !this.image.partitions().containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String name() {
        return this.image.name();
    }

    public Uuid id() {
        return this.image.id();
    }

    public void replay(PartitionRecord record) {
        PartitionRegistration partition = new PartitionRegistration(record);
        if (partition.isMirror() && !this.latestMirrorTopicState().isPresent()) {
            throw new RuntimeException("Topic is not a mirror, but we saw linked partition state");
        }
        this.partitionChanges.put(record.partitionId(), partition);
    }

    public void replay(PartitionChangeRecord record) {
        PartitionRegistration partition = this.partitionChanges.get(record.partitionId());
        if (partition == null && (partition = this.image.partitions().get(record.partitionId())) == null) {
            throw new RuntimeException("Unable to find partition " + record.topicId() + ":" + record.partitionId());
        }
        if (partition.isMirror() && !this.latestMirrorTopicState().isPresent()) {
            throw new RuntimeException("Topic " + this.image.id() + " is not a mirror, but we saw linked partition state");
        }
        this.partitionChanges.put(record.partitionId(), partition.merge(record));
    }

    void replay(MirrorTopicRecord record, short version) {
        MirrorTopic.State newMirrorTopicState;
        if (this.latestMirrorTopicState().isPresent()) {
            throw new RuntimeException("Unable to set mirror topic state on topic " + record.topicId() + " because there is already existing mirror topic state: " + this.latestMirrorTopicState().get());
        }
        if (version >= 1 && (newMirrorTopicState = MirrorTopic.State.fromStateName(record.mirrorTopicState())).equals((Object)MirrorTopic.State.PENDING_MIRROR)) {
            this.partitionChanges.replaceAll((k, v) -> v.merge(record));
            for (Map.Entry<Integer, PartitionRegistration> entry : this.image.partitions().entrySet()) {
                this.partitionChanges.putIfAbsent(entry.getKey(), entry.getValue().merge(record));
            }
        }
        this.mirrorTopicDelta = new MirrorTopicDelta.Changed(Optional.of(MirrorTopic.fromRecord(record)));
    }

    void replay(MirrorTopicChangeRecord record, short version) {
        Optional<MirrorTopic> latestMirrorTopicState = this.latestMirrorTopicState();
        if (!latestMirrorTopicState.isPresent()) {
            throw new RuntimeException("Unable to modify mirror topic state on topic " + record.topicId() + " because there is no existing mirror topic state.");
        }
        this.mirrorTopicDelta = new MirrorTopicDelta.Changed(MirrorTopic.fromChangeRecord(latestMirrorTopicState.get(), record));
        if (version >= 1) {
            this.partitionChanges.replaceAll((k, v) -> v.merge(record));
            for (Map.Entry<Integer, PartitionRegistration> entry : this.image.partitions().entrySet()) {
                this.partitionChanges.putIfAbsent(entry.getKey(), entry.getValue().merge(record));
            }
        } else {
            for (Map.Entry<Integer, PartitionRegistration> entry : this.image.partitions().entrySet()) {
                this.partitionChanges.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
    }

    void replay(RemoveClusterLinkRecord record) {
        Optional<MirrorTopic> latestMirrorTopicState = this.latestMirrorTopicState();
        if (!latestMirrorTopicState.isPresent()) {
            throw new RuntimeException("Unable to remove mirror topic state on topic " + this.image.id() + ", because there is none.");
        }
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitionChanges.entrySet()) {
            this.partitionChanges.put(entry.getKey(), entry.getValue().unlink());
        }
        for (Map.Entry<Integer, PartitionRegistration> entry : this.image.partitions().entrySet()) {
            if (this.partitionChanges.containsKey(entry.getKey())) continue;
            this.partitionChanges.put(entry.getKey(), entry.getValue().unlink());
        }
        this.mirrorTopicDelta = this.image.mirrorTopic().isPresent() ? MirrorTopicDelta.Changed.REMOVED : MirrorTopicDelta.Unchanged.INSTANCE;
    }

    public TopicImage apply() {
        HashMap<Integer, PartitionRegistration> newPartitions = new HashMap<Integer, PartitionRegistration>();
        for (Map.Entry<Integer, PartitionRegistration> entry : this.image.partitions().entrySet()) {
            int partitionId = entry.getKey();
            PartitionRegistration changedPartition = this.partitionChanges.get(partitionId);
            if (changedPartition == null) {
                newPartitions.put(partitionId, entry.getValue());
                continue;
            }
            newPartitions.put(partitionId, changedPartition);
        }
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitionChanges.entrySet()) {
            if (newPartitions.containsKey(entry.getKey())) continue;
            newPartitions.put(entry.getKey(), entry.getValue());
        }
        return new TopicImage(this.image.name(), this.image.id(), this.image.topicType(), newPartitions, this.latestMirrorTopicState().orElse(null));
    }

    public boolean hasPartitionsWithAssignmentChanges() {
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitionChanges.entrySet()) {
            PartitionRegistration currentPartition;
            int partitionId = entry.getKey();
            if (!this.image.partitions().containsKey(partitionId)) {
                return true;
            }
            PartitionRegistration previousPartition = this.image.partitions().get(partitionId);
            if (previousPartition.hasSameAssignment(currentPartition = entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public LocalReplicaChanges localChanges(int brokerId) {
        HashSet<TopicPartition> deletes = new HashSet<TopicPartition>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> electedLeaders = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> leaders = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> followers = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        HashMap<TopicIdPartition, Uuid> directoryIds = new HashMap<TopicIdPartition, Uuid>();
        for (Map.Entry<Integer, PartitionRegistration> entry : this.partitionChanges.entrySet()) {
            PartitionRegistration prevPartition;
            if (!Replicas.contains(entry.getValue().replicas, brokerId)) {
                prevPartition = this.image.partitions().get(entry.getKey());
                if (prevPartition != null && Replicas.contains(prevPartition.replicas, brokerId)) {
                    deletes.add(new TopicPartition(this.name(), entry.getKey().intValue()));
                }
            } else if (entry.getValue().leader == brokerId) {
                prevPartition = this.image.partitions().get(entry.getKey());
                if (prevPartition == null || prevPartition.partitionEpoch != entry.getValue().partitionEpoch || this.mirrorTopicDelta.changed()) {
                    TopicPartition tp = new TopicPartition(this.name(), entry.getKey().intValue());
                    LocalReplicaChanges.PartitionInfo partitionInfo = new LocalReplicaChanges.PartitionInfo(this.id(), entry.getValue());
                    leaders.put(tp, partitionInfo);
                    if (prevPartition == null || prevPartition.leaderEpoch != entry.getValue().leaderEpoch) {
                        electedLeaders.put(tp, partitionInfo);
                    }
                    topicIds.putIfAbsent(this.name(), this.id());
                }
            } else {
                prevPartition = this.image.partitions().get(entry.getKey());
                if (prevPartition == null || prevPartition.partitionEpoch != entry.getValue().partitionEpoch || this.mirrorTopicDelta.changed()) {
                    followers.put(new TopicPartition(this.name(), entry.getKey().intValue()), new LocalReplicaChanges.PartitionInfo(this.id(), entry.getValue()));
                    topicIds.putIfAbsent(this.name(), this.id());
                }
            }
            try {
                prevPartition = this.image.partitions().get(entry.getKey());
                if (prevPartition != null && prevPartition.directories != null && prevPartition.directory(brokerId) == entry.getValue().directory(brokerId)) continue;
                directoryIds.put(new TopicIdPartition(this.id(), new TopicPartition(this.name(), entry.getKey().intValue())), entry.getValue().directory(brokerId));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return new LocalReplicaChanges(deletes, electedLeaders, leaders, followers, topicIds, directoryIds);
    }

    public MirrorTopicDelta mirrorTopicDelta() {
        return this.mirrorTopicDelta;
    }

    public Optional<MirrorTopic> latestMirrorTopicState() {
        if (!this.mirrorTopicDelta.changed()) {
            return this.image.mirrorTopic();
        }
        return ((MirrorTopicDelta.Changed)this.mirrorTopicDelta).newValue();
    }

    public String toString() {
        return "TopicDelta(partitionChanges=" + this.partitionChanges + ", mirrorTopicDelta=" + this.mirrorTopicDelta + ")";
    }
}

