/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.authorizer.AclStore;
import org.apache.kafka.metadata.authorizer.ResourceAcls;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.Visitor;
import org.apache.kafka.server.immutable.ImmutableNavigableMap;

final class PrefixNode
implements AclStore {
    static final PrefixNode EMPTY = new PrefixNode((ImmutableNavigableMap<String, PrefixNode>)ImmutableNavigableMap.empty(), "", ResourceAcls.EMPTY);
    private final ImmutableNavigableMap<String, PrefixNode> children;
    private final String name;
    private final ResourceAcls resourceAcls;

    PrefixNode(ImmutableNavigableMap<String, PrefixNode> children, String name, ResourceAcls resourceAcls) {
        this.children = children;
        this.name = name;
        this.resourceAcls = resourceAcls;
    }

    PrefixNode(String name, ResourceAcls resourceAcls, PrefixNode ... children) {
        ImmutableNavigableMap childrenMap = ImmutableNavigableMap.empty();
        for (PrefixNode child : children) {
            childrenMap = childrenMap.updated((Object)child.name(), (Object)child);
        }
        this.children = childrenMap;
        this.name = name;
        this.resourceAcls = resourceAcls;
    }

    @Override
    public boolean walk(Visitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Optional<StandardAcl> findMatchingAcl(AclOperation operation, String host) {
        return this.resourceAcls.findMatchingAcl(operation, host);
    }

    String name() {
        return this.name;
    }

    boolean isRoot() {
        return this.name.isEmpty();
    }

    ResourceAcls resourceAcls() {
        return this.resourceAcls;
    }

    ImmutableNavigableMap<String, PrefixNode> children() {
        return this.children;
    }

    public int hashCode() {
        return Objects.hash(this.children, this.name, this.resourceAcls);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        PrefixNode other = (PrefixNode)o;
        return this.name.equals(other.name) && this.resourceAcls.equals(other.resourceAcls) && this.children.equals(other.children);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PrefixNode");
        builder.append("(name=").append(this.name);
        builder.append(", resourceAcls=").append(this.resourceAcls);
        builder.append(", children=(");
        String prefix = "";
        for (Map.Entry entry : this.children.entrySet()) {
            builder.append(prefix).append("Entry(name=").append((String)entry.getKey());
            builder.append(", value=").append(entry.getValue()).append(")");
            prefix = ",";
        }
        builder.append(")");
        builder.append(")");
        return builder.toString();
    }

    public boolean isEmpty() {
        return this.resourceAcls.isEmpty() && this.children.isEmpty();
    }

    boolean validateAclCache(KafkaPrincipal principal, ResourceType resourceType, String name) {
        Resource parentResource = new Resource(resourceType, name);
        if (!this.resourceAcls.validateAclCache(principal, parentResource)) {
            return false;
        }
        for (Map.Entry childEntry : this.children.entrySet()) {
            String childPrefixName = (String)childEntry.getKey();
            PrefixNode childPrefixNode = (PrefixNode)childEntry.getValue();
            if (childPrefixNode.validateAclCache(principal, resourceType, childPrefixName)) continue;
            return false;
        }
        return true;
    }

    List<StandardAcl> acls() {
        ArrayList<StandardAcl> allAcls = new ArrayList<StandardAcl>(this.resourceAcls.acls());
        this.children.values().forEach(node -> allAcls.addAll(node.acls()));
        return allAcls;
    }
}

