/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.provider;

import io.spiffe.exception.SocketEndpointAddressException;
import io.spiffe.exception.X509SourceException;
import io.spiffe.provider.EnvironmentUtils;
import io.spiffe.provider.SpiffeSslContextFactory;
import io.spiffe.spiffeid.SpiffeId;
import io.spiffe.spiffeid.SpiffeIdUtils;
import io.spiffe.workloadapi.DefaultX509Source;
import io.spiffe.workloadapi.X509Source;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class SpiffeSslSocketFactory
extends SSLSocketFactory {
    @Generated
    private static final Logger log = Logger.getLogger(SpiffeSslSocketFactory.class.getName());
    private final SSLSocketFactory delegate;

    public SpiffeSslSocketFactory() throws SocketEndpointAddressException, X509SourceException, NoSuchAlgorithmException, KeyManagementException {
        SpiffeSslContextFactory.SslContextOptions options;
        log.log(Level.INFO, "Creating SpiffeSslSocketFactory");
        DefaultX509Source x509source = DefaultX509Source.newSource();
        String envProperty = EnvironmentUtils.getProperty("ssl.spiffe.accept");
        if (StringUtils.isNotBlank((CharSequence)envProperty)) {
            Supplier<Set<SpiffeId>> acceptedSpiffeIds = () -> SpiffeIdUtils.toSetOfSpiffeIds((String)envProperty, (char)',');
            options = SpiffeSslContextFactory.SslContextOptions.builder().acceptedSpiffeIdsSupplier(acceptedSpiffeIds).x509Source((X509Source)x509source).build();
        } else {
            options = SpiffeSslContextFactory.SslContextOptions.builder().acceptAnySpiffeId().x509Source((X509Source)x509source).build();
        }
        SSLContext sslContext = SpiffeSslContextFactory.getSslContext(options);
        this.delegate = sslContext.getSocketFactory();
    }

    public SpiffeSslSocketFactory(SpiffeSslContextFactory.SslContextOptions contextOptions) throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = SpiffeSslContextFactory.getSslContext(contextOptions);
        this.delegate = sslContext.getSocketFactory();
    }

    SpiffeSslSocketFactory(SSLSocketFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
        return this.delegate.createSocket(socket, s, i, b);
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this.delegate.createSocket(s, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException {
        return this.delegate.createSocket(s, i, inetAddress, i1);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        return this.delegate.createSocket(inetAddress, i);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        return this.delegate.createSocket(inetAddress, i, inetAddress1, i1);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.delegate.createSocket();
    }
}

