/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer.provider;

import io.confluent.security.authorizer.AccessRule;
import java.util.HashMap;
import java.util.Map;

public class ResourceAuthorizeRules {
    private Map<String, AccessRule> allowLiteralRules = new HashMap<String, AccessRule>();
    private Map<String, AccessRule> denyLiteralRules = new HashMap<String, AccessRule>();
    private Map<String, AccessRule> allowPrefixedRules = new HashMap<String, AccessRule>();
    private Map<String, AccessRule> denyPrefixedRules = new HashMap<String, AccessRule>();

    public Map<String, AccessRule> allowLiteralRules() {
        return this.allowLiteralRules;
    }

    public Map<String, AccessRule> denyLiteralRules() {
        return this.denyLiteralRules;
    }

    public Map<String, AccessRule> allowPrefixedRules() {
        return this.allowPrefixedRules;
    }

    public Map<String, AccessRule> denyPrefixedRules() {
        return this.denyPrefixedRules;
    }

    public void addRuleIfNotExist(AccessRule rule) {
        Map<String, AccessRule> map;
        block0 : switch (rule.permissionType()) {
            case DENY: {
                switch (rule.resourcePattern().patternType()) {
                    case LITERAL: {
                        map = this.denyLiteralRules;
                        break block0;
                    }
                    case PREFIXED: {
                        map = this.denyPrefixedRules;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unsupported access rule pattern type " + rule.resourcePattern().patternType());
            }
            case ALLOW: {
                switch (rule.resourcePattern().patternType()) {
                    case LITERAL: {
                        map = this.allowLiteralRules;
                        break block0;
                    }
                    case PREFIXED: {
                        map = this.allowPrefixedRules;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unsupported access rule pattern type " + rule.resourcePattern().patternType());
            }
            default: {
                throw new IllegalArgumentException("Unsupported access rule permission type " + rule.permissionType());
            }
        }
        map.putIfAbsent(rule.resourcePattern().name(), rule);
    }

    public String toString() {
        return "ResourceAuthorizeRules{denyLiterals=" + this.denyLiteralRules + ", denyPrefixes=" + this.denyPrefixedRules + ", allowLiterals=" + this.allowLiteralRules + ", allowPrefixes=" + this.allowPrefixedRules + '}';
    }
}

