/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.events;

import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.events.EventLoggerConfig;
import io.confluent.telemetry.events.exporter.Exporter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;

public class EventLogger
implements Reconfigurable,
AutoCloseable {
    private final Function<EventLoggerConfig, Exporter<Event>> exporterFactory;
    private volatile Exporter<Event> exporter;

    public EventLogger() {
        this(config -> (Exporter)config.getConfiguredInstance("event.logger.exporter.class", Exporter.class));
    }

    public EventLogger(Function<EventLoggerConfig, Exporter<Event>> exporterFactory) {
        this.exporterFactory = exporterFactory;
    }

    private void ensureConfigured() {
        if (this.exporter == null) {
            throw new IllegalStateException("EventLogger is not configured yet");
        }
    }

    public void log(Event event) {
        this.ensureConfigured();
        this.exporter.emit(event);
    }

    public CompletableFuture<Boolean> logAndGetFuture(Event event) {
        this.ensureConfigured();
        return this.exporter.emit(event);
    }

    public boolean ready(Event event) {
        return this.exporter != null && this.exporter.routeReady(event);
    }

    public Set<String> reconfigurableConfigs() {
        this.ensureConfigured();
        return this.exporter.reconfigurableConfigs();
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        this.ensureConfigured();
        this.exporter.validateReconfiguration(configs);
    }

    public void reconfigure(Map<String, ?> configs) {
        this.ensureConfigured();
        this.exporter.reconfigure(configs);
    }

    public synchronized void configure(Map<String, ?> configs) {
        if (this.exporter != null) {
            throw new IllegalStateException("EventLogger is already configured");
        }
        EventLoggerConfig config = new EventLoggerConfig(configs);
        this.exporter = this.exporterFactory.apply(config);
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.exporter != null) {
            this.exporter.close();
        }
    }

    public Exporter<Event> eventExporter() {
        return this.exporter;
    }
}

