/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.events.exporter.log;

import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.events.EventUtils;
import io.confluent.telemetry.events.exporter.Exporter;
import io.confluent.telemetry.events.exporter.log.LogExporterConfig;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogExporter
implements Exporter<Event> {
    private Logger log = LoggerFactory.getLogger(LogExporter.class);

    public void configure(Map<String, ?> configs) {
        LogExporterConfig config = new LogExporterConfig(configs);
        this.log = LoggerFactory.getLogger((String)config.getString("event.logger.exporter.log.name"));
    }

    @Override
    public CompletableFuture<Boolean> emit(Event event) {
        this.log.info(EventUtils.toJson(event));
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public boolean routeReady(Event event) {
        return true;
    }

    @Override
    public void close() throws Exception {
    }

    public Set<String> reconfigurableConfigs() {
        return Utils.mkSet((Object[])new String[]{"event.logger.exporter.log.name"});
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    public void reconfigure(Map<String, ?> configs) {
        this.configure(configs);
    }
}

