/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.config.v2.remote;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.telemetry.config.v2.AggregationRule;
import io.confluent.telemetry.config.v2.ExporterConfig;
import io.confluent.telemetry.config.v2.NamedClientConfig;
import io.confluent.telemetry.config.v2.NamedFilter;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RemoteConfiguration {
    private static final String schemaVersion = "2";
    private final Set<String> activeFilters;
    private final Set<NamedFilter> filters;
    private final Set<ExporterConfig> exporters;
    private final Set<NamedClientConfig> clients;
    private final Set<AggregationRule> aggregationRules;

    public RemoteConfiguration() {
        this(Collections.emptySet(), Collections.singleton("_default"), null, null, null);
    }

    @JsonCreator
    public RemoteConfiguration(@JsonProperty(value="filters") Set<NamedFilter> filters, @JsonProperty(value="activeFilters") Set<String> activeFilters, @JsonProperty(value="exporters") Set<ExporterConfig> exporters, @JsonProperty(value="clients") Set<NamedClientConfig> clients, @JsonProperty(value="aggregations") Set<AggregationRule> aggregationRules) {
        this.filters = filters == null ? Collections.emptySet() : filters;
        this.activeFilters = activeFilters == null ? Collections.singleton("_default") : activeFilters;
        this.exporters = exporters == null ? Collections.emptySet() : exporters;
        this.clients = clients == null ? Collections.emptySet() : clients;
        this.aggregationRules = aggregationRules == null ? Collections.emptySet() : aggregationRules;
    }

    public Set<String> getActiveFilters() {
        return this.activeFilters;
    }

    public Set<NamedFilter> getFilters() {
        return this.filters;
    }

    public Set<ExporterConfig> getExporters() {
        return this.exporters;
    }

    public Set<NamedClientConfig> getClients() {
        return this.clients;
    }

    public Set<AggregationRule> getAggregationRules() {
        return this.aggregationRules;
    }

    @JsonIgnore
    public Map<String, ExporterConfig> getExporterConfigMap() {
        return this.exporters.stream().collect(Collectors.toMap(ExporterConfig::getName, Function.identity()));
    }

    @JsonIgnore
    public Map<String, NamedClientConfig> getNamedClientConfigMap() {
        return this.clients.stream().collect(Collectors.toMap(NamedClientConfig::getName, Function.identity()));
    }

    @JsonIgnore
    public static String getSchemaVersion() {
        return schemaVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteConfiguration)) {
            return false;
        }
        RemoteConfiguration that = (RemoteConfiguration)o;
        return Objects.equals(this.activeFilters, that.activeFilters) && Objects.equals(this.filters, that.filters) && Objects.equals(this.exporters, that.exporters) && Objects.equals(this.clients, that.clients);
    }

    public int hashCode() {
        return Objects.hash(this.activeFilters, this.filters, this.exporters, this.clients);
    }
}

