/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.protobuf.events.notifications.v1;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import io.confluent.protobuf.events.notifications.v1.NotificationOrBuilder;
import io.confluent.protobuf.events.notifications.v1.NotificationProto;
import io.confluent.protobuf.events.notifications.v1.Recipient;
import io.confluent.protobuf.events.notifications.v1.RecipientOrBuilder;
import io.confluent.protobuf.events.notifications.v1.TemplateVersion;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Notification
extends GeneratedMessageV3
implements NotificationOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int ORG_ID_FIELD_NUMBER = 1;
    private volatile Object orgId_;
    public static final int TYPE_FIELD_NUMBER = 2;
    private volatile Object type_;
    public static final int TITLE_FIELD_NUMBER = 3;
    private volatile Object title_;
    public static final int MESSAGE_FIELD_NUMBER = 4;
    private volatile Object message_;
    public static final int RESOURCE_FIELD_NUMBER = 5;
    private volatile Object resource_;
    public static final int CREATED_AT_FIELD_NUMBER = 6;
    private Timestamp createdAt_;
    public static final int LABELS_FIELD_NUMBER = 7;
    private MapField<String, String> labels_;
    public static final int ORG_RESOURCE_ID_FIELD_NUMBER = 8;
    private volatile Object orgResourceId_;
    public static final int TEMPLATE_VERSION_FIELD_NUMBER = 9;
    private int templateVersion_;
    public static final int RECIPIENTS_FIELD_NUMBER = 10;
    private List<Recipient> recipients_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Notification DEFAULT_INSTANCE = new Notification();
    private static final Parser<Notification> PARSER = new AbstractParser<Notification>(){

        public Notification parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new Notification(input, extensionRegistry);
        }
    };

    private Notification(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Notification() {
        this.orgId_ = "";
        this.type_ = "";
        this.title_ = "";
        this.message_ = "";
        this.resource_ = "";
        this.orgResourceId_ = "";
        this.templateVersion_ = 0;
        this.recipients_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Notification();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private Notification(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block19: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block19;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.orgId_ = s;
                        continue block19;
                    }
                    case 18: {
                        String s = input.readStringRequireUtf8();
                        this.type_ = s;
                        continue block19;
                    }
                    case 26: {
                        String s = input.readStringRequireUtf8();
                        this.title_ = s;
                        continue block19;
                    }
                    case 34: {
                        String s = input.readStringRequireUtf8();
                        this.message_ = s;
                        continue block19;
                    }
                    case 42: {
                        String s = input.readStringRequireUtf8();
                        this.resource_ = s;
                        continue block19;
                    }
                    case 50: {
                        Timestamp.Builder subBuilder = null;
                        if (this.createdAt_ != null) {
                            subBuilder = this.createdAt_.toBuilder();
                        }
                        this.createdAt_ = (Timestamp)input.readMessage(Timestamp.parser(), extensionRegistry);
                        if (subBuilder == null) continue block19;
                        subBuilder.mergeFrom(this.createdAt_);
                        this.createdAt_ = subBuilder.buildPartial();
                        continue block19;
                    }
                    case 58: {
                        if ((mutable_bitField0_ & 1) == 0) {
                            this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                            mutable_bitField0_ |= 1;
                        }
                        MapEntry labels__ = (MapEntry)input.readMessage(LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                        this.labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
                        continue block19;
                    }
                    case 66: {
                        String s = input.readStringRequireUtf8();
                        this.orgResourceId_ = s;
                        continue block19;
                    }
                    case 72: {
                        int rawValue;
                        this.templateVersion_ = rawValue = input.readEnum();
                        continue block19;
                    }
                    case 82: {
                        if ((mutable_bitField0_ & 2) == 0) {
                            this.recipients_ = new ArrayList<Recipient>();
                            mutable_bitField0_ |= 2;
                        }
                        this.recipients_.add((Recipient)input.readMessage(Recipient.parser(), extensionRegistry));
                        continue block19;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if ((mutable_bitField0_ & 2) != 0) {
                this.recipients_ = Collections.unmodifiableList(this.recipients_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return NotificationProto.internal_static_notifications_v1_Notification_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 7: {
                return this.internalGetLabels();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return NotificationProto.internal_static_notifications_v1_Notification_fieldAccessorTable.ensureFieldAccessorsInitialized(Notification.class, Builder.class);
    }

    @Override
    public String getOrgId() {
        Object ref = this.orgId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.orgId_ = s;
        return s;
    }

    @Override
    public ByteString getOrgIdBytes() {
        Object ref = this.orgId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.orgId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getType() {
        Object ref = this.type_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.type_ = s;
        return s;
    }

    @Override
    public ByteString getTypeBytes() {
        Object ref = this.type_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.type_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getTitle() {
        Object ref = this.title_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.title_ = s;
        return s;
    }

    @Override
    public ByteString getTitleBytes() {
        Object ref = this.title_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.title_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getMessage() {
        Object ref = this.message_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.message_ = s;
        return s;
    }

    @Override
    public ByteString getMessageBytes() {
        Object ref = this.message_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.message_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getResource() {
        Object ref = this.resource_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resource_ = s;
        return s;
    }

    @Override
    public ByteString getResourceBytes() {
        Object ref = this.resource_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resource_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasCreatedAt() {
        return this.createdAt_ != null;
    }

    @Override
    public Timestamp getCreatedAt() {
        return this.createdAt_ == null ? Timestamp.getDefaultInstance() : this.createdAt_;
    }

    @Override
    public TimestampOrBuilder getCreatedAtOrBuilder() {
        return this.getCreatedAt();
    }

    private MapField<String, String> internalGetLabels() {
        if (this.labels_ == null) {
            return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.internalGetLabels().getMap().size();
    }

    @Override
    public boolean containsLabels(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getLabels() {
        return this.getLabelsMap();
    }

    @Override
    public Map<String, String> getLabelsMap() {
        return this.internalGetLabels().getMap();
    }

    @Override
    public String getLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public String getOrgResourceId() {
        Object ref = this.orgResourceId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.orgResourceId_ = s;
        return s;
    }

    @Override
    public ByteString getOrgResourceIdBytes() {
        Object ref = this.orgResourceId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.orgResourceId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getTemplateVersionValue() {
        return this.templateVersion_;
    }

    @Override
    public TemplateVersion getTemplateVersion() {
        TemplateVersion result = TemplateVersion.valueOf(this.templateVersion_);
        return result == null ? TemplateVersion.UNRECOGNIZED : result;
    }

    @Override
    public List<Recipient> getRecipientsList() {
        return this.recipients_;
    }

    @Override
    public List<? extends RecipientOrBuilder> getRecipientsOrBuilderList() {
        return this.recipients_;
    }

    @Override
    public int getRecipientsCount() {
        return this.recipients_.size();
    }

    @Override
    public Recipient getRecipients(int index) {
        return this.recipients_.get(index);
    }

    @Override
    public RecipientOrBuilder getRecipientsOrBuilder(int index) {
        return this.recipients_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orgId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.orgId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.type_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.type_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.title_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.title_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.message_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.message_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resource_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.resource_);
        }
        if (this.createdAt_ != null) {
            output.writeMessage(6, (MessageLite)this.getCreatedAt());
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, (int)7);
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orgResourceId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.orgResourceId_);
        }
        if (this.templateVersion_ != TemplateVersion.UNKNOWN.getNumber()) {
            output.writeEnum(9, this.templateVersion_);
        }
        for (int i = 0; i < this.recipients_.size(); ++i) {
            output.writeMessage(10, (MessageLite)this.recipients_.get(i));
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orgId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.orgId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.type_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.type_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.title_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.title_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.message_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.message_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resource_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.resource_);
        }
        if (this.createdAt_ != null) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getCreatedAt());
        }
        for (Map.Entry entry : this.internalGetLabels().getMap().entrySet()) {
            MapEntry labels__ = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)labels__);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.orgResourceId_)) {
            size += GeneratedMessageV3.computeStringSize((int)8, (Object)this.orgResourceId_);
        }
        if (this.templateVersion_ != TemplateVersion.UNKNOWN.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)9, (int)this.templateVersion_);
        }
        for (int i = 0; i < this.recipients_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)((MessageLite)this.recipients_.get(i)));
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Notification)) {
            return super.equals(obj);
        }
        Notification other = (Notification)obj;
        if (!this.getOrgId().equals(other.getOrgId())) {
            return false;
        }
        if (!this.getType().equals(other.getType())) {
            return false;
        }
        if (!this.getTitle().equals(other.getTitle())) {
            return false;
        }
        if (!this.getMessage().equals(other.getMessage())) {
            return false;
        }
        if (!this.getResource().equals(other.getResource())) {
            return false;
        }
        if (this.hasCreatedAt() != other.hasCreatedAt()) {
            return false;
        }
        if (this.hasCreatedAt() && !this.getCreatedAt().equals((Object)other.getCreatedAt())) {
            return false;
        }
        if (!this.internalGetLabels().equals(other.internalGetLabels())) {
            return false;
        }
        if (!this.getOrgResourceId().equals(other.getOrgResourceId())) {
            return false;
        }
        if (this.templateVersion_ != other.templateVersion_) {
            return false;
        }
        if (!this.getRecipientsList().equals(other.getRecipientsList())) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Notification.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getOrgId().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getType().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getTitle().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getMessage().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getResource().hashCode();
        if (this.hasCreatedAt()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getCreatedAt().hashCode();
        }
        if (!this.internalGetLabels().getMap().isEmpty()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.internalGetLabels().hashCode();
        }
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getOrgResourceId().hashCode();
        hash = 37 * hash + 9;
        hash = 53 * hash + this.templateVersion_;
        if (this.getRecipientsCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getRecipientsList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static Notification parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Notification)PARSER.parseFrom(data);
    }

    public static Notification parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Notification)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Notification parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Notification)PARSER.parseFrom(data);
    }

    public static Notification parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Notification)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Notification parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Notification)PARSER.parseFrom(data);
    }

    public static Notification parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Notification)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Notification parseFrom(InputStream input) throws IOException {
        return (Notification)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Notification parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Notification)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Notification parseDelimitedFrom(InputStream input) throws IOException {
        return (Notification)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Notification parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Notification)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Notification parseFrom(CodedInputStream input) throws IOException {
        return (Notification)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Notification parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Notification)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Notification.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Notification prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Notification getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Notification> parser() {
        return PARSER;
    }

    public Parser<Notification> getParserForType() {
        return PARSER;
    }

    public Notification getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements NotificationOrBuilder {
        private int bitField0_;
        private Object orgId_ = "";
        private Object type_ = "";
        private Object title_ = "";
        private Object message_ = "";
        private Object resource_ = "";
        private Timestamp createdAt_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> createdAtBuilder_;
        private MapField<String, String> labels_;
        private Object orgResourceId_ = "";
        private int templateVersion_ = 0;
        private List<Recipient> recipients_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Recipient, Recipient.Builder, RecipientOrBuilder> recipientsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return NotificationProto.internal_static_notifications_v1_Notification_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 7: {
                    return this.internalGetLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 7: {
                    return this.internalGetMutableLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return NotificationProto.internal_static_notifications_v1_Notification_fieldAccessorTable.ensureFieldAccessorsInitialized(Notification.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getRecipientsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.orgId_ = "";
            this.type_ = "";
            this.title_ = "";
            this.message_ = "";
            this.resource_ = "";
            if (this.createdAtBuilder_ == null) {
                this.createdAt_ = null;
            } else {
                this.createdAt_ = null;
                this.createdAtBuilder_ = null;
            }
            this.internalGetMutableLabels().clear();
            this.orgResourceId_ = "";
            this.templateVersion_ = 0;
            if (this.recipientsBuilder_ == null) {
                this.recipients_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
            } else {
                this.recipientsBuilder_.clear();
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return NotificationProto.internal_static_notifications_v1_Notification_descriptor;
        }

        public Notification getDefaultInstanceForType() {
            return Notification.getDefaultInstance();
        }

        public Notification build() {
            Notification result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Notification buildPartial() {
            Notification result = new Notification(this);
            int from_bitField0_ = this.bitField0_;
            result.orgId_ = this.orgId_;
            result.type_ = this.type_;
            result.title_ = this.title_;
            result.message_ = this.message_;
            result.resource_ = this.resource_;
            if (this.createdAtBuilder_ == null) {
                result.createdAt_ = this.createdAt_;
            } else {
                result.createdAt_ = (Timestamp)this.createdAtBuilder_.build();
            }
            result.labels_ = this.internalGetLabels();
            result.labels_.makeImmutable();
            result.orgResourceId_ = this.orgResourceId_;
            result.templateVersion_ = this.templateVersion_;
            if (this.recipientsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.recipients_ = Collections.unmodifiableList(this.recipients_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.recipients_ = this.recipients_;
            } else {
                result.recipients_ = this.recipientsBuilder_.build();
            }
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Notification) {
                return this.mergeFrom((Notification)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Notification other) {
            if (other == Notification.getDefaultInstance()) {
                return this;
            }
            if (!other.getOrgId().isEmpty()) {
                this.orgId_ = other.orgId_;
                this.onChanged();
            }
            if (!other.getType().isEmpty()) {
                this.type_ = other.type_;
                this.onChanged();
            }
            if (!other.getTitle().isEmpty()) {
                this.title_ = other.title_;
                this.onChanged();
            }
            if (!other.getMessage().isEmpty()) {
                this.message_ = other.message_;
                this.onChanged();
            }
            if (!other.getResource().isEmpty()) {
                this.resource_ = other.resource_;
                this.onChanged();
            }
            if (other.hasCreatedAt()) {
                this.mergeCreatedAt(other.getCreatedAt());
            }
            this.internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            if (!other.getOrgResourceId().isEmpty()) {
                this.orgResourceId_ = other.orgResourceId_;
                this.onChanged();
            }
            if (other.templateVersion_ != 0) {
                this.setTemplateVersionValue(other.getTemplateVersionValue());
            }
            if (this.recipientsBuilder_ == null) {
                if (!other.recipients_.isEmpty()) {
                    if (this.recipients_.isEmpty()) {
                        this.recipients_ = other.recipients_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureRecipientsIsMutable();
                        this.recipients_.addAll(other.recipients_);
                    }
                    this.onChanged();
                }
            } else if (!other.recipients_.isEmpty()) {
                if (this.recipientsBuilder_.isEmpty()) {
                    this.recipientsBuilder_.dispose();
                    this.recipientsBuilder_ = null;
                    this.recipients_ = other.recipients_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.recipientsBuilder_ = alwaysUseFieldBuilders ? this.getRecipientsFieldBuilder() : null;
                } else {
                    this.recipientsBuilder_.addAllMessages((Iterable)other.recipients_);
                }
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            Notification parsedMessage = null;
            try {
                parsedMessage = (Notification)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (Notification)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getOrgId() {
            Object ref = this.orgId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.orgId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOrgIdBytes() {
            Object ref = this.orgId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.orgId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOrgId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.orgId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearOrgId() {
            this.orgId_ = Notification.getDefaultInstance().getOrgId();
            this.onChanged();
            return this;
        }

        public Builder setOrgIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Notification.checkByteStringIsUtf8((ByteString)value);
            this.orgId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getType() {
            Object ref = this.type_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.type_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTypeBytes() {
            Object ref = this.type_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.type_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setType(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.type_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.type_ = Notification.getDefaultInstance().getType();
            this.onChanged();
            return this;
        }

        public Builder setTypeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Notification.checkByteStringIsUtf8((ByteString)value);
            this.type_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getTitle() {
            Object ref = this.title_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.title_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTitleBytes() {
            Object ref = this.title_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.title_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTitle(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.title_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearTitle() {
            this.title_ = Notification.getDefaultInstance().getTitle();
            this.onChanged();
            return this;
        }

        public Builder setTitleBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Notification.checkByteStringIsUtf8((ByteString)value);
            this.title_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getMessage() {
            Object ref = this.message_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.message_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMessageBytes() {
            Object ref = this.message_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.message_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMessage(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.message_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearMessage() {
            this.message_ = Notification.getDefaultInstance().getMessage();
            this.onChanged();
            return this;
        }

        public Builder setMessageBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Notification.checkByteStringIsUtf8((ByteString)value);
            this.message_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getResource() {
            Object ref = this.resource_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resource_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceBytes() {
            Object ref = this.resource_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resource_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResource(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resource_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearResource() {
            this.resource_ = Notification.getDefaultInstance().getResource();
            this.onChanged();
            return this;
        }

        public Builder setResourceBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Notification.checkByteStringIsUtf8((ByteString)value);
            this.resource_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCreatedAt() {
            return this.createdAtBuilder_ != null || this.createdAt_ != null;
        }

        @Override
        public Timestamp getCreatedAt() {
            if (this.createdAtBuilder_ == null) {
                return this.createdAt_ == null ? Timestamp.getDefaultInstance() : this.createdAt_;
            }
            return (Timestamp)this.createdAtBuilder_.getMessage();
        }

        public Builder setCreatedAt(Timestamp value) {
            if (this.createdAtBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.createdAt_ = value;
                this.onChanged();
            } else {
                this.createdAtBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setCreatedAt(Timestamp.Builder builderForValue) {
            if (this.createdAtBuilder_ == null) {
                this.createdAt_ = builderForValue.build();
                this.onChanged();
            } else {
                this.createdAtBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeCreatedAt(Timestamp value) {
            if (this.createdAtBuilder_ == null) {
                this.createdAt_ = this.createdAt_ != null ? Timestamp.newBuilder((Timestamp)this.createdAt_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.createdAtBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearCreatedAt() {
            if (this.createdAtBuilder_ == null) {
                this.createdAt_ = null;
                this.onChanged();
            } else {
                this.createdAt_ = null;
                this.createdAtBuilder_ = null;
            }
            return this;
        }

        public Timestamp.Builder getCreatedAtBuilder() {
            this.onChanged();
            return (Timestamp.Builder)this.getCreatedAtFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreatedAtOrBuilder() {
            if (this.createdAtBuilder_ != null) {
                return (TimestampOrBuilder)this.createdAtBuilder_.getMessageOrBuilder();
            }
            return this.createdAt_ == null ? Timestamp.getDefaultInstance() : this.createdAt_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreatedAtFieldBuilder() {
            if (this.createdAtBuilder_ == null) {
                this.createdAtBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreatedAt(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.createdAt_ = null;
            }
            return this.createdAtBuilder_;
        }

        private MapField<String, String> internalGetLabels() {
            if (this.labels_ == null) {
                return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            return this.labels_;
        }

        private MapField<String, String> internalGetMutableLabels() {
            this.onChanged();
            if (this.labels_ == null) {
                this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.labels_.isMutable()) {
                this.labels_ = this.labels_.copy();
            }
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.internalGetLabels().getMap().size();
        }

        @Override
        public boolean containsLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getLabels() {
            return this.getLabelsMap();
        }

        @Override
        public Map<String, String> getLabelsMap() {
            return this.internalGetLabels().getMap();
        }

        @Override
        public String getLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearLabels() {
            this.internalGetMutableLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableLabels() {
            return this.internalGetMutableLabels().getMutableMap();
        }

        public Builder putLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableLabels().getMutableMap().put(key, value);
            return this;
        }

        public Builder putAllLabels(Map<String, String> values) {
            this.internalGetMutableLabels().getMutableMap().putAll(values);
            return this;
        }

        @Override
        public String getOrgResourceId() {
            Object ref = this.orgResourceId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.orgResourceId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOrgResourceIdBytes() {
            Object ref = this.orgResourceId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.orgResourceId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOrgResourceId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.orgResourceId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearOrgResourceId() {
            this.orgResourceId_ = Notification.getDefaultInstance().getOrgResourceId();
            this.onChanged();
            return this;
        }

        public Builder setOrgResourceIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Notification.checkByteStringIsUtf8((ByteString)value);
            this.orgResourceId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getTemplateVersionValue() {
            return this.templateVersion_;
        }

        public Builder setTemplateVersionValue(int value) {
            this.templateVersion_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public TemplateVersion getTemplateVersion() {
            TemplateVersion result = TemplateVersion.valueOf(this.templateVersion_);
            return result == null ? TemplateVersion.UNRECOGNIZED : result;
        }

        public Builder setTemplateVersion(TemplateVersion value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.templateVersion_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearTemplateVersion() {
            this.templateVersion_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureRecipientsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.recipients_ = new ArrayList<Recipient>(this.recipients_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<Recipient> getRecipientsList() {
            if (this.recipientsBuilder_ == null) {
                return Collections.unmodifiableList(this.recipients_);
            }
            return this.recipientsBuilder_.getMessageList();
        }

        @Override
        public int getRecipientsCount() {
            if (this.recipientsBuilder_ == null) {
                return this.recipients_.size();
            }
            return this.recipientsBuilder_.getCount();
        }

        @Override
        public Recipient getRecipients(int index) {
            if (this.recipientsBuilder_ == null) {
                return this.recipients_.get(index);
            }
            return (Recipient)this.recipientsBuilder_.getMessage(index);
        }

        public Builder setRecipients(int index, Recipient value) {
            if (this.recipientsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRecipientsIsMutable();
                this.recipients_.set(index, value);
                this.onChanged();
            } else {
                this.recipientsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setRecipients(int index, Recipient.Builder builderForValue) {
            if (this.recipientsBuilder_ == null) {
                this.ensureRecipientsIsMutable();
                this.recipients_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.recipientsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRecipients(Recipient value) {
            if (this.recipientsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRecipientsIsMutable();
                this.recipients_.add(value);
                this.onChanged();
            } else {
                this.recipientsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addRecipients(int index, Recipient value) {
            if (this.recipientsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRecipientsIsMutable();
                this.recipients_.add(index, value);
                this.onChanged();
            } else {
                this.recipientsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addRecipients(Recipient.Builder builderForValue) {
            if (this.recipientsBuilder_ == null) {
                this.ensureRecipientsIsMutable();
                this.recipients_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.recipientsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRecipients(int index, Recipient.Builder builderForValue) {
            if (this.recipientsBuilder_ == null) {
                this.ensureRecipientsIsMutable();
                this.recipients_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.recipientsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllRecipients(Iterable<? extends Recipient> values) {
            if (this.recipientsBuilder_ == null) {
                this.ensureRecipientsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.recipients_);
                this.onChanged();
            } else {
                this.recipientsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearRecipients() {
            if (this.recipientsBuilder_ == null) {
                this.recipients_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.recipientsBuilder_.clear();
            }
            return this;
        }

        public Builder removeRecipients(int index) {
            if (this.recipientsBuilder_ == null) {
                this.ensureRecipientsIsMutable();
                this.recipients_.remove(index);
                this.onChanged();
            } else {
                this.recipientsBuilder_.remove(index);
            }
            return this;
        }

        public Recipient.Builder getRecipientsBuilder(int index) {
            return (Recipient.Builder)this.getRecipientsFieldBuilder().getBuilder(index);
        }

        @Override
        public RecipientOrBuilder getRecipientsOrBuilder(int index) {
            if (this.recipientsBuilder_ == null) {
                return this.recipients_.get(index);
            }
            return (RecipientOrBuilder)this.recipientsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends RecipientOrBuilder> getRecipientsOrBuilderList() {
            if (this.recipientsBuilder_ != null) {
                return this.recipientsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.recipients_);
        }

        public Recipient.Builder addRecipientsBuilder() {
            return (Recipient.Builder)this.getRecipientsFieldBuilder().addBuilder((AbstractMessage)Recipient.getDefaultInstance());
        }

        public Recipient.Builder addRecipientsBuilder(int index) {
            return (Recipient.Builder)this.getRecipientsFieldBuilder().addBuilder(index, (AbstractMessage)Recipient.getDefaultInstance());
        }

        public List<Recipient.Builder> getRecipientsBuilderList() {
            return this.getRecipientsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Recipient, Recipient.Builder, RecipientOrBuilder> getRecipientsFieldBuilder() {
            if (this.recipientsBuilder_ == null) {
                this.recipientsBuilder_ = new RepeatedFieldBuilderV3(this.recipients_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.recipients_ = null;
            }
            return this.recipientsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class LabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)NotificationProto.internal_static_notifications_v1_Notification_LabelsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private LabelsDefaultEntryHolder() {
        }
    }
}

