/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import io.confluent.common.security.jetty.JwtLoginService;
import java.util.Objects;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;

public class JwtWithFallbackLoginService
extends AbstractLifeCycle
implements LoginService {
    private final JwtLoginService jwtLoginService;
    private final LoginService otherLoginService;
    private IdentityService identityService;
    private final String name;

    public JwtWithFallbackLoginService(JwtLoginService jwtLoginService, LoginService other) {
        if (!Objects.equals(jwtLoginService.getName(), other.getName())) {
            throw new IllegalArgumentException("login service realm names must match");
        }
        this.jwtLoginService = jwtLoginService;
        this.otherLoginService = other;
        this.name = jwtLoginService.getName();
    }

    public String getName() {
        return this.name;
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        Object useJwtObj = request.getAttribute("io.confluent.useJWTLoginService");
        if (useJwtObj instanceof Boolean && ((Boolean)useJwtObj).booleanValue()) {
            return this.jwtLoginService.login(username, credentials, request);
        }
        return this.otherLoginService.login(username, credentials, request);
    }

    public boolean validate(UserIdentity user) {
        if (JwtLoginService.isJwtUser(user)) {
            return this.jwtLoginService.validate(user);
        }
        return this.otherLoginService.validate(user);
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
        this.jwtLoginService.setIdentityService(identityService);
        this.otherLoginService.setIdentityService(identityService);
    }

    public void logout(UserIdentity user) {
        if (JwtLoginService.isJwtUser(user)) {
            this.jwtLoginService.logout(user);
        } else {
            this.otherLoginService.logout(user);
        }
    }

    protected void doStart() throws Exception {
        this.jwtLoginService.start();
        if (this.otherLoginService instanceof LifeCycle) {
            try {
                ((LifeCycle)this.otherLoginService).start();
            }
            catch (Throwable e) {
                this.jwtLoginService.stop();
                throw e;
            }
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        try {
            if (this.otherLoginService instanceof LifeCycle) {
                ((LifeCycle)this.otherLoginService).stop();
            }
        }
        finally {
            this.jwtLoginService.stop();
        }
        super.doStop();
    }
}

