/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import io.confluent.common.security.jetty.JwtLoginService;
import io.confluent.common.security.jetty.MultiJwtLoginService;
import java.util.Objects;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;

public class MultiJwtWithFallbackLoginService
extends AbstractLifeCycle
implements LoginService {
    private final MultiJwtLoginService multiJwtLoginService;
    private final LoginService otherLoginService;
    private final String name;
    private IdentityService identityService;

    public MultiJwtWithFallbackLoginService(MultiJwtLoginService multiJwtLoginService, LoginService other) {
        if (!Objects.equals(multiJwtLoginService.getName(), other.getName())) {
            throw new IllegalArgumentException("login service realm names must match");
        }
        this.multiJwtLoginService = multiJwtLoginService;
        this.otherLoginService = other;
        this.name = multiJwtLoginService.getName();
    }

    public String getName() {
        return this.name;
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        Object useJwtObj = request.getAttribute("io.confluent.useJWTLoginService");
        if (useJwtObj instanceof Boolean && ((Boolean)useJwtObj).booleanValue()) {
            return this.multiJwtLoginService.login(username, credentials, request);
        }
        return this.otherLoginService.login(username, credentials, request);
    }

    public boolean validate(UserIdentity user) {
        if (JwtLoginService.isJwtUser(user)) {
            return this.multiJwtLoginService.validate(user);
        }
        return this.otherLoginService.validate(user);
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
        this.multiJwtLoginService.setIdentityService(identityService);
        this.otherLoginService.setIdentityService(identityService);
    }

    public void logout(UserIdentity user) {
        if (JwtLoginService.isJwtUser(user)) {
            this.multiJwtLoginService.logout(user);
        } else {
            this.otherLoginService.logout(user);
        }
    }

    protected void doStart() throws Exception {
        this.multiJwtLoginService.start();
        if (this.otherLoginService instanceof LifeCycle) {
            try {
                ((LifeCycle)this.otherLoginService).start();
            }
            catch (Throwable e) {
                this.multiJwtLoginService.stop();
                throw e;
            }
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        try {
            if (this.otherLoginService instanceof LifeCycle) {
                ((LifeCycle)this.otherLoginService).stop();
            }
        }
        finally {
            this.multiJwtLoginService.stop();
        }
        super.doStop();
    }
}

