/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import io.confluent.common.security.jetty.OAuthRequestData;
import io.confluent.common.security.jetty.OAuthRequestDataFactory;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;

public class OAuthBearerAuthenticator
extends LoginAuthenticator {
    public static final String ACCESS_TOKEN = "access_token";
    public static final String BEARER_KEYWORD = "Bearer";
    public static final String AUTH_TOKEN = "auth_token";

    public String getAuthMethod() {
        return "BEARER";
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        UserIdentity user;
        String tokenToUse;
        if (!mandatory) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        HttpServletResponse response = (HttpServletResponse)res;
        OAuthRequestDataFactory oAuthRequestDataFactory = OAuthRequestDataFactory.getInstance();
        OAuthRequestData authRequestData = oAuthRequestDataFactory.getOAuthRequestData((HttpServletRequest)req);
        String tokenFromHeader = authRequestData.tokenFromAuthHeader();
        String tokenFromCookie = authRequestData.tokenFromCookie();
        String tokenFromQueryParam = authRequestData.tokenFromQueryParam();
        String string = tokenToUse = tokenFromHeader != null ? tokenFromHeader : tokenFromCookie;
        if (tokenToUse == null) {
            if (tokenFromQueryParam == null) {
                return this.sendError(response, ErrorCode.INVALID_REQUEST);
            }
            tokenToUse = tokenFromQueryParam;
            if (authRequestData.authHeaderSpecifiesSomeOtherAuthType()) {
                return this.sendError(response, ErrorCode.INVALID_REQUEST);
            }
        } else if (tokenFromQueryParam != null && !tokenToUse.equals(tokenFromQueryParam)) {
            return this.sendError(response, ErrorCode.INVALID_REQUEST);
        }
        if (tokenFromQueryParam != null) {
            response.setHeader(HttpHeader.CACHE_CONTROL.toString(), "private");
        }
        if (this.isValidUser(user = this.getLoginService().login(null, (Object)tokenToUse, req))) {
            return new UserAuthentication(this.getAuthMethod(), user);
        }
        if (!DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
            return this.sendError(response, ErrorCode.INVALID_TOKEN);
        }
        return Authentication.UNAUTHENTICATED;
    }

    public boolean requestIsOath(HttpServletRequest request) {
        OAuthRequestDataFactory oAuthRequestDataFactory = OAuthRequestDataFactory.getInstance();
        OAuthRequestData authRequestData = oAuthRequestDataFactory.getOAuthRequestData(request);
        return authRequestData.isOathRequest();
    }

    private Authentication sendError(HttpServletResponse response, ErrorCode error) throws ServerAuthException {
        StringBuilder value = new StringBuilder().append("Bearer realm=\"").append(this.getLoginService().getName()).append('\"');
        if (error != null) {
            value.append(',').append(error.asHeaderAttribute());
        }
        try {
            response.resetBuffer();
            response.setStatus(401);
            response.setHeader("Content-Type", "text/plain");
            response.getOutputStream().print(value.toString());
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new ServerAuthException((Throwable)e);
        }
        return Authentication.SEND_FAILURE;
    }

    private boolean isValidUser(UserIdentity user) {
        return user != null && user.getUserPrincipal() != null && user.getUserPrincipal().getName() != null && !user.getUserPrincipal().getName().isEmpty();
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) {
        return true;
    }

    private static enum ErrorCode {
        INVALID_REQUEST("invalid_request"),
        INVALID_TOKEN("invalid_token");

        final String error;

        private ErrorCode(String error) {
            this.error = error;
        }

        public String asHeaderAttribute() {
            return "error=\"" + this.error + '\"';
        }
    }
}

