/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import java.util.Arrays;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.StringUtil;

public class OAuthRequestData {
    private final Optional<Cookie> authCookie;
    private final String rawAuthHeader;
    private final String accessTokenQueryParam;
    private final boolean authHeaderSpecifiesSomeOtherAuthType;

    public OAuthRequestData(HttpServletRequest request) {
        this.rawAuthHeader = request.getHeader(HttpHeader.AUTHORIZATION.asString());
        this.authHeaderSpecifiesSomeOtherAuthType = StringUtil.isBlank((String)this.rawAuthHeader) ? false : !this.rawAuthHeader.startsWith("Bearer");
        this.accessTokenQueryParam = request.getParameter("access_token");
        this.authCookie = request.getCookies() == null ? Optional.empty() : Arrays.stream(request.getCookies()).filter(cookie -> cookie.getName().equals("auth_token")).findAny();
    }

    public boolean isOathRequest() {
        return this.rawAuthHeader != null && this.rawAuthHeader.startsWith("Bearer") || this.accessTokenQueryParam != null || this.authCookie.isPresent();
    }

    public String tokenFromAuthHeader() {
        String method;
        if (this.rawAuthHeader == null) {
            return null;
        }
        int space = this.rawAuthHeader.indexOf(32);
        if (space > 0 && "Bearer".equals(method = this.rawAuthHeader.substring(0, space))) {
            String potentialToken = this.rawAuthHeader.substring(space + 1).trim();
            if (StringUtil.isEmpty((String)potentialToken) || "null".equals(potentialToken)) {
                return null;
            }
            return potentialToken;
        }
        return null;
    }

    public String tokenFromCookie() {
        return this.authCookie.map(cookie -> cookie.getValue().trim()).orElse(null);
    }

    public String tokenFromQueryParam() {
        if (this.accessTokenQueryParam == null) {
            return null;
        }
        return this.accessTokenQueryParam.trim();
    }

    public boolean authHeaderSpecifiesSomeOtherAuthType() {
        return this.authHeaderSpecifiesSomeOtherAuthType;
    }

    public boolean authInfoExists() {
        return StringUtil.isNotBlank((String)this.rawAuthHeader) || this.tokenFromCookie() != null || this.tokenFromQueryParam() != null;
    }
}

